#
# TABLE STRUCTURE FOR: banner_image
#

DROP TABLE IF EXISTS `banner_image`;

CREATE TABLE `banner_image` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT COMMENT 'Primary key',
  `product_id` mediumint(8) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL COMMENT 'Foreign Key',
  `subcategory_id` int(11) DEFAULT NULL COMMENT 'Foreign Key',
  `image` text,
  `banner_status` int(1) DEFAULT '0',
  `insertedat` date DEFAULT NULL,
  `updatedat` datetime DEFAULT NULL,
  `delete_date` date DEFAULT NULL,
  `delete_status` int(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: baskets
#

DROP TABLE IF EXISTS `baskets`;

CREATE TABLE `baskets` (
  `basketID` int(11) NOT NULL AUTO_INCREMENT,
  `basketSession` varchar(50) DEFAULT NULL,
  `productID` int(11) DEFAULT NULL,
  `productPrice` varchar(50) DEFAULT NULL,
  `productQty` int(11) DEFAULT NULL,
  `product_weight` varchar(50) DEFAULT NULL,
  `pcode` varchar(100) DEFAULT NULL,
  `rid` int(11) DEFAULT NULL,
  `status` int(1) DEFAULT NULL,
  `order_id` int(11) DEFAULT NULL,
  `mem_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`basketID`)
) ENGINE=InnoDB AUTO_INCREMENT=298 DEFAULT CHARSET=latin1;

INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('21', 'rmc9p640qrgi2bhiqfs7rneuj7', '1', '100.00', '1', '22cm', '22cm', '1', '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('22', 'rmc9p640qrgi2bhiqfs7rneuj7', '2', '300.00', '2', '35cm', '35cm', '6', '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('25', 'rmc9p640qrgi2bhiqfs7rneuj7', '4', '100.00', '1', '22cm', '22cm', '10', '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('30', '79u8qjbr140nuotaaspv53je77', '1', '90.00', '1', 'celld-22', 'celld-22', '1', '0', NULL, '1');
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('32', 'b6pl673040717llutrhbqaepr2', '1', '90.00', '1', 'celld-22', 'celld-22', '1', '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('33', '7t20b6c77sdpesehaghv9gsek2', '1', '90.00', '1', 'celld-22', 'celld-22', '1', '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('34', 'abc36tot7giic8fcgph0r3h610', '1', '90.00', '1', 'celld-22', 'celld-22', '1', '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('35', 'd7mgpi8jovs4tor2fnav6t7tj7', '1', '90.00', '1', 'celld-22', 'celld-22', '1', '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('36', 'rdkki31on8rpg90t5ja4ndohk1', '1', '90.00', '2', 'celld-22', 'celld-22', '1', '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('42', 'bgrl54a6a01r1tfac6gsnnqt72', '1', '24500.00', '2', 'King Size', 'King Size', '1', '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('49', 'nmld5m7ghsnr0klokh94b2g8e3', '1', '24500.00', '1', 'King Size', 'King Size', '1', '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('50', 'anibopk1lon9vbbq46ts749he5', '1', NULL, '1', NULL, NULL, NULL, '1', '1', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('51', 'anibopk1lon9vbbq46ts749he5', '27', NULL, '1', NULL, NULL, NULL, '1', '1', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('54', 'anibopk1lon9vbbq46ts749he5', '96', NULL, '1', NULL, NULL, NULL, '1', '2', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('56', 'q2u38qs9nd434oodd4alr99snp', '2583', NULL, '1', NULL, NULL, NULL, '1', '3', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('57', '41fqdkeujmd75d3v7ti6e4n2rg', '2403', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('58', 'sv7e6597etlfglqvrerq0atou9', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('59', 'sv7e6597etlfglqvrerq0atou9', '45', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('60', 'sv7e6597etlfglqvrerq0atou9', '44', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('61', 'sv7e6597etlfglqvrerq0atou9', '2', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('62', 'sv7e6597etlfglqvrerq0atou9', '53', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('63', 'sv7e6597etlfglqvrerq0atou9', '2288', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('64', 'sv7e6597etlfglqvrerq0atou9', '2236', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('65', 'sv7e6597etlfglqvrerq0atou9', '2289', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('68', 'ajfgf7vneeenn1uo43hmsg2pm2', '2403', NULL, '5', NULL, NULL, NULL, '1', '4', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('69', 'ajfgf7vneeenn1uo43hmsg2pm2', '2311', NULL, '5', NULL, NULL, NULL, '1', '4', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('84', '1guf9gcltn7thbm452m9rugemj', '1', NULL, '1', NULL, NULL, NULL, '1', '5', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('85', '1guf9gcltn7thbm452m9rugemj', '4', NULL, '1', NULL, NULL, NULL, '1', '5', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('86', '3v4k8d8de16jtk4q2o3nqq6kmg', '626', NULL, '1', NULL, NULL, NULL, '1', '7', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('87', '3v4k8d8de16jtk4q2o3nqq6kmg', '1', NULL, '1', NULL, NULL, NULL, '1', '7', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('88', '3v4k8d8de16jtk4q2o3nqq6kmg', '17', NULL, '1', NULL, NULL, NULL, '1', '7', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('89', '1guf9gcltn7thbm452m9rugemj', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('93', 'bdua32qg06q0smu225lb52m5b1', '1', NULL, '1', NULL, NULL, NULL, '1', '8', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('101', 'bqdcfap5hf20pg6vbieokbussf', '1', NULL, '1', NULL, NULL, NULL, '1', '9', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('102', 'bqdcfap5hf20pg6vbieokbussf', '7', NULL, '1', NULL, NULL, NULL, '1', '9', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('103', 'bqdcfap5hf20pg6vbieokbussf', '10', NULL, '1', NULL, NULL, NULL, '1', '9', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('104', 'bqdcfap5hf20pg6vbieokbussf', '13', NULL, '1', NULL, NULL, NULL, '1', '9', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('105', 'bqdcfap5hf20pg6vbieokbussf', '558', NULL, '1', NULL, NULL, NULL, '1', '9', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('106', 'bqdcfap5hf20pg6vbieokbussf', '555', NULL, '1', NULL, NULL, NULL, '1', '9', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('107', 'bqdcfap5hf20pg6vbieokbussf', '626', NULL, '1', NULL, NULL, NULL, '1', '9', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('112', 'bdua32qg06q0smu225lb52m5b1', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('115', 't4qvbbte4b70diohgke5ck6qnr', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('116', '8qr55mrjsrgg240q9tgt6s868e', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('117', '8qr55mrjsrgg240q9tgt6s868e', '2', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('118', '8qr55mrjsrgg240q9tgt6s868e', '3', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('119', 't4qvbbte4b70diohgke5ck6qnr', '1925', NULL, '5', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('120', 't4qvbbte4b70diohgke5ck6qnr', '2336', NULL, '5', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('125', 'elnjsc79lg0ofitsa9ecuslho9', '1334', NULL, '10', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('126', 'jdthoi8uctr1906frevafrud74', '322', NULL, '1', NULL, NULL, NULL, '1', '10', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('127', 'jdthoi8uctr1906frevafrud74', '323', NULL, '2', NULL, NULL, NULL, '1', '10', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('132', 'v0c6bvd016vdfa7es00vck5jpl', '1', NULL, '1', NULL, NULL, NULL, '1', '11', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('133', 'v0c6bvd016vdfa7es00vck5jpl', '2', NULL, '1', NULL, NULL, NULL, '1', '11', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('134', '3gs3iupq0hqmsc81r5nld2akst', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('135', '3gs3iupq0hqmsc81r5nld2akst', '2', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('136', 'njef8r1cv8voeiv5k7ve8bb2mj', '1', NULL, '1', NULL, NULL, NULL, '1', '12', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('137', 'v0c6bvd016vdfa7es00vck5jpl', '55', NULL, '1', NULL, NULL, NULL, '1', '13', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('138', 'v0c6bvd016vdfa7es00vck5jpl', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('139', 'v0c6bvd016vdfa7es00vck5jpl', '5', NULL, '3', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('140', 'q5lmnd9q42vhh2v3d9leikud6p', '1907', NULL, '3', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('141', 'njef8r1cv8voeiv5k7ve8bb2mj', '13', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('142', 'njef8r1cv8voeiv5k7ve8bb2mj', '14', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('143', 'l1vhup8h5ar5mba45ev3jmdgfv', '534', NULL, '1', NULL, NULL, NULL, '1', '18', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('145', 'l1vhup8h5ar5mba45ev3jmdgfv', '1358', NULL, '7', NULL, NULL, NULL, '1', '18', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('146', 'l1vhup8h5ar5mba45ev3jmdgfv', '1925', NULL, '1', NULL, NULL, NULL, '1', '19', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('147', 'l1vhup8h5ar5mba45ev3jmdgfv', '2338', NULL, '1', NULL, NULL, NULL, '1', '19', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('148', 'l1vhup8h5ar5mba45ev3jmdgfv', '2336', NULL, '1', NULL, NULL, NULL, '1', '19', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('149', 'l1vhup8h5ar5mba45ev3jmdgfv', '3078', NULL, '1', NULL, NULL, NULL, '1', '19', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('150', 'l1vhup8h5ar5mba45ev3jmdgfv', '2339', NULL, '1', NULL, NULL, NULL, '1', '19', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('151', '7ujo6rfrq80ulb7d43fc9ul9v5', '2403', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('152', '7ujo6rfrq80ulb7d43fc9ul9v5', '2404', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('153', 'o2bpjm11e41933l0f1p91guul4', '933', NULL, '3', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('154', 'r915mbgubpcrdmv0783f4q41qc', '1', NULL, '1', NULL, NULL, NULL, '1', '20', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('155', 'r915mbgubpcrdmv0783f4q41qc', '3', NULL, '1', NULL, NULL, NULL, '1', '20', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('156', 'hg72qcfdlg3n54qd77ul346c7s', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('157', 'hg72qcfdlg3n54qd77ul346c7s', '2', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('158', 'o8m2gh0k7lsi1rdau87q83th7o', '55', NULL, '5', NULL, NULL, NULL, '1', '21', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('159', 'o8m2gh0k7lsi1rdau87q83th7o', '1907', NULL, '3', NULL, NULL, NULL, '1', '22', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('160', 'o8m2gh0k7lsi1rdau87q83th7o', '2', NULL, '7', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('161', 'o8m2gh0k7lsi1rdau87q83th7o', '5', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('162', 'o8m2gh0k7lsi1rdau87q83th7o', '9', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('163', '8mpgmpo6gevb0ubmt6j70ukdsk', '96', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('164', '5bqrlcv1bbsloil9vgcu8mch15', '1892', NULL, '2', NULL, NULL, NULL, '1', '23', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('165', '5bqrlcv1bbsloil9vgcu8mch15', '1893', NULL, '1', NULL, NULL, NULL, '1', '23', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('166', '5bqrlcv1bbsloil9vgcu8mch15', '1921', NULL, '5', NULL, NULL, NULL, '1', '23', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('167', '5bqrlcv1bbsloil9vgcu8mch15', '1892', NULL, '1', NULL, NULL, NULL, '1', '24', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('168', '5bqrlcv1bbsloil9vgcu8mch15', '1893', NULL, '1', NULL, NULL, NULL, '1', '24', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('169', '5bqrlcv1bbsloil9vgcu8mch15', '1894', NULL, '1', NULL, NULL, NULL, '1', '24', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('170', 'rftsv98ejpnedkldpbqmns8ee6', '47', NULL, '3', NULL, NULL, NULL, '1', '25', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('171', 'rftsv98ejpnedkldpbqmns8ee6', '27', NULL, '2', NULL, NULL, NULL, '1', '25', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('172', 'rftsv98ejpnedkldpbqmns8ee6', '1', NULL, '2', NULL, NULL, NULL, '1', '25', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('173', 'rftsv98ejpnedkldpbqmns8ee6', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('174', 'rftsv98ejpnedkldpbqmns8ee6', '2', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('176', 'orqp4685r7njv9fordjkkegd18', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('177', 'orqp4685r7njv9fordjkkegd18', '2', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('178', 'orqp4685r7njv9fordjkkegd18', '3', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('179', 'v5d2rfoh04i65acljtrnffjfuf', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('180', 'lvj0uhgj23vam9mkpp90b1morn', '55', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('181', '7ml9iff2ohhm8io7vb8cr9gos0', '1', NULL, '7', NULL, NULL, NULL, '1', '26', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('182', '2b9rkne7vhevqb39c51arfkjrb', '935', NULL, '7', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('183', '2b9rkne7vhevqb39c51arfkjrb', '316', NULL, '7', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('189', 'o75v1ka1mdrm7q9dd7atiqii0j', '1', NULL, '2', NULL, NULL, NULL, '1', '27', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('190', 'o75v1ka1mdrm7q9dd7atiqii0j', '2', NULL, '1', NULL, NULL, NULL, '1', '27', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('191', 'v11tadcm1v8o0tcbjba2ve3187', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('192', 'o75v1ka1mdrm7q9dd7atiqii0j', '1', NULL, '2', NULL, NULL, NULL, '1', '28', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('193', 'o75v1ka1mdrm7q9dd7atiqii0j', '2', NULL, '1', NULL, NULL, NULL, '1', '28', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('195', 'ctacf9rn4j752kt1ihiufeha7q', '389', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('197', 'sdanumu24smkfsvtjtrf0otsng', '4', NULL, '2', NULL, NULL, NULL, '1', '29', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('198', 'j3hk659i7746olb526nunchb91', '1972', NULL, '15', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('200', '29h7me8o11ekjfl4uu9ijksmpu', '2603', NULL, '1', NULL, NULL, NULL, '1', '30', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('201', 'r515bp2h8ob1rfko6s128h037d', '1892', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('205', 'v7mvbg0kq0m9cjash94iuubqme', '2', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('206', '02unpgrvvvqrf0q3fanu8nk335', '606', NULL, '4', NULL, NULL, NULL, '1', '31', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('209', '1odpcgj527bu9ii5637rduqri1', '1004', NULL, '1', NULL, NULL, NULL, '1', '32', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('214', '7ki2it1228a47ovk57utnp2phs', '1', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('215', '7ki2it1228a47ovk57utnp2phs', '2', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('218', '49jnar6bl3hvna8i9e40mi7jq9', '317', NULL, '5', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('219', '49jnar6bl3hvna8i9e40mi7jq9', '318', NULL, '4', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('222', 'qq0c0790s19pfs6n353l23q25t', '55', NULL, '6', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('224', '930d5f89a798daad767dce4b5683528a', '2417', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('227', '3b9cd40a3841dd6b6517b3e42093048c', '3067', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('229', '3337cc9ddad6d7abef1bb5689c5c6667', '56', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('230', '3337cc9ddad6d7abef1bb5689c5c6667', '58', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('239', '96ac38e20d4e1d8bf9ebcea77efac421', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('241', '96ac38e20d4e1d8bf9ebcea77efac421', '2311', NULL, '5', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('242', '103991431ddafb1b18ec1b153bf23d92', '410', NULL, '1', NULL, NULL, NULL, '1', '33', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('243', '103991431ddafb1b18ec1b153bf23d92', '412', NULL, '1', NULL, NULL, NULL, '1', '33', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('245', 'b13ec099a096d3262ea13ae38067cb47', '2311', NULL, '3', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('247', 'b6208fd3ca03f481bb211d621f541ab2', '2311', NULL, '4', NULL, NULL, NULL, '1', '34', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('249', 'b6208fd3ca03f481bb211d621f541ab2', '2311', NULL, '5', NULL, NULL, NULL, '1', '35', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('250', '459e97ca6d04e8b1fbd621315bc23bc4', '1', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('253', 'b6208fd3ca03f481bb211d621f541ab2', '280', NULL, '3', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('254', 'b6208fd3ca03f481bb211d621f541ab2', '352', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('255', '0f4cac9d6611a10b1d09f0054092ea0d', '3177', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('256', 'ce02e115864ee6245ac9db329844961f', '3123', NULL, '6', NULL, NULL, NULL, '1', '36', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('257', 'ce02e115864ee6245ac9db329844961f', '3144', NULL, '6', NULL, NULL, NULL, '1', '36', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('260', 'e948a5ddcd1a340b6508283e3e21256a', '1422', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('262', '43b74ddc165789479dc735bd766b25e3', '2407', NULL, '5', NULL, NULL, NULL, '1', '37', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('263', 'edbd7d9033af27110e5b2e0e9f7928d4', '1892', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('264', '377b81a0cc42912ff9d85818ecd3cdad', '20', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('265', '377b81a0cc42912ff9d85818ecd3cdad', '3259', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('268', '1c288cd879ffd45557828c98a7d65861', '1275', NULL, '6', NULL, NULL, NULL, '1', '38', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('270', '956d2786871bb4d6dffc24e2ead5236a', '1275', NULL, '6', NULL, NULL, NULL, '1', '39', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('271', 'ffbe7738426669c31ec26b18149f7416', '1275', NULL, '6', NULL, NULL, NULL, '1', '40', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('272', 'ffbe7738426669c31ec26b18149f7416', '1275', NULL, '6', NULL, NULL, NULL, '1', '41', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('273', '50d843c4ecc5ffadc7958f6ea7df831e', '1925', NULL, '2', NULL, NULL, NULL, '1', '42', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('274', '50d843c4ecc5ffadc7958f6ea7df831e', '2338', NULL, '3', NULL, NULL, NULL, '1', '42', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('275', '4f10f30c621e56760a5f395929bf94fd', '1319', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('277', '80ef44af5fa741a28cee64278a20696c', '1934', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('278', '80ef44af5fa741a28cee64278a20696c', '365', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('279', '80ef44af5fa741a28cee64278a20696c', '366', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('280', '80ef44af5fa741a28cee64278a20696c', '607', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('283', '7586804d60214bc466d2c116b43b8067', '365', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('284', '7586804d60214bc466d2c116b43b8067', '1934', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('285', '5606a64c6cb3473c76f691211dd33369', '1359', NULL, '4', NULL, NULL, NULL, '1', '43', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('286', '5606a64c6cb3473c76f691211dd33369', '1362', NULL, '4', NULL, NULL, NULL, '1', '43', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('287', 'f603d3c3292665c8a2ab8e4d25f5f3e5', '1494', NULL, '1', NULL, NULL, NULL, '1', '44', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('288', 'f7381cd412dd4490d28c0248e46c577e', '1934', NULL, '1', NULL, NULL, NULL, '1', '45', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('289', 'f7381cd412dd4490d28c0248e46c577e', '365', NULL, '1', NULL, NULL, NULL, '1', '45', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('290', '0af6b43b359df306cbd18c54baa98776', '200', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('291', 'ee42627f1b86b6512bad467c76935b05', '659', NULL, '4', NULL, NULL, NULL, '1', '46', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('292', 'ee42627f1b86b6512bad467c76935b05', '659', NULL, '4', NULL, NULL, NULL, '1', '47', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('293', 'b51627f4720f33ecc055e2e52077cdca', '2074', NULL, '400', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('296', 'dd9695070cd21c7b1617627d2339accf', '1904', NULL, '2', NULL, NULL, NULL, '1', '48', NULL);


#
# TABLE STRUCTURE FOR: brand
#

DROP TABLE IF EXISTS `brand`;

CREATE TABLE `brand` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `brand_name` varchar(30) NOT NULL,
  `image` varchar(255) DEFAULT NULL,
  `delete_status` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=49 DEFAULT CHARSET=latin1;

INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('1', 'ACETEQ', '1.png', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('2', 'AGATE', '15010714162ad98620e170.png', '1');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('3', 'ANTECH', '198607129962b6e9bfb8e85.jpg', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('4', 'ATAGO', '4.png', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('5', 'BARIGO', '43561512262ad95bd9ffad.png', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('6', 'BLUESTAR', '6.png', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('7', 'EUTECH', '7.png', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('8', 'GENERAL', '214384218362ad615632bda.png', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('9', 'GL150', '158973250062ad98a9150d3.png', '1');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('10', 'GLOLAB', '10.png', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('11', 'GLOLINE', '11.png', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('12', 'GLOSIL SILICAWARE', '16865659562b6cb3a1e854.png', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('13', 'GLOSIL TEFLONWARE', '13.png', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('14', 'GLOSON', '14.png', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('15', 'GLOVISION', '15.png', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('16', 'HANNA', '16.png', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('17', 'HBG', '17.png', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('18', 'HM', '18.png', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('19', 'INSIZE', '19.png', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('20', 'JAYANT', '20.png', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('21', 'KUMAR', '158843177562ad96b7de0a2.png', '1');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('22', 'LABOHOLIC', '22.png', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('23', 'LARK', '23.png', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('24', 'LEIMCO', '24.png', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('25', 'LOVIBOND', '25.png', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('26', 'LUTRON', '26.png', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('27', 'METRAVI', '27.png', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('28', 'MICROLIT', '28.png', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('29', 'MITUTOYO', '52506452962ad95caad808.png', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('30', 'OLYMPUS', '30.png', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('31', 'POLYLAB', '62646686062ad95d17a514.png', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('32', 'RAYSCOPE', '32.png', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('33', 'REMI', '33.png', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('34', 'RICO', '210654891662ad95dfea09f.png', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('35', 'SAFFRON', '35.png', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('36', 'SGE', '36.png', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('37', 'SHIMADZU', '37.png', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('38', 'SILICON RUBBER TUBING', '38.png', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('39', 'STANDARD', '39.png', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('40', 'SUPERIOR', '8872102262b6e9b11cd0e.jpg', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('41', 'SWASTIK', '41.png', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('42', 'TESTO', '42.png', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('43', 'TOP TECH', '43.png', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('44', 'WHATMAN', '44.png', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('45', 'WORKZONE', '69164724462ad985d2a4e5.png', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('46', 'GLOSIL HYDROMETER', '124672791162b6da30ad586.jpg', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('47', 'GLOSIL THERMOMETER', '63084221162b6da50d27dd.jpg', '0');
INSERT INTO `brand` (`id`, `brand_name`, `image`, `delete_status`) VALUES ('48', 'HAMILTON', '103530939862c2b5f50c3b8.jpg', '0');


#
# TABLE STRUCTURE FOR: category
#

DROP TABLE IF EXISTS `category`;

CREATE TABLE `category` (
  `category_id` mediumint(8) NOT NULL AUTO_INCREMENT COMMENT 'Primary key',
  `category_code` varchar(55) NOT NULL,
  `category_name` varchar(255) NOT NULL,
  `delete_status` int(2) DEFAULT '0',
  `status` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`category_id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=latin1;

INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `delete_status`, `status`) VALUES ('1', '', 'A', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `delete_status`, `status`) VALUES ('2', '', 'B', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `delete_status`, `status`) VALUES ('3', '', 'C', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `delete_status`, `status`) VALUES ('4', '', 'D', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `delete_status`, `status`) VALUES ('5', '', 'E', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `delete_status`, `status`) VALUES ('6', '', 'F', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `delete_status`, `status`) VALUES ('7', '', 'G', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `delete_status`, `status`) VALUES ('8', '', 'H', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `delete_status`, `status`) VALUES ('9', '', 'I', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `delete_status`, `status`) VALUES ('10', '', 'J', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `delete_status`, `status`) VALUES ('11', '', 'K', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `delete_status`, `status`) VALUES ('12', '', 'L', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `delete_status`, `status`) VALUES ('13', '', 'M', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `delete_status`, `status`) VALUES ('14', '', 'N', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `delete_status`, `status`) VALUES ('15', '', 'O', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `delete_status`, `status`) VALUES ('16', '', 'P', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `delete_status`, `status`) VALUES ('17', '', 'Q', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `delete_status`, `status`) VALUES ('18', '', 'R', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `delete_status`, `status`) VALUES ('19', '', 'S', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `delete_status`, `status`) VALUES ('20', '', 'T', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `delete_status`, `status`) VALUES ('21', '', 'U', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `delete_status`, `status`) VALUES ('22', '', 'V', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `delete_status`, `status`) VALUES ('23', '', 'W', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `delete_status`, `status`) VALUES ('24', 'CAT-000024', 'X1', '1', '1');


#
# TABLE STRUCTURE FOR: colour
#

DROP TABLE IF EXISTS `colour`;

CREATE TABLE `colour` (
  `colour_id` mediumint(8) NOT NULL AUTO_INCREMENT COMMENT 'Primary key',
  `colour_code` varchar(55) NOT NULL,
  `colour_name` varchar(255) NOT NULL,
  `delete_status` int(2) DEFAULT '0',
  `status` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`colour_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=latin1;

INSERT INTO `colour` (`colour_id`, `colour_code`, `colour_name`, `delete_status`, `status`) VALUES ('1', 'C-000001', 'Beige', '0', '1');
INSERT INTO `colour` (`colour_id`, `colour_code`, `colour_name`, `delete_status`, `status`) VALUES ('2', 'C-000002', 'Black', '0', '1');
INSERT INTO `colour` (`colour_id`, `colour_code`, `colour_name`, `delete_status`, `status`) VALUES ('3', 'C-000003', 'Blue', '0', '1');
INSERT INTO `colour` (`colour_id`, `colour_code`, `colour_name`, `delete_status`, `status`) VALUES ('4', 'C-000004', 'Brown', '0', '1');
INSERT INTO `colour` (`colour_id`, `colour_code`, `colour_name`, `delete_status`, `status`) VALUES ('5', 'C-000005', 'Green', '0', '1');
INSERT INTO `colour` (`colour_id`, `colour_code`, `colour_name`, `delete_status`, `status`) VALUES ('6', 'C-000006', 'Gray', '0', '1');
INSERT INTO `colour` (`colour_id`, `colour_code`, `colour_name`, `delete_status`, `status`) VALUES ('7', 'C-000007', 'Magenta', '0', '1');
INSERT INTO `colour` (`colour_id`, `colour_code`, `colour_name`, `delete_status`, `status`) VALUES ('8', 'C-000008', 'Multicolor', '0', '1');
INSERT INTO `colour` (`colour_id`, `colour_code`, `colour_name`, `delete_status`, `status`) VALUES ('9', 'C-000009', 'Orange', '0', '1');
INSERT INTO `colour` (`colour_id`, `colour_code`, `colour_name`, `delete_status`, `status`) VALUES ('10', 'C-000010', 'Pink', '0', '1');
INSERT INTO `colour` (`colour_id`, `colour_code`, `colour_name`, `delete_status`, `status`) VALUES ('11', 'C-000011', 'Red', '0', '1');
INSERT INTO `colour` (`colour_id`, `colour_code`, `colour_name`, `delete_status`, `status`) VALUES ('12', 'C-000012', 'Violet', '0', '1');
INSERT INTO `colour` (`colour_id`, `colour_code`, `colour_name`, `delete_status`, `status`) VALUES ('13', 'C-000013', 'White', '0', '1');
INSERT INTO `colour` (`colour_id`, `colour_code`, `colour_name`, `delete_status`, `status`) VALUES ('14', 'C-000014', 'Yellow', '0', '1');
INSERT INTO `colour` (`colour_id`, `colour_code`, `colour_name`, `delete_status`, `status`) VALUES ('15', 'C-000015', 'Ivory', '0', '1');


#
# TABLE STRUCTURE FOR: company_settings
#

DROP TABLE IF EXISTS `company_settings`;

CREATE TABLE `company_settings` (
  `id` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `site_short_name` varchar(20) NOT NULL,
  `gstin` varchar(16) DEFAULT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(20) NOT NULL,
  `tan_no` varchar(20) DEFAULT NULL,
  `cst_reg_no` varchar(20) DEFAULT NULL,
  `excise_reg_no` varchar(20) DEFAULT NULL,
  `lbt_reg_no` varchar(20) DEFAULT NULL,
  `servicetax_reg_no` varchar(20) DEFAULT NULL,
  `cin` varchar(20) DEFAULT NULL,
  `gst_registration_type` varchar(30) DEFAULT NULL,
  `street` varchar(150) NOT NULL,
  `city_id` int(11) NOT NULL COMMENT 'Foreign Key',
  `state_id` int(11) NOT NULL COMMENT 'Foreign Key',
  `state_code` varchar(2) DEFAULT NULL,
  `zip_code` varchar(10) DEFAULT NULL,
  `country_id` int(11) NOT NULL COMMENT 'Foreign Key',
  `default_language` varchar(20) DEFAULT NULL,
  `default_currency` varchar(10) DEFAULT NULL,
  `logo` varchar(100) DEFAULT NULL,
  `terms_condition` text,
  `bank_name` varchar(50) DEFAULT NULL,
  `account_no` varchar(50) DEFAULT NULL,
  `branch_ifsccode` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `company_settings` (`id`, `name`, `site_short_name`, `gstin`, `email`, `phone`, `tan_no`, `cst_reg_no`, `excise_reg_no`, `lbt_reg_no`, `servicetax_reg_no`, `cin`, `gst_registration_type`, `street`, `city_id`, `state_id`, `state_code`, `zip_code`, `country_id`, `default_language`, `default_currency`, `logo`, `terms_condition`, `bank_name`, `account_no`, `branch_ifsccode`) VALUES ('1', '', '01-07-2022', '24XXXXXXXXXXZ5', '', '', '0', '0', '', '', '', '', 'Unregistered', '', '0', '0', NULL, NULL, '0', '', '1', NULL, '<p><span style=\"font-family:Georgia,serif\"><tt><span class=\"marker\"><u><span style=\"font-size:11.0pt\"><span style=\"color:#ff6600\"><strong>PRICE REVISION:</strong></span></span></u></span></tt></span></p>\r\n\r\n<ul>\r\n	<li><span style=\"font-family:Georgia,serif\"><span style=\"font-size:11.0pt\"><span style=\"color:black\">Glosil Silicare Products</span></span></span></li>\r\n	<li><span style=\"font-family:Georgia,serif\"><span style=\"font-size:11.0pt\"><span style=\"color:black\">Zeal Type Thermometer</span></span></span></li>\r\n	<li><span style=\"font-family:Georgia,serif\"><span style=\"font-size:11.0pt\"><span style=\"color:black\">Eutech New Price revised</span></span></span></li>\r\n	<li><span style=\"font-family:Georgia,serif\"><span style=\"font-size:11.0pt\"><span style=\"color:black\">Saffron New Price revised</span></span></span></li>\r\n	<li><span style=\"font-family:Georgia,serif\"><span style=\"font-size:11.0pt\"><span style=\"color:black\">Whatman New Price revised </span></span></span></li>\r\n	<li><span style=\"font-family:Georgia,serif\"><span style=\"font-size:11.0pt\"><span style=\"color:black\">Laboholic New Price revised</span></span></span></li>\r\n	<li><span style=\"font-family:Georgia,serif\"><span style=\"font-size:11.0pt\"><span style=\"color:black\">Bluestar New Price Revised</span></span></span></li>\r\n	<li><span style=\"font-family:Georgia,serif\"><span style=\"font-size:11.0pt\"><span style=\"color:black\">Remi New Price Revised</span></span></span></li>\r\n	<li><span style=\"font-family:Georgia,serif\"><span style=\"font-size:11.0pt\"><span style=\"color:black\">Gloson Test Sieves price Revised</span></span></span></li>\r\n	<li><span style=\"font-family:Georgia,serif\"><span style=\"font-size:11.0pt\"><span style=\"color:black\">Rayscope some of the products prices revised</span></span></span></li>\r\n	<li><span style=\"font-family:Georgia,serif\"><span style=\"font-size:11.0pt\"><span style=\"color:black\">Insize Prices revised</span></span></span></li>\r\n	<li><span style=\"font-family:Georgia,serif\"><span style=\"font-size:11.0pt\"><span style=\"color:black\">Shimadzu Prices Revised</span></span></span></li>\r\n	<li><span style=\"font-family:Georgia,serif\"><span style=\"font-size:11.0pt\"><span style=\"color:black\">Olympus prices Revised</span></span></span></li>\r\n	<li><span style=\"font-family:Georgia,serif\"><span style=\"font-size:11.0pt\"><span style=\"color:black\">Agate Black prices Revised</span></span></span></li>\r\n</ul>\r\n\r\n<p><big><span style=\"font-family:Georgia,serif\"><span class=\"marker\"><u><span style=\"font-size:11.0pt\"><span style=\"color:#ff6600\"><strong><small>PRODUCT ADDITION:</small></strong></span></span></u></span></span></big></p>\r\n\r\n<ul>\r\n	<li><span style=\"font-family:Georgia,serif\"><span style=\"font-size:11.0pt\"><span style=\"color:black\">Rico Products added</span></span></span></li>\r\n	<li><span style=\"font-family:Georgia,serif\"><span style=\"font-size:11.0pt\"><span style=\"color:black\">Quartz Crucible &amp; Lid added</span></span></span></li>\r\n	<li><span style=\"font-family:Georgia,serif\"><span style=\"font-size:11.0pt\"><span style=\"color:black\">Polylab Products added</span></span></span></li>\r\n</ul>\r\n', '', '01-07-2022 14:52:38', '');


#
# TABLE STRUCTURE FOR: currency
#

DROP TABLE IF EXISTS `currency`;

CREATE TABLE `currency` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `symbol` char(5) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `currency` (`id`, `name`, `symbol`) VALUES ('1', 'INR', 'INR');
INSERT INTO `currency` (`id`, `name`, `symbol`) VALUES ('2', 'INR', 'INR');


#
# TABLE STRUCTURE FOR: customer
#

DROP TABLE IF EXISTS `customer`;

CREATE TABLE `customer` (
  `customer_id` mediumint(8) NOT NULL AUTO_INCREMENT COMMENT 'Primary key',
  `first_name` varchar(255) DEFAULT NULL,
  `cust_code` varchar(25) DEFAULT NULL,
  `last_name` varchar(255) DEFAULT NULL,
  `city` varchar(20) DEFAULT NULL,
  `contact_no` varchar(50) DEFAULT NULL,
  `email_address` varchar(100) DEFAULT NULL,
  `cpassword` varchar(15) DEFAULT NULL,
  `gst_no` varchar(25) DEFAULT NULL,
  `address` varchar(355) DEFAULT NULL,
  `lorry_no` varchar(25) DEFAULT NULL,
  `transport_name` varchar(255) DEFAULT NULL,
  `trans_contact` varchar(50) DEFAULT NULL,
  `wallet` double DEFAULT '0',
  `activation_code` varchar(100) DEFAULT NULL,
  `mobile_reg_id` text,
  `c_type` tinyint(1) NOT NULL DEFAULT '0',
  `customer_status` int(1) DEFAULT '0',
  `oauth_provider` varchar(255) DEFAULT NULL,
  `oauth_uid` varchar(255) DEFAULT NULL,
  `picture` varchar(255) DEFAULT NULL,
  `link` varchar(255) DEFAULT NULL,
  `insertedat` datetime DEFAULT NULL,
  `updatedat` datetime DEFAULT NULL,
  `delete_date` date DEFAULT NULL,
  `delete_status` int(1) DEFAULT '0',
  PRIMARY KEY (`customer_id`)
) ENGINE=InnoDB AUTO_INCREMENT=107 DEFAULT CHARSET=latin1;

INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('1', 'GlosilScientific', 'G001', NULL, NULL, '9940079368', 'glosilscientific@gmail.com', 'b5223b2', NULL, NULL, NULL, NULL, NULL, '0', '539390', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-06-21 15:01:15', '2022-06-22 00:00:00', '2022-06-29', '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('2', 'Glosil Scientific LLP', 'G002', NULL, NULL, '8148556619', 'viki.6103@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, '0', '284200', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-06-21 15:05:21', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('3', 'Glosil Scientific LLP', 'G003', NULL, NULL, '8148556619', 'viki.6103@gmail.com', 'd57d8a6', NULL, NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-06-21 15:34:55', NULL, '2022-06-29', '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('4', 'Test', 'G004', NULL, NULL, '9876543219', 'Test@test.com', NULL, NULL, NULL, NULL, NULL, NULL, '0', '383611', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-06-21 15:35:33', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('5', 'Glosil Scientific LLP', 'G005', NULL, NULL, '9597212113', 'gomathi.jayavel@gmail.com', '77d0681', NULL, NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-06-21 15:41:03', NULL, '2022-06-29', '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('6', 'Glosil scientific ', 'G006', NULL, NULL, '7904168144', 'rashmeejain98@gmail.com', '5b3c3ec', NULL, NULL, NULL, NULL, NULL, '0', '494451', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-06-23 10:58:37', NULL, '2022-06-29', '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('7', 'glosil scientific llp', 'G007', NULL, NULL, '9551367250', 'lokeshjayavel1993@gmail.com', 'acfa73d', NULL, NULL, NULL, NULL, NULL, '0', '490634', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-06-23 15:43:03', NULL, '2022-06-29', '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('8', 'Goldmine Infotech', 'G008', NULL, NULL, '9940044291', 'goldmineinfotech@gmail.com', '26597e4', '', '', NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-06-23 17:28:15', '2022-06-30 00:00:00', NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('9', 'Gomathi sci', 'G009', NULL, NULL, '9597212114', 'gomathisci@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, '0', '116183', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-06-24 12:17:41', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('10', 'Test', 'G010', NULL, NULL, '9898989898', 'test@gmail.com', NULL, '33BUUPS6048F1Z4', NULL, NULL, NULL, NULL, '0', '813918', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-06-29 12:42:00', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('11', 'GLOSIL SCIENTIFIC LLP', 'G011', NULL, NULL, '7305830501', 'info@glosilscientific.com', '77d0681', '33AAVFG4998G1ZP', '', NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-06-29 14:42:30', '2022-07-01 00:00:00', NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('12', 'GLOSIL', 'G012', NULL, NULL, '7904168143', 'rashmeejain98@gmail.com', NULL, 'â€‹33AAVFG4998G1ZP', NULL, NULL, NULL, NULL, '0', '993312', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-06-30 11:51:09', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('13', 'PRAXOR INSTRUMENTS AND SCIENTIFIC CO', 'G013', NULL, NULL, '9788000777', 'PRAVEENPROXOR@GMAIL.COM', '9ef6846', '33BPRPP0829K1ZG', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 11:22:37', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('14', 'Sri Ram scientific Traders', 'G014', NULL, NULL, '8838260562', 'sriramscientifictraders@gmail.com', NULL, '33AMQPD1286K1ZV', NULL, NULL, NULL, NULL, '0', '659753', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-07-01 11:35:31', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('15', 'Sri Ram scientific Traders', 'G015', NULL, NULL, '8838260562', 'sriramscientifictraders@gmail.com', 'aeac198', '33AMQPD1286K1ZV', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 11:37:45', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('16', 'Sri ram Scientific Traders', 'G016', NULL, NULL, '8838260562', 'sriramscientifictraders@gmail.com', NULL, '33AMQPD1286K1ZV', NULL, NULL, NULL, NULL, '0', '147345', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-07-01 11:39:18', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('17', 'GENESYS INC', 'G017', NULL, NULL, '9865126006', 'genesysinccbe@gmail.com', '7fac7f6', '33AAJFG1565H1ZI', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 11:45:52', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('18', 'DOLPHIN SCIENTIFIC SOLUTIONS', 'G018', NULL, NULL, '9444411215', 'dolphinmdu@gmail.com', 'eb0c028', '33ADXPR7719M1ZJ', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 11:46:37', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('19', 'Santhosh scientifics private limited', 'G019', NULL, NULL, '8754552365', 'accounts@santhoshscientifics.com', 'bb71e29', '33ABGCS4821B1ZS', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 11:50:36', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('20', 'santhosh scientifics private limited', 'G020', NULL, NULL, '9940240809', 'sales@santhoshscientifics.com', 'bb71e29', '33AABCG8774H1ZF', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 12:13:15', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('21', 'MARUTHI TRADER ', 'G021', NULL, NULL, '9840018488', 'maruthitrader@gmail.com', 'f0d134e', '33AAKPE9295R1ZU', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 12:52:15', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('22', 'Janandavel', 'G022', NULL, NULL, '9884319640', 'janandavel88@gmail.com', '13c07ad', '33strvsp', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 13:06:06', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('23', 'Hindustan Scientific Companies', 'G023', NULL, NULL, '9842249216', 'hss.scie@gmail.com', '5272546', '33AKKPP7208H2Z', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 13:15:48', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('24', 'Analytic Services', 'G024', NULL, NULL, '9840282177', 'analytic.chn@gmail.com', 'd74cb50', '33AIAPR7684M2ZM', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 13:49:57', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('25', 'MEHTA DOSHI & CO', 'G025', NULL, NULL, '9840081813', 'mehtadoshi@gmail.com', '8d8b991', '33AAAFM1320P1ZJ', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 14:23:19', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('26', 'Kesari scientific chemicals', 'G026', NULL, NULL, '9566180298', 'kesariscientificchemicals@gmail.com', '3e92f4e', '33AYFPJ0434L1ZM', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 14:25:30', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('27', 'Gemco Scientific Company', 'G027', NULL, NULL, '9842822310', 'info@gemcolabs.com', '70d313c', '33AAAHE1740B1Z8', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 14:28:21', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('28', 'DFT TECH', 'G028', NULL, NULL, '9789382483', 'dfttechindia@gmail.com', 'f1d9565', '33ACUPV4864D1Z3', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 14:35:23', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('29', 'HERENBA INSTRUMENTS & ENGINEERS', 'G029', NULL, NULL, '9791737778', 'herenbainstruments@gmail.com', 'f4991d7', '33AAHFH8721L1Z6', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 14:36:13', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('30', 'CHENKEM', 'G030', NULL, NULL, '9843010093', 'chenkemenquiry@gmail.com', '22a6b01', '33BJDPS4809J1Z1', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 14:49:59', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('31', 'THE SCIENTIFIC ENGINEERING WORKS', 'G031', NULL, NULL, '9443388285', 'apthangadurai@gmail.com', 'fe8a5c5', '33AELPT1763J1Z5', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 15:05:21', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('32', 'FUTURE LAB', 'G032', NULL, NULL, '9686799080', 'futurelabblr@gmail.com', '6083bd8', '29BIXPS8766F1Z1', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 15:21:20', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('33', 'Sri Jothi Chemicals', 'G033', NULL, NULL, '9443143003', 'srijothichem@yahoo.com', '1fd0c28', '33AHIPB6093P1ZZ', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 15:35:02', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('34', 'Glosil Scientific LLP', 'G034', NULL, NULL, '7200734670', 'glosilscientific@gmail.com', '17dadd0', '33AAVFG4998G1ZP', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 16:07:52', NULL, '2022-07-16', '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('35', 'R.R.Scientific Suppliers', 'G035', NULL, NULL, '9840120449', 'rrscientific@yahoo.co.in', 'e74654f', '33AGKPR1990A1ZI', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 16:12:00', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('36', 'srihari Scientific', 'G036', NULL, NULL, '9952958129', 'srihariscientific2013@gmail.com', '60064a2', '33AXRPC9965E1Z4', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 16:14:20', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('37', 'AIC INTERNATIONAL', 'G037', NULL, NULL, '9841020254', 'aicpondy@gmail.com', '804c5ce', '34AAQFA0099P1ZV', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 16:19:39', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('38', 'Sri Vinayaga scientific', 'G038', NULL, NULL, '9942937099', 'svstrichy2015@gmail.com', 'db6b3ec', '33BYQPB9005F1ZM', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 16:20:04', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('39', 'Chemico Glass And Scientific Company', 'G039', NULL, NULL, '9790014545', 'chemicoscientific@yahoo.co.in', '30b24c7', '33AIMPM9517C1Z9', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 17:18:29', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('40', 'NARESH SCIENTIFIC COMPANY', 'G040', NULL, NULL, '9345458671', 'nareshscientific@gmail.com', '0cf8509', '34ADJPV6994J1ZM', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 17:26:12', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('41', 'VIJAYA SCIENTIFIC COMPANY TNY', 'G041', NULL, NULL, '9884013356', 'salestny@vijayascientific.com', 'db6b3ec', '33ACPPL8181L1ZZ', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 17:46:59', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('42', 'PONMANI & CO.,', 'G042', NULL, NULL, '9486751611', 'ponmanitry@yahoo.co.in', '461708c', '33AAAFP5233C1ZV', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 17:49:52', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('43', 'SRI VETRI SCIENTIFIC COMPANY', 'G043', NULL, NULL, '7598595993', 'srivetriscientific@gmail.com', '0368f62', '34AXSPR0788H1ZT', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-02 09:17:26', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('44', 'VERTTEX ENTERPRISES', 'G044', NULL, NULL, '9884163463', 'salesverttex@gmail.com', 'bbf617c', '33ACGPL9480R1ZS', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-02 09:41:31', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('45', 'zoom scientific instruments', 'G045', NULL, NULL, '9080664331', 'zoomscientificinstruments@gmail.com', 'f356414', '33DOVPS6904F1ZG', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-02 10:36:07', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('46', 'zoom scientific instruments', 'G046', NULL, NULL, '9080664331', 'zoomscientificinstruments@gmail.com', NULL, '33DOVPS6904F1ZG', NULL, NULL, NULL, NULL, '0', '787611', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-07-02 10:36:09', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('47', 'CSSC Ltd', 'G047', NULL, NULL, '9986466604', 'csscomds@gmail.com', 'ab82c7e', '33AAACC3108Q1ZR', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-02 11:04:52', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('48', 'rakas science house', 'G048', NULL, NULL, '9842421597', 'rakas_kkl@yahoo.com', '4521ba0', '34gqsps5457k1zt', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-02 11:28:34', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('49', 'LabChems', 'G049', NULL, NULL, '8008688484', 'info@labchems.in', 'fde264a', '37BCYPP4304F1Z9', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-02 12:18:10', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('50', 'glosil', 'G050', NULL, NULL, '9597212113', 'gomathi.jayavel@gmail.com', '90282e5', '33AAVFG4998G1ZP', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-02 12:19:05', NULL, '2022-07-12', '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('51', 'Unicorn biomedicals', 'G051', NULL, NULL, '9884093060', 'unicornbiomed@gmail.com', NULL, '33AAGFU9694Q1Z2', NULL, NULL, NULL, NULL, '0', '342622', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-07-02 12:43:01', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('52', 'Unicorn biomedicals', 'G052', NULL, NULL, '9884093060', 'unicornbiomed@gmail.com', NULL, '33AAGFU9694Q1Z2', NULL, NULL, NULL, NULL, '0', '744565', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-07-02 12:43:04', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('53', 'MADRAS SCIENTIFIC SUPPLIES', 'G053', NULL, NULL, '9443825217', 'mss.slm1@gmail.com', '21affd4', '33AAHFM8015C1ZP', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-02 13:14:37', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('54', 'UNIVERSAL SCIENTIFIC APPLIANCES', 'G054', NULL, NULL, '9842083123', 'usas_2007@yahoo.com', '3a5bbd1', '33AQLPJ2492E1X', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-02 14:14:15', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('55', 'Hitech Clean Room Pvt.Ltd.', 'G055', NULL, NULL, '8925433747', 'hitechlaminar@gmail.com', '6aa9d99', '33AADCH2961F1ZV', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-02 15:17:58', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('56', 'Jayam Scientific Company', 'G056', NULL, NULL, '9443899136', 'jayam_14@yahoo.co.in', '62f0455', '', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-02 17:52:13', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('57', 'Associated instrument and chemicals', 'G057', NULL, NULL, '9841030204', 'chennai@aicgroup.in', '35a5130', '33AAAFA4546M1ZJ', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-02 17:59:10', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('58', 'Bhuvaneswar Scientific Glass Works', 'G058', NULL, NULL, '9566687733', 'bhuvaneswarscientific@gmail.com', 'b985bd2', '33AMZPB6070G1ZX', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-03 11:00:27', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('59', 'Nellai scientific company', 'G059', NULL, NULL, '9842426778', 'nellaiscientificcompany@gmail.com', '51e51dc', '33BCGPM5964C1ZO', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-03 19:47:06', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('60', 'SHANKAR SCIENTIFIC SUPPLIES', 'G060', NULL, NULL, '9962560135', 'sankars.chn@gmail.com', '28c8e17', '33ALXPS3074J2ZF', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-04 11:02:37', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('61', 'SK ENTERPRISES', 'G061', NULL, NULL, '9941158465', 'skenterprisesjoy@gmial.com', NULL, '33MJTPS6544M1Z0', NULL, NULL, NULL, NULL, '0', '842587', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-07-04 15:55:13', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('62', 'SK ENTERPRISES', 'G062', NULL, NULL, '9941158465', 'skenterprisesjoy@gmial.com', NULL, '33MJTPS6544M1Z0', NULL, NULL, NULL, NULL, '0', '122361', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-07-04 15:58:19', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('63', 'SK ENTERPRISES', 'G063', NULL, NULL, '9941158465', 'skenterprisesjoy@gmail.com', '7a56ffe', '33MJTPS6544M1Z0', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-04 16:00:34', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('64', 'shree scientific company', 'G064', NULL, NULL, '9003060805', 'shreescientificcorp@gmail.com', '7e174c3', '33BRGPR9488F1Z7', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-05 10:52:44', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('65', 'A.G.S.SCIENTIFIC COMPANY', 'G065', NULL, NULL, '9840382223', 'agschrompet@gmail.com', '00e0485', '33AAMFA5122F1ZW', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-05 12:20:25', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('66', 'Peculiar', 'G066', NULL, NULL, '6382731948', 'peculiarscientific@gmail.com', 'dbb2086', '33buwps0416b1zq', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-05 13:14:28', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('67', 'REYNA MULTIPLE SALES LOHGINS', 'G067', NULL, NULL, '9500483936', 'reynasales2277@gmail.com', '54c4bde', '33ACLPH6183J1ZD', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-05 16:30:11', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('68', 'Varma Scientific Company', 'G068', NULL, NULL, '9940200313', 'varmascientific@gmail.com', 'f932b64', '33BVBPM1320E1ZC', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-06 12:20:02', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('69', 'VS Agency', 'G069', NULL, NULL, '9442838160', 'vsagency15@gmail.com', NULL, '33FVZPS5548Q1Z3', NULL, NULL, NULL, NULL, '0', '702649', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-07-06 15:36:51', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('70', 'vsagecy', 'G070', NULL, NULL, '9442838160', 'vsagency15@gmail.com', 'e72fc62', '33FVZPS5548Q1Z3', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-06 17:31:28', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('71', 'EVERFLOW SCIENTIFIC INSTRUMENTS', 'G071', NULL, NULL, '9444259624', 'everflowscientific@yahoo.com', '99de74c', '33AFBPG5986P1ZX', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-07 10:48:05', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('72', 'MSP Laboratory Products & Services', 'G072', NULL, NULL, '9840471455', 'msplabproduct@gmail.com', 'f680479', '33CBLPM4502P1ZD', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-07 10:49:05', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('73', 'Aadi Enterprises', 'G073', NULL, NULL, '9974690102', 'toaadienterprises@yahoo.co.in', '423f87e', '', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-07 19:11:52', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('74', 'KRINSTRUMENTS', 'G074', NULL, NULL, '9886143298', 'krinstruments@gmail.com', '0b82760', '29AFQPM3297J1ZL', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-08 15:32:16', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('75', 'BS TECHNOLOGIES', 'G075', NULL, NULL, '9945068468', 'infobstechnologiesblr@gmail.com', 'd234b70', '29BTMPM1978F1Z4', '360 Dhanushree Apartments, Flat No A-401\r\nJakkasandra 1st Cross,Koramangala 1st Block\r\nBangalore - 560 034', NULL, NULL, NULL, '0', NULL, NULL, '1', '1', NULL, NULL, NULL, NULL, '2022-07-08 00:00:00', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('76', 'Sree Priya Scientific & Co', 'G076', NULL, NULL, '9840333668', 'sreepriyascientific@gmail.com', 'cafff59', '33BOXPP5928N2ZV', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-11 17:20:16', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('77', 'SCIENTIFIC SYSTEMS', 'G077', NULL, NULL, '9840721704', 'ss.scientificsystems@gmail.com', '985b964', '33AAFPJ9077K1ZC', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-12 10:27:04', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('78', 'KAVIN SCIENTIFIC PRODUCTS', 'G078', NULL, NULL, '9840054224', 'kavinscientific@gmail.com', NULL, '33AQKPP4277G1ZL', NULL, NULL, NULL, NULL, '0', '101829', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-07-12 13:53:04', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('79', 'KAVIN SCIENTIFIC PRODUCTS', 'G079', NULL, NULL, '9840054224', 'kavinscientific@yahoo.co.uk', '8a12ff8', '33AQKPP4277G1ZL', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-12 13:54:31', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('80', 'vijayascientific company', 'G080', NULL, NULL, '9884013709', 'salesmadurai@vijayascientific.com', 'bb14dbb', '33ACPPL8181L1ZZ', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-13 10:43:34', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('81', 'SAIRAM SCIENTIFIC', 'G081', NULL, NULL, '9842159043', 'sairamscientific@gmail.com', '7b80585', '33ADAFS0245G1ZK', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-13 12:55:30', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('82', 'Sai Associate', 'G082', NULL, NULL, '9841680906', 'saiassociate2009@gmail.com', '9d8338f', '33BGZPM7917E!ZW', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-13 15:15:24', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('83', 'Biolabs and Life Sciences LLP', 'G083', NULL, NULL, '6380553030', 'customercare@biolabsllp.com', '6b560bf', '33AASFB6747P1ZN', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-13 15:30:55', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('84', 'Synergy Scientific Services', 'G084', NULL, NULL, '7299081480', 'instruments@synergyscientific.in', 'f6a420f', '33AEMPV6474K1ZQ', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-13 16:51:54', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('85', 'Argon Scientific ', 'G085', NULL, NULL, '8943119995', 'info@argonscientific.co.in', 'f29589b', '32ABXFA5279K1ZS', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-14 17:08:59', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('86', 'GLOBAL SCIENTIFIC COMPANY', 'G086', NULL, NULL, '7708299632', 'globalscientificerd@gmail.com', NULL, '33AYDPT4126D1ZQ ', NULL, NULL, NULL, NULL, '0', '144907', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-07-15 12:21:07', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('87', 'GLOBAL SCIENTIFIC COMPANY', 'G087', NULL, NULL, '7708299632', 'globalscientificerd@gmail.com', NULL, '33AYDPT4126D1ZQ ', NULL, NULL, NULL, NULL, '0', '212688', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-07-15 12:21:09', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('88', 'GLOBAL SCIENTIFIC COMPANY', 'G088', NULL, NULL, '7708299632', 'globalscientificerd@gmail.com', 'f006b30', '33AYDPT4126D1ZQ ', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-15 12:21:09', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('89', 'M.VKRISHNAARAM LABORATORIES CHEMICALS CO', 'G089', NULL, NULL, '9840702945', 'mvkrishnaaram@yahoo.co.in', '87a3168', '33AADFM4922G1ZL', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-15 15:08:46', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('90', 'Glosil Scientific LLP', 'G090', NULL, NULL, '7200734670', 'glosilscientific@gmail.com', 'a53f8a3', '33AAVFG4998G1ZP', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-16 11:14:48', NULL, '2022-07-16', '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('91', 'Glosil Scientific LLP', 'G091', NULL, NULL, '7200734670', 'glosilscientific@gmail.com', 'a53f8a3', '33AAVFG4998G1ZP', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-16 11:22:03', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('92', 'Temple way', 'G092', NULL, NULL, '9994293024', 'templeway2020@gmail.com', 'af374ea', '33BVDPS0491Q2Z0', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-16 23:00:26', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('93', 'Kalro trades ', 'G093', NULL, NULL, '9840500006', 'kalrotrades@gmail.com', 'c6c6e7c', '33AAAFK0705C1Z9', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-17 10:15:08', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('94', 'universal scientific co', 'G094', NULL, NULL, '9842207200', 'universalscientificcbe@gmail.com', 'cbcb42b', '33ADJPT8641G1Z9', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-17 10:46:52', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('95', 'BIOSCIENCE', 'G095', NULL, NULL, '9847695181', 'bioscience641@gmail.com', 'aeba88a', '32AAZFB5266G1Z5', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-18 08:26:29', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('96', 'The Precision Scientific co', 'G096', NULL, NULL, '9843922732', 'psctvl@gmail.com', NULL, '33ACOPC4845P1Z6', NULL, NULL, NULL, NULL, '0', '633399', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-07-18 10:01:23', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('97', 'The Precision Scientific co', 'G097', NULL, NULL, '9843922732', 'psctveli@gmail.com', '7241e92', '33ACOPC4845P1Z6', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-18 10:02:00', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('98', 'THE SCIENTIFIC UNLIMITED', 'G098', NULL, NULL, '9843059043', 'thescientificunlimited@gmail.com', '4bbbb6c', '33MZYPS2699E1Z8', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-18 10:24:52', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('99', 'Royal Scientific Suppliers', 'G099', NULL, NULL, '9443648388', 'royalscientifictry@gmail.com', '0f3c1c1', '33ajzpr3621g1zw', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-18 11:55:01', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('100', 'CHITRA SCIENTIFIC INDUSTRIES', 'G100', NULL, NULL, '9962853734', 'chitrascientific@yahoo.com', NULL, '33GTHPM7571N1ZX', NULL, NULL, NULL, NULL, '0', '677681', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-07-18 12:31:38', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('101', 'CHITRA SCIENTIFIC INDUSTRIES', 'G101', NULL, NULL, '9751513734', 'chitrascientific@gmail.com', '69ff72e', '33GTHPM7571N1ZX', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-18 12:36:59', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('102', 'Shri Madhii Traders', 'G102', NULL, NULL, '9843053580', 'shrimadhii@yahoo.co.in', 'b1a1d6a', '33AAUPL4305R1Z4', NULL, NULL, NULL, NULL, '0', '961502', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-18 13:34:05', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('103', 'SS INSTRUMENTS', 'G103', NULL, NULL, '9380307375', 'ssinstrumentschennai@gmail.com', '1515f55', '33AIWPG2289B1Z8', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-19 09:47:37', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('104', 'ABONDING ', 'G104', NULL, NULL, '9442576397', 'abonding22@gmail.com', '7aeeb2f', '33BOOPK1916G1Z1', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-19 16:33:29', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('105', 'INNOVATIONS DIAGNOSTICS', 'G105', NULL, NULL, '9080143346', 'innovationdiagnostics@gmail.com', 'd234b70', '33AAFFI1699J1Z4', '28-A, P.R.V. Complex, 10/1-2, Kalingarayan Street, \r\nRam Nagar, Coimbatore-641009', NULL, NULL, NULL, '0', NULL, NULL, '1', '1', NULL, NULL, NULL, NULL, '2022-07-20 00:00:00', '2022-07-20 00:00:00', NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('106', 'Chitra Scientific Industries', 'G106', NULL, NULL, '9962853734', 'chitrascientific@yahoo.com', NULL, '33GTHPM7571N1ZX', NULL, NULL, NULL, NULL, '0', '682146', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-07-21 15:02:38', NULL, NULL, '1');


#
# TABLE STRUCTURE FOR: email_setup
#

DROP TABLE IF EXISTS `email_setup`;

CREATE TABLE `email_setup` (
  `id` int(11) NOT NULL,
  `email_protocol` varchar(50) DEFAULT 'SMTP',
  `email_encription` varchar(50) DEFAULT NULL,
  `smtp_host` varchar(50) DEFAULT NULL,
  `smtp_port` int(11) DEFAULT NULL,
  `smtp_email` varchar(100) DEFAULT NULL,
  `from_address` varchar(100) DEFAULT NULL,
  `from_name` varchar(100) DEFAULT NULL,
  `smtp_username` varchar(100) DEFAULT NULL,
  `smtp_password` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `email_setup` (`id`, `email_protocol`, `email_encription`, `smtp_host`, `smtp_port`, `smtp_email`, `from_address`, `from_name`, `smtp_username`, `smtp_password`) VALUES ('2', 'SMTP', 'mail.hhgro.com', 'hhgro.com', '587', 'noreply@hhgro.com', 'noreply@hhgro.com', 'hhGro ', 'noreply@hhgro.com', 'PzkwgBv6VOWk');


#
# TABLE STRUCTURE FOR: groups
#

DROP TABLE IF EXISTS `groups`;

CREATE TABLE `groups` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) DEFAULT NULL,
  `description` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO `groups` (`id`, `name`, `description`) VALUES ('1', 'admin', 'Administrator');
INSERT INTO `groups` (`id`, `name`, `description`) VALUES ('2', 'purchaser', '');
INSERT INTO `groups` (`id`, `name`, `description`) VALUES ('3', 'sales_person', '');
INSERT INTO `groups` (`id`, `name`, `description`) VALUES ('4', 'manager', '');
INSERT INTO `groups` (`id`, `name`, `description`) VALUES ('5', 'accountant', '');
INSERT INTO `groups` (`id`, `name`, `description`) VALUES ('6', 'members', '');


#
# TABLE STRUCTURE FOR: log
#

DROP TABLE IF EXISTS `log`;

CREATE TABLE `log` (
  `id` int(11) NOT NULL,
  `timestamp` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `user_id` int(11) DEFAULT '0',
  `table_id` int(11) DEFAULT NULL,
  `message` varchar(1000) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `log` (`id`, `timestamp`, `user_id`, `table_id`, `message`) VALUES ('0', '2021-02-02 07:07:08', '1', '1', 'Border Inserted');


#
# TABLE STRUCTURE FOR: order_items
#

DROP TABLE IF EXISTS `order_items`;

CREATE TABLE `order_items` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT COMMENT 'Primary key',
  `order_id` mediumint(8) DEFAULT NULL,
  `product_id` mediumint(8) DEFAULT NULL,
  `product_sku` varchar(50) DEFAULT NULL,
  `product_weight_id` mediumint(8) DEFAULT NULL,
  `product_weight` varchar(15) DEFAULT NULL,
  `product_price` decimal(25,2) DEFAULT NULL,
  `product_qty` double DEFAULT NULL,
  `tax_id` mediumint(8) DEFAULT NULL,
  `product_tax` double DEFAULT NULL,
  `discount_id` mediumint(8) DEFAULT NULL,
  `discount_value` double DEFAULT NULL,
  `product_discount` decimal(25,2) DEFAULT NULL,
  `order_subtotal` decimal(25,2) DEFAULT NULL,
  `insertedat` datetime DEFAULT NULL,
  `updatedat` datetime DEFAULT NULL,
  `delete_date` date DEFAULT NULL,
  `delete_status` int(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: orders
#

DROP TABLE IF EXISTS `orders`;

CREATE TABLE `orders` (
  `order_id` mediumint(8) NOT NULL AUTO_INCREMENT COMMENT 'Primary key',
  `order_ref_no` varchar(15) DEFAULT NULL,
  `order_date` datetime DEFAULT NULL,
  `no_of_items` double DEFAULT NULL,
  `grand_total` decimal(25,2) DEFAULT NULL,
  `customer_id` mediumint(8) DEFAULT NULL,
  `order_status` varchar(25) DEFAULT NULL,
  `otype` varchar(25) DEFAULT NULL,
  `notes` text,
  `delete_date` date DEFAULT NULL,
  `delete_status` int(1) DEFAULT '0',
  `views` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`)
) ENGINE=InnoDB AUTO_INCREMENT=49 DEFAULT CHARSET=latin1;

INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('1', 'GS-001', '2022-06-21 15:47:26', '2', NULL, '5', NULL, NULL, 'Dear Sir,\r\n\r\nPlease send dispatch items today.\r\n\r\nThanks\r\nGomathi', NULL, '1', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('2', 'GS-002', '2022-06-21 16:13:21', '1', NULL, '5', NULL, NULL, 'Dear Sir,\r\n\r\n', NULL, '1', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('3', 'GS-003', '2022-06-22 12:59:10', '1', NULL, '1', NULL, NULL, 'fdskbfadjf', NULL, '1', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('4', 'GS-004', '2022-06-22 22:05:15', '2', NULL, '1', NULL, NULL, 'Please dispatch the above order ', NULL, '1', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('5', 'GS-005', '2022-06-23 11:44:50', '2', NULL, '6', NULL, NULL, 'Whatsapp Order', NULL, '1', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('6', 'GS-006', '2022-06-23 11:46:06', '0', NULL, '6', NULL, NULL, 'Whatsapp Order', NULL, '1', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('7', 'GS-007', '2022-06-23 11:58:05', '3', NULL, '6', NULL, NULL, 'demo', NULL, '1', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('8', 'GS-008', '2022-06-23 15:32:33', '1', NULL, '5', NULL, NULL, 'Test message', NULL, '1', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('9', 'GS-009', '2022-06-23 17:30:23', '7', NULL, '8', NULL, NULL, 'Whatsapp Order', NULL, '1', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('10', 'GS-010', '2022-06-24 10:45:51', '2', NULL, '5', NULL, NULL, 'Whatsapp Order', NULL, '1', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('11', 'GS-011', '2022-06-28 17:04:45', '2', NULL, '6', NULL, NULL, 'Whatsapp Order', NULL, '1', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('12', 'GS-012', '2022-06-28 17:07:57', '1', NULL, '5', NULL, NULL, 'Whatsapp Order', NULL, '1', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('13', 'GS-013', '2022-06-28 17:08:01', '1', NULL, '6', NULL, NULL, 'gfhhkgjkgjkghjkhjk', NULL, '1', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('14', 'GS-014', '2022-06-28 17:08:02', '0', NULL, '6', NULL, NULL, 'gfhhkgjkgjkghjkhjk', NULL, '1', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('15', 'GS-015', '2022-06-28 17:08:03', '0', NULL, '6', NULL, NULL, 'gfhhkgjkgjkghjkhjk', NULL, '1', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('16', 'GS-016', '2022-06-28 17:08:04', '0', NULL, '6', NULL, NULL, 'gfhhkgjkgjkghjkhjk', NULL, '1', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('17', 'GS-017', '2022-06-28 17:08:05', '0', NULL, '6', NULL, NULL, 'gfhhkgjkgjkghjkhjk', NULL, '1', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('18', 'GS-018', '2022-06-28 20:19:42', '2', NULL, '8', NULL, NULL, 'Whatsapp Order', NULL, '1', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('19', 'GS-019', '2022-06-28 20:29:23', '5', NULL, '8', NULL, NULL, 'Whatsapp Order', NULL, '1', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('20', 'GS-020', '2022-06-29 11:57:04', '2', NULL, '8', NULL, NULL, 'Test', NULL, '1', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('21', 'GS-021', '2022-06-29 12:00:00', '1', NULL, '8', NULL, NULL, 'Test', NULL, '1', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('22', 'GS-022', '2022-06-29 12:00:59', '1', NULL, '8', NULL, NULL, 'Test', NULL, '1', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('23', 'GS-023', '2022-06-29 15:32:40', '3', NULL, '11', NULL, NULL, 'sample testing from rajesh\r\n ', NULL, '1', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('24', 'GS-024', '2022-06-29 15:34:06', '3', NULL, '11', NULL, NULL, 'Whatsapp Order', NULL, '1', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('25', 'GS-025', '2022-06-29 15:51:15', '3', NULL, '11', NULL, NULL, 'Whatsapp Order', NULL, '1', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('26', 'GS-026', '2022-06-30 19:07:28', '1', NULL, '11', NULL, 'Whatsapp Enquiry', 'Whatsapp Order', NULL, '1', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('27', 'GS-027', '2022-07-01 11:51:55', '2', NULL, '11', NULL, 'Whatsapp Enquiry', 'Whatsapp Order', NULL, '1', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('28', 'GS-028', '2022-07-01 11:58:19', '2', NULL, '11', NULL, 'Purchase Order', 'Po.no.425 \r\n\r\nPlease dispatch through Rathimeena', NULL, '1', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('29', 'GS-029', '2022-07-01 12:58:13', '1', NULL, '21', NULL, 'Enquiry', 'Please send the catalogue for AM4201', NULL, '0', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('30', 'GS-030', '2022-07-01 13:25:10', '1', NULL, '23', NULL, 'Enquiry', 'Share Photo ', NULL, '0', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('31', 'GS-031', '2022-07-01 16:16:54', '1', NULL, '36', NULL, 'Purchase Order', 'Sir, kindly supply the following products', NULL, '0', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('32', 'GS-032', '2022-07-02 09:06:12', '1', NULL, '11', NULL, 'Whatsapp Enquiry', 'Whatsapp Order', NULL, '1', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('33', 'GS-033', '2022-07-06 17:36:33', '2', NULL, '70', NULL, 'Purchase Order', 'please send me the proforma invoice', NULL, '0', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('34', 'GS-034', '2022-07-07 12:00:00', '1', NULL, '11', NULL, 'Enquiry', 'Please send the catalogue for the selected product', NULL, '0', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('35', 'GS-035', '2022-07-07 12:04:35', '1', NULL, '11', NULL, 'Purchase Order', 'PO.No.123456', NULL, '0', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('36', 'GS-036', '2022-07-08 10:33:37', '2', NULL, '32', NULL, 'Whatsapp Enquiry', 'Whatsapp Order', NULL, '0', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('37', 'GS-037', '2022-07-12 10:48:52', '1', NULL, '27', NULL, 'Whatsapp Enquiry', 'Whatsapp Order', NULL, '0', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('38', 'GS-038', '2022-07-14 12:25:20', '1', NULL, '42', NULL, 'Purchase Order', 'PO-6311', NULL, '1', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('39', 'GS-039', '2022-07-14 12:32:31', '1', NULL, '11', NULL, 'Purchase Order', 'sample', NULL, '0', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('40', 'GS-040', '2022-07-14 12:33:13', '1', NULL, '42', NULL, 'Purchase Order', 'PO-6311', NULL, '0', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('41', 'GS-041', '2022-07-14 12:38:40', '1', NULL, '42', NULL, 'Purchase Order', 'PO-6311', NULL, '1', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('42', 'GS-042', '2022-07-14 14:37:35', '2', NULL, '8', NULL, 'Enquiry', 'Testing Enquiry', NULL, '0', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('43', 'GS-043', '2022-07-18 12:13:12', '2', NULL, '99', NULL, 'Purchase Order', 'PO NO-525', NULL, '0', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('44', 'GS-044', '2022-07-18 16:41:48', '1', NULL, '83', NULL, 'Whatsapp Enquiry', 'Whatsapp Order', NULL, '0', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('45', 'GS-045', '2022-07-18 18:01:33', '2', NULL, '36', NULL, 'Purchase Order', 'Sir kindly supply the following Products', NULL, '0', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('46', 'GS-046', '2022-07-19 17:10:42', '1', NULL, '85', NULL, 'Whatsapp Enquiry', 'Whatsapp Order', NULL, '1', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('47', 'GS-047', '2022-07-19 17:12:39', '1', NULL, '85', NULL, 'Purchase Order', 'Please send PI with discount rate', NULL, '0', '1');
INSERT INTO `orders` (`order_id`, `order_ref_no`, `order_date`, `no_of_items`, `grand_total`, `customer_id`, `order_status`, `otype`, `notes`, `delete_date`, `delete_status`, `views`) VALUES ('48', 'GS-048', '2022-07-21 12:48:26', '1', NULL, '97', NULL, 'Purchase Order', 'THE PRECISION SCIENTIFIC CO(CBE) - TIRUNELVELI\r\n\r\nBILLING AND SHIPPING TO TIRUNELVELI\r\n\r\nPO NO : 186/21.07.2022', NULL, '0', '1');


#
# TABLE STRUCTURE FOR: products
#

DROP TABLE IF EXISTS `products`;

CREATE TABLE `products` (
  `product_id` mediumint(8) NOT NULL AUTO_INCREMENT COMMENT 'Primary key',
  `category_id` int(11) DEFAULT NULL COMMENT 'Foreign Key',
  `subcategory_id` int(11) DEFAULT NULL COMMENT 'Foreign Key',
  `brand_id` int(11) DEFAULT NULL,
  `product_code` varchar(255) DEFAULT NULL,
  `product_name` text CHARACTER SET utf8,
  `product_rate` varchar(25) DEFAULT NULL,
  `rcolor` tinyint(1) NOT NULL DEFAULT '0',
  `pcolor` tinyint(1) NOT NULL DEFAULT '0',
  `product_status` int(1) DEFAULT '0',
  `udate` varchar(25) DEFAULT NULL,
  `product_desc` text,
  `product_image` varchar(255) DEFAULT NULL,
  `product_pdf` varchar(255) DEFAULT NULL,
  `product_video` varchar(500) DEFAULT NULL,
  `insertedat` date DEFAULT NULL,
  `updatedat` datetime DEFAULT NULL,
  `sortid` tinyint(1) NOT NULL DEFAULT '0',
  `delete_date` date DEFAULT NULL,
  `delete_status` int(1) DEFAULT '0',
  PRIMARY KEY (`product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3265 DEFAULT CHARSET=latin1;

INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1', '1', '1', '26', 'AM4201', '<p>Model AM 4201 Portable Anemometer Lutron, Taiwan made with fan type vane, range 0.4 to 30m/s knots, feet and kms</p>', '6450', '0', '0', '1', '14-07-2022', '<h4><strong>Model AM 4201 Portable Anemometer Lutron, Taiwan made with fan type vane, range 0.4 to 30m/s knots, feet and kms</strong></h4>\r\n\r\n<ul>\r\n	<li>Data Hold.</li>\r\n	<li>Compact housing cabinmate.</li>\r\n	<li>Conventional twisted vane arms, always a source of unreliability have been eliminated.</li>\r\n	<li>Multi-functions for air flow measurement: m/s, km/h, ft/min &amp; knots.</li>\r\n	<li>Low-friction ball-bearing design resulting in accuracy at both high and low velocities.</li>\r\n	<li>The portable anemometer provides fast accurate readings with digital readability and the convenience of a remote sensor separately.</li>\r\n</ul>\r\n', '47470146762cfa6ae17060.jpg', '26647904662cfa6ae1735d.pdf', '<iframe width=\"560\" height=\"315\" src=\"https://www.youtube.com/embed/kjtWj8CmOqQ\" title=\"YouTube video player\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture\" allowfullscreen=\"\"></iframe>', NULL, '2022-07-14 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('2', '1', '1', '26', 'AM4202', 'Model AM 4202 Without RS-232 AP with temperature ,Taiwan made, range 0.4 to 30m/s ', '10000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('3', '1', '1', '26', 'AM4204', 'Model AM 4204 Hot Wire Anemometer Range 0.2 to 20 m/s and knots, feet and kms with Temp  0\'C to 50\'C ', '18000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('4', '1', '1', '26', 'AM4213', 'Model AM 4213 Mini fan/vane for high temp of 80c and low velocity 0.8 to 12m/s Hot Wire ', '24000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('5', '1', '1', '26', 'AM4221', 'Model AM 4221 Lutron, Anemometer Cup counter Taiwan made', '11500', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('6', '1', '1', '26', 'AM4222', 'Model AM 4222 Lutron, Taiwan handy with vane ', '5000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('7', '1', '2', '26', 'LM8000', 'Model LM 8000 Taiwan 4 in1 for Velocity, Temperature, Humidity and Lux. Handy built-in vane', '7200', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('8', '1', '2', '26', 'LM8010', 'Model LM 8010 Anemo / Temp/ Air Flow / RH / LUX  5 in 1 ', '8250', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('9', '1', '2', '26', 'LM8102', 'Model LM 8102 Anemo / Sound Level / Temp / RH / LUX 5 in 1 ', '11700', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('10', '1', '3', '42', 'TESTO4101', 'Testo-410-1 Velocity Meter(Vane Anemometer), Two variants with velocity, humidity & temperature, Timed mean calculation, Variant with humidity also calculates psycometric values ', '7400', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('11', '1', '3', '42', 'TESTO4102', 'Testo-410-2 Velocity Meter (3 in 1 Anemometer), Two variants with velocity, humidity & temperature, Timed mean calculation, Variant with humidity also calculates psycometric values ', '11500', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('12', '1', '4', '42', 'TESTO405I', '<p>Testo-405i Smart Thermal Anemometer (Thermal Anemometer) Measurement of air flow velocity , temperature and volume flow, range 0 - 30 m/s and -20&deg;C to +60&deg;C, Telescopic shaft,extendable upto 400 mm, wireless connection to a smartphone or tablet via Bluetooth free app, All measurement data in graph or tabular format, can be directly sent as PDF or excel files, testovent 415</p>', '13000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('13', '1', '4', '42', 'TESTO410I', '<p>Testo-410i Smart Vane Anemometer Measurement of air flow velocity,volume flow and &nbsp;temperature at air outlets,range of 0.4 to 30 m/s and -20&deg;C to +60&deg;C, Telescopic shaft, extendable upto 400 mm, wireless connection to a smartphone or tablet via Bluetooth free app, All measurement data in graph or tabular format, can be directly sent as PDF or excel files</p>', '10900', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('14', '1', '5', '15', 'GVBUCKET20', '<p>GV-BUCKET-20 Bucket type Aluminum-300x350mm (12&quot;x15&quot;) with Pressure Gauge , Heater 20 lt</p>', '6250', '0', '0', '1', '16-07-2022', '', '', '', '', NULL, '2022-07-16 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('15', '1', '5', '15', 'GVCOOKER20', '<p>GV-COOKER-20 Cooker Type S.Steel-300x300mm(12&quot;x12&quot;) / Bucket Model Vertical Type with Pressure Gauge, Heater 20 lt</p>', '12000', '0', '0', '1', '16-07-2022', '', '', '', '', NULL, '2022-07-16 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('16', '1', '6', '15', 'GVFT203', 'FT-203 Size 12\" X 20\" Verical Economy Autoclave, Double Chamber construction, Wing Nut Type locking system, Inner & Outer made of SS 202 grade, support ring is mad of cast aluminium dully polished,Lid Mad of 202 Grade SS , Pressure adjustable from 5 psi to 15 psi ', 'POR', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('17', '1', '6', '15', 'GVFT204', 'FT-204 Size 12\" X 20\"  Verical Economy Plus Autoclave,Double Chamber construction, Wing Nut Type locking system, Inner & Outer made of SS 202 grade, support ring is mad of cast aluminium dully polished,Lid Mad of 202 Grade SS , Pressure adjustable from 5 psi to 15 psi ', '23500', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('18', '1', '7', '15', '', 'Laboratory Autoclaves are made of Double chamber, Stainless steel 304 grade. Supplied with standard accessories such as: Radial locking system,paddle lifting arrangement, pressure control switch, low water cut off, manual timer. Dual safety valve, Pressure guage, steam release valve, water outlet valve.', '', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('19', '1', '7', '15', '', 'SEMI AUTOMATIC: Incorporated with low water cut off device, microprocessor based controller (Programmable by user) digital display of temp and timer. After achieving 121 degree timer starts automatically which is also preset at 30 Minutes (Adjustable). After cycle end unit gets switched off and steam can be released manually. Standard working temperature 121 degree. However as per requirement it can be upgraded upto 134 degree (On Extra Cost)', '', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('20', '1', '7', '15', 'GVFTS301', 'FTS-301 , Semi automatic Size 12\" X 20\" (300 X 300 mm) Capacity 40 Ltrs, 3 kw load', '67500', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('21', '1', '7', '15', 'GVFTS302', 'FTS-302 , Semi automatic Size 12\" X 20\" (300 X 300 mm) Capacity 50 Ltrs, 3 kw load', '75950', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('22', '1', '7', '15', 'GVFTS303', 'FTS-303 , Semi automatic Size 12\" X 20\" (300 X 300 mm) Capacity 78 Ltrs, 4.5 kw load', '102000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('23', '1', '7', '15', 'GVFTS304', 'FTS-304 , Semi automatic Size 18\" X 24\" (450 X 600 mm) Capacity 90 Ltrs, 6 kw load', '131625', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('24', '1', '7', '15', '', 'FULLY AUTOMATIC: Incorporated with low water cut off device, microprocessor based controller (Programmable by user) digital display of temp and timer. Enable reproducibility of results as full cycle included pursing of stale air, Sterilization hold time, cycle ends with automatic steam release. Requires no intervention. Standard working temperature 121 degeree, However as per requirement it can be upgraded upto 134 degree (On Extra Cost)', '', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('25', '1', '7', '15', 'GVFTF301', 'FTF-301 , Fully automatic Size 12\" X 20\" (300 X 300 mm) Capacity 40 Ltrs, 3 kw load', '81000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('26', '1', '7', '15', 'GVFTF304', 'FTF-304 , Fully automatic Size 18\" X 24\" (450 X 600 mm) Capacity 90 Ltrs, 6 kw load', '145125', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('27', '1', '8', '8', '', '<p>Agate Black Stone 2&quot;</p>', '550', '1', '0', '1', '22-07-2022', '', '', '', '', NULL, '2022-07-22 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('28', '1', '8', '8', '', '<p>Agate Black Stone 3&quot;</p>', '900', '1', '0', '1', '22-07-2022', '', '', '', '', NULL, '2022-07-22 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('29', '1', '8', '8', '', '<p>Agate Black Stone 4&quot;</p>', '1500', '1', '0', '1', '22-07-2022', '', '', '', '', NULL, '2022-07-22 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('30', '1', '8', '8', '', '<p>Agate Black Stone 5&quot;</p>', '2650', '1', '0', '1', '22-07-2022', '', '', '', '', NULL, '2022-07-22 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('31', '1', '8', '8', '', '<p>Agate Black Stone 6&quot;</p>', '3750', '1', '0', '1', '22-07-2022', '', '', '', '', NULL, '2022-07-22 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('32', '1', '8', '8', '', 'Agate Gray Stone 2\" ', '2500', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('33', '1', '8', '8', '', 'Agate Gray Stone 3\" ', '5000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('34', '1', '8', '8', '', 'Agate Gray Stone 4\" ', '8000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('35', '1', '8', '8', '', 'Agate Gray Stone 5\" ', '17500', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('36', '1', '8', '8', '', 'Agate Gray Stone 6\" ', '30000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('37', '1', '9', '23', 'AC15', 'Alumina Crucible 15 ml', '350', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('38', '1', '9', '23', 'AC25', 'Alumina Crucible 25 ml', '450', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('39', '1', '9', '23', 'AC30', 'Alumina Crucible 30 ml', '475', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('40', '1', '9', '23', 'AC50', 'Alumina Crucible 50 ml', '600', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('41', '1', '9', '23', 'AC100', 'Alumina Crucible 100 ml', '850', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('42', '1', '9', '23', 'AC200', 'Alumina Crucible 200 ml', '1400', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('43', '1', '9', '23', 'AC250', 'Alumina Crucible 250 ml', '1750', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('44', '1', '9', '23', 'AC500', 'Alumina Crucible 500 ml', '4000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('45', '1', '9', '23', 'AC1000', 'Alumina Crucible 1000 ml', '8000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('46', '1', '10', '23', 'AL15', 'Alumina Lid 15 ml', '175', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('47', '1', '10', '23', 'AL25', 'Alumina Lid 25 ml', '225', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('48', '1', '10', '23', 'AL30', 'Alumina Lid 30 ml', '240', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('49', '1', '10', '23', 'AL50', 'Alumina Lid 50 ml', '300', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('50', '1', '10', '23', 'AL100', 'Alumina Lid 100 ml', '425', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('51', '1', '10', '23', 'AL200', 'Alumina Lid 200 ml', '700', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('52', '1', '10', '23', 'AL250', 'Alumina Lid 250 ml', '875', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('53', '1', '10', '23', 'AL500', 'Alumina Lid 500 ml', '2000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('54', '1', '10', '23', 'AL1000', 'Alumina Lid 1000 ml', '4000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('55', '2', '11', '5', '', 'Baraometer BARIGO Cat no.183 Dial size 85 mm German Make', '7000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('56', '2', '12', '15', 'GVBB', 'GV-BB Electric Bunsen with energy regulator up to 350*C Rating 230V', '2750', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('57', '2', '13', '15', 'GVBOD4 ', 'GV- BOD-4 Size 400x450x600 mm 4CFT CAPACITY 105LTRS INNER  SS OUTER MS Powder coated with digital temp cont 5 to 100c ', '62000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('58', '2', '13', '15', 'GVBOD6', 'GV- BOD-6 Size 410x500x850 mm 6CFT CAPACITY 175LTRS INNER SS OUTER MS Powder coated with digital temp cont 5 to 100c ', '73000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('59', '2', '14', '25', '2444460', 'BOD Measurement System  LOVIBOND BD 600  6 measuring sensors   code no 2444460 ', '328430', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('60', '2', '14', '25', '2444465', 'BOD Measurement System  LOVIBOND BD 606  12 measuring sensors   code no 2444465', '630424', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('61', '2', '15', '34', 'RSBT5 ', '<p>RSBT-5 Digital Bomb Calorimeter With Water Jacket With Puff Insulation, Safety Device, Sensor Probe, High Pressure Flexible Tubing Set &amp; Certified Bomb. Temp. Resolution 0.01&deg;C.</p>', '105950', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('62', '2', '15', '34', 'RSBT6', '<p>RSBT-6 Automatic Bomb Calorimeter Microprocessor Based 20 X 4 Lcd Display With Keypad On Front Pannel, Automatic Calculation &amp; Memory Storage Via Usb Interface In Pc. Supplied With Water Jacket With Puff Insulation, Safety Device, Sensor Probe, High Pressure Flexible Tubing Set &amp; Certified Bomb. Temp. Resolution 0.001&deg;C.</p>', '188500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('63', '2', '16', '34', 'RSBTS1 ', 'RSBT-S-1 	Complete Bomb With Works Test Certificate ', '36750', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('64', '2', '16', '34', 'RSBTS2 ', 'RSBT-S-2 	Complete Bomb Certified By Testing Lab ', '44070', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('65', '2', '16', '34', 'RSBTS3', 'RSBT-S-3 	Water Jacket With Puff Insulation ', '27200', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('66', '2', '16', '34', 'RSBTS4', 'RSBT-S-4 	Calorimeter Vessel (Copper) ', '15000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('67', '2', '16', '34', 'RSBTS5', 'RSBT-S-5 	Combined Lid For Calorimeter Vessel ', '7500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('68', '2', '16', '34', 'RSBTS6', 'RSBT-S-6 	Bomb Support Stand ', '2800', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('69', '2', '16', '34', 'RSBTS7', 'RSBT-S-7 	Calorimeter Vessel Stand ', '2550', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('70', '2', '16', '34', 'RSBTS8', 'RSBT-S-8 	Stirrer Motor ', '19700', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('71', '2', '16', '34', 'RSBTS9', 'RSBT-S-9 	Pellet Press ', '15950', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('72', '2', '16', '34', '', 'RSBT-S - 10 	Connecting Tube To Connect Bomb & Safety Device ', '', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('73', '2', '16', '34', 'RSBTS10A', 'Made Of Copper ', '3470', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('74', '2', '16', '34', 'RSBTS10B', 'Made Of High Pressure Rubber Flexible Tube. ', '4790', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('75', '2', '16', '34', '', 'RSBT-S-11 	Connecting Tube To Connect Oxygen Control Valve & Pressure Gauge ', '', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('76', '2', '16', '34', 'RSBTS11A', 'Made Of Copper ', '2550', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('77', '2', '16', '34', 'RSBTS11B', 'Made Of High Pressure Rubber Flexible Tube. ', '3660', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('78', '2', '16', '34', '', 'RSBT-S-12 Connecting Tube To Connect Safety Device & Pressure Gauge ', '', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('79', '2', '16', '34', 'RSBTS12A', 'Made Of Copper ', '1220', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('80', '2', '16', '34', 'RSBTS12B', 'Made Of High Pressure Rubber Flexible Tube.. ', '1790', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('81', '2', '16', '34', 'RSBTS13', 'RSBT-S-13 	High Pressure Flexible Tube (Set Of 3 Tubes) ', '8900', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('82', '2', '16', '34', 'RSBTS14', 'RSBT-S-14 	Cotton Reel (Approx 35 Meters) ', '190', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('83', '2', '16', '34', 'RSBTS15', 'RSBT-S-15 	Stainless Steel Crucible 8 Ml. Capacity ', '2550', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('84', '2', '16', '34', 'RSBTS16', 'RSBT-S-16 	Valve Body With Schrader Valve Fitted Inside ', '3470', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('85', '2', '16', '34', 'RSBTS17', 'RSBT-S-17 	Schrader Valve (For Five Pieces) ', '850', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('86', '2', '16', '34', 'RSBTS18', 'RSBT-S-18 	Ignition Wire (Nichrome Wire) (Minimum 50 Mtrs) ', '2750', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('87', '2', '16', '34', 'RSBTS19', 'RSBT-S-19 	Benzoic acid of known calorific value 100 grams approx with photocopy of nabl tracability certificate ', '2070', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('88', '2', '16', '34', 'RSBTS20', 'RSBT-S-20 	Benzoic acid of known calorific value (pack of 50) tablets) with photocopy of nabl tracability certificate ', '3000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('89', '2', '16', '34', 'RSBTS22', '<p>&quot;RSBT-S-22 Bomb &lsquo;o&rsquo; ring &quot; set of 2</p>', '600', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-28 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('90', '2', '16', '34', 'RSBTS23', '\"RSBT-S-23 	Valve body &#8216;o&#8217; ring \"\r\n', '100', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('91', '2', '16', '34', 'RSBTS27', 'RSBT-S-27 	Sensor for digital beckmann ', '9375', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('92', '2', '16', '34', 'RSBTS32', 'RSBT-S-32 	Connecting wire ', '950', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('93', '2', '16', '34', 'RSBTS35', 'RSBT-S-35 	Pressure gauge with stand ', '4700', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('94', '2', '16', '34', 'RSBTS38', 'RSBT-S-38 	Valve key ', '300', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('95', '2', '16', '34', 'RSBTS39', 'RSBT-S-39 	Gas releasing pin ', '300', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('96', '2', '17', '22', 'LH1160', 'LH-1160 Bomb Calorimeter Automatic Bomb Calorimeter Microprocessor Based (Graphical Display) 128x64 Graphical LCD, Temperature Resolution 0.010 \'C, Internal Memory 1000 logs with date and time, USB interface to PC, Inbuilt thermal printer, Time Clock, Realtime clock with battery backup. Measurement & calculation of calorific value & water equivalent, USB interface for sending data to PC, full test report printout by inbuilt thermal printer, Weight of sample water equivalent & sensitivity can be set through keypad on single page, Fusewire open indication error adjustable, No paper or printer door open detection, Audio indication on firing as well as after test, Automatic detection of temperature rise & fall, Power supply 230 + 10% AC, Complete with all accessories.', '120000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('97', '2', '17', '22', 'LH160', '<p>LH-160 Digital Bomb Calorimeter, manual measurement and calculation, Initial temperature rise and fall, 3 Digit LED Display,Temp.accuracy 0.1&deg;C, Temp.resolution 0.1&deg;C, RTD Temperature Detector, Temp.range RT to 99.9&deg;C NEW ADDITION</p>', '74000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('98', '2', '18', '34', 'RBMT1', 'RBMT-1 	Ball mill 1 kg. (wth aluminium jar) ', '26650', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('99', '2', '18', '34', 'RBMT2', 'RBMT-2 	Ball mill 1 kg. (with s.s. jar) ', '31850', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('100', '2', '19', '37', 'AP135WAD', '<p>Model AP135W-AD Super Range(sm) built-in calibration 0.01mg capacity 135g Pan size &Oslash; 91</p>', 'POR', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('101', '2', '19', '37', 'AP225WAD', '<p>Model AP225W-AD Super Range(sm) built-in calibration 0.01mg capacity 220g Pan Size &Oslash; 91</p>', 'POR', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('102', '2', '19', '37', 'AP125WDAD', '<p>Model AP125WD-AD Dual Range(sm) built-in calibration 0.1mg/0.01mg Cap 120g/52g Pan Size &Oslash; 91</p>', 'POR', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('103', '2', '19', '37', 'AP225WDAD', '<p>Model AP225WD-AD Dual Range(sm) built-in calibration 0.1mg/0.01mg Cap 220g/102g Pan Size &Oslash; 91</p>', 'POR', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('104', '2', '19', '37', 'AP224WAD', '<p>Model AP224W-AD Analytical built-in calibration 0.1mg Cap 220g Pan Size &Oslash; 91</p>', 'POR', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('105', '2', '19', '37', 'AP324WAD', '<p>Model AP324W-AD Analytical built-in calibration 0.1mg Cap 320g Pan Size &Oslash; 91</p>', 'POR', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('106', '2', '20', '37', '', '<p>Advance Performance UniBloc Balances</p>', '', '0', '1', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('107', '2', '20', '37', 'AP225W', '<p>Model AP225W Super Range(sm) Internal calibration 0.01mg capacity 220g Pan size &Oslash; 91</p>', '420000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('108', '2', '20', '37', 'AP135W', '<p>Model AP135W Super Range(sm) Internal calibration 0.01mg capacity 135g Pan size &Oslash; 91</p>', '320000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('109', '2', '20', '37', 'AP225WD', 'Model AP225WD Semi micro Internal calibration 0.01mg/0.1mg Cap 102g/220g Pan Size  91Dia', 'POR', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('110', '2', '20', '37', 'AP125WD', 'Model AP125WD Semi micro Internal calibration 0.01mg/0.1mg Cap 52g/120g Pan Size 91Dia', '220000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('111', '2', '20', '37', 'AP324W', 'Model AP324W Analytical Internal calibration 0.1mg Cap 320g Pan Size  91Dia', '200000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('112', '2', '20', '37', 'AP224W', 'Model AP224W Analytical Internal calibration 0.1mg Cap 220g Pan Size  91Dia', '175000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('113', '2', '20', '37', 'A124W', 'Model AP124W Analytical Internal calibration 0.1mg Cap 120g Pan Size  91Dia', '195000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('114', '2', '20', '37', 'A324X', 'Model AP324X Analytical Internal calibration 0.1mg Cap 320g Pan Size  91Dia', '170000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('115', '2', '20', '37', 'A224X', 'Model AP224X Analytical Internal calibration 0.1mg Cap 220g Pan Size  91Dia', '150000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('116', '2', '20', '37', 'A124X', 'Model AP124X Analytical Internal calibration 0.1mg Cap 120g Pan Size  91Dia', '165000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('117', '2', '20', '37', 'A324Y ', 'Model A324Y Analytical External calibration 0.1mg Cap 320g Pan Size  91Dia', '170000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('118', '2', '20', '37', 'A224Y', 'Model AP224Y Analytical External calibration 0.1mg Cap 220g Pan Size  91Dia', '165000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('119', '2', '20', '37', 'A124Y', 'Model AP124Y Analytical External calibration 0.1mg Cap 120g Pan Size  91Dia', '160000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('120', '2', '21', '37', 'ATY224', 'Model ATY224 Capacity 220gm Resolution 0.1mg PAN SIZE  90 DIA', '100000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('121', '2', '21', '37', 'AUW220D', '<p>Model AUW220D Semi Micro Internal Calibration 0.01mg/0.1mg 82g/220g Pan size &Oslash; 80</p>', '245000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('122', '2', '22', '37', '', 'Basic Model with Improved Convenience', '', '0', '1', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('123', '2', '22', '37', 'ATX324R', 'Model ATX 324R  Capacity 320gm Resolution 0.1mg PAN SIZE  90 DIA  ', '140000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('124', '2', '22', '37', 'ATX224R ', 'Model ATX 224R Capacity 220gm Resolution 0.1mg PAN SIZE  90 DIA ', '110000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('125', '2', '22', '37', 'ATX124R', 'Model ATX 124R  Capacity 120gm Resolution 0.1mg PAN SIZE  90 DIA  ', '120000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('126', '2', '22', '37', 'ATX84R ', 'Model ATX 84R  Capacity 82gm Resolution 0.1mg PAN SIZE  90 DIA   ', '120000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('127', '2', '22', '37', 'ATY324R', 'Model ATY324R Capacity 320gm Resolution 0.1mg PAN SIZE  90 DIA   ', '125000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('128', '2', '22', '37', 'ATY224R ', 'Model ATY224R Capacity 220gm Resolution 0.1mg PAN SIZE  90 DIA ', '89000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('129', '2', '22', '37', 'ATY 124R', 'Model ATY 124R  Capacity 120gm Resolution 0.1mg PAN SIZE  90 DIA  ', '99000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('130', '2', '22', '37', 'ATY 64R', 'Model ATY 64R  Capacity 62gm Resolution 0.1mg PAN SIZE  90 DIA  ', '95000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('131', '2', '23', '37', '', 'X Series with Internal Calibration Weights', '', '0', '1', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('132', '2', '23', '37', 'UP223X', 'Model UP223X Internal Calibration Capacity 220gm Resolution 1mg/0.001g PAN SIZE 108x105 mm', '105000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('133', '2', '23', '37', 'UP423X', 'Model UP423X Internal Calibration Capacity 420gm Resolution 1mg/0.001g PAN SIZE 108x105 mm', '105000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('134', '2', '23', '37', 'UP623X', 'Model UP623X Internal Calibration Capacity 620gm Resolution 1mg/0.001g PAN SIZE 108x105 mm', '110000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('135', '2', '23', '37', 'UP823X', 'Model UP823X Internal Calibration Capacity 820gm Resolution 1mg/0.001g PAN SIZE 108x105 mm', '130000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('136', '2', '23', '37', 'UP1023X', 'Model UP1023X Internal Calibration Capacity 1020gm Resolution 1mg/0.001g PAN SIZE 108x105 mm', '150000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('137', '2', '23', '37', 'UP422X', 'Model UP422X Internal Calibration Capacity 420gm Resolution 10mg/0.01g PAN SIZE 108x105 mm', '85000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('138', '2', '23', '37', 'UP822X', 'Model UP822X Internal Calibration Capacity 820gm Resolution 10mg/0.01g PAN SIZE 108x105 mm', '95000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('139', '2', '23', '37', 'UP2202X ', 'Model UP2202X Internal Calibration Capacity 2200gm Resolution 10mg/0.01g PAN SIZE 170x180 mm', '105000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('140', '2', '23', '37', 'UP4202X', 'Model UP4202X Internal Calibration Capacity 4200gm Resolution 10mg/0.01g PAN SIZE 170x1180 mm', '105000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('141', '2', '23', '37', 'UP6202X', 'Model UP6202X Internal Calibration Capacity 6200gm Resolution 10mg/0.01g PAN SIZE 170x180 mm', '110000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('142', '2', '23', '37', 'UP4201X ', 'Model UP4201X Internal Calibration Capacity 4200gm Resolution 100mg/0.1g PAN SIZE 170x180 mm', '105000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('143', '2', '23', '37', 'UP8201X', 'Model UP8201X Internal Calibration Capacity 8200gm Resolution 100mg/0.1g PAN SIZE 170x180 mm', '115000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('144', '2', '23', '37', '', 'Y Series with External Calibration Weights', '', '0', '1', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('145', '2', '23', '37', 'UP223Y', 'Model UP223Y External Calibration, Capacity 220gm, Resolution 1mg/0.001g, PAN SIZE 108x105 mm', '95000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('146', '2', '23', '37', 'UP423Y', 'Model UP423Y External Calibration, Capacity 420gm, Resolution 1mg/0.001g, PAN SIZE 108x105 mm', '95000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('147', '2', '23', '37', 'UP623Y', 'Model UP623Y External Calibration, Capacity 620gm, Resolution 1mg/0.001g, PAN SIZE 108x105 mm', '105000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('148', '2', '23', '37', 'UP823Y', 'Model UP823Y External Calibration, Capacity 820gm, Resolution 1mg/0.001g, PAN SIZE 108x105 mm', '125000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('149', '2', '23', '37', 'UP1023Y', 'Model UP1023Y External Calibration Capacity 1020gm Resolution 1mg/0.001g PAN SIZE 108x105 mm', '140000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('150', '2', '23', '37', 'UP422Y ', 'Model UP422Y External Calibration Capacity 420gm Resolution 10mg/0.01g PAN SIZE 108x105 mm', '75000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('151', '2', '23', '37', 'UP822Y', 'Model UP822Y External Calibration Capacity 820gm Resolution 10mg/0.01g PAN SIZE 108x105 mm', '85000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('152', '2', '23', '37', 'UP2202Y', 'Model UP2202Y External Calibration Capacity 2200gm Resolution 10mg/0.01g PAN SIZE 170x180 mm', '90000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('153', '2', '23', '37', 'UP4202Y', 'Model UP4202Y External Calibration Capacity 4200gm Resolution 10mg/0.01g PAN SIZE 170x180 mm', '95000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('154', '2', '23', '37', 'UP6202Y', 'Model UP6202Y External Calibration Capacity 6200gm Resolution 10mg/0.01g PAN SIZE 170x180 mm', '105000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('155', '2', '23', '37', 'UP4201Y', 'Model UP4201Y External Calibration Capacity 4200gm Resolution 100mg/0.1g PAN SIZE 170x180 mm', '90000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('156', '2', '23', '37', 'UP8201Y', 'Model UP8201Y External Calibration Capacity 8200gm Resolution 100mg/0.1g PAN SIZE 170x180 mm', '100000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('157', '2', '24', '37', '', 'Top-Loading Balances', '', '0', '1', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('158', '2', '24', '37', 'TW223L', '<p>Model TW 223L Capacity 220gm Resolution 1mg/0.001g PAN SIZE &Oslash; 110</p>', '91500', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('159', '2', '24', '37', 'TW323L', '<p>Model TW 323L Capacity 320gm Resolution 1mg/0.001g PAN SIZE &Oslash; 110</p>', '91500', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('160', '2', '24', '37', 'TW423L', '<p>Model TW 423L Capacity 420gm Resolution 1mg/0.001g PAN SIZE &Oslash; 110</p>', '92000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('161', '2', '24', '37', 'TX2223L', '<p>Model TX 2223L Capacity 220gm Resolution 1mg/0.001g PAN SIZE &Oslash; 110</p>', '65000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('162', '2', '24', '37', 'TX323L ', '<p>Model TX 323L Capacity 320gm Resolution 1mg/0.001g PAN SIZE &Oslash; 110</p>', '65000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('163', '2', '24', '37', 'TX423L', '<p>Model TX 423L Capacity 420gm Resolution 1mg/0.001g PAN SIZE &Oslash; 110</p>', '79000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('164', '2', '24', '37', 'TX2202L', '<p>Model TX 2202L Capacity 2.2kg Resolution 1mg/0.001g PAN SIZE &Oslash; 110</p>', '58000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('165', '2', '24', '37', 'TX3202L', 'Model TX 3202L Capacity 3.2kg  Resolution 1mg/0.001g PAN SIZE  110 ', '58000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('166', '2', '24', '37', 'TX4202L', '<p>Model TX 4202L Capacity 4.2kg Resolution 1mg/0.001g PAN SIZE &Oslash; 110</p>', '70000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('167', '2', '24', '37', 'TXB622L', '<p>Model TXB622L Capacity 620gm Resolution 10mg/0.01g PAN SIZE &Oslash; 110</p>', '52000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('168', '2', '24', '37', 'TXB6201L', '<p>Model TXB6201L Capacity 6.2Kg Resolution 100mg/0.1g PAN SIZE &Oslash; 160</p>', '53000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('169', '2', '24', '37', 'TWC323L', '<p>Model TWC323L Carat Scale internal calibration Capacity 320ct Resolution 0.001ct PAN SIZE &Oslash; 80</p>', 'POR', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('170', '2', '24', '37', 'TXC323L', '<p>Model TXC323L Carat Scale internal calibration Capacity 320ct Resolution 0.001ct PAN SIZE &Oslash; 80</p>', 'POR', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('171', '2', '24', '37', 'TXC623L', '<p>Model TXC623L Carat Scale Capacity 620ct Resolution 0.001ct PAN SIZE &Oslash; 80</p>', 'POR', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('172', '2', '25', '37', '', 'Portable Electronic Balances', '', '0', '1', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('173', '2', '25', '37', 'ELB300', 'Model ELB300 Capacity 300 gm Resolution 0.01g (10mg) PAN SIZE  110 DIA', '29000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('174', '2', '25', '37', 'ELB3000', 'Model ELB3000 Capacity 3KG Resolution 0.1g (100mg) PAN SIZE 170 x 130  DIA', '29000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('175', '2', '25', '37', 'ELB12KH', 'Model ELB12KH Capacity 12KG Resolution 1g (1000mg) PAN SIZE 170 x 130  DIA', '29000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('176', '2', '25', '37', 'BL220H', 'Model BL220H Capacity 220 gm Resolution 0.001g(1mg) PANSIZE 100X100', '42750', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('177', '2', '25', '37', 'BL2200H', 'Model BL2200H Capacity 2200 gm Resolution 0.01g(10mg) PANSIZE 160X124', '42750', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('178', '2', '26', '37', '', 'Electronic Printer', '', '0', '1', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('179', '2', '26', '37', 'EP100', 'Model EP-100 Printer with AC Adaptor ', '70000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('180', '2', '26', '37', 'EP110', 'Model EP-110 Printer with AC Adaptor ', '60000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('181', '2', '26', '37', 'STABLOAP', 'Model STABLO-AP Ionizer-Speed AC Discharge for Static Electricity Removal', '90000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('182', '2', '26', '37', 'ANMUSP100', 'Model ANM USP100 Printer (Equivalent  to Shimadzu EP-110 printer)', '35000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('183', '2', '26', '37', 'UDK', 'Universal Density kit', '35000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('184', '2', '26', '37', '', '* Shimadzu Balances Warranty - 1 year * IQ OQ PQ Doumnets charges extra', '', '0', '2', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('185', '2', '27', '0', '', 'EMFC Based fully Auto Internal Calibration Analytical Balance', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('186', '2', '27', '0', '', 'High grade chemicals resistance Metallic housing', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('187', '2', '27', '35', 'SES224', '<p>Model SES224 Capacity 220g, Resolution 0.0001g, Pan Size 90mm&Oslash;, LCD Display, Auto internal calibration</p>', '44500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('188', '2', '27', '35', 'SES324', '<p>Model SES324 Capacity 320g, Resolution 0.0001g, Pan Size 90mm&Oslash;,LCD Display, Auto internal calibration</p>', '60000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('189', '2', '27', '35', 'SES620C', '<p>Model SES620C Capacity 620g, Resolution 0.001g, Pan Size 120mm&Oslash;,LCD Display,Auto internal calibration</p>', '45300', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('190', '2', '27', '35', 'SES1023C', '<p>Model SES1020C Capacity 1020g, Resolution 0.001g, Pan Size 120mm&Oslash;,LCD Display,Auto internal calibration</p>', '63300', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('191', '2', '27', '35', '', 'Advanced Cutting edge Brillient Technology', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('192', '2', '27', '35', '', 'Competent products with High Quality Brand', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('193', '2', '27', '35', '', 'EMFC- MONOLOG SINGLE BLOCK TECHNOLOGY (Analytical, Laboratory,Pharma,Chemicals,Precision, Institution, Gems-Jewelry)', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('194', '2', '27', '35', 'SES323S', 'Model SES323S Capacity 320g, Resolution 0.001g, Pan Size 120mm&#8709;,LCD Display,Auto External calibration', '24500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('195', '2', '27', '35', 'SES2202', '<p>Model SES2202 Capacity 2200g, Resolution 0.01g, Pan Size 150mm&Oslash;,LCD Display,Auto External calibration</p>', '25500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('196', '2', '27', '35', 'SES2202SQUAREPAN', 'Model SES2202* Capacity 2200g, Resolution 0.01g, Pan Size 160x160mm,LCD Display,Auto External calibration', '27350', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('197', '2', '28', '35', 'SES200LCD', '<p>Model SES200 (LCD) Capacity 200g, Resolution 0.001g, Pan Size 80mm&Oslash;,LCD Display, External calibration</p>', '9500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('198', '2', '28', '35', 'SES300LCD', '<p>Model SES300 (LCD) Capacity 300g, Resolution 0.001g, Pan Size 80mm&Oslash;,LCD Display, External calibration</p>', '10750', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('199', '2', '28', '35', 'SES400LCD', '<p>Model SES400 (LCD) Capacity 400g, Resolution 0.001g, Pan Size 80mm&Oslash;,LCD Display, External calibration</p>', '12500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('200', '2', '28', '35', 'SES500LCD', '<p>Model SES500 (LCD) Capacity 500g, Resolution 0.001g, Pan Size 80mm&Oslash;,LCD Display, External calibration</p>', '15000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('201', '2', '28', '35', 'SES605LCD', '<p>Model SES605 (LCD) Capacity 600g, Resolution 0.005g, Pan Size 120mm&Oslash;,LCD Display, External calibration</p>', '9500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('202', '2', '28', '35', 'SES1005LCD', '<p>Model SES1005 (LCD) Capacity 1000g, Resolution 0.005g, Pan Size 120mm&Oslash;,LCD Display, External calibration</p>', '9750', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('203', '2', '28', '35', 'SES602LCD', '<p>Model SES602 (LCD) Capacity 600g, Resolution 0.01g, Pan Size 120mm&Oslash;,LCD Display, External calibration</p>', '7800', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('204', '2', '28', '35', 'SES1202LCD', '<p>Model SES1202 (LCD) Capacity 1200g, Resolution 0.01g, Pan Size 120mm&Oslash;,LCD Display, External calibration</p>', '9500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('205', '2', '28', '35', 'SES1502LCD', '<p>Model SES1502 (LCD) Capacity 1500g, Resolution 0.01g, Pan Size 120mm&Oslash;,LCD Display, External calibration</p>', '11750', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('206', '2', '28', '35', 'SES2002LCD', '<p>Model SES2002 (LCD) Capacity 2000g, Resolution 0.01g, Pan Size 120mm&Oslash;,LCD Display, External calibration</p>', '13300', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('207', '2', '28', '35', 'SES3002LCD', 'Model SES3002 (LCD) Capacity 3000g, Resolution 0.01g, Pan Size 170X170mm,LCD Display, External calibration', '17950', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('208', '2', '28', '35', 'SES5002LCD', 'Model SES5002 (LCD) Capacity 5000g, Resolution 0.01g, Pan Size 170X170mm,LCD Display, External calibration', '26250', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('209', '2', '28', '35', 'SES6002LCD', 'Model SES6002 (LCD) Capacity 6000g, Resolution 0.01g, Pan Size 170X170mm,LCD Display, External calibration', '30500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('210', '2', '28', '35', 'SES6001LCD', 'Model SES6001 (LCD) Capacity 6000g, Resolution 0.1g, Pan Size 170X170mm,LCD Display, External calibration', '16500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('211', '2', '28', '35', ' SES14LCD', '<p>Model SES14 (LCD) Capacity 10g, Resolution 0.0001g, Pan Size 45mm&Oslash;,LCD Display, External calibration</p>', '21250', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('212', '2', '28', '35', 'SES24LCD', '<p>Model SES24 (LCD) Capacity 20g, Resolution 0.0001g, Pan Size 45mm&Oslash;,LCD Display, External calibration</p>', '24250', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('213', '2', '29', '35', '', ' External Calibration', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('214', '2', '29', '35', 'SES202SLED', '<p>Model SES202S (LED) Capacity 200g, Resolution 0.01g, Pan Size 120mm&Oslash;, Red LED Display</p>', '5750', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('215', '2', '29', '35', 'SES302SLED', '<p>Model SES302S (LED) Capacity 300g, Resolution 0.01g, Pan Size 120mm&Oslash;, Red LED Display</p>', '6250', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('216', '2', '29', '35', 'SES602SLED', '<p>Model SES602S (LED) Capacity 600g, Resolution 0.01g, Pan Size 120mm&Oslash;, Red LED Display</p>', '6250', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('217', '2', '29', '35', 'SES1202SLED', '<p>Model SES1202S (LED) Capacity 1200g, Resolution 0.01g, Pan Size 120mm&Oslash;, Red LED Display</p>', '7800', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('218', '2', '29', '35', 'SES302LED', '<p>Model SES302 (LED) Capacity 300g, Resolution 0.01g, Pan Size 120mm&Oslash;, Green LED Display</p>', '7000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('219', '2', '29', '35', 'SES602LED', '<p>Model SES602 (LED) Capacity 600g, Resolution 0.01g, Pan Size 120mm&Oslash;, Green LED Display</p>', '7000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('220', '2', '29', '35', 'SES1202LED', '<p>Model SES1202 (LED) Capacity 1200g, Resolution 0.01g, Pan Size 120mm&Oslash;, Green LED Display</p>', '8500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('221', '2', '29', '35', 'SES605LED', '<p>Model SES605 (LED)Capacity 600g, Resolution 0.005g, Pan Size 120mm&Oslash;, Green LED Display</p>', '7800', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('222', '2', '29', '35', 'SES1005LED', '<p>Model SES1005 (LED) Capacity 1000g, Resolution 0.005g, Pan Size 120mm&Oslash;, Green LED Display</p>', '9500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('223', '2', '29', '35', 'SES1502LED', '<p>Model SES1502 (LED) Capacity 1500g, Resolution 0.01g, Pan Size 120mm&Oslash;, Green LED Display</p>', '9000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('224', '2', '29', '35', 'SES2002LED', '<p>Model SES2002 (LED) Capacity 2000g, Resolution 0.01g, Pan Size 120mm&Oslash;, Green LED Display</p>', '11750', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('225', '2', '29', '35', '', 'Complete wash down SS 304 Table Top,Bench scale for Pharmaceutical & Chemistry Industry ', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('226', '2', '29', '35', 'SES6THSS ', 'Model SES6THSS Capacity 6Kg, Resolution 0.1g, Pan Size 250x250mm, LCD/LED Display', '17950', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('227', '2', '29', '35', 'SES10THSS', 'Model SES10THSS Capacity 10Kg, Resolution 0.1g, Pan Size 250x250mm, LCD/LED Display', '19500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('228', '2', '29', '35', 'SES20THSS', 'Model SES20THSS Capacity 20Kg, Resolution 0.1g, Pan Size 250x250mm, LCD/LED Display', '22750', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('229', '2', '29', '35', 'SES30THSS ', 'Model SES30THSS Capacity 30Kg, Resolution 0.1g, Pan Size 250x250mm, LCD/LED Display', '27300', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('230', '2', '29', '35', ' SES50THSS', 'Model SES50THSS Capacity 50Kg, Resolution 1g, Pan Size 300x300mm, LCD/LED Display', '24250', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('231', '2', '30', '35', ' SES45', '<p>Model SES45 Capacity 40g, Resolution 0.01mg, Pan Size 90mm&Oslash;,LCD Display, Auto internal calibration</p>', '138500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('232', '2', '30', '35', 'SES65', '<p>Model SES65 Capacity 60g, Resolution 0.01mg, Pan Size 90mm&Oslash;,LCD Display, Auto internal calibration</p>', '141500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('233', '2', '30', '35', ' SES165', '<p>Model SES165 Capacity 60/100g, Resolution 0.01/0.1mg, Pan Size 90mm&Oslash;,LCD Display, Auto internal calibration</p>', '141500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('234', '2', '30', '35', ' SES265', '<p>Model SES265 Capacity 60/220g, Resolution 0.01/0.1mg, Pan Size 90mm&Oslash;,LCD Display, Auto internal calibration</p>', '141500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('235', '2', '30', '35', 'SES285', '<p>Model SES285 Capacity 80/220g, Resolution 0.01/0.1mg, Pan Size 90mm&Oslash;,LCD Display, Auto internal calibration</p>', '154000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('236', '2', '30', '35', '', 'EMFC- MONOLOG SINGLE BLOCK TECHNOLOGY (Analytical, Laboratory,Pharma,Chemicals,Precision, Institution, Gems-Jewelry) Auto External calibration', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('237', '2', '30', '35', 'SES204', '<p>Model SES204 Capacity 220g, Resolution 0.0001g, Pan Size 90mm&Oslash;,LCD Display</p>', '54000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('238', '2', '30', '35', 'SES220C', '<p>Model SES220C Capacity 220g, Resolution 0.0001g, Pan Size 90mm&Oslash;,LCD Display</p>', '66500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('239', '2', '30', '35', 'SES603', '<p>Model SES603 Capacity 120g, Resolution 0.0002g, Pan Size 90mm&Oslash;,LCD Display</p>', '47750', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('240', '2', '30', '35', 'SES323', '<p>Model SES323 Capacity 320g, Resolution 0.001g, Pan Size 120mm&Oslash;,LCD Display</p>', '33750', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('241', '2', '30', '35', 'SES523', '<p>Model SES523 Capacity 520g, Resolution 0.001g, Pan Size 120mm&Oslash;,LCD Display</p>', '42200', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('242', '2', '30', '35', 'SES623', '<p>Model SES623 Capacity 620g, Resolution 0.001g, Pan Size 120mm&Oslash;,LCD Display</p>', '47750', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('243', '2', '30', '35', 'SES3202', 'Model SES3202 Capacity 3200g, Resolution 0.01g, Pan Size 220X220mm,LCD Display', '38300', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('244', '2', '30', '35', 'SES4202', 'Model SES4202 Capacity 4200g, Resolution 0.01g, Pan Size 220X220mm,LCD Display', '42200', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('245', '2', '30', '35', 'SES6202', 'Model SES6202 Capacity 6200g, Resolution 0.01g, Pan Size 220X220mm,LCD Display', '63300', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('246', '2', '31', '35', 'SES6TH', 'Model SES6TH Capacity 6Kg, Resolution 0.1g, Pan Size 240x290, LED Display, External calibration', '8600', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('247', '2', '31', '35', 'SES10TH', 'Model SES10TH Capacity 10Kg, Resolution 0.1g, Pan Size 240x290, LED Display, External calibration', '11000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('248', '2', '31', '35', 'SES3T', 'Model SES3T Capacity 3Kg, Resolution 0.1g, Pan Size 170x220, LED Display, External calibration', '4000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('249', '2', '31', '35', 'SES6T ', 'Model SES6T Capacity 6Kg, Resolution 0.5g, Pan Size 240x290, LED Display, External calibration', '4000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('250', '2', '31', '35', 'SES10T', 'Model SES10T Capacity 10Kg, Resolution 0.5g, Pan Size 240x290, LED Display, External calibration', '4000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('251', '2', '31', '35', 'SES20T ', 'Model SES20T Capacity 20Kg, Resolution 1g, Pan Size 240x290, LED Display, External calibration', '4000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('252', '2', '31', '35', 'SES30T', 'Model SES30T Capacity 30Kg, Resolution 1g, Pan Size 240x290, LED Display, External calibration', '4000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('253', '2', '32', '35', '', 'F1 Class', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('254', '2', '32', '35', 'SESF1PCS12', 'Weight Box  F1 Class 12 Pcs Set Weight 1 mg to 500 mg  SS304 ', '7000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('255', '2', '32', '35', 'SESF1PCS12NABL', 'NABL Charges for the above F1 Class weight box 1 mg to 500 mg', '2350', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('256', '2', '32', '35', 'SESF1PCS23', 'Weight Box  F1 Class 23 Pcs Set Weight 1 mg to 200 g  SS304 ', '13300', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('257', '2', '32', '35', 'SESF1PCS23NABL', 'NABL Charges for the above F1 Class weight box 1 mg to 200 g', '3950', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('258', '2', '33', '8', '', 'Model AT 6000  Breath Alcohol meter  China.', '1500', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('259', '2', '34', '22', 'LH21', 'LH-21 Differential Blood Cell Counter, a microcontroller based system for quick differential counts, has facility to count 8 types of cell and audible deep facility, 16 digit alphanumeric LCD Display shows percentage (%) calculations, individual cell count with built-in stop watch and timer functions. ', '5000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('260', '2', '35', '22', 'LH43', 'LH-43 Blood Roller Mixer to make blood homogeneous with 4 rollers 230mmlong.', '3800', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('261', '2', '36', '8', '', 'Blood cell counters with 5 keys and one totalizer with bell', '850', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('262', '2', '36', '8', '', 'Blood cell counters with 8 keys and one totalizer with bell', '1200', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('263', '2', '36', '8', '', 'Blood cell counter Digital Economy Model with 8 keys & totalizer china make', '2500', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('264', '2', '37', '28', 'SCI25', 'SCI-2.5 Range 0.25 - 2.5 ml Microlit', '10580', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('265', '2', '37', '28', 'SCI5', 'SCI-5 Range 0.5 - 5 ml Microlit', '10580', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('266', '2', '37', '28', 'SCI10', 'SCI-10 Range 1-10 ml Microlit', '10580', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('267', '2', '37', '28', 'SCI30', 'SCI-30 Range 2.5 - 30 ml Microlit', '15820', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('268', '2', '37', '28', 'SCI60', 'SCI-60 Range 5- 60 ml Microlit', '15820', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('269', '2', '37', '28', 'SCI100', 'SCI-100 Range 10- 100 ml  Microlit', '19050', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('270', '2', '38', '28', 'BEAT25', 'BEAT-2.5 Range 0.25 - 2.5 ml Microlit', '14290', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('271', '2', '38', '28', 'BEAT5', 'BEAT-5 Range 0.5 - 5 ml Microlit', '14290', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('272', '2', '38', '28', 'BEAT10', 'BEAT-10 Range 1 -10 ml Microlit', '14290', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('273', '2', '38', '28', 'BEAT30', 'BEAT-30 Range 2.5 - 30 ml  Microlit', '21370', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('274', '2', '38', '28', 'BEAT60', 'BEAT-60 Range 5 - 60 ml  Microlit', '21370', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('275', '2', '38', '28', 'BEAT100', 'BEAT-100 Range 10 - 100 ml Microlit', '25750', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('276', '2', '39', '43', 'T15', 'Bottle Top Dispenser 0-5 ml', '2750', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('277', '2', '39', '43', 'T16', 'Bottle Top Dispenser 2-10 ml', '2750', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('278', '2', '40', '34', 'RSBT1', 'RBST &#8211; 1 	Bursting strength tester (analog model)  Capacity &#8211; 0 to 35kg / cm2, To determine bursting strength of knitted fabrics, paper, corrugated paper etc. Latest design with control panel with maximum capacity 35 kgs. Glycerin used as test fluid with digital display capacity &#8211; 0 to 35kg / cm2  ', '116350', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('279', '2', '41', '7', '', 'Buffer Solutions  480 ml Bottle Calibrated with Certificate of analysis from EUTECH ', '', '0', '1', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('280', '2', '41', '7', 'PH168', 'pH  Buffer Solution 1.68pH', '1750', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('281', '2', '41', '7', 'PH401', 'pH  Buffer Solution 4.01pH', '1750', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('282', '2', '41', '7', 'PH686', 'pH  Buffer Solution 6.86pH', '1750', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('283', '2', '41', '7', 'PH7', 'pH  Buffer Solution 7pH', '1750', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('284', '2', '41', '7', 'PH9', 'pH  Buffer Solution 9pH', '1750', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('285', '2', '41', '7', 'PH918', 'pH  Buffer Solution 9.18pH', '1750', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('286', '2', '41', '7', 'PH1001', 'pH  Buffer Solution 10.01pH', '1750', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('287', '2', '41', '7', 'PH1245', 'pH  Buffer Solution 12.45pH', '1750', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('288', '2', '42', '7', '', 'Buffer Solutions  480 ml Bottle Calibrated with Certificate of analysis from EUTECH ', '', '0', '1', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('289', '2', '42', '7', 'TDS50', 'TDS Buffer Solution 50ppm', '1850', '1', '0', '1', '22-06-2022', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('290', '2', '42', '7', 'TDS300', 'TDS Buffer Solution 300ppm', '1850', '1', '0', '1', '22-06-2022', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('291', '2', '42', '7', 'TDS1000', 'TDS Buffer Solution 1000ppm', '1850', '1', '0', '1', '22-06-2022', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('292', '2', '42', '7', 'TDS3000', 'TDS Buffer Solution 3000ppm', '1850', '1', '0', '1', '22-06-2022', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('293', '2', '42', '7', 'TDS5000', 'TDS Buffer Solution 5ppt (5000ppm)', '2600', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('294', '2', '42', '7', 'TDS25000', 'TDS Buffer Solution 25ppt (25000ppm)', '2600', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('295', '2', '42', '7', 'TDS45000', 'TDS Buffer Solution 45ppt (45000ppm)', '2600', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('296', '2', '43', '7', '', 'Buffer Solutions  480 ml Bottle Calibrated with Certificate of analysis from EUTECH ', '', '0', '1', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('297', '2', '43', '7', 'COND84', 'Conductivity Buffer Solution 84 &#956;s', '1850', '1', '0', '1', '22-06-2022', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('298', '2', '43', '7', 'COND100', 'Conductivity Buffer Solution 100 &#956; s ', '1850', '1', '0', '1', '22-06-2022', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('299', '2', '43', '7', 'COND500', 'Conductivity Buffer Solution 500 &#956; s ', '1850', '1', '0', '1', '22-06-2022', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('300', '2', '43', '7', 'COND1413', 'Conductivity Buffer Solution 1413&#956;s', '1850', '1', '0', '1', '22-06-2022', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('301', '2', '43', '7', 'COND2764', 'Conductivity Buffer Solution 2764&#956;s', '1850', '1', '0', '1', '22-06-2022', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('302', '2', '43', '7', 'COND5', 'Conductivity Buffer Solution 5 ms', '1850', '1', '0', '1', '22-06-2022', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('303', '2', '43', '7', 'COND12880', 'Conductivity Buffer Solution 12880 &#956;s', '1975', '1', '0', '1', '22-06-2022', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('304', '2', '43', '7', 'COND1118', 'Conductivity Buffer Solution 111.8 ms', '1975', '1', '0', '1', '22-06-2022', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('305', '2', '44', '7', '', 'Buffer Solutions  480 ml Bottle Calibrated with Certificate of analysis from EUTECH ', '', '0', '1', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('306', '2', '44', '7', 'ECRE005', 'ELECTRODE STORAGE SOLUTION EUTECH 480ML ECRE005', '7200', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('307', '2', '44', '18', 'PHPSTOR20', 'PH-PSTOR(20ml) 20 packets of 20 ml potassium chloride (KCl) storage solution', '320', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('308', '2', '44', '18', 'PHPSTOR60', 'PH-PSTOR(60ml) pH Electrode Storage Solution 60 ml', '950', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('309', '2', '45', '18', 'ASP20', 'ASP-20 20 pack assorted solutions [ 5X 20 ml (pH 4, pH 7), 5 x 20 ml (pH Storage & EC/TDS Calibration Solution)]', '6000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('310', '2', '45', '18', 'PH4710', 'PH-4/7/10 (20ml) Buffer Solution', '320', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('311', '2', '46', '7', '', 'Buffer Solutions  480 ml Bottle Calibrated with Certificate of analysis from EUTECH ', '', '0', '1', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('312', '2', '46', '7', 'ORP86MV', 'Buffer Solutions for ORP 86 mv ', '4100', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('313', '2', '46', '7', 'ORP263MV', 'Buffer Solutions for ORP 263mv ', '4100', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('314', '2', '46', '7', 'ORP475MV', 'Buffer Solutions for ORP 475mv', '4100', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('315', '2', '49', '22', 'LH1201', 'LH-1201 Auto Bio Chemistry Analyser For End Point, Kinetic, Fix Point, Multi Standard and coagulation tests, Quartz flowcell system, Built in Thermal printer with graphics capability, Upto 250test items, 240 x 128 LCD display, Paltrier Controlled thermostat, open reagent system, user friendly. (Imported)', '122000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('316', '2', '49', '22', 'LH1202', 'LH-1202 Semi Automatic Bio Chemistry Analyser, Real time coloured graph and absorbance, Windows Embedded compact 7, 4.3 inch true color touchscreen, 300 programmable test, 1000 Result storage with editable patient information, universal power supply, End point with standard/factor, Two point kinetics, Multi standard upto 8 standards, biochromatic, dual wavelength, absorbance, photometric analysis with interference filter, aborbance range 0.0000-3.0000 (Linearity:+/-1%, Repeatability: 0.002, Resolution: 0.0001), Spectral range selection: Automatic via Filter wheel, Light source: 6V 10 W Long life tungsten Halogen lamp, Detector: Photodiode.', '105000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('317', '2', '50', '10', 'GLBTS42', '<p>GLBTS-4.2 Blood Bag Tube Sealer is a compact equipment to seal the Blood Bag pilot tube by radio frequency, Sealed tube can be easily separated by pulling the sealing section by both sides, Scan Here For Detailed Specifications,Oscillation Frequency : 40.68 MHz, Maximum Sealing Time - 1.5 seconds,Radio Frequency Output :20W</p>', '75000', '0', '0', '1', '08-07-2022', NULL, NULL, NULL, NULL, NULL, '2022-07-08 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('318', '2', '50', '10', 'GLP1', '<p>GLP-1 Plasma Expressor, Pressure plate: Acrylic, Manual control, size: 232 x 165 x 243 mm</p>', '9900', '0', '0', '1', '08-07-2022', NULL, NULL, NULL, NULL, NULL, '2022-07-08 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('319', '2', '50', '10', 'GLP2 ', 'GLP-2 Electronic Plasma Expressor, Power supply 230v/110v AC, Infra Red sensor, Clamping: Motor activated, Acrylic Pressure plate, alarm: audio visual, automatic control, Size 252 x 165 x 243 mm', '49500', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('320', '2', '50', '10', 'GLBM14 ', '<p>GLBM - 14 Blood Collection Monitor, Control System : Micro controller based,Alarm : Audio Visual Alarm if the flow is less than 20 ml per minute at the end of the Collection, Outer body : Mild steel powder coated, Speed of rocker : 10 RPM, Accuracy : &plusmn; 2 RPM, Settable volume : 1 to 999 ml Readability : 1 ml/1g, Pinching : Motorized pinching at the end of collection, Display : user friendly LCD display with messages,Blood bag Tray : ABS molded, Display parameters : Weight and volume of collection, duration of collection Previous collection records,Calibration : Auto calibration from the control panel</p>', '75000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('321', '2', '50', '10', 'GLAP48 ', '<p>GLAP-48 Platelet Agitator is very well-known for its uniqueness in design. S.S racks with high ventilation capability allows maximum oxygen transfer to the platelets. Sliding stainless steel trays makes the cleaning purpose easier as well as enables easy removal or loading of bags. Capacity 48 bags, No. of tray: 8, Ocillation: 70/Minute, Accuracy: &nbsp;&plusmn; 5/ minute</p>', '67500', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('322', '3', '51', '7', 'ECOECTESTLOW', 'Model ECOEC TEST LOW Range 0-1999&#956;s, NO TEMP.Display, Resolution 10&#956;s/cm, Sensor Pin', '6500', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('323', '3', '51', '7', 'ECOECTESTHIGH', 'Model ECOEC TEST HIGH Range 0-19.9MS, NO TEMP.Display, Resolution 0.1ms/cm, Sensor Pin', '6500', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('324', '3', '51', '7', 'ECTEST11', 'Model EC TEST 11 Range 0-2000/&#956;s & 0-20MS/cm, TEMP.Display Yes, Resolution 10&#956;s/0.1ms, Sensor Pin', '10440', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('325', '3', '51', '7', 'ECTEST11PLS', 'Model EC TEST 11 PLS Range 200,2000&#956;s/cm,20MS/cm, TEMP.Display YES, Resolution 0.1&#956;s/1&#956;s/0.01ms,  Sensor Cup', '16200', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('326', '3', '51', '7', 'CTSEXPERTCOND', 'NEW CTS EXPERT / Cond / TDS / Salinity / TEMP.          ', '9000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('327', '3', '51', '16', 'HI98303', 'Conductivity Meter Dist 3 Range 0-1990&#956;s, Resolution 1&#956;s, Temp.BOLD Display HI98303 New', '5250', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('328', '3', '51', '16', 'HI98304', 'Conductivity Meter Dist 4 Range 0.01ms TO 19.99ms, Resolution .01ms, Temp.BOLD Display  HI98304 New', '5250', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('329', '3', '51', '16', 'HI98303P', 'Conductivity Meter Dist 3 Range 0-1990&#956;s, Resolution 1&#956;s, Temp.BOLD Display HI98303P New', '3000', '1', '0', '1', '11-07-2022', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('330', '3', '51', '16', 'HI98304P', 'Conductivity Meter Dist 4 Range 0.01ms TO 19.99ms, Resolution .01ms, Temp.BOLD Display  HI98304P New', '3000', '1', '0', '1', '11-07-2022', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('331', '3', '51', '18', 'AP2', 'AP 2 Conductivity Meter Range 0- 9999 &#956;s, Resolution 1&#956;s, TEMP.Small  Display', '750', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('332', '3', '51', '18', 'COM80', 'COM80 Model COND /TDS HM Model  Range 9990 uS/5000ppm, Resolution 10&#956;s/10ppm, TEMP.BOLD Display', '1550', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('333', '3', '52', '7', 'CON603PLUSK', 'Model CON603PLUSK Parameter Conductivity Range  0 to /200MS/cm, Powered by battery IP54', '38700', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('334', '3', '52', '7', 'CONWP15003K ', 'Model CONWP15003K Parameter Cond / TDS Range 0-200ms/200ppt, Memory 150 Powered by Main/Battery', '47700', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('335', '3', '52', '7', 'CONWP45003K', 'Model CONWP45003k Parameter Cond/TDS/Salinity, Range 200ms/200ppt/50ppt, Memory 500 Powered  by Main/Battery', '72000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('336', '3', '52', '7', ' CONWP61043K', 'Model CONWP61043K Parameter Cond/TDS/Res/Sal, Range 0 to 500MS/cm 500ppt, Memory 500 Powered  by Main/Battery IP 67', 'POR', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('337', '3', '53', '22', 'LH17', 'LH-17 Portable Conductivity Meter 3 1/2 digit LCD display, battery operated, ABS Plastic body.', '4300', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('338', '3', '54', '7', 'ECCON70043S', 'Model ECCON70043S Conductivity/ATC Probe CONSEN9501D ,K=1.0, Integral Electrode Holder & 100/240 VAC Adapter Cond/TDS, Range 0 to 200ms/cm:0 to 100 ppt, Powered by Main ', '63000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('339', '3', '54', '7', 'ECCON270043S', 'Model ECCON270043S With 4-Cell Conductivity Probe CONSEN9201D K=0.530, Integral Electrode Holder & 100/240 VAC Adapter, RS232 cableParameter Cond/TDS/Salinity/Restivity and Tepm.Range 0 to 500ms/cm 0 to 500ppt; 0 to 80 ppt,o to 200mohms', '100650', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('340', '3', '54', '7', 'CON2700AN270', 'ANTECH AN 270 Printer Suitable for ECCON270043S model . ', '36000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('341', '3', '55', '7', 'CONPH700', 'PH 700 & CON 700 ', '85000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('342', '3', '56', '22', 'LH5100', '<p>LH-5100 Trutouch Conductivity Meter, 5 &nbsp;Inch touch screen with high resolution and sensitivity, Combined and Separate measurement facility cond. TDS. Sal. and temp., 6 auto ranges, Auto sensor check facility, 5 point calibration facility 1 for each range( EC-0-20 , 0-200S&micro;s, 0-2ms,0-20ms,0-200ms, TDS - 0-20, 0-200ppm, 0-20,0-200ppt, Salinity- 0-20,0-200ppm, 0-0,2-20,0-5ppt), Meets GLP norms, Password protected data and login facility, PC attachment through USB.,1000 data storing facility with file name. NEW ADDITION</p>', '31000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('343', '3', '56', '22', '', 'EPSON LX-310 Printer Suitable for Trutouch Conductivity Meter(LH-5100) & Trutouch pH Meter(LH-5001)', '15500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('344', '3', '56', '22', 'LH16', 'LH-16 Auto Digital Conductivity Meter (AUTO RANGING) 3.5 digit LED display with facility for temperature compensation and digital cell constant adjustment along with conductivity cell & other accessories. ', '6000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('345', '3', '56', '22', 'LH26', 'LH-26 Deluxe Conductivity Meter 3.5 digit LED display with facility for automatic temp. Compensation & digital cell constant adjustment along with cond. cell & temperature probe', '6500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('346', '3', '57', '7', 'CTSEXPERTCOND', 'CTS EXPERT Eutech COND/ TDS / SALINITY / TEMP. Combo meter', '9450', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('347', '3', '57', '7', 'PCTESTr35', '<p>PCTESTr35 Parameters Ph/Cond/Temp, Range &nbsp;0.0 to 14.0 Ph/0 to 1999 &micro;S/cm/2.00 to 20.00MS, Resolution 0.1 Ph/1 &micro;S/cm/0.01 mS/cm, Accuracy &nbsp;&plusmn;0.1pH /&plusmn;1&micro;S, Large &nbsp;Display with temp</p>', '17100', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('348', '3', '57', '7', 'PTTESTr35', '<p>PTTESTr35 &nbsp;Parameters &nbsp;Ph/TDS/Temp, Range 0.0 to 14.0Ph/0 to 999 ppm/1 to 10.00ppt, Resolution 0.1 Ph/1 ppm/0.01 ppt, Accuracy &nbsp;&plusmn;0.1 pH/ &plusmn;1ppm, Large Display with temp IP 67 wp</p>', '17100', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('349', '3', '57', '7', 'PCSTESTr35', '<p>PCSTESTr35 Parameters Ph/Cond/TDS/Salinity/Temp, Range 0.00 to 14.00Ph/0.0 to 20ms/0-10.00 ppt/ 0 to 50 c, &nbsp;Resolution 0.01Ph/1 &micro;S/cm/0.01&micro;S/cm/ 0.1ppm/1 ppm, Accuracy &nbsp;&plusmn;0.1pH /&plusmn;0.1&micro;S/&plusmn;0.1ppm, Large Screen &nbsp;Display with temp</p>', '22500', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('350', '3', '57', '18', 'COM80', 'COM80 Model COND /TDS HM Model, Range 9990 uS/5000ppm, Resolution 10&#956;s/10ppm, TEMP.BOLD Display', '1550', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('351', '3', '57', '18', 'COM100', 'COM-100 Waterproof Professional Series EC/TDS Meter, measures EC, TDS, Salinity & Temperature, wit ATC , Replaceable Sensor', '3800', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('352', '3', '57', '18', 'COM360', '<p>COM-360 pH/EC/TDS Meter. pH Range: 0.0 &ndash; 14.0, pH EC Range: 0 - 9990 &mu;S; 0 - 9.99 mS, TDS Range: 0 - 8560 ppm (mg/L); 0.5 (NaCl) scale; 0.7 (442) scale, 0 - 5000 ppm (mg/L), Temperature Range: 0.1 - 50&deg;C</p>', '9950', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('353', '3', '57', '16', 'HI98129', 'HANNA HI 98129 (low Range) pH/Cond/Tds meter  (or) HANNA HI 98130 (hight Range) pH/Cond/Tds meter', '16000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('354', '3', '58', '7', 'ECPCWP45004k ', 'ECPCWP45004k  Parameters ph/cond/TDS, Range -2.00 to 16.00/200ms/200ppt, ORP YES, POWER main/BT', 'POR', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('355', '3', '58', '7', 'ECPDWP45004K', 'ECPDWP45004K  ph/DO Range  -2.00 to 16.00/20ppm, ORP YES, POWER main/BT', 'POR', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('356', '3', '58', '7', 'ECPCDWP65044K', 'ECPCDWP65044K pH/ION/ORP/Cond/Sal/TDS/DO/Res, Range -2.00 to 20.00/0.00-19900/(+/- 2000mv) 0-500ms/0-80 ppt/2-20Mohm/0-500ppt/90ppm, Power battery/9V DC', 'POR', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('357', '3', '58', '18', 'HM200', 'HM-200 Portable pH/EC/TDS/Temp Monitor', '18100', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('358', '3', '58', '18', 'HM500', '<p>HM-500 HydroMaster: EC/TDS, pH, Temp Continuous Monitor Range: pH: 0.00 &ndash; 14.00 pH,Temp. 0.0 &ndash; 80.0 &deg;C,TDS: 0 &ndash; 9999 ppm / 0 &ndash; 10.00 ppt,EC: 0 &ndash; 9999 &micro;S / 0 &ndash; 20.00 mS</p>', '22000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('359', '3', '58', '18', 'HM500N', '<p>HM-500N HydroMaster: pH, TDS, EC, DO and Temp Continuous Monitor Range: pH: 0.00 &ndash; 14.00 pH,TDS: 0 &ndash; 9999 ppm / 0 &ndash; 10.00 ppt,EC: 0 &ndash; 9999 &micro;S / 0 &ndash; 20.00 mS, DO:0-200 % , 0-20.0 mg/L and Temp. 0.0 &ndash; 80.0 &deg;C</p>', 'POR', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('360', '3', '59', '7', 'ECPC70043S ', 'ECPC70043S  Parameters PH/Mv/Cond/ TDS  with Feet/Glass  Electrode Dual Display', '85500', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('361', '3', '59', '7', 'ECPC270043S', 'ECPC270043S PH/Mv/Ion/Cond/TDS/Resist/Salinity with Cond cell/ph, Glass  Electrode, Dual Display Memory 500 / RS232  ', 'POR', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('362', '3', '60', '22', 'LH51 ', 'LH-51 Microprocessor Conductivity/TDS/Salinity/Temp. Meter (Graphical Display) a research grade instrument with 128 x 64 Large Graphical LCD display having automatic calibration, automatic range selection, automatic Temperature compensation, selectable reference temp, fluid resistant housing & rotational electrode stand along with accessories. Data Storage fealty up to 1000 samples, complete with cell. temperature probe, rotational electrode stand, dust cover& instructions manual, computer interlace through USB', '13000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('363', '3', '60', '22', 'LH53', 'LH-53 Microprocessor pH/Conductivity/TDS/Salinity/Temp. Meter a research grade instrument with 16 x 2 Large LCD display having automatic calibration, automatic range selection, automatic Temperature compensation, selectable reference temp, fluid resistant housing & rotational electrode stand along with accessories. Data Storage fealty up to 1000 samples, complete with cell. temperature probe, rotational electrode stand, dust cover & instructions manual, computer interlace through USB NEW', '17000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('364', '3', '60', '22', 'LH23', 'LH-23 Digital Ph, Conductivity and Temperature Meter for measurement of pH. Conductivity & temp., 3.5 digit LED display supplied with pH combination electrode, conductivity cell and temp.probe ', '7250', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('365', '3', '60', '22', 'LH25', 'LH-25 Digital TDS/Conductivity Meter Digital Conductivity Cum TDS meter 3.5 digit LED display with facility for temp. compensation & digital cell constant adjustment along with conductivity cell', '6500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('366', '3', '61', '15', 'CD06', 'CD-06 TDS/COND Cell at Cell constant K=1.00(appx.) Unbreakable ', '1250', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('367', '3', '61', '15', 'CD06BNC1', 'CD-06 TDS/COND Cell at Cell constant K=1.00(appx.) with BNC connector', '1250', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('368', '3', '61', '15', 'CD065', 'CD-06 TDS/COND Cell at Cell constant K=5.00(appx.)', '1250', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('369', '3', '61', '15', 'CD04', 'CD-04 TDS/COND Cell at Cell constant  K=0.50(appx.)', '2250', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('370', '3', '61', '15', 'CD08', 'CD-08 TDS/COND Cell at Cell constant  K=0.10(appx.)', '3225', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('371', '3', '61', '15', 'SWINGARMSTAND', 'Laboholic swing arm stand with good base at best rate', '750', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('372', '3', '61', '7', '', 'Eutech calibration Buffer for TDS / Conductivity  of 50 ppm / 100ppm/ 300ppm/ 1000ppm/ 3000ppm/84us / 100us / 1413us/2467us/  480ml  pack with certificate', '1750', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('373', '3', '61', '7', '', 'Eutech Calibration Buffer Solutions Salinity 5ppt, 25ppt , 45 ppt  (Any one) 480 ml EUTECH', '2500', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('374', '3', '61', '7', '', 'Eutech calibration Buffer for conductivity/ TDS  12.88ms/111.8ms available in 480ml pack certificate', '2200', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('375', '3', '61', '7', 'CONSEN91W2SS', 'Cond.cell CONSEN 91W 2SS rings with ATC, Cell constant K=1.0, 6 pin connector,1M cable for CON 510 / 150/ 450  / 11 / 110', '25200', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('376', '3', '61', '7', 'CONSEN91B', 'Cond Cell CONSEN91B Suitable  FOR SALT 6+ / Con 6+  / TDS 6+ ', '25200', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('377', '3', '61', '7', 'CONSEN9501D', 'Cond Cell CONSEN9501D COND / ATC Electrode K=1.0  Suitable  for Con700 Models', '27000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('378', '3', '61', '7', 'CONSEN9201D', 'Cond Cell CONSEN9201D 4-Cell Conductivity/ATC Electrode K=0.530, Graphite Sensor, Epoxy-Body (2700 series)', '54000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('379', '3', '62', '22', 'LH36', 'LH-36 Digital Colony Counter 3 digit LED display Range 0-999 with 125 memory, hold and count correction facility. Data restored even after powerfailure.', '4300', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('380', '3', '62', '22', 'LH37', 'LH-37 Digital ColonyCounter4 digit LED display Range 0-9999. With 125 memory, hold and count correction faciIity. Data restored even after powerfailure', '4600', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('381', '3', '63', '22', 'LH116', 'LH-116 Digital Fully Automatic Colorimeter 9 digital filters with facility for automatic zero setting with finger touch, digital wavelength selection. mode % T & OD inbuilt 6V Ni-Cd Re-Chargeable Battery. lml. solution measurement, Range400 to 700 nm, highly accurate &compact.', '5800', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('382', '3', '63', '22', 'LH111', 'LH-111 Microprocessor Photo Colorimeter 8 fitters with facility for direct measurement of results in cone., %T& O.D. Memory for Storage of 3 standards to avoid frequent use of standards. Automatic zero setting facility. lml. solution measurement.', '6800', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('383', '3', '63', '22', 'LH114', 'LH-114 Auto Photo Colorimeter 8 filters with facility for automatic zero setting with finger touch, 2.5 digit LED display, Range 400to 700nm, highly accurate & compact.', '6100', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('384', '3', '63', '22', 'LH112', 'LH-112 Deluxe Photo Colorimeter 8 filters mains cum battery operated with inbuilt rechargeable battery. 2.5 digit LED display, Range 400 to 700nm, highly accurate & compact.', '6100', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('385', '3', '63', '22', 'LH12', 'LH-12 Digital Photo Colorimeter 8 filters mains operated with optical density 2.5 digit LED display. Range 400 to 700 nm. lml solution measurement.', '5600', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('386', '3', '64', '22', 'LH790', 'LH-790 Visual Colorimeter Measuring principle visual in terms of international colour scale units, measuring range 0.1-79.9 Red, 0.1 - 79.9 Yellow,0.1- 49.9 Blue, 0.1 -3.9 Neutral, Resolution 0.1 colour scale unit, Light source Incandescent lamp, path length upto 180mm.', '120000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('387', '3', '65', '22', 'LH1232', '<p>LH-1232 Coagulation Analyzer, 5 inch LCD Touch screen, 4 Testing channels, 24 Cuvette incubation positions, 6 Reagent incubation positions, Wavelength LED 470nm, Sample Type Plasma, 10,000 results storage memory, Sample volume 20-40ul, Reagent volume 20-40ul,Electonic pipette &nbsp;20-200ul, Incubation Temp. 37.0&plusmn; 1.0&deg;C &nbsp;NEW ADDITION</p>', '158000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('388', '3', '66', '15', 'GVDOCTOR', 'GV-DOCTOR CENTRIFUGE Glovision Doctor Centrifuge 8 x 15 ml Metal body Head ABS ', '3000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('389', '3', '67', '33', 'RM02PLUS', 'RM-02 PLUS  Remi Mini Plus Centrifuge 6000 RPM With Speed Indicator, Capacity 8 x 1.5 ml', '10000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('390', '3', '67', '33', 'RM03PLUS', 'RM-03 PLUS Remi Micro Centrifuge 15000 RPM LCD Display with 12x1.5ml /2 ml and PCR strip Rotor  (2 x 8 x 0.2 ) ml', '53000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('391', '3', '68', '33', 'MEDICOPLUS', 'Medico Plus  Medico Centrifuge max.speed 4000 rpm with brushless induction motor, frequency drive, LED display of speed and time, safety lid lock, imbalance detector, dynamic brake supplied without rotors and accessories', '25000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('392', '3', '68', '33', 'SM815', 'SM 8-15 Swing out rotor suitable for 8 tubes of 15ml (supplied with glass tubes)', '4500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('393', '3', '68', '33', 'SM450 ', 'SM 4-50 Swing out rotor suitable for 4 tubes of 50ml (supplied with glass tubes)', '4000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('394', '3', '68', '33', 'AM365', 'AM 36-5 Angle rotor suitable for 36 Vaccutainer tubes of 5ml (12.5mm x 81mm) without tubes', '4500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('395', '3', '68', '33', 'AM205', 'AM 20-5 Angle rotor suitable for 20 Vaccutainer tubes of 5ml (12.5mm x 106mm) without tubes', '4200', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('396', '3', '68', '33', 'AM1810', 'AM 18-10 Angle rotor suitable for 18 Vaccutainer tubes of 10ml (15.5mm x 106mm) without tubes', '4200', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('397', '3', '68', '33', 'AM1215', 'AM 12-15 Angle rotor suitable for 12 tubes of 15ml (supplied with glass tubes)', '4200', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('398', '3', '68', '33', 'AM650', 'AM 6-50 Angle rotor suitable for 6 tubes of 50ml (supplied with plastic tubes)', '5200', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('399', '3', '69', '33', 'C852', 'C-852 Medical Centrifuge Buckets 4 Capacity 15ml RPM 3500 NO Display', '6400', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('400', '3', '69', '33', 'C8544', 'C-854/4 Clinical Centrifuge  Bucket 4  Capacity 15ml RPM 3500 NO Display', '7400', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('401', '3', '69', '33', 'C8546', 'C-854/6 Clinical Centrifuge  Bucket 6  Capacity 15ml RPM 3500 NO Display', '8200', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('402', '3', '69', '33', 'C8548', 'C-854/8 Clinical Centrifuge  Bucket 8  Capacity 15ml RPM 3500 NO Display', '10400', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('403', '3', '69', '33', 'R303 ', 'R-303 Doctors Centrifuge  Bucket 8  Capacity 15ml RPM 3800 NO Display', '8400', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('404', '3', '69', '33', 'R304', 'R-304 Doctors Centrifuge Bucket 24 Capacity 5ml RPM 7000 NO Display', '13000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('405', '3', '69', '33', 'R4C ', 'R-4C  W/Timer Centrifuge  Without Head RPM 4400 WITH Display', '24000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('406', '3', '69', '33', 'R41 ', 'Head R-41 Spare  Bucket 8 (SWING) Capacity 15ml RPM 3500, Suitable for R-4C', '4000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('407', '3', '69', '33', 'R42', 'Head R-42 Spare  Bucket 4 (SWING) Capacity 50ml RPM 3500 Suitable for R-4C', '5000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('408', '3', '69', '33', 'R43 ', 'Head R-43 Spare Bucket 8 (ANGLE) Capacity 15ml RPM 4400 Suitable for R-4C', '4000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('409', '3', '69', '33', 'R44 ', 'Head R-44 Spare Bucket 4 (ANGLE) Capacity 50ml RPM 4200 Suitable for R-4C', '5000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('410', '3', '69', '33', 'R8C', 'R-8C Centrifuge Without Head  RPM 5250 WITH Display', '29000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('411', '3', '69', '33', 'R8CBL', 'R8C BL Centrifuge Without Head  RPM 6000 WITH Display', '68000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('412', '3', '69', '33', 'R81', 'Head R-81 Spare Bucket 16 (swing) Capacity 15ml RPM 4000 Suitable for R-8C', '7400', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('413', '3', '69', '33', 'R81A', 'Head R-81A Spare  Bucket 12(swing) Capacity 15ml  RPM 4000 Suitable for R-8C', '6600', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('414', '3', '69', '33', 'R81B', 'Head R-81B Spare  Bucket 8(swing) Capacity 15ml    RPM 4200 Suitable for R-8C', '4000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('415', '3', '69', '33', 'R82', 'Head R-82  Spare  Bucket 6 (swing) Capacity 50ml Suitable for R-8C', '6800', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('416', '3', '69', '33', 'R82A', 'Head R-82A Spare  Bucket 4 (swing) Capacity 50ml  RPM 4000 Suitable for R-8C', '5000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('417', '3', '69', '33', 'R83', 'Head R-83 Spare Bucket 16 (Angle) Capacity 15ml Suitable for R-8C', '6600', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('418', '3', '69', '33', 'R83A', 'Head R-83A Spare  Bucket 12 (Angle) Capacity 15ml  RPM 5250 Suitable for R-8C', '5200', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('419', '3', '69', '33', 'R83B ', 'Head R-83B Spare Bucket 8 (Angle) Capacity 15ml with polypropylene tubes suitable for R-8C', '4200', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('420', '3', '69', '33', ' R84 ', 'Head R-84 Spare Bucket 6 (Angle) Capacity 50ml  with polypropylene tubes Suitable for R-8C', '4200', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('421', '3', '69', '33', 'R84A', 'Head R-84A Spare Bucket 4 (Angle) Capacity 50ml  RPM 5250 Suitable for R-8C', '4200', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('422', '3', '69', '33', 'R88', 'Head R-88 Spare Angle Head4 x 100 ml  with Polypropylene tube For R-8C BL ', '9500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('423', '3', '69', '33', 'R89', 'Head R-89 Spare Angle Head24 x 15 ml  with Polypropylene tube For R-8C BL ', '10000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('424', '3', '69', '33', 'R90', 'Head R-90 Spare 4 x 100 ml swing out with glass tube & Biosafety cap for R-8CBL', '20000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('425', '3', '69', '33', 'RM12C', 'RM-12C W/timer Micro Centrifuge  w/o Head  RPM 16000  with Display', '25500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('426', '3', '69', '33', 'RM1210', 'Head RM-1210 Spare  Bucket 24 Capillary  Capacity 75mmx1mm  RPM 12000 Suitable for RM - 12C', '4200', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('427', '3', '69', '33', 'RM1214 ', 'Head RM-1214 Spare  Bucket 10 (Angle) Capacity 2.0ml RPM 16000 Suitable for RM - 12C', '4200', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('428', '3', '69', '33', 'RM1215', 'Head RM-1215 Spare  Bucket  24 (Angle) Capacity 1.5ml   RPM 11850', '6200', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('429', '3', '69', '33', 'RM1213', 'Head RM-1213  Spare  (Reading Device for RM-1210)                  ', '4600', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('430', '3', '69', '33', 'RM1216', '<p>Head RM 1216 Spare Bucket 8 Capacity 5ml</p>', '9000', '1', '0', '1', '09-07-2022', NULL, NULL, NULL, NULL, NULL, '2022-07-09 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('431', '3', '69', '33', 'R8K', 'R-8K Centrifuge For Milk & Oil W /O Rotor    with Display', '33000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('432', '3', '69', '33', 'R86', 'Head R-86 Spare   Rotor for above suitable for R-8k  Capacity 4 x 50 ml Head ', '6800', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('433', '3', '69', '33', 'R8M PLUS', 'R-8M PLUS Centrifige ( Max 6000 RPM) With Brushless Induction Motor without Head ', '44000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('434', '3', '69', '33', 'R8CPLUS ', 'R-8C PLUS Centrifige ( Max 6000 RPM) With Brushless Induction Motor without Head ', '36000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('435', '3', '69', '33', 'S2415', 'Head S 24 -15 Swing Out Rotor 24 x 15ml ( Supplied with Glass Tubes)', '12500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('436', '3', '69', '33', 'S815', 'Head S 8 -15 Swing Out Rotor 8 x15ml ( Supplied with Glass Tubes)', '6400', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('437', '3', '69', '33', 'A2415', 'Head A24 - 15  Angle Rotor 24 x 15 ml  ( Supplied with Plastic Tubes)', '11500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('438', '3', '69', '33', 'AR650', 'Head AR 6 - 50  Angle Rotor 6 x 50 ml  ( Supplied with Plastic Tubes)', '5600', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('439', '3', '70', '33', 'NEYA12', 'NEYA 12 Bench Top Centrifuge, (max. speed 16000 rpm) LCD display of speed and time, imbalance detector, dynamic brake safety lid lock, 10 accelaration / decelaration profiles, 10 programs and rotor identification, supplied without rotors and  accessories', '115500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('440', '3', '70', '33', 'NEYA16R', 'NEYA 16R Refrigerated Bench Top Centrifuge, (max. speed 16000 rpm) LCD display of speed and time, imbalance detector, dynamic brake, safety lid lock, 10 accelaration / decelaration profiles, 10 programs and rotor identification, supplied without rotors and accessories', '214000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('441', '3', '70', '33', 'S4175 ', 'S 4-175 4 place Swing out Rotor', '15500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('442', '3', '70', '33', 'S696MP', 'S 6-96 MP 2 place Swing out Rotor for 6 micro plates of 96 wells', '33175', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('443', '3', '71', '33', 'CM101', 'REMI Model CM101  with single and Multi tube Head', '6200', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('444', '3', '71', '33', 'CM101PLUS', 'CM-101 Plus Vortex Mixer with brushless motor & suitable for Interchangeable mixing Heads', '10000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('445', '3', '71', '15', 'GVCYCLOMIXER', 'Cyclomixer Glovision', '2600', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('446', '3', '72', '33', 'R24', 'R-24 Revolutionary High Speed Centrifuge Without Rotor Head  And Accessories ', '72750', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('447', '3', '72', '33', 'R242', 'R-242 ANGLE Head Rotor With PP Tubes 6X50ML Suitable For R-24 And C-24 ', '23550', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('448', '3', '72', '33', 'CM12PLUS', 'CM-12 Plus  REFRIGERATED Compact Bench Top Cooling Micro Centrifuges w/o rotor Heads and accessories (-20\'c up to 5 ml)', '176550', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('449', '3', '72', '33', 'RM1214M ', 'RM-1214M 10 x 2 ml Angle Head (with Polycarbonate Tubes)', '6200', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('450', '3', '72', '33', 'RM1215M', 'RM-1215M 24 x 1.5 ml Angle Head (with Polycarbonate Tubes)', '8550', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('451', '3', '72', '33', 'RM1216M', 'RM-1216M  8 x 5 ml Angle Head (with Polycarbonate Tubes)', '10700', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('452', '3', '72', '33', 'RM1217M', 'RM-1217M Angle Head suitable for PCR Strip Tubes - Capacity 4 strips of 8 x 0.2 ml', '15500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('453', '3', '72', '33', 'VS02', ' VS-02 Servo controlled Voltage Stabilizer', '13900', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('454', '3', '72', '33', 'C23PLUS', 'C-23 Plus HIGH Volume Low Speed Table Top Cooling Centrifuge Max 7000 RPM / 7560 RCF,LED Display without rotor Heads ', '269650', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('455', '3', '72', '33', 'CPR23PLUS', 'CPR-23 Plus HIGH Volume Low Speed Table Top Cooling Centrifuge Max 7000 RPM / 7400 RCF, LCD Display W/O rotor Heads', '374500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('456', '3', '72', '33', 'R238M', 'R-238M Complete with Polypropylene Tubes (Capacity 12 x 50 ML)', '29950', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('457', '3', '72', '33', 'R239M', 'R-239M Complete with Polypropylene Tubes (Capacity 36 x 15 ML)', '34250', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('458', '3', '72', '33', 'VS03', 'VS-03 Servo controlled Voltage Stabilizer', '16050', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('459', '3', '72', '33', 'C24PLUS', 'C-24 Plus LOW VOLUME HIGH SPEED COOLING Centrifuge MAX 20000 RPM / 37570 RCF, LED Display W/O rotor Heads', '265350', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('460', '3', '72', '33', 'CPR24PLUS', 'CPR-24 Plus LOW VOLUME HIGH SPEED  COOLING Centrifuge, MAX 20000 RPM / 37570  RCF, LCD Display W/O rotor Heads ', '374500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('461', '3', '72', '33', 'C30PLUS ', 'C-30 Plus HIGH Volume High  Speed FLOOR Model COOLING Centrifuge MAX 20000 RPM / 37570 RCF, LED Display, W/O  rotor ', '326350', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('462', '3', '72', '33', 'CPR30PLUS', 'CPR-30 Plus HIGH Volume High  Speed FLOOR Model COOLING Centrifuge MAX 20000 RPM / 37570 RCF LCD Display w/o Rotor', '401250', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('463', '3', '72', '33', 'R243M ', 'R-243M Complete with Polypropylene Tubes (Capacity 8 x 25 ML)', '25675', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('464', '3', '72', '33', 'R244M', 'R-244M Complete with Polypropylene Tubes (Capacity 12 x 15 ML)', '25675', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('465', '3', '72', '33', 'R247M', 'R-247M Complete with Polypropylene Tubes (Capacity 8 x 50 ML)', '29950', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('466', '3', '72', '33', 'R248M', 'R-248M  Complete with Polypropylene Tubes (Capacity 24 x 1.5 ML)', '19250', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('467', '3', '72', '33', 'VS03', 'VS-03 Servo controlled Voltage Stabilizer', '16050', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('468', '3', '73', '33', 'CC6PLUSLED', '<p>CC-6 Plus Capacity 200 liters, Temperature Range 2&deg;C to 12&deg;C Microprocessor based (VS-02) LED</p>', '179750', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('469', '3', '73', '33', 'CC6PLUSLCD', '<p>CC-6 Plus Capacity 200 liters, Temperature Range 2&deg;C to 12&deg;C Microprocessor based (VS-02) LCD</p>', '205450', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('470', '3', '73', '33', 'CC10PLUSLED', '<p>CC-10 Plus Capacity 280 litters, Temperature Range 2&deg;C to 12&deg;C Microprocessor based (VS-02) LED</p>', '190450', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('471', '3', '73', '33', 'CC10PLUSLCD', '<p>CC-10 Plus Capacity 280 liters, Temperature Range 2&deg;C to 12&deg;C Microprocessor based (VS-02) LCD</p>', '214000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('472', '3', '73', '33', 'CC12PLUSLED', '<p>CC-12 Plus Capacity 370 liters, Temperature Range 2&deg;C to 12&deg;C Microprocessor based (VS-02) LED</p>', '199025', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('473', '3', '73', '33', 'CC12PLUSLCD', '<p>CC-12 Plus Capacity 370 liters, Temperature Range 2&deg;C to 12&deg;C Microprocessor based (VS-02) LCD</p>', '224700', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('474', '3', '73', '33', 'VS02 ', 'VS-02 Servo controlled Voltage Stabilizer', '13900', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('475', '3', '73', '33', '', 'The high end REMI Items will be Supplied Against Order With Advance . Delivery 3 - 4 Weeks', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('476', '3', '74', '26', 'GCO2008', 'Carbon Monoxide  Range  0 - 1000 ppm with Temp - 0 - 50\'C Model Lutron GCO 2008', '15500', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('477', '3', '75', '26', 'GCH2018', 'CO2 Meter Model GCH-2018 For Measuring Carbon Dioxide. Range O-3000ppm, With Alarms And Warming. RH 10 to 95%,temp, 0 to 50c and dew point Lutron Taiwan Made ', '28000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('478', '3', '75', '26', 'GC2028', 'CO2 meter GC- 2028 With alarm Setting Lutron Taiwan Made ', '23000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('479', '3', '76', '42', 'TESTO3153', 'Testo 315-3 Ambient CO / CO2 Monitor Parallel and direct CO / CO2 measurement, TUV-tested according to EN 50543, Convenient, easy handling, optical and audible alarms, wireless data transfer', 'POR', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('480', '3', '77', '42', 'TESTO270', 'Testo 270 Cooking Oil Tester Ergonomic and robust design, with temperature sensor along with TPM, clean alarams via backlit display, Rinsable under running water (IP65), HACCP certified (without calibration)', '50100', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('481', '3', '77', '18', '', 'TM-4000 Cooking oil Thermometer', '2200', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('482', '3', '78', '43', 'TT1', 'BEO Melting Ponit Capillary 3\"Long (Pkt 100)', '40', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('483', '3', '78', '43', 'TT2', 'BEO Melting Ponit Capillary 3\"Long (Pkt 250)', '80', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('484', '3', '78', '43', 'TT3', 'BEO Melting Ponit Capillary 4\"Long (Pkt 100)', '50', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('485', '3', '78', '43', 'TT4', 'BEO Melting Ponit Capillary 4\"Long (Pkt 250)', '110', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('486', '3', '78', '43', 'TT5', 'OES Melting Ponit Capillary 3\"Long (Pkt 100)', '50', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('487', '3', '78', '43', 'TT6', 'OES Melting Ponit Capillary 3\"Long (Pkt 250)', '110', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('488', '3', '78', '43', 'TT7', 'OES Melting Ponit Capillary 4\"Long (Pkt 100)', '60', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('489', '3', '78', '43', 'TT8', 'OES Melting Ponit Capillary 4\"Long (Pkt 250)', '135', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('490', '3', '79', '43', 'T9', 'TLC Capillary 100mm long (Pkt 250)', '350', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('491', '3', '80', '43', 'T10', 'Hepernised Capillary 3\" long (Pkt 100)', '70', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('492', '3', '80', '43', 'T11', 'Non Hepernised Capillary 3\" long (Pkt 100)', '50', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('493', '3', '81', '43', 'T12', 'Graduated Capillary 5 ul 1 Mark', '440', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('494', '3', '81', '43', 'T13', 'Graduated Capillary 5 ul 5 Mark', '440', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('495', '3', '81', '43', 'T14', 'Graduated Capillary 10 ul 2 Mark', '440', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('496', '3', '82', '25', '142020', '142020 Comparator 2000+ (+2 cells) ', '9220', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('497', '3', '82', '25', '234060', '234060 3/40E DISC CHLORINE DPD -TEST 0,02 - 0,3 MG/L', '17134', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('498', '3', '82', '25', '', 'DPD TABLETS', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('499', '3', '82', '25', '511050BT', '511050BT DPD NO.1 TABLETS BF IN PACK OF 100', '2245', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('500', '3', '82', '25', '511080BT ', '511080BT DPD NO.3 TABLETS IN PACK OF 100', '2245', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('501', '3', '82', '25', '511220BT', '511220BT DPD NO.4 TABLETS IN PACK OF 100', '2958', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('502', '3', '83', '25', '', 'COMPARATOR  with 1 pair of square 13.5 mm cells \"INDIAN\"', '5000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('503', '3', '83', '25', '', 'NESSELIZER INDIAN WITH SAMPLE TUBES', '7000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('504', '3', '83', '25', '', 'Spare colour disc price code A  CHLORINE / pH / UNIVERSAL INDIAN each Disk', '3500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('505', '3', '83', '25', '', 'Spare colour disc price code B - HAZEN INDIAN', '3500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('506', '3', '83', '25', '', 'Spare colour disc price code C INDIAN', '3500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('507', '3', '83', '25', '', 'Spare 13.5mm, 10ml moulded cells for comparator with stoppers (One Pair) INDIAN', '1250', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('508', '3', '84', '25', '147020', '147020 TESTKIT CHECKIT COMPARATOR CHLORINE DPD 0 - 4 MG/L', '13536', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('509', '3', '84', '25', '147275', '147275 TESTKIT CHECKIT COMPARATOR OZONE DPD 0 - 1 MG/L', '8349', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('510', '3', '84', '25', '147100', '147100 TESTKIT CHECKIT COMPARATOR pH 6,5 - 8,4', '10810', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('511', '3', '84', '25', '400700', '400700 ARSENIC TEST KIT (5ppb) IN CASE ', '27718', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('512', '3', '85', '25', '415020MK', 'IN415020MK pH 2- 13 pH (2, 4, 5,6 7, 8, 9 10,11, 12, 13) Pk. Sz. 100 Colour card ShuddhCheck ', '622', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('513', '3', '85', '25', '415050MK', 'IN415050MK Turbidity 0-80 NTU (0, 0-10, 10-20, 20-40, 40-60, Pk. Sz. 100 Colour card ShuddhCheck ', '414', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('514', '3', '85', '25', '415030MK', 'IN415030MK FRC 0-3 ppm (0, 0.2, 0.5, 1.0, 1.5, 2.0, 3.0) Pk. Sz. 100 Colour card ShuddhCheck ', '1038', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('515', '3', '85', '25', '415010MK', 'IN415010MK Fluoride 0- 3 ppm(0, 0.5, 1.0, 1.5, 2.0, 3.0) Pk. Sz. 100 Colour card ShuddhCheck ', '622', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('516', '3', '85', '25', '415060MK ', 'IN415060MK IRON HR 0- 4 ppm(0, 1.0, 1.5, 2.0, 3.0, 4.0) Pk. Sz. 100 Colour card ShuddhCheck ', '622', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('517', '3', '85', '25', '415110MK', 'IN415110MK Silica 0-0.530 ppm as SiO2(0, .021, 0.053,0.106, Pk. Sz. 100 Colour card ShuddhCheck ', '6238', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('518', '3', '85', '25', '415070MK', 'IN415070MK Iron LR 0-1.5 ppm(0, 0.2, 0.3, 0.4, 0.5, 1.0, 1.5) Pk. Sz. 100 Colour card ShuddhCheck', '1038', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('519', '3', '85', '25', '415120MK', 'IN415120MK Iron ULR 0-0.5 ppm(0, 0.1, 0.2, 0.3, 0.4, 0.5) Pk. Sz. 100 Colour card ShuddhCheck ', '1038', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('520', '3', '85', '25', '415040MK', 'IN415040MK Nitrate Mini Kit 0-154 ppm NO3(0, 22, 44, 66, 88, 110, 132, 154 ppm as NO3  0,5,10,15,20,25,30,35 ppm as NO3-N) Pk. Sz. 100ml Colour card ShuddhCheck', '4158', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('521', '3', '85', '25', '416060MK ', 'IN416060MK Nitrate 0-40 as NO3-N & 0- 175 ppm as NO3() Pk. Sz. 100 Drop Test ShuddhCheck', '2078', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('522', '3', '85', '25', '416010MK ', 'IN416010MK Chloride 0-1000 ppm() Pk. Sz. 100 Drop Test ShuddhCheck ', '2078', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('523', '3', '85', '25', '416040MK', 'IN416040MK Total Hardness 0-3000 ppm() Pk. Sz. 100 Drop Test ShuddhCheck', '1246', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('524', '3', '85', '25', '416030MK ', 'IN416030MK Total Hardness 0-500 ppm() Pk. Sz. 100 Drop Test ShuddhCheck ', '1038', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('525', '3', '85', '25', '416020MK', 'IN416020MK Total Hardness 0-50 ppm() Pk. Sz. 100 Drop Test ShuddhCheck ', '1246', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('526', '3', '85', '25', '416050MK', 'IN416050MK Total Alkalinity 0-1000 ppm() Pk. Sz. 100 Drop Test ShuddhCheck ', '1038', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('527', '3', '86', '25', '276000', '276000 MD100 CHLORINE TABLETS 0,01-6,0 MG/L - PHOTOMETER IN CASE', '69301', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('528', '3', '86', '25', '276160', '276160 MD100 HAZEN PHOTOMETER IN CASE', '76571', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('529', '3', '86', '25', '276150', '276150 MD100 SUSPENDED SOLIDS PHOTOMETER IN CASE', '76571', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('530', '3', '86', '25', '214025', '214025 MD610 PHOTOMETER BLUETOOTH IN CARRYING CASE WITH STANDARD ACCESSORIES', '170872', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('531', '3', '87', '25', '56B000701', '56B000701 DI 10 Dipslide Incubator ', '90574', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('532', '3', '87', '25', '56B010510 ', '56B010510 Dipslide D005 (TTC/E.COLI) Pack of 10', '3181', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('533', '3', '87', '25', '56K009701', 'IN56K009701 E Coli/Coliform kit for 25 test ', '27633', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('534', '3', '88', '45', '', 'DFT-222 Professional high accuracy Coating Thickness gauge, measuring range 0 to 2000um, Resolution 0-99.9um', '6900', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('535', '3', '88', '45', '', '456 High accuracy Coating Thickness gauge with separated probe, measuring range 3000um, Resolution 0-99.9um', '12650', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('536', '3', '88', '45', '', 'Coat-PRO Coating Thickness gauge, range 0-1500um/0-60mil, Resolution 0.1um/, temp -10\'C to 50\'C', '14100', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('537', '3', '89', '8', '', 'Coating Thickness gauge AA C1 Non Ferrous', '18000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('538', '3', '90', '27', '', 'Model CTG-01 Measures coating thickness on both ferrous and non-ferrous materials', '13250', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('539', '3', '90', '27', '', 'Model CTG-02 Measures coating thickness on both ferrous and non-ferrous materials with extended flexible cable with sensor', '23600', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('540', '3', '91', '8', '', 'Rohem Silverlite', '1100', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('541', '3', '91', '17', '', 'HBG Silverlite', '1000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('542', '3', '91', '8', '', 'China Chamber plain without silver coating', '425', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('543', '3', '92', '25', '2892602', 'COD Measurement system  COD set up MD 200 COD VARIO 10 with reagents consisting of COD photometer, LOVIBOND ', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('544', '3', '92', '25', '', 'COD reactor RD 125Code 2418940, COD tube 0 - 150 mg/l and 0-1500 mg/l cuvette rack,  manual code 2892602', '194688', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('545', '3', '92', '25', '', 'COD PHOTOMETER', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('546', '3', '92', '25', '2892502', '2892502 MD200 COD VARIO PHOTOMETER PHOTOMETER IN CASE WITH ADAPTER ', '78186', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('547', '3', '93', '15', 'GVCOD15', 'GV-COD-15 COD Digester with digital temp controller & timer along with glass parts Indian make 15 Samples', '35000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('548', '3', '93', '15', 'GVCOD6', 'GV-COD-6 COD Digester with digital temp controller & timer along with glass parts Indian make  6 Samples', '27500', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('549', '3', '94', '8', '', 'Kumar Make Boat Size 10 X 12 X 88 (Pkt of 150) Price per pcs', '9', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('550', '3', '94', '8', '', 'Tube Kumar Make Size 19 X 24 X 600', '500', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('551', '3', '94', '8', '', 'Tube Kumar Make Size 17 X 22 X 600', '500', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('552', '3', '94', '8', '', 'Tube Kumar Make Size 22 X 29 X 600', '750', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('553', '4', '95', '26', 'PDO519', 'Model PDO 519 Lutron DO meter Pen type 0-20 ppm, Taiwan with built in probe', '14250', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('554', '4', '95', '26', 'PDO520', 'Model PDO 520 Lutron DO meter Pen type 0-20 ppm, Taiwan with Detachable probe', '16500', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('555', '4', '96', '26', '5509', 'Model 5509 Lutron DO Meter, 0 to 20mg/L Calibration  ', '12500', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('556', '4', '96', '26', '5510', 'Model 5510 Lutron DO  Mete 0 to 20mg/L measure oxygen in air ', '19500', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('557', '4', '96', '26', '5510HA', 'Model 5510 Lutron DO  Mete 0 to 20mg/L measure oxygen in air ', 'POR', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('558', '4', '96', '26', '5519', 'Model 5519 Lutron DO meter 0 - 20 mg/l  / Oxigen in Air - 0 - 100 % ', '17000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('559', '4', '96', '26', 'OXEL03', 'Spare Electrolyte OXEL-03 for Lutron DO meters 50 ml bottle', '1225', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('560', '4', '96', '26', 'DIAPHRAMMEMBRANE', 'Do Spare Membrane LUTRON per pcs.', '900', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('561', '4', '97', '7', 'DO602K', 'Model DO602K DO Range 0 to19.9 mg/1;0  TO199.9% IP Rating IP 54', '72000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('562', '4', '98', '22', 'LH28', 'LH-28 Portable Digital Dissolved Oxygen Meter 31/3  digit LCD display, battery operated, ABS Plastic body. (Against order)', '4900', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('563', '4', '99', '7', 'ECDO70042S ', 'Model ECDO70042S   DO/Temp RANGE o to 30 mg/l, NO Memory ', '112000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('564', '4', '99', '7', 'ECDO270042', 'Model ECDO270042  DO/BOD/Temp. RANGE o to 50 mg/l Memory 500 Output RS232', 'POR', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('565', '4', '99', '7', 'DO2700AN270', 'ANTECH AN 270 Printer Suitable for ECDO270042S model .', '36000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('566', '4', '100', '22', 'LH52', 'LH-52 Microprocessor D.O. Meter with 16x 2 alpha numeric LCD display, simultaneous display of O.O. & temp. Data Storage facility upto 1000 samples, computer interlace through USB, Supplied with O.O. probe, temp. probe, electrode stand, dust cover & instructions manual. ', '13000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('567', '4', '100', '22', 'LH18', 'LH-18 Digital Dissolved Oxygen Meter 3.5 Digit LED display with Gold/Silver O.O.Probe ', '6100', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('568', '4', '100', '22', 'LH27', 'LH-27 Digital Dissolved Oxygen Analyser cum temperature Meter along with Gold/Silver O.O. probe and RTD temp.probe ', '6100', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('569', '4', '101', '8', '', 'HILGER 15000 Lines', '2000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('570', '4', '101', '8', '', 'Diffraction Grating Student', '300', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('571', '4', '102', '22', 'LH42', '<p>LH-42 Digital Dry Bath Incubator 24 Holes for 12 mm tubes, +S&ordm;C above ambient to70&ordm;C. Temperature sensor PT100, Maximum heating power 125W, Temperature Controller PID, Timer 1 min to 99 minutes, LCD Display for time &amp; temperature, Anodized Aluminum block. 220VAC, Available with Buzzer alarm &amp; Overheat protection.</p>', '6000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('572', '4', '103', '33', 'RQV200PLUSLED', '<p>RQV-200 Plus Capacity 200 liters, Temperature up to -20&deg;C, Microprocessor (VS 02) LED</p>', '177625', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('573', '4', '103', '33', 'RQV200PLUSLCD', '<p>RQV-200 Plus Capacity 200 liters, Temperature up to -20&deg;C, Microprocessor (VS 02) LCD</p>', '203300', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('574', '4', '103', '33', 'RQV300PLUSLED', '<p>RQV-300 Plus Capacity 300 liters, Temperature up to -20&deg;C, Microprocessor (VS 02) LED</p>', '203300', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('575', '4', '103', '33', 'RQV300PLUSLCD', '<p>RQV-300 Plus Capacity 300 liters, Temperature up to -20&deg;C, Microprocessor (VS 02) LCD</p>', '228975', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('576', '4', '103', '33', 'RQV400PLUSLED', '<p>RQV-400 Plus Capacity 400 liters, Temperature up to -20&deg;C, Microprocessor (VS 03) LED</p>', '214000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('577', '4', '103', '33', 'RQV400PLUSLCD', '<p>RQV-400 Plus Capacity 400 liters, Temperature up to -20&deg;C, Microprocessor (VS 03) LCD</p>', '240750', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('578', '4', '103', '33', 'VS03', 'VS-03 Servo controlled Voltage Stabilizer', '16050', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('579', '4', '103', '33', 'VS02 ', 'VS-02 Servo controlled Voltage Stabilizer', '13900', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('580', '4', '104', '33', 'RFV245', '<p>RFV-245, 245 Liters capacity, Plastic inner chamber &amp; outer body of G.I, temperature range -16&deg;C to -24&deg;C</p>', '85600', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('581', '4', '104', '33', 'RFV340', '<p>RFV-340, 340 Liters capacity, Plastic inner chamber &amp; outer body of G.I, temperature range -16&deg;C to -24&deg;C</p>', '136975', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('582', '4', '105', '33', 'ULT90', 'ULT-90 Capacity 90 liters, Temp low upto -86c, microprocessor control lcd version(VS 05)', '442975', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('583', '4', '105', '33', 'ULT185', 'ULT-185 Capacity 185 liters, Temp low upto -86c, microprocessor control lcd version(VS 06)', '510400', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('584', '4', '105', '33', 'ULT360', 'ULT-360 Capacity 360 liters, Temp low upto -86c, microprocessor control lcd version(VS 07)', '603475', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('585', '4', '105', '33', 'VS05', 'VS-05 Servo controlled Voltage Stabilizer', '39600', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('586', '4', '105', '33', 'VS06', 'VS-06 Servo controlled Voltage Stabilizer', '59925', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('587', '4', '105', '33', 'VS07', 'VS-07 Servo controlled Voltage Stabilizer', '69550', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('588', '4', '106', '42', 'TESTO174T', 'Testo 174 T Single Channel Temperature datalogger with internal sensor (NTC), Memory capacity: 16,000 readings, Easy readout of  the data and transfer to a PC via testo USB interface', '5000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('589', '4', '106', '42', 'TESTO174H', 'Testo 174 H Two Channel Temperature and Humidity datalogger with internal sensor (NTC/Capacitive humidity sensor), Memory capacity: 16,000 readings, Easy readout of  the data and transfer to a PC via testo USB interface', '8500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('590', '4', '106', '42', 'TESTO175H', 'Testo 175 H1 2-channel data logger for temperature and humidity measurements, external humidity sensor (NTC/ capacitive humidity sensor), wall bracket, lock, batteries, calibration protocol', '45650', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('591', '4', '106', '42', 'TESTO174D', 'Testo 174 D USB Interface', '8320', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('592', '5', '107', '17', '', 'ESR Tube HBG Make', '60', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('593', '5', '107', '43', '', 'ESR Tube Top Tech', '45', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('594', '5', '107', '8', '', 'ESR Tube Superior Make', '75', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('595', '5', '107', '8', '', 'ESR Stand 6 Tube powder coated', '200', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('596', '5', '108', '43', 'T22', 'ESRITE KIT E-5', '575', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('597', '5', '108', '43', 'T23', 'ESR Pipette Plain for ESRITE Kit', '50', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('598', '5', '108', '43', 'T24', 'ESR Pipette Graduated for ESRITE Kit', '60', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('599', '5', '109', '7', 'ECFC7252101B', 'ECFC7252101B General Purpose Plastic-body Single Junction Gel-Filled pH Combination 12x90mm, BNC 1m for PH700/Tutor etc', '6000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('600', '5', '109', '7', 'ECFC72521R01B ', '<p>ECFC72521R01B General Plastic-body Single Junction Refillable pH Combination Electrode12x90mm, BNC, 1m &amp; 10ml refilling electrolyte</p>', '10800', '1', '0', '1', '12-07-2022', NULL, NULL, NULL, NULL, NULL, '2022-07-12 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('601', '5', '109', '7', 'ECFC7252201B ', '<p>ECFC7252201B General Purpose Plastic-body Double Junction Gel-Filled pH Combination 12x90mm,BNC,1m</p>', '9180', '1', '0', '1', '12-07-2022', NULL, NULL, NULL, NULL, NULL, '2022-07-12 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('602', '5', '109', '7', 'ECFC7352901B ', 'ECFC7352901B General Purpose Plastic-body \"3-in-1\" pH/Temp. Combination Electrode, 12x90mm, BNC , 1m for Tutor DS ', '10800', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('603', '5', '109', '7', 'ECFG4390401B', 'ECFG4390401B Glass-body pH Combination Micro-Electrode, reference Calomel Refillable ,4x55 mm, BNC connector, 1m cable length. Ideal for Micro sample, such as semi-micro cuvettes and NMR tube,Research measurements, fruit juices, beer, milk and yogurt, Tris buffers, clinical, and biological media containing  proteins, creams, fats and cosmetics ', '31500', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('604', '5', '109', '7', 'ECFG7252001B ', 'ECFG7252001B General Purpose, Flat-surface, Glass-body Single Junction Refillable pH Combination Electrode,12x110mm, BNC connector, 1m cable length. Used for surface measurements such as paper, skin, textile, leather, agar', '31500', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('605', '5', '109', '7', 'ECPH5TEMB01P', 'ECPH5TEMB01P ATC Probe (for Tutor, Ion 510, pH 510,  pH 700, Ion 700, pH 1100, pH 2100, pH 2700, & Ion 2700), 1m cable length ', '7920', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('606', '5', '110', '15', 'PC22', 'PC22 pH glass combined electrode KCL filling type BNC jack OR Suitable for all brand of pH meters ', '475', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('607', '5', '110', '15', 'PHEPOXYBNC', 'pH unbreakable Gel filled combined electrode EPOXY body', '750', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('608', '5', '110', '15', 'PHEPOXYBANANA', 'pH unbreakable Gel filled combined electrode EPOXY body with Banana pin', '750', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('609', '5', '110', '15', 'CD06', 'CD-06 TDS/COND Cell at Cell constant K=1.00(appx.) Unbreakable ', '1250', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('610', '5', '110', '15', 'CD06BNC1', 'CD-06 TDS/COND Cell at Cell constant K=1.00(appx.) with BNC connector', '1250', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('611', '5', '110', '15', 'CD065', 'CD-06 TDS/COND Cell at Cell constant K=5.00(appx.)', '1250', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('612', '5', '110', '15', 'CD04', 'CD-04 TDS/COND Cell at Cell constant  K=0.50(appx.)', '2250', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('613', '5', '110', '15', 'CD08', 'CD-08 TDS/COND Cell at Cell constant  K=0.10(appx.)', '3225', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('614', '5', '110', '15', 'PE77 - Banana', '<p>Calamel (reference) Electrode Banana Pin for Potientiometer PE-77</p>', '300', '1', '0', '1', '04-07-2022', NULL, NULL, NULL, NULL, NULL, '2022-07-04 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('615', '5', '110', '15', 'PG11', 'Glass Electrode Banana  Pin for Potientiometer', '450', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('616', '5', '110', '15', 'PM55', 'Platinum Electrode Banana Pin for Potientiometer', '630', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('617', '5', '110', '15', 'SM66 ', 'Silver Electrode Banana pin for Potientiometer', '450', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('618', '5', '110', '15', 'GVCU', 'Copper Electrode with Banana pin', '300', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('619', '5', '110', '15', 'GVCD', 'Cadmium Electrode with Banana pin', '330', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('620', '5', '110', '15', 'GVAL', 'Aluminium Electrode with Banana pin', '300', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('621', '5', '110', '15', 'GVZN', 'Zinc Electrode with Banana pin', '300', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('622', '5', '110', '15', 'PE88', 'Reference Electrode ( Ag/ AgCL) with Banana pin PE-88', '300', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('623', '5', '111', '22', 'SWINGARMSTAND', 'LABOHOLIC SWING ARM STAND WITH GOOD BASE AT BEST RATE', '750', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('624', '5', '112', '22', 'LH1260', 'LH-1260 Microplate Elisa Reader Designed with long life LED light technology, 7\" Touch TFT LCD Screen, Test results simultaneous displayed in screen,Bichromatic,8-channel optical system, 96-well plate, Light sourceMonochromatic LED, 3 shaking mode with variable time, Large storage capacity up to 200 test protocols and 100,000 results, Self-Check & malfunction alarm, Windows operating system. (Imported)', '190000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('625', '5', '113', '22', 'LH1261', '<p>LH-1261 Mircoplate Elisa Washer Large LCD Display, Intelligent software, easy to operate, Strong washing function, bottom washing and two positions aspiration make completed washing effect., Plate - 48/96 well and trips (U,V, Flat bottom), Residual volume &nbsp;&le;2&micro;l, Dispensing volume : Adjustable From 50 to 900&micro;l,1-16 optional wash cycles, Soak tiem upto 990 seconds adjustable, Shake time upto 990 sec,3 channel for washing liquid, 1 channel for waste liquid, Self-calibration and trouble alarm function,Large memory to store up to 100 program, RS232 interface NEW ADDITION</p>', '190000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('626', '6', '114', '22', 'LH6710 ', 'LH-6710 Microprocessor Flame Photometer Touch Screen,  Auto Gas Cut-off Facility, Auto Flame Failure Detection Facility, &#956;P Based with Printer Interface, Five Element Measurement in single Aspiration of the sample, Curve Calibration Programmability using Maximum of 25 Standards Data Processing Through Curve Fitting Techniques - Least Squares,Quadratic,Multiple Calibration Curves Saving Facility, Samples Data Storage Facility, Online Help Key, Printer Attachment Facility,Measurement in ppm & meq, Useful for both Medical & Soil Testing Applications, Setup Storage facility upto 10 setups files. (with 2 Filters Na & K)NEW ADDITION', '76000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('627', '6', '114', '22', 'LH672 ', 'LH-672 Microprocessor flame photometer (Graphical Display) Four Element measurement in a single aspiration (Na & Kas standard, Li and Ca optional at extra cost). Calibration curve fit routines first order and second order. Data displayed in concentration units i.e. ppm & meq, automatic filter selection; auto calibration feature. Printer attachment, PC connecting compatibility, Sample data storage more than 500 results. Alphanumerical keyboard for easy data entry. Graphical LCD display thus easy to read, Curve calibration using upto 5 standard, Multiple calibration curve saving facility, Stainless steel burner. Auto Gas Cut off in case of power failure. (with 2 Filters Na & K)', '61000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('628', '6', '114', '22', 'LH671 ', 'LH-671 Microprocessor flame photometer (Graphical Display) Four Element measurement in a single aspiration (Na & Kas standard, Li and Ca optional at extra cost). Calibration curve fit routines first order and second order. Data displayed in concentration units i.e. ppm & meq, automatic filter selection; auto calibration feature. Printer attachment, PC connecting compatibility, Sample data storage more than 500 results. Alphanumerical keyboard for easy data entry. Graphical LCD display thus easy to read, Curve calibration using upto 5 standard,Multiple calibration curve saving facility, Stainless steel burner. Auto Gas Cut off in case of power failure.PROVIDED WITH 2 FILTERS & COMPRESSOR. (with 2 Filters Na & K)', '50000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('629', '6', '114', '22', 'LH66', 'LH-66 Digital Clinical Flame Photometer Digital Flame Photometer (Dual Channel) single aspirations, with filters (Na & K). Final result in ppm, 2.5 digit dual LED display for simultaneous result along with compressor & accessories, autoignition. Ca & Li filter can to provided on request at extra cost.(with 2 Filters Na & K)', '28250', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('630', '6', '114', '22', 'LH65', 'LH-65 Digital Flame Photometer Digital Flame Photometer (Single Channel) with filter (Na &K) 2.5 LED display (ppm) along with compressor and other accessories, auto ignition, Ca & Li filter can be provided on request at extra cost. (with 2 Filters Na & K)', '24500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('631', '6', '114', '22', 'LHCALI', 'Spare Filter (Calcium or Lithium) for Flame Photometer Against order can be fitted any of the above models ', '5500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('632', '6', '114', '22', 'LHBA', 'Spare Filter (Barium) for Flame Photometer Against order can be fitted any of the above models ', '10000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('633', '6', '115', '22', 'LH330', 'LH-330 Digital Photo Flourometer measures florophors like vitamins, quinine, steroids and metal. Supplied with 2 primary and 3 secondary filters mounted on holders. Results are displayed on 3 digit 7 segment LED. Sensitivity in 4 ranges', '49000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('634', '6', '116', '8', '', 'B-2 Cup with stand and Level', '3250', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('635', '6', '116', '8', '', 'B-3 Cup with stand and Level', '3250', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('636', '6', '116', '8', '', 'B-4 Cup with stand and Level', '3250', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('637', '6', '116', '8', '', 'B-5 Cup with stand and Level', '3250', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('638', '6', '116', '8', '', 'B-6 Cup with stand and Level', '3250', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('639', '6', '116', '8', '', '<p>B-8 Cup with stand and Level</p>', '3750', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('640', '6', '116', '8', '', 'B-10 Cup with stand and Level', '3250', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('641', '6', '116', '8', '', 'B-2 Cup only', '2500', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('642', '6', '116', '8', '', 'B-3 Cup only', '2500', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('643', '6', '116', '8', '', 'B-4 Cup only', '2500', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('644', '6', '116', '8', '', '<p>B-5 Cup only</p>', '3000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('645', '6', '116', '8', '', 'B-6 Cup only', '2500', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('646', '6', '116', '8', '', 'B-8 Cup only', '2500', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('647', '6', '116', '8', '', 'B-10 Cup only', '2500', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('648', '6', '116', '8', '', 'Flow cup as per IS 101 with stand B4 cup only', '5500', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('649', '6', '117', '8', '', 'Zahn Cup with handle No. 1,2,3,4,5,or 6  Bottom Round Shape ', '4000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('650', '6', '118', '18', 'FLM3', 'FLM-3 Flow Meter Range: 0.8-8.0 LPM/0.2-2.1 GPM; 0-99999 g/l, Accuracy: +/- 10%, Resolution: 0.1 LPM/GPM; 1 g/l, Set Point: Fully programmable', '3750', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('651', '6', '119', '8', '', '<p>S.S. wt./ Litr. Cup 50 CC</p>', '1500', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('652', '6', '119', '8', '', '<p>S.S. wt./ Litr. Cup 100 CC</p>', '1850', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('653', '6', '120', '44', '', 'Grade 1', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('654', '6', '120', '44', '1001042', 'Cat No. 1001 042 Grade 1 Diameter 42.5  Pkt of 100 NO. Whatman ', '1230', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('655', '6', '120', '44', '1001047', 'Cat No. 1001 047 Grade 1 Diameter 47  Pk of 100 NO.  Whatman', '1330', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('656', '6', '120', '44', '1001055', 'Cat No. 1001 055 Grade 1 Diameter 55  pk of 100 NO. Whatman', '1370', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('657', '6', '120', '44', '1001070', 'Cat No. 1001 070 Grade 1 Diameter 70  pk  of 100 NO. Whatman  ', '1370', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('658', '6', '120', '44', '1001090', 'Cat No. 1001 090 Grade 1 Diameter 90  pk of 100 NO. Whatman  ', '1170', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('659', '6', '120', '44', '1001110', 'Cat No. 1001 110 Grade 1 Diameter 110 pk of 100 NO. Whatman', '1280', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('660', '6', '120', '44', '1001125', 'Cat No. 1001 125 Grade 1 Diameter 125 pk of 100 NO. Whatman', '1460', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('661', '6', '120', '44', '1001150', 'Cat No. 1001 150 Grade 1 Diameter 150 pk of 100 NO . Whatman ', '1710', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('662', '6', '120', '44', '1001185', 'Cat No. 1001 185 Grade 1 Diameter 185 pk of 100 NO. Whatman  ', '2550', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('663', '6', '120', '44', '1001240', 'Cat No. 1001 240 Grade 1 Diameter 240 pk of 100 NO. Whatman', '5340', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('664', '6', '120', '44', '1001270', 'Cat No. 1001 270 Grade 1 Diameter 270 pk of 100 NO.  Whatman', '6080', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('665', '6', '120', '44', '1001320', 'Cat No. 1001 320 Grade 1 Diameter 320  pk of 100 NO. Whatman ', '6680', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('666', '6', '120', '44', '1001917', 'Cat No. 1001 917 Grade 1 Diameter 460x570 Sheets pk of 100 NO. Whatman ', '14120', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('667', '6', '120', '44', '1001918', 'Cat No. 1001 918 Grade 1 Diameter 460X570 Sheets  pk of 500 NO . Whatman', '51190', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('668', '6', '120', '44', '', 'Grade 2', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('669', '6', '120', '44', '1002055', 'Cat No. 1002 055 Grade 2 Diameter 55 pk of100 NO. Whatman ', '1290', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('670', '6', '120', '44', '1002070', 'Cat No. 1002 070 Grade 2 Diameter 70 pk of100 NO. Whatman ', '1430', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('671', '6', '120', '44', '1002090', 'Cat No. 1002 090 Grade 2 Diameter 90 pk of 100 NO. Whatman ', '1430', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('672', '6', '120', '44', '1002110', 'Cat No. 1002 110 Grade 2 Diameter 110 pk of 100 NO.  Whatman', '1600', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('673', '6', '120', '44', '1002125', 'Cat No. 1002 125 Grade 2 Diameter 125 pk of 100 NO.  Whatman ', '1730', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('674', '6', '120', '44', '1002150', 'Cat No. 1002 150 Grade 2 Diameter 150 pk of 100 NO.  Whatman  ', '2550', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('675', '6', '120', '44', '1002185', 'Cat No. 1002 185 Grade 2 Diameter 185 pk of 100 NO.  Whatman', '3440', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('676', '6', '120', '44', '1002917', 'Cat No. 1002 917 Grade 2 Diameter  460x570 Sheets pk of 100 NO. Whatman', '22980', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('677', '6', '120', '44', '', 'Grade 3 ', '', '1', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('678', '6', '120', '44', '1003070', 'Cat No. 1003 070 Grade 3 Diameter 70 pk of 100 NO.  Whatman', '2160', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('679', '6', '120', '44', '1003090', 'Cat No. 1003 090 Grade 3 Diameter 90 pk of 100 NO.  Whatman  ', '2380', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('680', '6', '120', '44', '1003110', 'Cat No. 1003 110 Grade 3 Diameter 110 pk of 100 NO.  Whatman', '2270', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('681', '6', '120', '44', '1003125', 'Cat No. 1003 125 Grade 3 Diameter 125 pk of 100 NO.  Whatman', '3190', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('682', '6', '120', '44', '1003150', 'Cat No. 1003 150 Grade 3 Diameter 150 pk of 100 NO.  Whatman   ', '3320', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('683', '6', '120', '44', '1003185', 'Cat No. 1003 185 Grade 3 Diameter 185 pk of 100 NO.  Whatman  ', '6380', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('684', '6', '120', '44', '1003917', 'Cat No. 1003 917 Grade 3 Diameter  460x570 Sheets pk of 100 NO.  Whatman ', '41310', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('685', '6', '120', '44', '', 'Grade 4', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('686', '6', '120', '44', '1004042', 'Cat No. 1004 042 Grade 4 Diameter 42.5 pk of 100 NO.  Whatman  ', '1170', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('687', '6', '120', '44', '1004047', 'Cat No. 1004 047 Grade 4 Diameter 47 pk of 100 NO.  Whatman  ', '1160', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('688', '6', '120', '44', '1004055', 'Cat No. 1004 055 Grade 4 Diameter 55 pk of 100 NO.   Whatman', '1230', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('689', '6', '120', '44', '1004070', 'Cat No. 1004 070 Grade 4 Diameter 70 pk of 100 NO.   Whatman ', '1230', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('690', '6', '120', '44', '1004090', 'Cat No. 1004 090 Grade 4 Diameter 90 pk of 100 NO.   Whatman ', '1390', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('691', '6', '120', '44', '1004110', 'Cat No. 1004 110 Grade 4 Diameter 110 pk of 100 NO.  Whatman  ', '1660', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('692', '6', '120', '44', '1004125', 'Cat No. 1004 125 Grade 4 Diameter 125 pk of 100 NO.  Whatman ', '1970', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('693', '6', '120', '44', '1004150', 'Cat No. 1004 150 Grade 4 Diameter 150 pk of 100 NO.  Whatman', '2680', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('694', '6', '120', '44', '1004185', 'Cat No. 1004 185 Grade 4 Diameter 185 pk of 100 NO.  Whatman ', '3830', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('695', '6', '120', '44', '1004240', 'Cat No. 1004 240 Grade 4 Diameter 240 pk of 100 NO.  Whatman ', '6770', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('696', '6', '120', '44', '1004917', 'Cat No. 1004 917 Grade 4 Diameter 460x570 Sheets pk of 100 NO.  Whatman', '29390', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('697', '6', '120', '44', '', 'Grade 5', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('698', '6', '120', '44', '1005070', 'Cat No. 1005 070 Grade 5 Diameter 70 pk of 100 NO. Whatman   ', '1530', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('699', '6', '120', '44', '1005090', 'Cat No. 1005 090 Grade 5 Diameter 90 pk of 100 NO. Whatman  ', '1660', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('700', '6', '120', '44', '1005110', 'Cat No. 1005 110 Grade 5 Diameter 110 pk of 100 NO. Whatman', '1810', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('701', '6', '120', '44', '1005125', 'Cat No. 1005 125 Grade 5 Diameter 125 pk of 100 NO.Whatman ', '2270', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('702', '6', '120', '44', '1005150', 'Cat No. 1005 150 Grade 5 Diameter 150 pk of 100 NO. Whatman ', '3570', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('703', '6', '120', '44', '1005185', 'Cat No. 1005 185 Grade 5 Diameter 185 pk of 100 NO.   Whatman ', '5620', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('704', '6', '121', '44', '', ' Grade 40 ', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('705', '6', '121', '44', '1440012', 'Cat No. 1440 012 Grade 40 Diameter  12.7 / 1.27 cm pk of 400 NO.  Whatman  ', '2550', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('706', '6', '121', '44', '1440042', 'Cat No.1440 042  Grade 40 Diameter  42.5  pk of 100 NO. Whatman  ', '2940', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('707', '6', '121', '44', '1440047', 'Cat No. 1440 047 Grade 40 Diameter 47 pk of 100 NO. Whatman  ', '3060', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('708', '6', '121', '44', '1440055', 'Cat No. 1440 055 Grade 40 Diameter 55 pk of 100 NO. Whatman  ', '2170', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('709', '6', '121', '44', '1440070', 'Cat No. 1440 070 Grade 40 Diameter 70 pk of 100 NO. Whatman', '2420', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('710', '6', '121', '44', '1440090', 'Cat No. 1440 090 Grade 40 Diameter 90 pk of 100 NO. Whatman ', '2980', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('711', '6', '121', '44', '1440110', 'Cat No. 1440 110 Grade 40 Diameter 110 pk of  100 NO.  Whatman  ', '3560', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('712', '6', '121', '44', '1440125', 'Cat No. 1440 125 Grade 40 Diameter 125 pk of  100 NO.  Whatman', '4430', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('713', '6', '121', '44', '1440150', 'Cat No. 1440 150 Grade 40 Diameter 150 pk of  100 NO.  Whatman  ', '5890', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('714', '6', '121', '44', '1440185', 'Cat No. 1440 185 Grade 40 Diameter 185 pk of  100 NO. Whatman ', '9580', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('715', '6', '121', '44', '1440240', 'Cat No. 1440 240 Grade 40 Diameter 240 pk of  100 NO. Whatman', '19280', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('716', '6', '121', '44', '1440917', 'Cat No. 1440 917 Grade 40 Diameter 460x570 Sheets 100 NO. Whatman ', '61170', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('717', '6', '121', '44', '', 'Grade 41 ', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('718', '6', '121', '44', '1441070', 'Cat No. 1441 070 Grade 41 Diameter  70 pk of 100 NO. Whatman ', '2450', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('719', '6', '121', '44', '1441090', 'Cat No. 1441 090 Grade 41 Diameter  90 pk of 100 NO. Whatman ', '3100', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('720', '6', '121', '44', '1441110', 'Cat No. 1441 110 Grade 41 Diameter 110 pk of  100 NO. Whatman ', '4170', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('721', '6', '121', '44', '1441125', 'Cat No. 1441 125 Grade 41 Diameter 125 pk of 100 NO.  Whatman', '4720', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('722', '6', '121', '44', '1441150', 'Cat No. 1441 150 Grade 41 Diameter 150 pk of 100 NO.  Whatman', '6120', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('723', '6', '121', '44', '1441185', 'Cat No. 1441 185 Grade 41 Diameter 185 pk of 100 NO.  Whatman  ', '9190', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('724', '6', '121', '44', '1441240', 'Cat No. 1441 240 Grade 41 Diameter 240 pk of  100 NO. Whatman ', '18270', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('725', '6', '121', '44', '1441917', 'Cat No. 1441 917 Grade 41 Diameter 460x570 Sheets pk of 100 NO. Whatman ', '57050', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('726', '6', '121', '44', '', 'Grade 42', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('727', '6', '121', '44', '1442042', 'Cat No. 1442 042  Grade 42 Diameter  42.5 pk of 100 NO.  Whatman', '2170', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('728', '6', '121', '44', '1442055', 'Cat No. 1442 055  Grade 42 Diameter  55 pk of 100 NO.  Whatman  ', '1970', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('729', '6', '121', '44', '1442070', 'Cat No. 1442 070  Grade 42 Diameter  70 pk of 100 NO. Whatman', '2450', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('730', '6', '121', '44', '1442090', 'Cat No. 1442 090  Grade 42 Diameter  90 pk of  100 NO.  Whatman  ', '2980', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('731', '6', '121', '44', '1442110', 'Cat No. 1442 110  Grade 42 Diameter  110 pk of 100 NO.  Whatman', '3750', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('732', '6', '121', '44', '1442125', 'Cat No. 1442 125  Grade 42 Diameter  125 pk of 100 NO.  Whatman ', '4430', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('733', '6', '121', '44', '1442150', 'Cat No. 1442 150  Grade 42 Diameter  150 pk of 100 NO.  Whatman', '5890', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('734', '6', '121', '44', '1442185', 'Cat No. 1442 185  Grade 42 Diameter  185 pk of 100 NO.  Whatman ', '9180', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('735', '6', '121', '44', '1442240', 'Cat No. 1442 240  Grade 42 Diameter  240 100 NO.  Whatman', '14640', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('736', '6', '121', '44', '1442917', 'Cat No. 1442 917  Grade 42 Diameter  460x570 Sheets pk of 100 NO. Whatman ', '54950', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('737', '6', '121', '44', '', 'Grade 44 ', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('738', '6', '121', '44', '1444070', 'Cat No. 1444 070  Grade 44 Diameter 70 pk of 100 NO.  Whatman  ', '2940', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('739', '6', '121', '44', '1444090', 'Cat No. 1444 090  Grade 44 Diameter 90 pk of 100 NO.  Whatman', '3450', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('740', '6', '121', '44', '1444110', 'Cat No. 1444 110  Grade 44 Diameter 110 pk of 100 NO. Whatman', '4090', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('741', '6', '121', '44', '1444125', 'Cat No. 1444 125  Grade 44 Diameter 125 pk of 100 NO.  Whatman ', '4570', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('742', '6', '121', '44', '1444150', 'Cat No. 1444 150  Grade 44 Diameter 150 pk of 100 NO.  Whatman', '7770', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('743', '6', '121', '44', '1444185', 'Cat No. 1444 185  Grade 44 Diameter 185 pk of 100 NO. Whatman ', '11240', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('744', '6', '122', '44', '', 'Grade 50', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('745', '6', '122', '44', '1450070', 'Cat No. 1450 070  Grade 50 Diameter  70 pk of  100 NO.  Whatman', '2940', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('746', '6', '122', '44', '1450090', 'Cat No. 1450 090  Grade 50 Diameter  90 pk of  100 NO.  Whatman ', '3550', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('747', '6', '122', '44', '1450110', 'Cat No. 1450 110  Grade 50 Diameter 110 pk of 100 NO. Whatman  ', '5360', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('748', '6', '122', '44', '1450125', 'Cat No. 1450 125  Grade 50 Diameter 125 pk of  100 NO.  Whatman', '5710', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('749', '6', '122', '44', '1450150', 'Cat No. 1450 150  Grade 50 Diameter 150 pk of  100 NO.  Whatman ', '8290', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('750', '6', '122', '44', '1450185', 'Cat No. 1450 185  Grade 50 Diameter 185 pk of  100 NO. Whatman   ', '12310', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('751', '6', '122', '44', '1450917', 'Cat No. 1450 917  Grade 50 Diameter 460x570 Sheets pk of 100 NO. Whatman ', '66530', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('752', '6', '122', '44', '', 'Grade 52', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('753', '6', '122', '44', '1452090', 'Cat No. 1452 090  Grade 52 Diameter 90 pk of 100 NO.  Whatman', '4720', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('754', '6', '122', '44', '1452110', 'Cat No. 1452 110  Grade 52 Diameter 110 pk of 100 NO.  Whatman', '5900', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('755', '6', '122', '44', '1452125', 'Cat No. 1452 125  Grade 52 Diameter 125 pk of 100 NO.  Whatman', '6740', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('756', '6', '122', '44', '1452150', 'Cat No. 1452 150  Grade 52 Diameter 150 pk of 100 NO.  Whatman  ', '8550', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('757', '6', '122', '44', '', 'Grade 54', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('758', '6', '122', '44', '1454070', 'Cat No. 1454 070  Grade 54 Diameter 70 pk of 100 NO.  Whatman ', '2850', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('759', '6', '122', '44', '1454090', 'Cat No. 1454 090  Grade 54 Diameter 90 pk of  100 NO.   Whatman ', '3830', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('760', '6', '122', '44', '1454110', 'Cat No. 1454 110  Grade 54 Diameter 110 pk of  100 NO.  Whatman ', '4880', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('761', '6', '122', '44', '1454125', 'Cat No. 1454 125  Grade 54 Diameter 125 pk of  100 NO.  Whatman', '6160', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('762', '6', '122', '44', '1454150', 'Cat No. 1454 150  Grade 54 Diameter 150 pk of  100 NO. Whatman ', '8810', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('763', '6', '122', '44', '1454185', 'Cat No. 1454 185  Grade 54 Diameter 185 pk of 100 NO.  Whatman ', '12640', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('764', '6', '122', '44', '', 'Grade 540', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('765', '6', '122', '44', '1540090', 'Cat No. 1540 090  Grade 540 Diameter 90 pk of 100 NO.  Whatman  ', '3830', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('766', '6', '122', '44', '1540110', 'Cat No. 1540 110  Grade 540 Diameter 110 pk of  100 NO.  Whatman   ', '5240', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('767', '6', '122', '44', '1540125', 'Cat No. 1540 125  Grade 540 Diameter 125 pk of  100 NO.  Whatman ', '5830', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('768', '6', '122', '44', '1540150', 'Cat No. 1540 150  Grade 540 Diameter 150 pk of  100 NO. Whatman ', '8550', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('769', '6', '122', '44', '1540185', 'Cat No. 1540 185  Grade 540 Diameter 185 pk of  100 NO.  Whatman   ', '14680', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('770', '6', '122', '44', '', 'Grade 541', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('771', '6', '122', '44', '1541070', 'Cat No. 1541 070  Grade 541 Diameter 70 pk of 100 NO.  Whatman', '2940', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('772', '6', '122', '44', '1541090', 'Cat No. 1541 090  Grade 541 Diameter 90 pk of 100 NO.   Whatman', '3570', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('773', '6', '122', '44', '1541110', 'Cat No. 1541 110  Grade 541 Diameter 110 pk of 100 NO.  Whatman ', '5110', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('774', '6', '122', '44', '1541125', 'Cat No. 1541 125  Grade 541 Diameter 125 pk of 100 NO. Whatman ', '5250', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('775', '6', '122', '44', '1541150', 'Cat No. 1541 150  Grade 541 Diameter 150 pk of 100 NO.  Whatman', '8750', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('776', '6', '122', '44', '1541185', 'Cat No. 1541 185  Grade 541 Diameter 185 pk of 100 NO. Whatman  ', '13920', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('777', '6', '122', '44', '', 'Grade 542', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('778', '6', '122', '44', '1542070', 'Cat No. 1542 070  Grade 542 Diameter 70 pk of 100 NO. Whatman', '2940', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('779', '6', '122', '44', '1542090', 'Cat No. 1542 090  Grade 542 Diameter 90 pk of 100 NO.  Whatman', '4210', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('780', '6', '122', '44', '1542110', 'Cat No. 1542 110  Grade 542 Diameter 110 pk of 100 NO.  Whatman  ', '5750', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('781', '6', '122', '44', '1542125', 'Cat No. 1542 125  Grade 542 Diameter 125 pk of 100 NO.  Whatman ', '6170', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('782', '6', '122', '44', '1542150', 'Cat No. 1542 150  Grade 542 Diameter 150 pk of 100 NO.  Whatman ', '9320', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('783', '6', '122', '44', '1542185', 'Cat No. 1542 185  Grade 542 Diameter 185 pk of 100 NO.  Whatman ', '13920', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('784', '6', '122', '44', '', 'Grade 2V   - Folded Prepleated Grades', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('785', '6', '122', '44', '1202125', 'Cat NO. 1202-125 Grade GR 2 FF Diameter 125mm pk of  100 NO Whatman', '6160', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('786', '6', '122', '44', '', 'EPM 2000', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('787', '6', '122', '44', '1882047', 'Cat No. 1882 047  Grade EPM 2000  Diameter 47 pk of 100 NO.  Whatman  ', '7020', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('788', '6', '122', '44', '1882866', 'Cat No. 1882 866  Grade EPM 2000  Diameter 203 X 254* Sheets pk of 100 NO.  Whatman ', '56060', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('789', '6', '122', '44', '', '934 - AH', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('790', '6', '122', '44', '1827047', 'Cat No.1827 047   Grade 934-AH  Diameter 47 pk of 100 NO.  Whatman', '7490', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('791', '6', '122', '44', '1827055', 'Cat No. 1827 055  Grade 934-AH  Diameter 55 pk of 100 NO.  Whatman ', '8430', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('792', '6', '122', '44', '1827070', 'Cat No. 1827 070  Grade 934-AH  Diameter 70 pk of 100 NO.  Whatman ', '10600', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('793', '6', '122', '44', '1827090', 'Cat No. 1827 090  Grade 934-AH  Diameter 90 pk of 100 NO.  Whatman', '15840', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('794', '6', '122', '44', '1827110', 'Cat No. 1827 110  Grade 934-AH  Diameter 110 pk of 100 NO. Whatman  ', '19660', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('795', '6', '123', '44', '', 'CELLULOSE EXTRACTION THIMBLES SINGLE', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('796', '6', '123', '44', '2800199', 'Cat No. 2800199 CELLULOSE EXTRACTION THIMBLES Diameter  19X90 pk of  25 NO.  Whatman  ', '11270', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('797', '6', '123', '44', '2800228', 'Cat No. 2800228 CELLULOSE EXTRACTION THIMBLES  Diameter 22X80  pk of  25 NO.  Whatman ', '11460', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('798', '6', '123', '44', '2800258', 'Cat No. 2800258 CELLULOSE EXTRACTION THIMBLES  Diameter 25X80  pk of  25 NO.  Whatman', '11320', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('799', '6', '123', '44', '2800250', 'Cat No. 2800250 CELLULOSE EXTRACTION THIMBLES  Diameter 25X100 pk of  25 NO.  Whatman ', '11320', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('800', '6', '123', '44', '2800288', 'Cat No. 2800288 CELLULOSE EXTRACTION THIMBLES  Diameter 28X80 pk of 25 NO. Whatman', '11270', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('801', '6', '123', '44', '2800308', 'Cat No. 2800308 CELLULOSE EXTRACTION THIMBLES  Diameter 30X80 pk of 25 NO. Whatman', '11270', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('802', '6', '123', '44', '2800330', 'Cat No. 2800330 CELLULOSE EXTRACTION THIMBLES  Diameter 33X100 pk of 25 NO.  Whatman  ', '13470', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('803', '6', '123', '44', '2800432', 'Cat No. 2800432 CELLULOSE EXTRACTION THIMBLES  Diameter 43X123 pk of 25 NO.  Whatman  ', '16770', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('804', '6', '123', '44', '2800280', 'Cat No. 2800280 CELLULOSE EXTRACTION THIMBLES   Diameter 28X100 pk of 25 NO.   Whatman ', '11380', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('805', '6', '123', '44', '2800300', 'Cat No. 2800300 CELLULOSE EXTRACTION THIMBLES   Diameter 30X100 pk of 25 NO.   Whatman ', '11340', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('806', '6', '123', '44', '', 'ASHLESS CLIPPINGS', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('807', '6', '123', '44', '1703050', 'Cat No.1703 050  ASHLESS CLIPPINGS   500g', '6770', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('808', '6', '123', '8', '', 'PARAFILM \'M\' USA MAKE SPECIAL PRICE', '', '0', '1', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('809', '6', '123', '8', '', 'PARAFILM    4\" X 125 feet', '2000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('810', '6', '123', '8', '', 'PARAFILM    2\" X 250 feet ', '2125', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('811', '6', '123', '0', '', 'NO RETURN / REPLACEMENT for Whatman', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('812', '6', '123', '0', '', 'Kindly Order with Correct order codes.', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('813', '6', '124', '44', '', 'GF / A', '', '1', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('814', '6', '124', '44', '1820021', 'Cat No. 1820 021  Grade GF/A  Diameter 21 pk of 100 NO.  Whatman  ', '2680', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('815', '6', '124', '44', '1820024', 'Cat No. 1820 024  Grade GF/A  Diameter 24 pk of 100 NO. Whatman   ', '2940', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('816', '6', '124', '44', '1820025', 'Cat No. 1820 025  Grade GF/A  Diameter 25 pk of 100 NO.  Whatman  ', '2900', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('817', '6', '124', '44', '1820037', 'Cat No. 1820 037  Grade GF/A  Diameter  37 pk of 100 NO.  Whatman  ', '3970', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('818', '6', '124', '44', '1820042', 'Cat No. 1820 042  Grade GF/A  Diameter 42.5 pk of  100 NO. Whatman', '4210', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('819', '6', '124', '44', '1820047', 'Cat No. 1820 047  Grade GF/A  Diameter 47 pk of 100 NO.  Whatman', '4300', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('820', '6', '124', '44', '1820055', 'Cat No. 1820 055  Grade GF/A  Diameter 55 pk of 100 NO.  Whatman ', '5750', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('821', '6', '124', '44', '1820070', 'Cat No. 1820 070  Grade GF/A  Diameter 70 pk of 100 NO.  Whatman', '6260', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('822', '6', '124', '44', '1820090', 'Cat No. 1820 090  Grade GF/A  Diameter 90 pk of 100 NO.  Whatman ', '8050', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('823', '6', '124', '44', '1820110', 'Cat No. 1820 110  Grade GF/A  Diameter 110 pk of 100 NO.  Whatman  ', '9570', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('824', '6', '124', '44', '1820125', 'Cat No. 1820 125  Grade GF/A  Diameter 125 pk of 100 NO.  Whatman   ', '13440', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('825', '6', '124', '44', '1820150', 'Cat No. 1820 150  Grade GF/A  Diameter 150 pk of 100 NO.  Whatman', '18010', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('826', '6', '124', '44', '1820866', 'Cat No. 1820 866  Grade GF/A  Diameter 203 x 254* Sheets 100 NO. pk  Size In MM  Whatman  ', '29050', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('827', '6', '124', '44', '', 'GF / B', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('828', '6', '124', '44', '1821025', 'Cat No. 1821 025  Grade GF/B  Diameter 25 pk of 100 NO.  Whatman ', '3720', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('829', '6', '124', '44', '1821042', 'Cat No. 1821 042  Grade GF/B  Diameter 42.5 pk of 100 NO. Whatman ', '9070', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('830', '6', '124', '44', '1821047', 'Cat No. 1821 047  Grade GF/B  Diameter 47 pk of  100 NO.  Whatman ', '6770', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('831', '6', '124', '44', '1821055', 'Cat No. 1821 055  Grade GF/B  Diameter 55 pk of 100 NO.   Whatman ', '10340', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('832', '6', '124', '44', '1821070', 'Cat No. 1821 070  Grade GF/B  Diameter 70 pk of 100 NO.   Whatman', '12130', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('833', '6', '124', '44', '1821090', 'Cat No. 1821 090  Grade GF/B  Diameter 90 pk of  100 NO.  Whatman ', '5830', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('834', '6', '124', '44', '1821110', 'Cat No. 1821 110  Grade GF/B  Diameter 110 pk of 100 NO. Whatman', '7260', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('835', '6', '124', '44', '1821125', 'Cat No. 1821 125  Grade GF/B  Diameter 125 pk of 100 NO. Whatman', '9580', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('836', '6', '124', '44', '1821150', 'Cat No. 1821 150  Grade GF/B  Diameter 150 pk of 100 NO. Whatman', '12310', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('837', '6', '124', '44', '', 'GF / C', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('838', '6', '124', '44', '1822025', 'Cat No. 1822 025  Grade GF/C  Diameter 25 pk of  100 NO.  Whatman', '2900', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('839', '6', '124', '44', '1822037', 'Cat No. 1822 037  Grade GF/C  Diameter 37 pk of  100 NO.  Whatman ', '4310', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('840', '6', '124', '44', '1822042', 'Cat No. 1822 042  Grade GF/C  Diameter 42.5 pk of 100 NO.  Whatman ', '4530', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('841', '6', '124', '44', '1822047', 'Cat No. 1822 047  Grade GF/C  Diameter 47 pk of  100 NO.  Whatman ', '4340', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('842', '6', '124', '44', '1822055', 'Cat No. 1822 055  Grade GF/C  Diameter 55 pk of 100 NO. Whatman ', '6720', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('843', '6', '124', '44', '1822070', 'Cat No. 1822 070  Grade GF/C  Diameter 70 pk of 100 NO.  Whatman ', '9030', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('844', '6', '124', '44', '1822090', 'Cat No. 1822 090  Grade GF/C  Diameter 90 pk of 100 NO.  Whatman ', '9490', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('845', '6', '124', '44', '1822110', 'Cat No. 1822 110  Grade GF/C  Diameter 110 pk of 100 NO.  Whatman ', '12470', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('846', '6', '124', '44', '1822125', 'Cat No. 1822 125  Grade GF/C  Diameter 125 pk of 100 NO.  Whatman', '15270', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('847', '6', '124', '44', '1822150', 'Cat No. 1822 150  Grade GF/C  Diameter 150 pk of  100 NO. Whatman  ', '21030', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('848', '6', '124', '44', '', 'GF / D', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('849', '6', '124', '44', '1823025', 'Cat No. 1823-025 Grade GF/D  Diameter 25 pk of  100 NO  Whatman', '3720', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('850', '6', '124', '44', '1823047', 'Cat No. 1823-047 Grade GF/D  Diameter 47 pk of  100 NO  Whatman', '7350', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('851', '6', '124', '44', '', 'PM 2.5 Air Monitoring Membrane 7592-104 PKT OF 50', '18100', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('852', '6', '124', '44', '', 'GLASS MICROFIBRE THIMBLES', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('853', '6', '124', '44', '2814199', 'Cat No. 2814199    Diameter 19X90 pk of  25 NO.  Whatman ', '20320', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('854', '6', '125', '44', '', 'Pure Cellulose Sheets & Reels', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('855', '6', '125', '44', '', '1 Chr (0.18mm) thickness', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('856', '6', '125', '44', '3001845', 'Cat No. 3001845 Size(mm) 100X300  Micro granular  100 Sheets   Whatman ', '6210', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('857', '6', '125', '44', '3001861', 'Cat No. 3001861 Size(mm) 200X200  Micro granular  100 Sheets   Whatman', '7660', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('858', '6', '125', '44', '3001878', 'Cat No. 3001878 Size(mm) 250x250  Micro granular  100 Sheets   Whatman ', '12000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('859', '6', '125', '44', '3001917', 'Cat No. 3001917 Size(mm) 460x570  Micro granular  100 Sheets   Whatman ', '26250', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('860', '6', '125', '44', '3001931', 'Cat No. 3001931 Size(mm) 580x680  Micro granular  100 Sheets   Whatman', '40300', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('861', '6', '125', '44', '3001604', 'Cat No. 3001604 Size(mm) 10X100m  Micro granular  Reels   Whatman ', '2870', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('862', '6', '125', '44', '3001640', 'Cat No. 3001640 Size(mm) 30X100m  Micro granular  Reels   Whatman', '5110', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('863', '6', '125', '44', '', '2 Chr (0.18 mm Thickness)', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('864', '6', '125', '44', '3002917', 'Cat No. 3002917  Size(mm) 460x570    Micro granular  100 Sheets   Whatman', '37670', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('865', '6', '125', '44', '', '3 Chr (0.34 mm Thickness)', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('866', '6', '125', '44', '3003917', 'Cat No. 3003917  Size(mm) 460x570    Micro granular  100 Sheets   Whatman ', '63630', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('867', '6', '126', '44', '7402001', ' Cat No 7402001  NYLON MEMBRANE  13mm 0.2um pk 100   Whatman ', '10640', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('868', '6', '126', '44', '7402002', 'Cat No 7402002   NYLON MEMBRANE  25 mm 0.2um pk 100  Whatman ', '10670', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('869', '6', '126', '44', '7402004', 'Cat No 7402004   NYLON MEMBRANE   47 mm 0.2um pk 100  Whatman ', '8080', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('870', '6', '126', '44', '7404001', 'Cat No 7404001   NYLON MEMBRANE 13 mm 0.45um pk 100  Whatman  ', '10640', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('871', '6', '126', '44', '7404002', 'Cat No 7404002   NYLON MEMBRANE  25 mm 0.45um pk 100  Whatman', '12020', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('872', '6', '126', '44', '7404004', 'Cat No 7404004   NYLON MEMBRANE 47 mm 0.45um pk 100  Whatman', '10270', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('873', '6', '127', '44', '7182001', 'Cat No 7182001  CELLULOSE NITRATE MEMBRANE 13mm 0.2um pk 100    Whatman', '11390', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('874', '6', '127', '44', '7182002', 'Cat No 7182002  CELLULOSE NITRATE MEMBRANE  25 mm 0.2um pk 100   Whatman', '6750', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('875', '6', '127', '44', '7182004', 'Cat No 7182004  CELLULOSE NITRATE MEMBRANE 47 mm 0.2um pk 100   Whatman ', '4880', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('876', '6', '127', '44', '7184001', 'Cat No 7184001  CELLULOSE NITRATE MEMBRANE 13 mm 0.45um pk 100  Whatman', '9520', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('877', '6', '127', '44', '7184002', 'Cat No 7184002  CELLULOSE NITRATE MEMBRANE 25 mm 0.45um pk 100  Whatman', '9520', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('878', '6', '127', '44', '7184004', 'Cat No 7184004  CELLULOSE NITRATE MEMBRANE 47 mm 0.45um pk 100   Whatman ', '4730', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('879', '6', '128', '44', '1825047', 'Cat No 1825-047  GF/F Glass Circles, 47mm  100/pk  Whatman', '12920', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('880', '6', '128', '44', '1825025', 'Cat No1825-025   GF/F Glass Circles, 25mm  100/pk  Whatman ', '6340', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('881', '6', '128', '44', '1851025', 'Cat No 1851-025  QM-A Quartz Circles, 25mm  100/pk   Whatman', '16330', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('882', '6', '128', '44', '1851037', 'Cat No 1851-037  QM-A Circles, 37mm  100/pk   Whatman', '20600', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('883', '6', '128', '44', '1851047', 'Cat No 1851-047  QM-A Circles, 47mm  100/pk  Whatman', '21960', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('884', '6', '128', '44', '7592104', 'Cat No 7592-104   PM2.5 Membrane, PTFE 46.2mm with support ring, sequentially numbered  50/pk  Whatman', '18100', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('885', '6', '128', '44', '2017006', 'Cat No 2017-006   Antibiotic Assay Discs, 6mm  1000/pk  Whatman', '10060', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('886', '6', '128', '44', '2105841', 'Cat No 2105-841   105 Sheets, Lens Cleaning Tissue, 100 x 150mm, 25 wallets of 25 sheets  25/pk  Whatman', '7390', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('887', '6', '128', '44', '2105862', 'Cat No 2105-862   105 Sheets, Lens Cleaning Tissue, 200 x 300mm  100/pk   Whatman ', '2480', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('888', '6', '128', '44', '2300772', 'Cat No 2300-772    Benchkote Surface Protector, Reel, 920mm x 50 metres  1/pk  Whatman ', '36110', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('889', '6', '128', '44', '2300916', 'Cat No 2300-916    Benchkote Surface Protector, Sheets, 460 x 570mm  50/pk   Whatman', '5710', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('890', '6', '128', '44', '23016150', 'Cat No 2301-6150  Benchkote Plus Surface Protector, Sheets, 500 x 600mm  50/pk Whatman ', '10580', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('891', '6', '128', '44', '23016160', 'Cat No 2301-6160  Benchkote Plus Surface Protector, Reel, 600mm x 50 metres  1/pk Whatman', '17280', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('892', '6', '128', '44', '2814199', 'Cat No 2814-199    Glass Thimbles, HPGF, 19 x 90mm  25/pk  Whatman', '20320', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('893', '6', '128', '44', '10370394', 'Cat No 10370394   GF10 , 50mm x 100m Core25mm 1/pk   Whatman  ', '155490', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('894', '6', '129', '44', '10534612', 'Cat No 10534612 903 PROTEINSAVER US 100/PK  Whatman', '16910', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('895', '6', '129', '44', '10535097', 'Cat No 10535097 903 Sheets 210 x 297mm 100/pk  Whatman', '36130', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('896', '6', '129', '44', '10538017', 'Cat No 10538017  903 Sheets 46 x 57cm 100/pk    Whatman ', '77700', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('897', '6', '129', '44', '10538018', 'Cat No 10538018  903 Sheets 58 x 58cm 100/pk  Whatman', '64640', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('898', '6', '130', '44', '10406871', 'Cat No 10406871    ME25/21 ST Membrane Circles white, Mixed esters,0.45&#956;m, 3.1 black grid, sterile, 47mm  1000/pk   Whatman', '39530', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('899', '6', '130', '44', '13406870', 'Cat No 13406870     ME25/21 ST V Membrane Circles white, Mixed esters, 0.45&#956;m, 3.1 black grid, sterile, 47mm  100/pk   Whatman', '2770', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('900', '6', '131', '44', '99091302', 'Cat No 9909-1302   UNIFLO 13/0.2 PVDF 500/PK  Whatman', '13370', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('901', '6', '131', '44', '99091304', 'Cat No 9909-1304   UNIFLO 13/0.45 PVDF 500/PK  Whatman', '13370', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('902', '6', '131', '44', '99092502', 'Cat No 9909-2502   UNIFLO 25/0.2 PVDF 500/PK    Whatman', '21980', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('903', '6', '131', '44', '99092504', 'Cat No 9909-2504   UNIFLO 25/0.45 PVDF 500/PK   Whatman', '20410', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('904', '6', '131', '44', '99101302', 'Cat No 9910-1302   UNIFLO 13/0.2 NYL  500/PK  Whatman', '13230', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('905', '6', '131', '44', '99101304', 'Cat No 9910-1304   UNIFLO 13/0.45 NYL 500/PK   Whatman', '13580', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('906', '6', '131', '44', '99102502', 'Cat No 9910-2502   UNIFLO 25/0.2 NYL 500/PK  Whatman ', '15700', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('907', '6', '131', '44', '99102504', 'Cat No 9910-2504   UNIFLO 25/0.45 NYL  500/PK  Whatman', '15700', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('908', '6', '131', '44', '99111302', 'Cat No 9911-1302   UNIFLO 13/0.2 PTFE  500/PK  Whatman', '15690', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('909', '6', '131', '44', '99111304', 'Cat No 9911-1304   UNIFLO 13/0.45 PTFE 500/PK  Whatman ', '15690', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('910', '6', '131', '44', '99112502', 'Cat No 9911-2502   UNIFLO 25/0.2 PTFE 500/PK  Whatman', '21330', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('911', '6', '131', '44', '99112504', 'Cat No 9911-2504   UNIFLO 25/0.45 PTFE 500/PK Whatman', '22400', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('912', '6', '131', '44', '99121302', 'Cat No 9912-1302   UNIFLO 13/0.2 PES   500/PK Whatman', '19370', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('913', '6', '131', '44', '99121304', 'Cat No 9912-1304   UNIFLO 13/0.45 PES 500/PK Whatman ', '19370', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('914', '6', '131', '44', '99122502', 'Cat No 9912-2502   UNIFLO 25/0.2 PES  500/PK Whatman ', '19370', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('915', '6', '131', '44', '99122504', 'Cat No 9912-2504   UNIFLO 25/0.45 PES  500/PK  Whatman', '19370', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('916', '6', '132', '44', '99132502', 'Cat No 9913 2502 UNIFLO 25 mm 0.22 PVDF Strtile Pak of 45 Whatman', '3160', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('917', '6', '132', '44', '99132504', 'Cat No 9913 2504 UNIFLO 25 mm 0.45 PVDF Strtile Pak of 45 Whatman', '3160', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('918', '6', '132', '44', '99142502', 'Cat No 9914 2502 UNIFLO 25 mm 0.22 PES Strtile Pak of 45 Whatman', '3160', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('919', '6', '132', '44', '99142504', 'Cat No 9914 2504 UNIFLO 25 mm 0.45 PES Strtile Pak of 45 Whatman', '3160', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('920', '6', '132', '44', '99152502', 'Cat No 9915 2502 UNIFLO 25 mm 0.22 PES Strtile Pak of 200 Whatman', '14120', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('921', '6', '132', '44', '99152504', 'Cat No 9915 2504 UNIFLO 25 mm 0.45 PES Strtile Pak of 200 Whatman', '14120', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('922', '6', '132', '44', '99161302', 'Cat No 9916 2502 UNIFLO 13 mm 0.22 PES Strtile Pak of 100  Whatman', '7000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('923', '6', '132', '44', '99161304', 'Cat No 9916 2504 UNIFLO 13 mm 0.45 PES Strtile Pak of 100  Whatman', '7000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('924', '6', '133', '10', 'GLFH47', 'Stainless steel Funnel Type 47MM / 300ml capacity without Filter flask                                     ', '3000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('925', '6', '133', '10', 'GLFH47GL45', 'Glass With Filter Flask & Clamp 47MM GL-45 with cap & adaptor 300ml, alluminium cap GLOLAB', '3500', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('926', '6', '133', '10', 'GLFH47B40', 'Glass With Filter Flask & Clamp 47MM with B40 joint and filter flask GLOLAB', '3500', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('927', '6', '133', '10', 'GLFH47PLASTIC', '<p>Spare Glass filter holder 47MM with Plastic adaptor GLOLAB</p>', '2250', '0', '0', '1', '16-07-2022', '', '', '', '', NULL, '2022-07-16 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('928', '6', '134', '10', 'GLSDIKIT', 'Filter Holder All Glass 47 mm ,Vacuum Pump Oil Free TID 15(1/20hp) ,Whatman  Cat.no. 13406870, 47mm dia 0.45um, 5 meter silicon tube 8/11', '12020', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('929', '6', '135', '8', '', 'FOGTECH NEO ABS housing and HDPE Tank,Tank Capacity 8 Ltrs Mechanical Timer 1-60 Minutes', '22000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('930', '6', '135', '8', '', 'FOGTECH NEO MAXX ABS housing and SS 304 Grade Tank,Tank Cap 6 Ltrs Mechanical Timer 1-60 Minutes', '25380', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('931', '6', '135', '8', '', 'FOGTECH PRO Complete SS 304 Grade Tank,Capacity 6 Ltrs Mechanical Timer 1-60 Minutes', '26250', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('932', '6', '135', '8', '', 'FOGTECH ADVANCE Complete Stainless Steel 304 Grade Tank,Tank Capacity 6 Ltrs Digital Timer 1-99 Minutes with Delay Timer for Operator Safety', '29000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('933', '6', '136', '4', 'DOM24', '<p>Model DOM-24 used to periodically check and monitor the quality of oil, Total Polar Materials(TPM): 0.5 to 40.0% Acid Value(AV): 0.00 to 9.99,Temp.: +0 to +225&deg;C (In continuous mode +0 to +180&deg;C)</p>', '43500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('934', '7', '137', '0', '', 'KNOBBLED COVER,PORCELINE PLATE China', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('935', '7', '137', '8', '', 'Desiccator China Make Glass Plain   100mm', '800', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('936', '7', '137', '8', '', 'Desiccator China Make Glass Plain   120mm', '900', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('937', '7', '137', '8', '', 'Desiccator China Make Glass Plain   150mm', '1035', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('938', '7', '137', '8', '', 'Desiccator China Make Glass Plain   180mm', '1700', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('939', '7', '137', '8', '', 'Desiccator China Make Glass Plain   210mm', '2500', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('940', '7', '137', '8', '', 'Desiccator China Make Glass Plain   240mm', '3250', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('941', '7', '137', '8', '', 'Desiccator China Make Glass Plain   300mm', '4275', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('942', '7', '137', '8', '', 'Desiccator China Make Glass Plain   400mm', '9000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('943', '7', '137', '8', '', 'Vaccum Desiccator Glass Amber colour 150mm', '3500', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('944', '7', '137', '8', '', 'Vaccum Desiccator Glass Amber colour 210mm', '5750', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('945', '7', '138', '8', '', 'Vaccum Desiccator Glass 120mm', '1350', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('946', '7', '138', '8', '', 'Vaccum Desiccator Glass 150mm', '1800', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('947', '7', '138', '8', '', 'Vaccum Desiccator Glass 210mm', '2500', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('948', '7', '138', '8', '', 'Vaccum Desiccator Glass 240mm', '4500', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('949', '7', '138', '8', '', 'Vaccum Desiccator Glass 300mm', '6750', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('950', '7', '139', '8', '', 'Glass Beads (Per Bottle 500 gms)    1mm', '350', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('951', '7', '139', '8', '', 'Glass Beads (Per Bottle 500 gms)    2mm', '300', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('952', '7', '139', '8', '', 'Glass Beads (Per Bottle 500 gms)    3mm', '300', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('953', '7', '139', '8', '', 'Glass Beads (Per Bottle 500 gms)    4mm', '300', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('954', '7', '139', '8', '', 'Glass Beads (Per Bottle 500 gms)    5mm', '250', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('955', '7', '139', '8', '', 'Glass Beads (Per Bottle 500 gms)    6mm', '225', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('956', '7', '139', '8', '', 'Glass Beads (Per Bottle 500 gms)    8mm', '350', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('957', '7', '140', '8', '', 'Gerber Centrifuge electrical for Milk Butymeter mini for 8 tests ', '8250', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('958', '7', '140', '8', '', 'Gerber Centrifuge electrical for Milk Butymeter mini for 12 tests   ', '9000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('959', '7', '140', '8', '', 'Gerber Centrifuge electrical for Milk Butymeter mini for 24 tests   ', '11500', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('960', '7', '140', '33', '', 'R-86 for R-8k Centrifuge  REMI with R86 Head                                                 SEE \"C\" Centrifuge REMI', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('961', '7', '141', '42', 'TESTO3173', 'Testo 317-3 CO Monitor 3 years warranty on CO sensor, Adjustable alarm threshold, CO zeroing at site, No initialization phase, instrument ready to operate immediately', 'POR', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('962', '7', '141', '42', 'TESTO3162', 'Testo 316-2 Gas Leak Detector Detects CH4,C3H8,H2, Optical and audible alarm, Trend display shows maximum leakage, Integrated pump, flexible measurement probe in accessible places', 'POR', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('963', '8', '142', '15', 'GVOVEN12 ', 'GV-OVEN-12 Chamber size 300x300x300mm 12&#8221;x12&#8221;x12&#8221;, capacity 28 Ltr, 750 Rating  Shelves Analog Regulator Temp.', '11500', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('964', '8', '142', '15', 'GVOVEN12DIGI', 'GV-OVEN-12 DIGI 12&#8221;x12&#8221;x12&#8221; with Digital Temperature Controller', '17500', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('965', '8', '142', '15', 'GVOVEN12DIGIFAN', 'GV-OVEN-12 DIGI & FAN 12&#8221;x12&#8221;x12&#8221; with Digital Temperature Controller and Fan for Circulating air', '22000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('966', '8', '142', '15', 'GVOVEN14 ', 'GV-OVEN-14 Chamber Size 355x355x355mm 14&#8221;x14&#8221;x14&#8221;, capacity  45 Ltr, 1000 Rating 2 Shelves Analog Regulator Temp.', '16500', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('967', '8', '142', '15', 'GVOVEN14DIGI ', 'GV-OVEN-14 DIGI 14&#8221;x14&#8221;x14&#8221; with Digital Temperature Controller', '22000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('968', '8', '142', '15', 'GVOVEN14DIGIFAN', 'GV-OVEN-14 DIGI  & FAN 14&#8221;x14&#8221;x14&#8221; with Digital Temperature Controller and Fan for Circulating air', '27500', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('969', '8', '142', '15', 'GVOVEN18', 'GV-OVEN-18 Chamber size 455x455x455mm 18&#8221;x18&#8221;x18&#8221; capacity  95 Ltr, 1500 Rating, 2 Shelves, Analog Regulator Temp.', '21000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('970', '8', '142', '15', 'GVOVEN18DIGI', 'GV-OVEN-18 DIGI 18&#8221;x18&#8221;x18 with Digital Temperature Controller', '26500', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('971', '8', '142', '15', 'GVOVEN18DIGI&FAN', 'GV-INC-18 DIGI & FAN 18\'x18&#8221;x18&#8221; with Digital Temperature Controller and Fan for Circulating air', '32000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('972', '8', '142', '15', 'GVOVEN24', 'GV-OVEN- 24 Inner Chamber 605x605x605mm 24&#8221;x24&#8221;x24&#8221; capacity  224 Ltr, 2200 Rating, 3 Shelves Analog Regulator Temp.', '33000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('973', '8', '142', '15', 'GVOVEN24DIGI', 'GV-OVEN-24 DIGI 24&#8221;x24&#8221;x24&#8221; with Digital Temperature Controller', '38500', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('974', '8', '142', '15', 'GVOVEN24DIGIFAN', 'GV-OVEN-24 DIGI & FAN 24&#8221;x24&#8221;x24&#8221; with Digital Temperature Controller and Fan for Circulating air', '44000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('975', '8', '143', '33', 'RDHO50', '<p>RDHO-50 DryHot Air Oven (50 liters) with temperature setting from RT + 10&deg;C up to +300&deg;C</p>', '67400', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('976', '8', '143', '33', 'RDHO80', '<p>RDHO-80 DryHot Air Oven (80 Liters) with temperature setting from RT + 10&deg;C up to +300&deg;C</p>', '78100', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('977', '8', '144', '15', 'GVHP8MS', 'GV-HP-8 MS Hot Plate8&#8221; Dia (1000W) M.S. (Energy Regulator)  ', '2750', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('978', '8', '144', '15', 'GVHP9MS', 'GV-HP-9 MS Hot Plate9&#8221; Dia (1000W) M.S. (Energy Regulator)    ', '3300', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('979', '8', '144', '15', 'GVHP12MS', 'GV-HP-12 MS Hot Plate12&#8221; Dia (1500W) M.S. (Energy Regulator)   ', '4100', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('980', '8', '144', '15', 'GVHP1012MS ', 'GV-HP(10x12) MS Hot Plate10x12 (1000W) M.S. (Energy Regulator)   ', '4750', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('981', '8', '144', '15', 'GVHP1016MS', 'GV-HP(10x16) MS Hot Plate10x16 (1500W) M.S. (Energy Regulator)  ', '4750', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('982', '8', '144', '15', 'GVHP1218MS', 'GV-HP(12x18) MS Hot Plate12x18 (2000W) M.S. (Energy Regulator)', '6500', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('983', '8', '144', '15', 'GVHP1824MS', 'GV-HP(18x24) MS Hot Plate18x24 (4000W) M.S. (Energy Regulator) ', '12000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('984', '8', '144', '15', 'GVHP8MSDIGI', 'GV-HP-8 MS DIGI Hot Plate 8\" Digital Controller MS BODY', '8700', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('985', '8', '144', '15', 'GVHP1218MSDIGI', 'GV-HP(12x18) MS DIGI Hot Plate12X18\" Digital Controller  M.S Digital', '12500', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('986', '8', '144', '15', 'GVHP7MS', 'GV-HP-7 MS Hot Plate7\" [ ORDINARY] M.S Body Commercial', '1500', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('987', '8', '144', '15', 'GVHP8SS ', 'GV-HP-8 SS Hot Plate 8&#8221; Dia (1000W) S.S. (Energy Regulator)  ', '4200', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('988', '8', '144', '15', 'GVHP9SS ', 'GV-HP-9 SS Hot Plate9&#8221; Dia (1000W) S.S. (Energy Regulator)    ', '5500', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('989', '8', '144', '15', 'GVHP12SS', 'GV-HP-12 SS Hot Plate12&#8221; Dia (1500W) S.S. (Energy Regulator)   ', '6750', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('990', '8', '144', '15', 'GVHP1012SS', 'GV-HP(10x12) SS Hot Plate10x12 (1000W) S.S. (Energy Regulator)   ', '6750', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('991', '8', '144', '15', 'GVHP1016SS ', 'GV-HP(10x16) SS Hot Plate10x16 (1500W) S.S. (Energy Regulator)  ', '7200', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('992', '8', '144', '15', 'GVHP1218SS', 'GV-HP(12x18) SS Hot Plate12x18 (2000W) S.S. (Energy Regulator)', '8000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('993', '8', '144', '15', 'GVHP1224SS', 'GV-HP(12x24) SS Hot Plate12x24 (4000W) S.S. (Energy Regulator) ', '17000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('994', '8', '144', '15', 'GVHP8SSDIGI', 'GV-HP-8 SS DIGI Hot Plate 8\" Digital Controller SS body', '10000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('995', '8', '144', '15', 'GVHP1012SSDIGI', 'GV-HP(10x12) SS DIGI Hot Plate 10x12 Digital Controller SS Body', '12750', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('996', '8', '144', '15', 'GVHP1218SSDIGI', 'GV-HP(12x18) SS DIGI Hot Plate12x18\"  SS Top Digital Controller', '16250', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('997', '8', '145', '15', 'GVHM50', 'GV-HM-50 Heating Mantels Capacity 50ml', '1700', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('998', '8', '145', '15', 'GVHM100', 'GV-HM-100 Heating Mantels Capacity 100ml', '1800', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('999', '8', '145', '15', 'GVHM250', 'GV-HM-250 Heating Mantels Capacity 250ml', '1900', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1000', '8', '145', '15', 'GVHM500', 'GV-HM-500 Heating Mantels Capacity 500ml', '2000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1001', '8', '145', '15', 'GVHM1000', 'GV-HM-1000 Heating Mantels Capacity 1000ml', '2200', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1002', '8', '145', '15', 'GVHM2000', 'GV-HM-2000 Heating Mantels Capacity 2000ml', '2500', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1003', '8', '145', '15', 'GVHM3000', 'GV-HM-3000 Heating Mantels Capacity 3000ml', '3400', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1004', '8', '145', '15', 'GVHM5000', 'GV-HM-5000 Heating Mantels Capacity 5000ml', '3800', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1005', '8', '145', '15', 'GVHM10000', 'GV-HM-10000 Heating Mantels Capacity 10000ml', '4800', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1006', '8', '145', '15', 'GVHM20000', 'GV-HM-20000 Heating Mantels Capacity 20000ml', '6800', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1007', '8', '145', '15', 'GVSM50', 'Spare Mantel 50ml', '550', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1008', '8', '145', '15', 'GVSM100', 'Spare Mantel 100ml', '600', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1009', '8', '145', '15', 'GVSM250', 'Spare Mantel 250ml', '700', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1010', '8', '145', '15', 'GVSM500', 'Spare Mantel 500ml', '825', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1011', '8', '145', '15', 'GVSM1000', 'Spare Mantel 1000ml', '950', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1012', '8', '145', '15', 'GVSM2000', 'Spare Mantel 2000ml ', '1100', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1013', '8', '145', '15', 'GVSM3000', 'Spare Mantel 3000ml', '1325', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1014', '8', '145', '15', 'GVSM5000', 'Spare Mantel 5000ml', '1960', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1015', '8', '145', '15', 'GVSM10000', 'Spare Mantel 10000ml', '3030', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1016', '8', '145', '15', 'GVSM20000', 'Spare Mantel 20000ml', '3700', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1017', '8', '146', '8', '', 'Heating Mantle 250ml Economy', '1100', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1018', '8', '146', '8', '', 'Heating Mantle 500ml Economy', '1200', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1019', '8', '146', '8', '', 'Heating Mantle 1000ml Economy', '1300', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1020', '8', '147', '46', 'GHCAUSTIC1', '<p>CAUSTIC % in 30-35, 35-40, 40-45, 45-50 % any type</p>', '525', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1021', '8', '147', '46', 'GHCAUSTIC2', '<p>CAUSTIC percentage meter 30-50%</p>', '245', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1022', '8', '147', '46', 'GHSULPHURIC', '<p>SULPHURIC 60-80%, 80-98%, 65-75%</p>', '245', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1023', '8', '147', '46', 'GHHYDROCLORIC', '<p>HYDROCLORIC % Meter 25-35%</p>', '245', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1024', '8', '147', '46', 'GHNITRIC', '<p>NITRIC % 50-75%, 75-100%</p>', '245', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1025', '8', '147', '46', 'GHACETIC', '<p>ACETIC ACID % 90-100%</p>', '245', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1026', '8', '147', '46', 'GHLIQUORAMONIA', '<p>LIQUOR AMMONIA % 0-10, 10-26%</p>', '245', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1027', '8', '147', '46', 'GHHYDROGENPEROXIDE', '<p>HYDROGEN PEROXIDE % 30-50%</p>', '350', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1028', '8', '147', '46', 'GHSALINOMETER', '<p>SALINOMETER (BRINOMETER)</p>', '450', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1029', '8', '147', '46', 'GHCARTIER', '<p>CARTIER 10-44</p>', '225', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1030', '8', '147', '46', 'GHLATEXOMETER', '<p>LATEXOMETER</p>', '325', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1031', '8', '148', '46', '', '<p>SPECIFIC GRAVITY,BAUME,BRIX,SOIL,SALINO,ALCOHOL,SIKES,TWADDEL INDIAN</p>', '', '1', '1', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1032', '8', '148', '46', 'GHSP1', '<p>Hydrometer Range SP,Gravity 1.000-2.000 (0-70) (For Heavy Liquid)</p>', '110', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1033', '8', '148', '46', 'GHSP2', '<p>Hydrometer Range SP,Gravity 0.700 - 1.000 (10-70) (For Heavy Light Liquid)</p>', '130', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1034', '8', '148', '46', 'GHSP3', '<p>Hydrometer Range SP,Gravity 1.000 - 1.500 (0-70) (For Heavy Liquid bulb type)</p>', '190', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1035', '8', '148', '46', 'GHSP4', '<p>Hydrometer Range SP,Gravity 1.500 - 2.000 &amp; BE</p>', '130', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1036', '8', '148', '46', 'GHSP5', '<p>Hydrometer Range SP,Gravity 1.000 - 1.300 &amp; BE</p>', '150', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1037', '8', '148', '46', 'GHSP6', '<p>Hydrometer 0.002 Range SP,Gravity 0.600 - 0.800</p>', '175', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1038', '8', '148', '46', 'GHSP7', '<p>Hydrometer 0.002 Range SP,Gravity 0.800 - 1.000</p>', '130', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1039', '8', '148', '46', 'GHSP8', '<p>Hydrometer 0.002 Range SP,Gravity 1.000 - 1.200</p>', '130', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1040', '8', '148', '46', 'GHSP9', '<p>Hydrometer 0.002 Range SP,Gravity 1.200 - 1.400</p>', '130', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1041', '8', '148', '46', 'GHSP10', '<p>Hydrometer 0.002 Range SP,Gravity 1.400 - 1.600</p>', '130', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1042', '8', '148', '46', 'GHSP11', '<p>Hydrometer 0.002 Range SP,Gravity 1.600 - 1.800</p>', '225', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1043', '8', '148', '46', 'GHSP12', '<p>Hydrometer 0.002 Range SP,Gravity 1.800 - 2.000</p>', '225', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1044', '8', '148', '46', 'GHSP13', '<p>Hydrometer 0.001 Range SP,Gravity 0.600 - 0.700</p>', '225', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1045', '8', '148', '46', 'GHSP14', '<p>Hydrometer 0.001 Range SP,Gravity 0.700 - 0.800</p>', '130', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1046', '8', '148', '46', 'GHSP15', '<p>Hydrometer 0.001 Range SP,Gravity 0.800 - 0.900 / 0.900 - 1.000</p>', '130', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1047', '8', '148', '46', 'GHSP16', '<p>Hydrometer 0.001 Range SP,Gravity 1.000 - 1.100</p>', '130', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1048', '8', '148', '46', 'GHSP17', '<p>Hydrometer 0.001 Range SP,Gravity 1.100 - 1.200</p>', '130', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1049', '8', '148', '46', 'GHSP18', '<p>Hydrometer 0.001 Range SP,Gravity 1.200 - 1.300</p>', '130', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1050', '8', '148', '46', 'GHSP19', '<p>Hydrometer 0.001 Range SP,Gravity 1.300 - 1.400</p>', '130', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1051', '8', '148', '46', 'GHSP20', '<p>Hydrometer 0.001 Range SP,Gravity 1.400-1.500</p>', '130', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1052', '8', '148', '46', 'GHSP21', '<p>Hydrometer 0.001 Range SP,Gravity 1.500-1.600</p>', '130', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1053', '8', '148', '46', 'GHSP22', '<p>Hydrometer 0.001 Range SP,Gravity 1.600 - 1.700</p>', '225', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1054', '8', '148', '46', 'GHSP23', '<p>Hydrometer 0.001 Range SP,Gravity 1.700 - 1.800</p>', '225', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1055', '8', '148', '46', 'GHSP24', '<p>Hydrometer 0.001 Range SP,Gravity 1.800 - 1.900</p>', '225', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1056', '8', '148', '46', 'GHSP25', '<p>Hydrometer 0.001 Range SP,Gravity 1.900 - 2.000</p>', '225', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1057', '8', '148', '46', 'GHSP26', '<p>Hydrometer 0.005 Range SP,Gravity 0.600 - 0.650</p>', '225', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1058', '8', '148', '46', 'GHSP27', '<p>Hydrometer 0.005 Range SP,Gravity 0.650 - 0.700</p>', '225', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1059', '8', '148', '46', 'GHSP28', '<p>Hydrometer 0.005 Range SP,Gravity 0.700 - 0.750</p>', '175', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1060', '8', '148', '46', 'GHSP29', '<p>Hydrometer 0.005 Range SP,Gravity 0.750 - 0.800</p>', '175', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1061', '8', '148', '46', 'GHSP30', '<p>Hydrometer 0.005 Range SP,Gravity 0.800 - 0.850</p>', '175', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1062', '8', '148', '46', 'GHSP31', '<p>Hydrometer 0.005 Range SP,Gravity 0.850 - 0.900</p>', '175', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1063', '8', '148', '46', 'GHSP32', '<p>Hydrometer 0.005 Range SP,Gravity 0.900 - 0.950</p>', '175', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1064', '8', '148', '46', 'GHSP33', '<p>Hydrometer 0.005 Range SP,Gravity 0.950 - 1.000</p>', '175', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1065', '8', '148', '46', 'GHSP34', '<p>Hydrometer 0.005 Range SP,Gravity 1.000 - 1.050</p>', '225', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1066', '8', '148', '46', 'GHSP35', '<p>Hydrometer 0.005 Range SP,Gravity 1.050 - 1.100</p>', '225', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1067', '8', '148', '46', 'GHSP36', '<p>Hydrometer 0.005 Range SP,Gravity 1.100 - 1.150</p>', '225', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1068', '8', '148', '46', 'GHSP37', '<p>Hydrometer 0.005 Range SP,Gravity 1.150 - 1.200</p>', '225', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1069', '8', '148', '46', 'GHSP38', '<p>Hydrometer 0.005 Range SP,Gravity 1.200 - 1.250</p>', '225', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1070', '8', '148', '46', 'GHSP39', '<p>Hydrometer 0.005 Range SP,Gravity 1.250 - 1.300</p>', '225', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1071', '8', '148', '46', '', 'BAUME Hydrometer', '', '0', '1', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1072', '8', '148', '46', 'GHBE1', '<p>Hydrometer 0 - 10</p>', '130', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1073', '8', '148', '46', 'GHBE2', '<p>Hydrometer 10 - 20</p>', '130', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1074', '8', '148', '46', 'GHBE3', '<p>Hydrometer 20-30</p>', '130', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1075', '8', '148', '46', 'GHBE4', '<p>Hydrometer 30-40</p>', '130', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1076', '8', '148', '46', 'GHBE5', '<p>Hydrometer 40-50</p>', '130', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1077', '8', '148', '46', 'GHBE6', '<p>Hydrometer 50-60</p>', '130', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1078', '8', '148', '46', 'GHBE7', '<p>Hydrometer 60-70</p>', '130', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1079', '8', '148', '46', 'GHBE8', '<p>Hydrometer 0-20</p>', '130', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1080', '8', '148', '46', 'GHBE9', '<p>Hydrometer 20-40</p>', '130', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1081', '8', '148', '46', 'GHBE10', '<p>Hydrometer 40-60</p>', '130', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1082', '8', '148', '46', 'GHBE11', '<p>Hydrometer 0-30</p>', '130', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1083', '8', '148', '46', 'GHBE12', '<p>Hydrometer 30-60</p>', '130', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1084', '8', '148', '46', 'GHBE13', '<p>Hydrometer 0-40</p>', '130', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1085', '8', '148', '46', 'GHBE14', '<p>Hydrometer 0-50</p>', '130', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1086', '8', '148', '46', '', 'BRIX Hydrometer', '', '0', '1', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1087', '8', '148', '46', 'GHBX1', '<p>BRIX Hydrometer 0-10</p>', '180', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1088', '8', '148', '46', 'GHBX2', '<p>BRIX Hydrometer 10-20</p>', '180', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1089', '8', '148', '46', 'GHBX3', '<p>BRIX Hydrometer 20-30</p>', '180', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1090', '8', '148', '46', 'GHBX4', '<p>BRIX Hydrometer 0-30</p>', '180', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1091', '8', '148', '46', 'GHBX5', '<p>BRIX Hydrometer 30-40</p>', '180', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1092', '8', '148', '46', 'GHBX6', '<p>BRIX Hydrometer 30 - 60</p>', '180', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1093', '8', '148', '46', 'GHBX7', '<p>BRIX Hydrometer 40 - 50</p>', '180', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1094', '8', '148', '46', 'GHBX8', '<p>BRIX Hydrometer 50 - 60</p>', '180', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1095', '8', '148', '46', 'GHBX9', '<p>BRIX Hydrometer 60 - 70</p>', '225', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1096', '8', '148', '46', 'GHBX10', '<p>BRIX Hydrometer 60 - 90</p>', '180', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1097', '8', '148', '46', '', 'BRIX With Thermo', '', '0', '1', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1098', '8', '148', '46', 'GHBXT1', '<p>BRIX With Thermo 0 - 10</p>', '550', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1099', '8', '148', '46', 'GHBXT2', '<p>BRIX With Thermo 10 - 20</p>', '550', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1100', '8', '148', '46', 'GHBXT3', '<p>BRIX With Thermo 20 - 30</p>', '550', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1101', '8', '148', '46', 'GHBXT4', '<p>BRIX With Thermo 0 - 30</p>', '550', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1102', '8', '148', '46', 'GHBXT5', '<p>BRIX With Thermo 30 - 60</p>', '550', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1103', '8', '148', '46', 'GHBXT6', '<p>BRIX With Thermo 60 - 90</p>', '550', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1104', '8', '148', '46', '', 'SOIL Hydrometer', '', '0', '1', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1105', '8', '148', '46', 'GHSH', '<p>SOIL Hydrometer 0.995 TO 1.030</p>', '425', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1106', '8', '148', '46', '', 'Alcohol Meter', '', '0', '1', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1107', '8', '148', '46', 'GHAH', '<p>0-100% Alcoholometer Gay Lussac</p>', '100', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1108', '8', '148', '46', '', 'LACTOMETER / URINOMETER GLASS HYDROMETERS', '', '0', '1', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1109', '8', '148', '46', 'GHLJ', '<p>1.000-1.040 Lactometer with jar</p>', '80', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1110', '8', '148', '46', 'GHL', '<p>1.000-1.040 Lactometer only</p>', '65', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1111', '8', '148', '46', 'GHU', '<p>1.000-1.060 Urinometer with jar</p>', '80', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1112', '8', '148', '46', '', 'Sikes Hydrometers', '', '0', '1', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1113', '8', '148', '46', 'GHSI1', '<p>Sikes 0 -20A</p>', '410', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1114', '8', '148', '46', 'GHSI2', '<p>Sikes 0 - 20</p>', '410', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1115', '8', '148', '46', 'GHSI3', '<p>Sikes 20 - 40</p>', '410', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1116', '8', '148', '46', 'GHSI4', '<p>Sikes 40 - 60</p>', '410', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1117', '8', '148', '46', 'GHSI5', '<p>Sikes 60 - 80</p>', '410', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1118', '8', '148', '46', 'GHSI6', '<p>Sikes 80 - 100</p>', '410', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1119', '8', '148', '46', '', 'Barko Meter', '', '0', '1', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1120', '8', '148', '46', 'GHBM', '<p>Barko Meter 0 - 120</p>', '425', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1121', '8', '148', '46', '', 'Twaddle', '', '0', '1', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1122', '8', '148', '46', 'GHT1', '<p>Twaddle No.1 (0 - 26)</p>', '130', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1123', '8', '148', '46', 'GHT2', '<p>Twaddle No.2 (24 - 50)</p>', '130', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1124', '8', '148', '46', 'GHT3', '<p>Twaddle No.3 (48 - 74)</p>', '130', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1125', '8', '148', '46', 'GHT4', '<p>Twaddle No.4 (72 - 104)</p>', '160', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1126', '8', '148', '46', 'GHT5', '<p>Twaddle No.5 (104 - 138)</p>', '160', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1127', '8', '148', '46', 'GHT6', '<p>Twaddle No.6 (136 - 174)</p>', '160', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1128', '8', '148', '46', '', '<p>Battery Hydrometer Big Leimco-Range 1.100 to 1.300 specific Gravity</p>', '195', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1129', '8', '148', '46', '', '<p>Calibration Certificate by private for Hydrometer BAUME and Specific Gravity</p>', '250', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1130', '8', '148', '46', '', 'Calibration Certificate charges for Brix hydro With Thermometer  ', '', '0', '1', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1131', '8', '148', '46', '', 'Calibration Certificate charges for Brix hydrrometer', '', '0', '1', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1132', '8', '148', '46', '', 'Calibration Certificate charges for Sikes hydrrometer', '', '0', '1', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1133', '8', '149', '24', '', 'SPECIFIC GRAVITY,BAUME,BRIX,SOIL,SALINO,ALCOHOL,SIKES,TWADDEL INDIAN (LEIMCO / LIEMCO BRANDS) Any Available One ', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1134', '8', '149', '24', 'LE1', 'Hydrometer Range SP,Gravity  1.000-2.000 (0-70) LEIMCO', '210', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1135', '8', '149', '24', 'LE2', 'Hydrometer Range SP,Gravity  .700 - 1.000 LEIMCO', '210', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1136', '8', '149', '24', 'LE3', 'Hydrometer Range SP,Gravity  1.000 - 1.500  LEIMCO', '250', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1137', '8', '149', '24', 'LE4', 'Hydrometer Range SP,Gravity  1.500 - 2.000 LEIMCO', '250', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1138', '8', '149', '24', 'LE5', 'Hydrometer  0.002 Range  0.600-.800 LEIMCO', '365', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1139', '8', '149', '24', 'LE6', 'Hydrometer  0.002 Range  0.800 - 1.000  LEIMCO  ', '250', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1140', '8', '149', '24', 'LE7', 'Hydrometer 0.002 Range 1.000 - 1.200 LEIMCO  or 0.800 - 1.000', '250', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1141', '8', '149', '24', 'LE8', 'Hydrometer 0.002 Range SP,Gravity  1.200 - 1.400 LEIMCO', '250', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1142', '8', '149', '24', 'LE9', 'Hydrometer 0.002 Range SP,Gravity 1.400 - 1.600 LEIMCO', '250', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1143', '8', '149', '24', 'LE10', 'Hydrometer 0.002 Range SP,Gravity 1.600 - 1.800 LEIMCO', '365', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1144', '8', '149', '24', 'LE11', 'Hydrometer 0.002 Range SP,Gravity 1.800 - 2.000 LEIMCO', '365', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1145', '8', '149', '24', 'LE12', 'Hydrometer 0.001 Range 0.600 -.700', '375', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1146', '8', '149', '24', 'LE13', 'Hydrometer 0.001 Range 0.700 - .800', '250', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1147', '8', '149', '24', 'LE14', 'Hydrometer 0.001 Range 0.800 - 0.900 / 0.900 - 1.000', '250', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1148', '8', '149', '24', 'LE15', 'Hydrometer 0.001 Range 1.000 - 1.100', '250', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1149', '8', '149', '24', 'LE16', 'Hydrometer 0.001 Range 1.100 - 1.200', '250', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1150', '8', '149', '24', 'LE17', 'Hydrometer 0.001 Range 1.200 - 1.300', '250', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1151', '8', '149', '24', 'LE18', 'Hydrometer 0.001 Range 1.300 - 1.400', '250', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1152', '8', '149', '24', 'LE19', 'Hydrometer 0.001 Range 1.400-1.500', '325', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1153', '8', '149', '24', 'LE20', 'Hydrometer 0.001 Range 1.500-1.600', '325', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1154', '8', '149', '24', 'LE21', 'Hydrometer 0.001 Range 1.600 - 1.700', '325', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1155', '8', '149', '24', 'LE22', 'Hydrometer 0.001 Range 1.700 - 1.800', '325', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1156', '8', '149', '24', 'LE23', 'Hydrometer 0.001 Range 1.800 - 1.900', '375', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1157', '8', '149', '24', 'LE24', 'Hydrometer 0.001 Range 1.900 - 2.000', '375', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1158', '8', '149', '24', 'LE25', 'Hydrometer 0.001 Range  0.600 - 0.650', '535', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1159', '8', '149', '24', 'LE26', 'Hydrometer 0.001 Range 0.650 - 0.700 ', '375', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1160', '8', '149', '24', 'LE27', 'Hydrometer 0.001 Range 0.700 - 0.750', '375', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1161', '8', '149', '24', 'LE28', 'Hydrometer 0.001 Range 0.750 - 0.800 ', '375', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1162', '8', '149', '24', 'LE29', 'Hydrometer 0.001 Range 0.800 - 0.850 ', '375', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1163', '8', '149', '24', 'LE30', 'Hydrometer 0.001 Range 0.850 - 0.900', '375', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1164', '8', '149', '24', 'LE31', 'Hydrometer 0.001 Range 0.900 - 0.950', '375', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1165', '8', '149', '24', 'LE32', 'Hydrometer 0.001 Range 0.950 - 1.000', '375', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1166', '8', '149', '24', 'LE33', 'Hydrometer 0.001 Range 1.000 - 1.050', '405', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1167', '8', '149', '24', 'LE34', 'Hydrometer 0.001 Range 1.050 - 1.100', '405', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1168', '8', '149', '24', 'LE35', 'Hydrometer 0.001 Range 1.100 - 1.150', '405', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1169', '8', '149', '24', 'LE36', 'Hydrometer 0.001 Range 1.150 - 1.200', '405', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1170', '8', '149', '24', 'LE37', 'Hydrometer 0.001 Range 1.200 - 1.250', '405', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1171', '8', '149', '24', 'LE38', 'Hydrometer 0.001 Range 1.250 - 1.300', '405', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1172', '8', '149', '24', '', 'BAUME Hydrometer', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1173', '8', '149', '24', 'LE39', 'Hydrometer   0 - 10', '250', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1174', '8', '149', '24', 'LE40', 'Hydrometer   10 - 20', '250', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1175', '8', '149', '24', 'LE41', 'Hydrometer   20-30', '250', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1176', '8', '149', '24', 'LE42', 'Hydrometer    30-40', '250', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1177', '8', '149', '24', 'LE43', 'Hydrometer   40-50', '345', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1178', '8', '149', '24', 'LE44', 'Hydrometer  50-60', '345', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1179', '8', '149', '24', 'LE45', 'Hydrometer  60-70', '345', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1180', '8', '149', '24', 'LE46', 'Hydrometer  0-20', '265', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1181', '8', '149', '24', 'LE47', 'Hydrometer  20-40', '265', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1182', '8', '149', '24', 'LE48', 'Hydrometer  40-60', '265', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1183', '8', '149', '24', 'LE49', 'Hydrometer  0-30', '250', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1184', '8', '149', '24', 'LE50', 'Hydrometer  30-60', '265', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1185', '8', '149', '24', 'LE51', 'Hydrometer  0-40', '265', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1186', '8', '149', '24', 'LE52', 'Hydrometer  0-50', '265', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1187', '8', '149', '24', 'LE53', 'Hydrometer  0-70', '210', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1188', '8', '149', '24', '', 'BRIX Hydrometer', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1189', '8', '149', '24', 'LE54', 'BRIX Hydrometer  0-10', '420', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1190', '8', '149', '24', 'LE55', 'BRIX Hydrometer  10-20', '420', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1191', '8', '149', '24', 'LE56', 'BRIX Hydrometer  20-30', '420', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1192', '8', '149', '24', 'LE57', 'BRIX Hydrometer  0-30', '365', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1193', '8', '149', '24', 'LE58', 'BRIX Hydrometer  30-40', '445', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1194', '8', '149', '24', 'LE59', 'BRIX Hydrometer  30 - 60', '365', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1195', '8', '149', '24', 'LE60', 'BRIX Hydrometer  40 - 50', '445', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1196', '8', '149', '24', 'LE61', 'BRIX Hydrometer  50 - 60', '500', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1197', '8', '149', '24', 'LE62', 'BRIX Hydrometer  60 - 70', '500', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1198', '8', '149', '24', 'LE63', 'BRIX Hydrometer  60 - 90', '435', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1199', '8', '149', '24', 'LE64', 'BRIX Hydrometer  90-100', '500', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1200', '8', '149', '24', '', 'BRIX With Thermo', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1201', '8', '149', '24', 'LE65', 'BRIX With Thermo  0 - 10', '785', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1202', '8', '149', '24', 'LE66', 'BRIX With Thermo  10 - 20', '785', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1203', '8', '149', '24', 'LE67', 'BRIX With Thermo  20 - 30', '845', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1204', '8', '149', '24', 'LE68', 'BRIX With Thermo  0 - 30', '845', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1205', '8', '149', '24', 'LE69', 'BRIX With Thermo  30 - 60', '845', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1206', '8', '149', '24', 'LE70', 'BRIX With Thermo  60 - 90', '1000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1207', '8', '149', '24', '', 'SOIL Hydrometer', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1208', '8', '149', '24', 'LE71', 'SOIL Hydrometer  0.995 TO 1.030 LEIMCO', '1000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1209', '8', '149', '24', '', 'Alcohol Meter', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1210', '8', '149', '24', 'LE72', 'Alcohol Meter 0 - 100% (Gay Lucas)', '250', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1211', '8', '149', '24', 'LE73', 'Alcohol Meter  90 - 100%', '875', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1212', '8', '149', '24', 'LE74', 'Alcohol Meter  94 - 104', '875', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1213', '8', '149', '24', '', 'Sikes', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1214', '8', '149', '24', 'LE75', 'Sikes  0 -20A', '585', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1215', '8', '149', '24', 'LE76', 'Sikes  0 - 20', '585', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1216', '8', '149', '24', 'LE77', 'Sikes  20 - 40', '620', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1217', '8', '149', '24', 'LE78', 'Sikes  40 - 60', '620', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1218', '8', '149', '24', 'LE79', 'Sikes  60 - 80', '620', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1219', '8', '149', '24', 'LE80', 'Sikes  80 - 100', '620', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1220', '8', '149', '24', 'LE81', 'Sikes  TABLE BOOK', '375', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1221', '8', '149', '24', '', 'Barko Meter', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1222', '8', '149', '24', 'LE82', 'Barko Meter   0 - 120', '635', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1223', '8', '149', '24', '', 'Twaddle', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1224', '8', '149', '24', 'LE83', 'Twaddle  No.1 (0 - 26)', '265', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1225', '8', '149', '24', 'LE84', 'Twaddle  No.2 (24 - 50)', '265', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1226', '8', '149', '24', 'LE85', 'Twaddle  No.3 (48 - 74)', '265', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1227', '8', '149', '24', 'LE86', 'Twaddle  No.4 (72 - 104)', '325', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1228', '8', '149', '24', 'LE87', 'Twaddle  No.5 (102 - 138)', '325', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1229', '8', '149', '24', 'LE88', 'Twaddle  No.6 (136 - 174)', '325', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1230', '8', '149', '24', 'LE89', 'Twaddle  No 7 (160-200)', '410', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1231', '8', '149', '24', 'LE90', 'Battery Hydrometer Big Leimco-Range 1.100 to 1.300 specific Gravity', '395', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1232', '8', '149', '24', 'LE91', 'Calibration Certificate by private for Hydrometer  BAUME and Specific Gravity ', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1233', '8', '149', '24', 'LE92', 'Calibration Certificate charges for Brix hydro With Thermometer  ', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1234', '8', '149', '24', 'LE93', 'Calibration Certificate charges for Brix hydrrometer', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1235', '8', '149', '24', 'LE94', 'Calibration Certificate charges for Sikes hydrrometer', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1236', '8', '150', '24', 'LE95', 'Lactometer  Liemco/ Indian make 1.000 - 1.040', '250', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1237', '8', '150', '24', 'LE96', 'Urinometer 1.000 -1.060 / 0.001', '410', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1238', '8', '151', '24', 'LE97', 'DN M50 700-750 LEIMCO ,MUMBAI', '550', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1239', '8', '151', '24', 'LE98', 'DN M50 800-850 LEIMCO ,MUMBAI', '550', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1240', '8', '151', '24', 'LE99', '<p>Swastik Thermometer 50&deg;C M (0.5)</p>', '450', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1241', '8', '151', '24', 'LE100', 'Oil Paste for Kaveri make', '115', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1242', '8', '151', '24', 'LE101', 'Water Paste Kaveri make ', '115', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1243', '8', '151', '24', '', 'Density Kit Small', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1244', '8', '151', '24', 'LE102', '<p>2 Hydrometer ( 700 to 750 &amp; 800 to 850), 1 no. Thermometer 50&deg;C (0.5) with certificate and 1 measuring cylinder 500ml. Borosilicate glass and 1 each of water paste &amp; oil pase</p>', '3500', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1245', '8', '152', '24', 'LE103', 'DN Range 0.600 to 0.650 LEIMCO M-50(0.001) ', '570', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1246', '8', '152', '24', 'LE104', 'DN Range 0.650 to 0.700  LEIMCO M-50(0.001) ', '380', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1247', '8', '152', '24', 'LE105', 'DN Range  0.700 to 0.750 LEIMCO M-50(0.001) ', '360', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1248', '8', '152', '24', 'LE106', 'DN Range 0.750 to 0.800  LEIMCO M-50(0.001) ', '360', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1249', '8', '152', '24', 'LE107', 'DN Range 0.800 to 0.850 LEIMCO M-50(0.001) ', '360', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1250', '8', '152', '24', 'LE108', 'DN Range 0.850 to 0.900 LEIMCO M-50(0.001) ', '380', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1251', '8', '152', '24', 'LE109', 'DN Range 0.900 to 0.950 LEIMCO M-50(0.001) ', '380', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1252', '8', '152', '24', 'LE110', 'DN Range 0.950 to 1.000  LEIMCO M-50(0.001) ', '380', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1253', '8', '152', '24', 'LE111', 'DN Range 1.000 to 1.050  LEIMCO M-50(0.001) ', '570', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1254', '8', '152', '24', 'LE112', 'DN Range 1.0500 to 1.100  LEIMCO M-50(0.001) ', '570', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1255', '8', '153', '24', 'LE113', 'DN Range 0.600 to 0.650 LEIMCO L-50(0.0005) ', '640', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1256', '8', '153', '24', 'LE114', 'DN Range 0.650 to 0.700  LEIMCO L-50(0.0005) ', '580', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1257', '8', '153', '24', 'LE115', 'DN Range  0.700 to 0.750 LEIMCO L-50(0.0005) ', '580', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1258', '8', '153', '24', 'LE116', 'DN Range 0.750 to 0.800  LEIMCO L-50(0.0005) ', '580', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1259', '8', '153', '24', 'LE117', 'DN Range 0.800 to 0.850 LEIMCO L-50(0.0005) ', '580', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1260', '8', '153', '24', 'LE118', 'DN Range 0.850 to 0.900 LEIMCO L-50(0.0005) ', '580', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1261', '8', '153', '24', 'LE119', 'DN Range 0.900 to 0.950 LEIMCO L-50(0.0005) ', '580', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1262', '8', '153', '24', 'LE120', 'DN Range 0.950 to 1.000  LEIMCO L-50(0.0005) ', '580', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1263', '8', '153', '24', 'LE121', 'DN Range 1.000 to 1.050  LEIMCO L-50(0.0005) ', '640', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1264', '8', '153', '24', 'LE122', 'DN Range 1.0500 to 1.100  LEIMCO L-50(0.0005) ', '640', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1265', '8', '154', '24', 'LE122', 'NABL CERTIFICATION FOR HYDROMETER', '1250', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1266', '8', '154', '24', 'LE123', 'CERTIFICATE BY PRIVATE PARTY FOR NATIONAL STANDARD FOR HYDROMETER ', '350', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1267', '8', '155', '43', 'T17', 'Heamometer Round Top Tech full set', '500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1268', '8', '156', '17', 'H12', 'Heamometer SAHLIS HBG Make complete set with comparator, round tube 20cm pipette brush', '800', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1269', '8', '156', '17', 'H13', 'Round Tube HBG Make', '100', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1270', '8', '156', '17', 'H14', '20 cm Pipette HBG Make', '100', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1271', '8', '157', '43', 'T18', 'RBC Pipette Top Tech', '70', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1272', '8', '157', '43', 'T19', 'WBC Pipette Top Tech', '70', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1273', '8', '157', '43', 'T20', '20cm Pipette Top Tech', '35', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1274', '8', '157', '43', 'T21', 'Wintrobe Tube Top Tech ', '30', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1275', '8', '158', '17', 'H1', 'Heamocytometer HBG with Counting Chamber, HBG WBC & RBC full set ', '1500', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1276', '8', '159', '40', '', 'Heamometer Superior', '1200', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1277', '8', '159', '40', '', 'Round Tube HB', '150', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1278', '8', '159', '40', '', '20 Pipette Superior', '225', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1279', '8', '159', '40', '', 'WBC Superior', '375', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1280', '8', '159', '40', '', 'RBC Superior', '375', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1281', '8', '159', '40', '', 'ESR Tube Superior', '60', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1282', '8', '160', '17', 'H2', 'Counting Chamber HBG Make', '1000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1283', '8', '160', '8', 'H3', 'Counting Chamber ROHEM', '1050', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1284', '8', '160', '8', 'H4', 'Counting Chamber CHINA', '425', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1285', '8', '160', '8', 'H5', 'Counting Chamber Accutek Brightline', '750', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1286', '8', '160', '17', 'H6', 'RBC and WBC Pipette HBG Make', '130', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1287', '8', '160', '40', 'H7', 'RBC and WBC Pipette SUPERIOR ', '375', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1288', '8', '160', '8', 'H8', 'RBC and WBC Pipette JAYNA', '', '0', '1', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1289', '8', '160', '8', 'H9', '20cm Pipette Top JAYNA', '', '0', '1', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1290', '8', '160', '17', 'H10', 'Wintrobe Tube HBG Make', '100', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1291', '8', '160', '17', 'H11', 'ESR Tube HBG Make', '60', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1292', '8', '161', '8', 'H15', 'Accutek Chamber with HBG Pipette', '1025', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1293', '8', '161', '8', 'H16', 'Accutek Chamber with Indian Pipette', '925', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1294', '8', '161', '8', 'H17', 'Accutek Chamber with Top Tech Pipette', '975', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1295', '8', '161', '8', 'H18', 'China Chamber with HBG Pipette', '775', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1296', '8', '161', '8', 'H19', 'China Chamber with Indian Pipette', '625', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1297', '8', '161', '8', 'H20', 'China Chamber with Top Tech Pipette', '700', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1298', '8', '161', '8', 'H21', 'HBG Chamber with HBG Pipette', '1500', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1299', '8', '161', '8', 'H22', 'HBG Chamber with Indian Pipette', '1250', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1300', '8', '161', '8', 'H23', 'HBG Chamber with Superior Pipette', '1975', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1301', '8', '161', '8', 'H24', 'HBG Chamber with Top Tech Pipette', '1350', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1302', '8', '161', '8', 'H25', 'Rohem Chamber with HBG Pipette', '1450', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1303', '8', '161', '8', 'H26', 'Rohem Chamber with Indian Pipette', '1275', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1304', '8', '161', '8', 'H27', 'Rohem Chamber with Superior Pipette', '2000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1305', '8', '161', '8', 'H28', 'Rohem Chamber with Top Tech Pipette', '1400', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1306', '8', '161', '8', 'H29', 'Weber Chamber with HBG Pipette ', '2800', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1307', '8', '161', '8', 'H30', 'Weber Chamber with Superior Pipette ', '3375', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1308', '8', '161', '8', 'H31', 'Weber Chamber with Top Tech Pipette ', '2750', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1309', '8', '162', '22', 'LH113', 'LH-113 Digital Haemoglobin Meter With finger touch zero setting, Memory for the storage of samples, 1 ml solution measurement.', '6000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1310', '8', '162', '22', 'LH113P', 'LH-113-P Portable Haemoglobin Meter Portable and high performance digital hemoglobin meter is fully automated process. This provides easy,fast & highly accurate monitoring of haemoglobin. ln this the adjustment or calibration is not needed and ensures to provide results within 15seconds. 10 Testing strips, measuring range 5 \"\'25gm/dl, memory: 1000 test results, auto calibration.', '5500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1311', '8', '162', '22', 'LHHB', 'Spare HB Strips (Pack of 50)', '1500', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1312', '8', '163', '42', 'TESTO622', '<p>Testo 622 Large Display Hygromete with Absolute Pressure &nbsp;Measures &amp; displays % rH, &deg;C/F, mBar,(abs), psychometric parameters, Displays date and time, Reminder alarm for calibration, visual alarms for both the channels with Max./Min.values&nbsp;</p>', 'POR', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1313', '8', '163', '42', 'TESTO623', '<p>Testo 623 Large Display Hygromete with History Function &nbsp;Measures &amp; displays % rH, &deg;C/F, mBar,(abs), psychometric parameters, Displays date and time, Displays history of measurement for the last 90 days, visual alarms for both the channels with Max./Min.values</p>', 'POR', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1314', '8', '164', '22', 'LH3201', 'LH-3201 High Pressure Liquid Chromatograph (HPLC) isocratic System with high pressure solvent delivery pump, Multi-wavelength UV Detector. Sample inject valve Rheodyne 7725i. LC Column (USA)with workstation software. Wavelength range 190-700 nm, Wavelength accuracy +lnm, spectral bandwidth 8nm, flow cell volume 8micro litre optical length-lOnm. (Imported)', '800000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1315', '8', '165', '10', 'GL6200', '<p>GL-6200 High-Pressure Liquid Chromatography system,&nbsp;<br />\r\nPump - Series dual- plunger pump, Pressure Accuracy &plusmn; 2%, Flow Rates 0.001 ~10.000 ml/min, Flow Accuracy &nbsp;&le;&plusmn;1 % (2&mu;L/min), Pressure 0 - 6000 psi, Pulsation: &nbsp;&lt;15psi from 600 to 1,600 psi, Flow 1mL/min, Operating Temp.4~40&deg;C, UV-Detector - Wavelength 190-700 nm,Spectral bandwidth 6 nm,Wavelength Accuracy &le;&plusmn;1 nm, Flow pool volume 10 &mu; L, Optical path 10 mm,Operating Temp. 4-40&deg;C, Minimum detection concentration &le;1&times;10-8g/mL(Naphthalene/methanol solution),Linear range &ge;104</p>', '690000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1316', '8', '165', '10', 'GL6300', '<p>GL-6300 High-Pressure Liquid Chromatography system,&nbsp;<br />\r\nPump - Series dual- plunger pump, Pressure Accuracy &plusmn; 2%, Flow Rates 0.001 ~9.999 ml/min, Flow Accuracy &nbsp;&le;&plusmn;0.5 % , Pressure 0 - 9999 psi, Pulsation: &nbsp;&lt;15psi from 600 to 1,600 psi, Flow 1mL/min, Operating Temp.4~40&deg;C, UV-Detector - Wavelength 190-700 nm,Spectral bandwidth 6 nm,Wavelength Accuracy &le;&plusmn;1 nm, Flow pool volume 8 &mu; L, Optical path 10 mm,Operating Temp. 4-40&deg;C</p>', '1075000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1317', '8', '166', '22', 'LH1290', 'LH-1290 Fully Automatic Hematology Analyzer (Double Chamber) for complete blood count Using Principle of electrical resistance for counting & SFT Method for HGB. Accurate & reliable results using digital filtering, blood cell overlap calibration dual way high pressure cleaning, to avoid aperture blocking. Electro hydraulic separation structure design alarm function, auto wiping/cleaning of sample needle. Large storage up to 30 thousand result with histogram. Easy operation using touch screen with 640x480 LCD Display. Automatic sample sipping, mixing testing & cleaning in Built thermal the printer and external printer Optional (Imported)', '366000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1318', '9', '167', '15', '', 'Double walled cabinet provided with glass wool insulation with thermostat control. Temp. range 5\'C above ambient to 80\'C with a variation of 0.5\'C complete with glass front door,expanded metal Shelves,indicator lamps  rotary ON/OFF switch,to work on 220volts AC. Temp. range 5\'C above room temp. to 80\'C.', '', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1319', '9', '167', '15', 'GVINC12', 'GV-INC-12 Size Of Inner Chamber  300x300x300mm 12&#8221;x12&#8221;x12&#8221; Capacity 28 Ltr, 250 w Rating, 1 Shelves Analog Regulator Temp.', '12000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1320', '9', '167', '15', 'GVINC12DIGI', 'GV-INC-12 DIGI  12&#8221;x12&#8221;x12&#8221; with Digital Temperature Controller', '18000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1321', '9', '167', '15', 'GVINC12DIGIFAN', 'GV-INC-12 DIGI & FAN 12&#8221;x12&#8221;x12&#8221; with Digital Temperature Controller and Fan for Circulating air', '22500', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1322', '9', '167', '15', 'GVINC14', 'GV-INC-14 Size Of Inner Chamber 355x355x355mm 14&#8221;x14&#8221;x14&#8221; Capacity 45 Ltr, 250 w Rating, 2 Shelves Analog Regulator Temp.', '17000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1323', '9', '167', '15', 'GVINC14DIGI ', 'GV-INC-14 DIGI 14&#8221;x14&#8221;x14&#8221; with Digital Temperature Controller', '22500', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1324', '9', '167', '15', 'GVINC14DIGIFAN', 'GV-INC-14 DIGI & FAN 14&#8221;x14&#8221;x14&#8221; with Digital Temperature Controller and Fan for Circulating air', '28000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1325', '9', '167', '15', 'GVINC18', 'GV-INC-18 Size Of Inner Chamber 455x455x455mm 18\'x18&#8221;x18&#8221; Capacity 95 Ltr, 400 w Rating, 2 Shelves Analog Regulator Temp.', '21500', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1326', '9', '167', '15', 'GVINC18DIGI', 'GV-INC-18 DIGI 18\'x18&#8221;x18&#8221; with Digital Temperature Controller', '27000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1327', '9', '167', '15', 'GVINC18DIGIFAN', 'GV-INC-18 DIGI & FAN 18\'x18&#8221;x18&#8221; with Digital Temperature Controller and Fan for Circulating air', '32000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1328', '9', '167', '15', 'GVINC24', 'GV-INC-24 Size Of Inner Chamber 605x605x605mm 24&#8221;x24&#8221;x24&#8221;Capacity 224 Ltr, 750 w Rating, 3 Shelves Analog Regulator Temp.', '33500', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1329', '9', '167', '15', 'GVINC24DIGI', 'GV-INC-24 DIGI 24&#8221;x24&#8221;x24&#8221; with Digital Temperature Controller', '39000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1330', '9', '167', '15', 'GVINC12DIGIFAN', 'GV-INC-12 DIGI & FAN 24&#8221;x24&#8221;x24&#8221;  with Digital Temperature Controller and Fan for Circulating air', '45000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1331', '9', '168', '33', 'RHI50', '<p>RHI-50 Hot air Incubator with 50 Liters capacity &amp; Temperature setting range from RT + 5&deg;C up to +65&deg;C</p>', '54570', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1332', '9', '168', '33', 'RHI80', '<p>RHI-80 Hot air Incubator with 80 Liters capacity &amp; Temperature setting range from RT + 5&deg;C up to +65&deg;C</p>', '71690', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1333', '9', '169', '25', '2438210', '2438210  TC 140 G THERMOSTATICALLY CONTROLLED CABINET LOVIBOND', '244422', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1334', '9', '170', '7', 'ECION70040S', 'ECION70040S Eutech Ion 700 Meter With Integral Electrode Holder & 100/240 VAC Adapter. pH and Ion Electrodes to be ordered separately', '56700', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1335', '9', '170', '7', 'ECION270042GS ', 'ECION270042GS Eutech ION 2700 Meter With pH Electrode (ECFG7370101B), ATC Probe (PH5TEMB01P), Integral Electrode Holder, 100/240 VAC Adapter, RS232 cable, & pH Electrode Refill Solution. Ion Electrodes to be ordered separately', '75000', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1336', '9', '170', '7', 'IONELECTRODES', 'ION Selective Electrodes ANTECH USA make with  500 ml Standard solution and Ion strength adjuster Price for One (FOR FLOURIDE, NITRATE, CHLORIDE, SODIUM ETC ANY ONE)', 'POR', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1337', '9', '171', '33', 'CI6PLUSLED', '<p>CI-6 Plus Capacity 200 litters, Temperature range 5&deg;C to 60&deg;C Microprocessor ( VS-02) LED</p>', '181900', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1338', '9', '171', '33', 'CI6PLUSLCD', '<p>CI-6 Plus Capacity 200 litters, Temperature range 5&deg;C to 60&deg;C Microprocessor ( VS-02) LCD</p>', '208650', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1339', '9', '171', '33', 'CI10PLUSLED', '<p>CI-10 Plus Capacity 280 litters, Temperature range 5&deg;C to 60&deg;C Microprocessor ( VS-02 ) LED</p>', '189400', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1340', '9', '171', '33', 'CI10PLUSLCD', '<p>CI-10 Plus Capacity 280 litters, Temperature range 5&deg;C to 60&deg;C Microprocessor ( VS-02 ) LCD</p>', '218275', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1341', '9', '171', '33', 'CI12PLUSLED', '<p>CI-12 Plus Capacity 370 liters, Temperature range 5&deg;C to 60&deg;C Microprocessor (VS-03) LED</p>', '199025', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1342', '9', '171', '33', 'CI12PLUSLCD', '<p>CI-12 Plus Capacity 370 liters, Temperature range 5&deg;C to 60&deg;C Microprocessor (VS-03) LCD</p>', '226850', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1343', '9', '171', '33', 'VS03', 'VS-03 Servo controlled Voltage Stabilizer', '16050', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1344', '9', '171', '33', 'VS02', 'VS-02 Servo controlled Voltage Stabilizer', '13900', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1345', '10', '172', '15', 'GVJAR2 ', 'GV-JAR-2 Jar test apparatus with digital rpm & timer w/o glass beaker 2 test  ', '15500', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1346', '10', '172', '15', 'GVJAR4', 'GV-JAR-4 Jar test apparatus with digital rpm & timer w/o glass beaker 4 test  ', '19000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1347', '10', '172', '15', 'GVJAR6', 'GV-JAR-6 Jar test apparatus with digital rpm & timer w/o glass beaker 6 test  ', '22000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1348', '10', '173', '15', 'GVJUNKER', 'GV-JUNKER For estimation of Calorific value of gaseous fuels with volume meter. Complete supply with all Spares & Gas flow meter.', '140000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1349', '10', '173', '15', 'GVJUNKERINSTALLATION', ' Installation charges  for JUNKERS CALORIMETERS to be added separately with in chennai TamilNadu', '6000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1350', '11', '174', '22', 'LH6310', 'LH-6310 Microprocessor K.F Moisture Titrator 7\" inch Coloured Touch screen, Microprocessor Based with Printer Interface, User Friendly and Menu Driven Software, Direct Results in ppm, % and mg H2O on single display screen, Setup Data Storage Facility, Sample Data Storage Facility, 128x64 Graphical LCD, Batch-wise, Data-wise and Individual Result Data Printing, RS232/USB Interface (Optional), Measuring Range 10 ppm to 100% Moisture, Measuring method Karl fischer volumetric Titration method, Resolution of Titrant volume 0.01 ml, In built clock with date & time display, In built magnetic stirrer with adjustable speed, Dot Matrix Printer Interface. NEW ADDITION', '81250', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1351', '11', '174', '22', 'LH630', 'LH-630 Microprocessor K.F Moisture Titrator (Graphical Display)with built-in magnetic stirrer, Auto computation of moisture in ppm, % age and mg H20, Simultaneous display of results in all three units, 1000 sample storage facility with batch no, Final result are flashed on 128*64 premium graphical LCD. Icon based Menu for easy navigation. K.F reagent dispensing by motor.', '60000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1352', '11', '174', '22', 'LH63', 'LH-63 Auto Karl Fishers Titrimeter Having array of LED\'s provided with inbuilt stirrer, auto zero burette,adjustable timer, dual platinum electrodes and other accessories.', '18500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1353', '12', '175', '26', 'LX101A', 'LX 101A LUTRON  range 0 to 50000 LUX/One meter cable/Sensor with photodiode & Colour Correction Filters  ', '3400', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1354', '12', '175', '26', 'LX102', 'LX 102 LUTRON   range 0 to 50000 LUX Fl. Candle. Data Hold ', '5900', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1355', '12', '175', '26', 'LX1102 ', 'LX 1102 LUTRON  0 to 4 Lakh LUX Large LCD Display with RS 232 Port / cable and software to be ordered separately.', '9500', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1356', '12', '175', '26', 'LX1108', 'LX 1108 LUX METER with four light selection with RS 232 port / cable and software to be ordered separately.', '11500', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1357', '12', '175', '42', 'TESTO540', 'Testo-540 Light Intensity Meter(Lux Meter) , Large backlit LCD display, Wide range upto 99,999 Lux,With Hold,Max./Min.function', '9550', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1358', '12', '175', '45', '', 'LX-101 Workzone LUX METER with built in sensor Range 1 - 50,000 Lux  ', '2000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1359', '12', '176', '8', '', '3 Feet 30 watts philips ', '1250', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1360', '12', '176', '8', '', '3 Feet 30 watts Osram Lamp ', '900', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1361', '12', '176', '8', '', '3 Feet 30 watts Indian Fittings with & without refelector Philips ', '875', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1362', '12', '176', '8', '', '1 1/2 Feet 15 watts Phillips ', '750', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1363', '12', '176', '8', '', '1 1/2 Feet 15 watts Indian Fittings with & without refelector Philips ', '800', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1364', '12', '177', '8', '', '4 watts length 134.5mm (6\") Phillips Clear Lamp ', '425', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1365', '12', '177', '8', '', '4 watts length 134.5mm (6\") Phillips / Osram Black Lamp ', '475', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1366', '12', '177', '8', '', '6 watts length 210.5mm (9\") Phillips / Osram Clear Lamp ', '375', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1367', '12', '177', '8', '', '6 watts length 210.5mm (9\") Phillips / Osram Black Lamp ', '440', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1368', '12', '177', '8', '', '8 watts length 287 mm (12\") Phillips Clear Lamp', '300', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1369', '12', '177', '8', '', '8 watts length 287 mm (12\") Osram Clear Lamp', '220', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1370', '12', '177', '8', '', '8 watts length 287 mm (12\") Phillips / Osram Black Lamp', '400', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1371', '12', '177', '8', '', '8 watts length 287 mm (12\") OREVA FLOURESCENT TUBES ', '150', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1372', '12', '177', '8', '', '18 watts length 2 feet  Phillips / Osram Black Lamp', '715', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1373', '12', '177', '8', '', '18 watts length 2 feet  Starlite', '450', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1374', '12', '177', '8', '', '36 watts length 4 feet  Phillips / Osram Clear Lamp', '1200', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1375', '12', '177', '8', '', '36 watts length 4 feet  Starlite', '600', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1376', '12', '177', '8', '', 'Fitting Indian 8 watts length 287 mm (12\") ', '285', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1377', '12', '178', '8', '', 'Halogen Lamp 15 v 150 w Philips', '270', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1378', '12', '178', '8', '', 'Halogen Lamp 15 v 150 w Osram Lamp', '225', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1379', '12', '178', '8', '', 'Halogen Lamp  6 v 20 w Philips', '180', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1380', '12', '178', '8', '', 'Halogen Lamp  6 v 20 w Osram Lamp', '120', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1381', '12', '178', '8', '', 'Halogen Lamp  6 v 10 w Philips', '205', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1382', '12', '178', '8', '', 'Halogen Lamp  6 v 10 w Osram Lamp', '135', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1383', '12', '178', '8', '', 'Halogen Lamp  12 v 20 w Philips', '1350', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1384', '12', '178', '8', '', 'Halogen Lamp  12 v 20 w Osram Lamp', '1125', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1385', '12', '178', '8', '', 'Halogen Lamp  12 v 20 w Type 12345', '1350', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1386', '12', '178', '8', '', 'Halogen Lamp 24 v 250 w Philips', '180', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1387', '12', '178', '8', '', 'Halogen Lamp 24 v 250 w Osram Lamp', '120', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1388', '12', '178', '8', '', 'Halogen Lamp 24 v 100 w Osram Lamp', '450', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1389', '12', '178', '8', '', 'Halogen Lamp 24 v 150 w Philips', '180', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1390', '12', '178', '8', '', 'Halogen Lamp 24 v 150 w Osram Lamp', '130', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1391', '12', '178', '8', '', 'Halogen Lamp  24 v 600 w', '600', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1392', '12', '178', '8', '', 'Halogen Lamp  12 v 50 w Philips', '190', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1393', '12', '178', '8', '', 'Halogen Lamp  12 v 50 w Osram Lamp', '150', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1394', '12', '178', '8', '', 'Halogen Lamp  15 v 50 w', '200', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1395', '12', '178', '8', '', 'Halogen Lamp  15 v 50 w with Reflector Philips', '525', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1396', '12', '178', '8', '', 'Halogen Lamp  15 v 50 w with Reflector Osram Lamp', '450', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1397', '12', '178', '8', '', 'Halogen Lamp  24 v 250 w with Reflector Philips', '540', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1398', '12', '178', '8', '', 'Halogen Lamp  24 v 250 w with Reflector Osram Lamp', '475', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1399', '12', '179', '8', '', 'Laboratory Jacks MS Top 12x14 cms', '1500', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1400', '12', '179', '8', '', 'Laboratory Jacks MS Top  20x20 cms', '2000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1401', '12', '179', '8', '', 'Laboratory Jacks MS Top  25x25 cms', '2250', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1402', '12', '179', '8', '', 'Laboratory Jacks MS Top  30x30 cms', '3000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1403', '12', '179', '8', '', 'Laboratory Jacks SS Top 12x14 cms', '1750', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1404', '12', '179', '8', '', 'Laboratory Jacks SS Top  20x20 cms', '4500', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1405', '12', '179', '8', '', 'Laboratory Jacks SS Top  25x25 cms', '3500', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1406', '12', '179', '8', '', 'Laboratory Jacks SS Top  30x30 cms', '5000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1407', '12', '179', '8', '', 'Laboratory Jacks SS Top  15x15 cms', '2275', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1408', '12', '180', '8', '', 'College school Lab coat made at Standard Quality (TC) Size S, M,L,XL any size Half Sleeve ', '325', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1409', '12', '181', '10', '', 'G-VLT-201 Vacuum Leak Tester with Desiccator Vacuum Range 150 - 600 mmHg, Alphanumeric Keypad\r\nLAN, RS - 232 , External 80/40 column printer and 40 column built in mini Dot Matrix Printer', '82000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1410', '12', '182', '10', '', '<p>G-NVLT-101 Leak Tester Apparatus (NANO) is designed with utmost precision using top notch quality material and advanced equipment. Comprises a polycarbonate desicators housing to sustain the vacuum for long time, can be released manually. Vacuum Range 550mmHg &plusmn;10mmHg, 4-digit LED display, push button (4 keys), High Quality vacuum guage.</p>', '43000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1411', '12', '183', '22', '', 'LH-75 Digital Leak Test Apparatus (12\" DESICCATOR) with digit seven segment bright red LED display,\r\nprogrammable vacuum hold time up to 9999 secs. Extremely useful for packing industry and ideal for leak testingfor strips, blisters & sachets. Please specify the desiccator size while ordering. Supplied in S.S. 304 Cabinet.', '37500', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1412', '13', '185', '22', 'LH108', '<p>LH-108 Digital Melting Point Apparatus with resolution O.l&deg;C to measure melting point, boiling point of solid and liquid samples. Temperature range 0-300&deg;C with 411 TFTScreen &amp; Camera. NEW</p>', '49000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1413', '13', '185', '22', 'LH109', '<p>LH-109 Automatic Melting Point Apparatus (Graphical Display) a research grade instrument with 128x64 Graphical LCD display, Icon based navigation menu for ease of operation, Programmable Ramp rates (slow, medium and Rapid). Storage up to 1000 results, Quick Cooling with Integrated fans. Audio and Visual Indications for System Status, Range ambient to 300&deg;C, USB Interface to PC. Power 230V 210 % AC.</p>', '30500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1414', '13', '185', '22', 'LH115', '<p>LH-115 Digital Melting Point Apparatus Within built Silicon Oil Bath and Stirrer Adjustable heating rate and stirrer speed. Range upto 275&deg;C with readability of 1&deg;C.</p>', '18300', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1415', '13', '186', '15', 'GVMPALDIE', 'Melting Point Apparatus Aluminum Die cast', '2500', '1', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1416', '13', '186', '15', 'GVMPR', '<p>Melting Point Apparatus Regular</p>', '3000', '0', '0', '1', '08-07-2022', NULL, NULL, NULL, NULL, NULL, '2022-07-08 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1417', '13', '186', '15', 'GVMPD', 'Melting Point Apparatus Digital', '10000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1418', '13', '187', '8', '', 'Melting Point Apparatus Economy', '1750', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1419', '13', '188', '15', 'GVIR5', 'IR Moisture Balance 5 gms', '17500', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1420', '13', '188', '15', 'GVIR10', 'IR Moisture Balance 10 gms', '17500', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1421', '13', '188', '15', 'GVIR25', 'IR Moisture Balance 25 gms', '17500', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1422', '13', '189', '15', '', 'IR Moisture Tray Pkt of 80 (Spare Alluminium Foil Pan for Digital Balance )', '4500', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1423', '13', '189', '15', '', 'Spare disposable Alluminium pan for Digital IR Moisture Balance ', '60', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1424', '13', '190', '22', 'LH76', '<p>LH-76 Digital Moisture Balance with Weighing Range SOg, Readability lmg, Repeatability (3g samples) 0.20%, Minimum Sample Amount O.Sg, Advised Sample Amount 3-lOg, Heat up timel-99 minutes, 1 minute Interval,Temperature Program Standard Terminal Control Timing, Automatic, Heating Temperature Range 50-180&deg;C,Showing Content Moisture%, Solid%, Weight, Time, Data etc Heating Source Halogen Lamp Pan Size 100mm.Window matrix liquid crystal display (LCD) High precision heat insulation. Automatic peeling function. Halogen drying method. Highly accurate &amp; stable. NEW</p>', '67000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1425', '13', '191', '0', '', '<p>UniBloc Electronic Moisture Balance</p>', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-25 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1426', '13', '191', '37', 'MOC63U', 'Model MOC63u External cali, Display 1mg/0.001g, capacity 62g, pan size 95 mm', '160000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1427', '13', '191', '37', 'MOC120H', 'Model MOC120H External cali, Display 1mg/0.001, capacity 120g, pan size 130 mm', '525000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1428', '13', '192', '35', 'SES50MA', '<p>Model SES50MA Capacity 50g, Resolution 0.001g, Pan size 90mm&Oslash;, Touch Screen, Auto external calibration</p>', '61750', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1429', '13', '192', '35', 'SES110MA', '<p>Model SES110MA Capacity 110g, Resolution 0.001g, Pan size 100mm&Oslash;, Touch Screen, Auto external calibration</p>', '69500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1430', '13', '192', '35', 'SESPRINTER', 'Statistic Lab Data Printer', '18750', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1431', '13', '192', '35', 'DENSITYKITSOLID', 'Density Kit for Solid', '12500', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1432', '13', '192', '35', 'DENSITYKITLIQUID', 'Density Kit for Liquid', '12500', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1433', '13', '192', '35', 'WIFI21CRF', 'WiFi Based 21 CRF with Ultimate Data saving', '39070', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1434', '13', '193', '26', ' PMS714', 'Soil Moisture meter Lutron PMS 714                                                                                   ', '14100', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1435', '13', '193', '26', 'PMS713', 'Moisture Meter built in pins LUTRON Model PMS 713. Range 6 TO 40%, For Wood And 0-100% For cotton, Paper etc', '9500', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1436', '13', '193', '26', 'VG200D', 'Soil Moisture Meter VG 200 Digital', 'POR', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1437', '13', '194', '26', 'MS7000 ', 'MS-7000 Wood moisture meter,Range: 9% to 30% moisture content, 9 matarial species groups in memory, Max. min. Data hold, Self-calibration, RS-232 interface', '12000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1438', '13', '194', '26', 'MS7003', 'MS-7003 Digital and LED Iidicator, Range 0-40% for Wood And 0-100% Concrete and other material With Aditional sensor', '9500', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1439', '13', '195', '8', '', 'Moisture Meter for Grains in bags with 12&#8221; inserting Probe China made GMM 7821 Model Range 8 - 20 %', '4000', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1440', '13', '195', '8', '', 'Moisture Meter for Grains in bags with 12&#8221; inserting Probe China make GMM 7002 (or) Equvalent Model Range5 - 30 %', '4750', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1441', '13', '195', '8', '', 'Moisture Meter Digital 5 to 45% with built in pins handy China made for paper / wood etc.', '1250', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1442', '13', '196', '42', '', 'Testo 606-1 Wood/ Material Moisture meter 8.8 to 54.8 % by weight beech, spruce, larch, birch, cherry, walnut, 7.0 to 47.9 % by weight oak, pine, maple, ash-tree, douglas fir, meranti 0.9 to 22.1 % by weight\r\ncement screed, concrete 0.0 to 11.0 % by weight anhydrite screed 0.7 to 8.6 % by weight cement mortar\r\n0.6 to 9.9 % by weight lime mortar, plaster 0.1 to 16.5 % by weight bricks', '7280', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1443', '13', '197', '0', '', '<p>Digital Moisture Meter measure % moisture in the grains and immediately indicates the result on LCD display. Just pour the sample and read % moisture. Deliver 1-2 weeks after confirming the grains name to measured.Made to order for 1-8 combination of grains. Please Specify Grains like Maize,Groundnut,Paddy,Rice,Sunflower,Etc.while ordering.</p>', '', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-07-04 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1444', '13', '197', '8', '', 'Moisture Meter  Model DMA 1  for specific one grain', '7800', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1445', '13', '197', '8', '', 'Moisture Meter  Model DMA 2  for specific two grains ', '8050', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1446', '13', '197', '8', '', 'Moisture Meter  Model DMA 3 for specific three grains', '8300', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1447', '13', '197', '8', '', 'Moisture Meter  Model DMA 4  for specific four grains ', '8550', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1448', '13', '197', '8', '', 'Moisture Meter  Model DMA 5 for specific five grains ', '8800', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1449', '13', '197', '8', '', 'Moisture Meter  Model DMA 6 for specific six grains ', '9050', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1450', '13', '197', '8', '', 'Moisture Meter  Model DMA 7 for specific seven grains ', '9300', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1451', '13', '197', '8', '', 'Moisture Meter  Model DMA 8 for specific eight grains ', '9550', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1452', '13', '198', '15', 'GV1MLH', 'GV-1MLH Magnetic Stirrer 1 litre Capacity', '2100', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1453', '13', '198', '15', 'GV2MLH', 'GV-2MLH Magnetic Stirrer 2 litre Capacity', '2750', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1454', '13', '199', '33', '', 'REMI ML - Digital Speed Indicator & Without Hot Plate    REMI MLH -Digital Speed Indicator & With Hot Plate ', '', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1455', '13', '199', '33', 'MS500', 'Magnetic Stirrer REMI MS-500', '3500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1456', '13', '199', '33', 'IML', 'Magnetic Stirrer REMI IML(1 Litre)', '6800', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1457', '13', '199', '33', 'IMLH', 'Magnetic Stirrer REMI IMLH', '8400', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1458', '13', '199', '33', '2ML', 'Magnetic Stirrer REMI 2ML', '7000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1459', '13', '199', '33', '2MLH', 'Magnetic Stirrer REMI 2MLH(2 Litter)', '9200', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1460', '13', '199', '33', '5ML', 'Magnetic Stirrer REMI 5ML(5 Liter)', '9000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1461', '13', '199', '33', '5MLH', 'Magnetic Stirrer REMI 5MLH', '11600', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1462', '13', '200', '33', 'MS800PLUS ', 'MS800 PLUS Magnetic Stirrer 800 ml,Capacity Speed 1500 RPM Remi ', '10800', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1463', '13', '200', '33', '5MLHPLUS', '<p>5 MLH PLUS Magnetic Stirrer with SS Hot Plate (Max.temp.340&deg;C), LCD display of speed &amp; temp with PT-1000 probe &amp; Stand</p>', '33000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1464', '13', '200', '33', '10MLHPLUS ', '<p>10 MLH PLUS Magnetic Stirrer with CERAMIC Hot Plate ( TEMP 550&deg;C) LCD display of speed &amp; temp with PT-1000 probe &amp; stand</p>', '56000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1465', '13', '200', '33', '15MLHPLUS', '<p>15 MLH Plus Magnetic Stirrer with Allu. Alloy Plate temp. 450&deg;C LCD display of speed &amp; temp with external PT-1000 probe &amp; stand</p>', 'Discontinue', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1466', '13', '200', '33', '20MLPLUS ', '20 ML Plus Magnetic stirrer 1500 RPM 20 Liter \r\nCapacity ', '31500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1467', '13', '200', '33', 'MPS1 ', 'MPS 1 Remi Microplate Shaker Speed Setting 300 to 800 RPM Suitable for Micro centrifuge tube 1.5 ml or 2.00 ml ', '17500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1468', '13', '201', '33', 'RQ121D ', 'Model RQ121/D Shaft dia in mm 8X250 Speed 200 - 2000 Rpm, Stirring capacity 10 Ltr, Speed Regulator with digital RPM ', '10500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1469', '13', '201', '33', 'RQG121D', 'Model RQG121/D Shaft dia in mm 6X250, Speed 50 - 550 Rpm, Stirring capacity 5 Ltr, Speed Regulator Inbuilt with digital RPM  ', '13500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1470', '13', '201', '33', 'RQM122R', 'Model RQM122/R Shaft dia in mm 6X250, Motor HP 1/20hp, Speed 800 - 4000 Rpm, Stirring capacity 7Ltr Mount On  ', '8400', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1471', '13', '201', '33', ' RQ122D', 'Model RQ122/D Shaft dia in mm 6X250, Motor HP 1/20hp Speed 800 - 4000 Rpm, Stirring capacity 7Ltr Remote ', '10200', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1472', '13', '201', '33', 'RQ124AD', 'Model RQ 124A/D Shaft dia in mm 8X350, Motor HP 1/8HP Speed 300 - 4000 Rpm, Stirring capacity 20Ltr Remote ', '12500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1473', '13', '201', '33', 'RQT124AD', 'Model RQT124A/D Shaft dia in mm 8X350, Motor HP 1/8HP Speed 300 - 4000 Rpm, Stirring capacity 20Ltr Remote ', '17000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1474', '13', '201', '33', ' RQ126D', 'Model RQ126/D Shaft dia in mm 10X450mm, Speed 120 - 2000 Rpm, Stirring capacity 25 Ltr, Remote with digital speed  ', '15500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1475', '13', '201', '33', 'RQ127D', 'Model RQ127/D Shaft dia in mm 8X240, Motor HP 1/8HP, Speed 300 - 6000 Rpm, Stirring capacity 8Ltr, Remote ', '14600', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1476', '13', '201', '33', 'RQ127AD', 'Model RQ127A/D Shaft dia in mm 8X275, Motor HP 1/8HP, Speed 300 - 8000 Rpm, Stirring with 50 ml homogeniser', '14500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1477', '13', '201', '33', 'RQT127AD', 'Model RQT127A/D Shaft dia in mm 8X275, Motor HP 1/8HP, Speed 300 - 8000 Stirring  with 50 ml  homogeniser', '18000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1478', '13', '201', '33', 'HOMO510', '5 ml or 10 ml capacity For  homogeniser', '1400', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1479', '13', '201', '33', 'HOMO1525', '15 ml or 25 ml capacity  For  homogeniser', '1500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1480', '13', '201', '33', 'HOMO50100', '50 ml or 100 ml capacity  For  homogeniser', '1800', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1481', '13', '201', '33', ' RQT127D', 'Model RQT127/D Medium duty high speed Emulsifier with 1/8 Motor, Digital Speed Indicator & speed regulator.', '18500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1482', '13', '201', '33', 'RQ128D', 'Model RQ128/D Shaft dia in mm 8X310 Motor HP 1/20HP, Speed 50 - 150 Rpm Stirring capacity 3kgs, Remote ', '18000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1483', '13', '201', '33', 'RQ128DD ', 'Model RQ128D/D Shaft dia in mm 12X450 Motor HP 1/2HP Speed 50 - 280 Rpm Stirring capacity 20kgs Remote ', '25000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1484', '13', '201', '33', 'RQG128CD', 'Model RQG128C/D Shaft dia in mm 10X450 Speed 50 - 500 Rpm Stirring capacity 20Lts Remote ', '18000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1485', '13', '201', '33', 'RQ129D', 'Model RQ129/D Shaft dia in mm 10X550 Speed 100 - 1400 Rpm, Stirring capacity 50Ltr Remote with digital speed ', '17000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1486', '13', '201', '33', 'RQG126D', 'Model RQG126/D Shaft dia in mm 8X450 Speed 50 - 750 Rpm Stirring capacity 15Ltr Remote with digital speed  ', '18500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1487', '13', '201', '33', 'RQG129D', 'Model RQG129/D Shaft dia in mm 10X550, Speed 50 - 550 Rpm, Stirring capacity 25Ltr, Remote with digital speed  ', '21000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1488', '13', '201', '33', 'RQ130BD', 'Model RQ130B/D Shaft dia in mm 12X475, Motor HP 2/3HP, Speed 300 - 5000 Rpm, Stirring capacity 35Lts, Remote ', '31000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1489', '13', '201', '33', 'RQ134LD', 'Model RQ134L/D Shaft dia in mm 12X450, Motor HP 1/2HP, Speed 900 - 5000 Rpm, Stirring capacity 60Lts, Remote ', '21000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1490', '13', '201', '33', 'RQ134 HD ', 'Model RQ134 H/D Shaft dia in mm 12X450, Motor HP 2/3HP, Speed 500 - 5000 Rpm, Stirring capacity 80Lts, Remote ', '23500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1491', '13', '201', '33', 'RQT134HD', 'Model RQT134H/D Shaft dia in mm 12X450, Motor HP 2/3HP, Speed 500 - 5000 Rpm, Stirring capacity 80Lts, Remote ', '31000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1492', '13', '201', '33', 'RQ140D', 'Model RQ140/D Shaft dia in mm 10X730, Speed 100 - 1400 Rpm, Stirring capacity 40Ltr, Frequency Drive  ', '54000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1493', '13', '201', '33', 'RQ140DFP', 'Model RQ140/DFP Shaft dia in mm 10X730, Speed 100 - 1400, Stirring capacity 40Ltr, Frequency Drive  ', '85000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1494', '13', '202', '33', 'RQ5PLUS', 'RQ 5 PLUS Mini Stirrer With Burshless DC Motor, LCD Display of Speed ( 5 litre Capacity ) ', '15500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1495', '13', '202', '33', 'RQ20PLUS', 'RQ-20 Plus Direct Drive Stirrer with brushless Motor, LCD Display of Speed & Torque (20 Letter Capacity), Speed 50 to 2200rpm', '60000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1496', '13', '202', '33', 'RQ40PLUS', 'RQ-40 Plus Direct Drive Stirrer with brushless Motor,LCD Display of Speed & Torque (40 Letter Capacity) Speed 50 to 2200rpm', '72000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1497', '13', '203', '8', '', 'Labomed VISION 2000 LED ', '27500', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1498', '13', '204', '32', 'RYS2', 'RYS-2 Dissecting Monocular Microscope, heavy round cast iron base for greater stability, Eye piece pipe, knobs & lens holding arm,with black and white wide square glass stage size 85mm X 75mm having two stage clips. Magnification 10X and 20X, Illumination by Plano-concave refelector mirror fitted in fork for light refelection', '1225', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1499', '13', '204', '32', 'RYS3', 'RYS-3 Heavy round base providing convenience for lifting and movement.Smooth racks & pinion mechanism operated for easy working during dissection.Plano-concave mirror in fork provides illumination in day light or under artificial light.', '1950', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1500', '13', '205', '32', '', 'Monocular, Eye piece Huygenian 15x,10X, Objective JIS Achro 10x, 40x(SL), 120mmx120mm mechanical stage with clip, Separate coarse and fine movement, Condenser Abbe N A 1.25 with IRIS diaphram,Palno concave mirror for light source, Optional LED sub stage ', '', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1501', '13', '205', '32', 'RYS5', 'RYS-5 Student Microscope Fixed condenser, fixed Abbe N A 1.25 with IRIS diaphram', '3100', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1502', '13', '205', '32', 'RYS7', 'RYS-7 Student Microscope Movable condenser, movable Abbe N A 1.25 with IRIS diaphram', '3500', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1503', '13', '205', '32', 'RYS9', 'RYS-9 Medical Microscope Movable condenser, movable Abbe N A 1.25 with IRIS diaphram, with Blue filter & 100X', '6000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1504', '13', '206', '32', 'RYS20M', 'RYS-20 Monocular Microscope, Monocular Tube, 45\' Inclined,360\' rotable, Wide field Eye piece 10X, Objective JIS 4x,10x, 40x(S) and 100x Oil(S), 140mmx140mm mechanical stage with cross travel 90(x) X 65mm (y) on ball bearing with coaxial controls, Separate coarse and fine movement, Movable abbe condenser N A 1.25 with asperic lens, IRIS diaphram, Illumination system LED or Halogen', '8400', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1505', '13', '206', '32', 'RYSINFYSTARM', 'RYS-Infystar Monocular Reasearch Microscope, Monocular head 45\' Inclined, 360\' Rotatable, Wide field 10x/18mm focusable Eyepiece with foldable eye guard, Objectives 4x,10x,40x(S), 100x Oil(S) Mechanical stage, single plate stage size 140mmx132mm X/Y Travel range 90mmx55mm, Sub stage Abbe condenser NA 1.25 with aspheric lens, IRIS diaphram, Illumination Halogen or LED', '12800', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1506', '13', '206', '32', 'RYS700M', 'RYS-700 Research Monocular LED Microscope,360\'rotatable 30\'inclined Monocular head, Eyepieces High point paired WF 10x/18mm, Semi-Plan Achromat DIN objectives 4x, 10x, 40x (s), 100x(s,oil), Mechanical stage doube plate stage size 190 x 140mm, X-Y travel range 90mm x 65mm, Double specimen SS clip, Sub stage Abbe condenser NA 1.25 with aspheric lens, Iris diaphragm with frosted white/blue filter, Illumination, halogen 6v 20w light source or LED 3w', '15000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1507', '13', '207', '32', 'RYS22B', 'RYS-22 Binocular Microscope, Sliding Binocular head,45\' Inclined,360\' rotable, Wide field Eye piece 10X / 20mm, Achro objectives 4x,10x, 40x(S) and 100x Oil(S), 190mm x140mm mechanical stage with XY travel range 90mmX65mm, Coaxial coarse and fine movement, Movable abbe condenser N A 1.25 with asperic lens.IRIS diaphram with  Frosted white/Blue Filter, Illumination system with 6v 20W Halogen bulb or LED', '9750', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1508', '13', '207', '32', 'RYSINFYSTARB', 'RYS-Infystar Binocular Reasearch Microscope, Binocular head 45\' Inclined, 360\' Rotatable, Wide field 10x/18mm focusable Eyepiece with foldable eye guard, Objectives 4x,10x,40x(S),100x Oil(S) Mechanical stage, single plate stage size 140mmx132mm X/Y Travel range 90mmx55mm, Sub stage Abbe condenser NA 1.25 with aspheric lens, IRIS diaphram, Illumination Halogen or LED', '13500', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1509', '13', '207', '32', 'RYSINFINIXB', 'RYS- Infinix Binocular LED Microscope , An Adaptable System for the Colleges & Laboratories. Sliding Binocular Head 45\'Inclined, 360\'rotatable, Eyepieces Wide field 10x/18mm, lockable, antifungal, Semi -Plan Achromat DIN objectives 4x,10x,40x (s),100x(s,oil), Mechanical stage 140 x 132mm, X-Y travel range 90mm x 55mm with low-height controls, Abbe condenser NA 1.25 with aspheric lens, IRIS diaphragm with blue daylight filter, Intensity controlled LED (optional 6V-20W Halogen illumination) ', '15000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1510', '13', '207', '32', 'RYS700B', 'RYS-700 Research Binocular LED Microscope,Single mould aluminium stand with hand rests for enhanced comfort and stability. Butterfly type Binocular head, 30\'inclined,360\' Rotable,Eypepiece Wide field 10x / 20mm.Achro Objectives 4x,10x,40x(S),100x Oil(S) Mechanical stage, double plate stage size 190mmx140mm X/Y Travel range 75mmx50mm, Double specimen holder clip, Sub stage Abbe condenser NA 1.25 with aspheric lens, IRIS diaphram with blue daylight filter, Illumination Halogen 6v-20w or 3w LED', '18500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1511', '13', '207', '32', 'RYS700PREMIAB', 'RYS-700 Premia Binocular LED Microscope, 360\' Rotable 30\' sidentoff Binocular Head, Highpoint paired WF 10x/28mm Eyepieces, Achro Objectives 4x,10x,40x(S),100x Oil(S) Mechanical stage, double plate stage size 190X140mm X/Y Travel range 75mm x 50mm, Double specimen SS clip, Sub stage Abbe condenser NA 1.25 with aspheric lens, IRIS diaphram with frosted white/blue filter, Illumination Kohler Q-LED 3.5W 3V', '23000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1512', '13', '207', '32', 'RYSICONIC55B', 'RYS-ICONIC-55 Binocular Research Microscope Single mould aluminium stand with hand rests for \r\nenhanced comfort and stability, Sliding type Binocular head, 30\'inclined, 360\' Rotable, Eypepiece Wide field 10x/18mm, DIN Semi Plan Achromatic Objectives 4x,10x,40x(S),100x Oil(S) Mechanical stage, double plate stage size 190mmx140mm X/Y Travel range 75mmx50mm, Double specimen holder clip, Sub stage Abbe condenser NA 1.25 with aspheric lens,  IRIS diaphram, Illumination Halogen or LED ', '23750', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1513', '13', '207', '32', 'RYSICONIC77B', 'RYS-ICONIC-77 Binocular Research Microscope,Single mould aluminium stand with hand rests for \r\nenhanced comfort and stability, Butterfly type Binocular head, 30\'inclined, 360\' Rotable, Eypepiece Wide field 10x/20mm, Achro Objectives 4x,10x,40x(S),100x Oil(S) Mechanical stage, double plate stage size 190mmx140mm X/Y Travel range 75mmx50mm, Double specimen holder clip, Sub stage Abbe condenser NA 1.25 with aspheric lens,  IRIS diaphram, Illumination Halogen or LED ', '28000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1514', '13', '207', '32', 'RYSICONIC99B', 'RYS-ICONIC-99 Binocular Research Microscope, Single mould aluminium stand with hand rests for enhanced comfort and stability, Butterfly type Binocular head, 30\'inclined, 360\' Rotatable, Eypepiece WF 10x/20mm with anti-reflection & anti-fungal coatings. DIN Plan Achro Objectives 4x,10x,40x(S),100x Oil(S), Anti-fungal. Mechanical stage Rackless X Axis,double plate stage size 190mmx140mm X/Y Travel range 75mmx50mm, Double specimen holder clip.Sub stage Abbe condenser NA 1.25 with aspheric lens, IRIS diaphram with Blue daylight filter, Illumination Halogen 6v-20w or 3w LED ', '38000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1515', '13', '207', '32', 'RYSNE620B', 'RYS-NE-620 Binocular Research Microscope, 30 Inclined Binocular head, Eyepiece 10/22mm Infinity Plan Achro objectives 4,10,40(s),100 Oil(s)or 100x water, Synchronous belt stage size 230 X 150mm, Moving range 78 X 54mm, Abbe condenser NA 1.25, Coaxial coarse & fine control, Koehler Q-LED 3.5W 3V illumination with automatic swtiching and sleep timer.', '125000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1516', '13', '208', '32', 'RYS22T', 'RYS-22 Trinocular Microscope, Sliding Trinocular head,45\' Inclined,360\' rotable, Wide field Eye piece 10X / 20mm, Achro objectives 4x,10x, 40x(S) and 100x Oil(S), 190mm x140mm mechanical stage with XY travel range 90mmX65mm.Coaxial coarse and fine movement, Movable abbe condenser N A 1.25 with asperic lens.IRIS diaphram with  Frosted white/Blue Filter,Illumination system with 6v 20W Halogen bulb', '11000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1517', '13', '208', '32', 'RYSINFYSTART', 'RYS-Infystar Trinocular Reasearch Microscope, Trinocular head 45\' Inclined, 360\' Rotatable. Wide field 10x/18mm focusable Eyepiece with foldable eye guard.Objectives 4x,10x,40x(S),100x Oil(S) Mechanical stage,single plate stage size 140mmx132mm X/Y Travel range 90mmx55mm. Sub stage Abbe condenser NA 1.25 with aspheric lens, IRIS diaphram, Illumination Halogen or LED', '15000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1518', '13', '208', '32', 'RYSINFINIXT', 'RYS- Infinix Trinocular LED Microscope , An Adaptable System for the Colleges & Laboratories. Sliding Trinocular Head 45\'Inclined, 360\'rotatable. Eyepieces Wide field 10x/18mm, lockable, antifungal. Semi -Plan Achromat DIN objectives 4x,10x,40x (s),100x(s,oil), Mechanical stage 140 x 132mm, X-Y travel range 90mm x 55mm with low-height controls, Abbe condenser NA 1.25 with aspheric lens, IRIS diaphragm with blue daylight filter, Intensity controlled LED (optional 6V-20W Halogen illumination) ', '16500', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1519', '13', '208', '32', 'RYS700RESEARCHT', 'RYS-700 Research Trinocular LED Microscope, Single mould aluminium stand with hand rests for enhanced comfort and stability, Butterfly type Trinocular head, 30\'inclined,360\' Rotable, Eypepiece Wide field 10x / 20mm.Achro Objectives 4x,10x,40x(S),100x Oil(S) Mechanical stage, double plate stage size 190mmx140mm X/Y Travel range 75mmx50mm, Double specimen holder clip.Sub stage Abbe condenser NA 1.25 with aspheric lens, IRIS diaphram with blue daylight filter, Illumination Halogen 6v-20w or 3w LED', '17500', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1520', '13', '208', '32', 'RYS700PREMIAT', 'RYS-700 Premia Trinocular LED Microscope,360\' Rotable 30\' sidentoff Trinocular Head, Highpoint paired WF 10x/28mm Eyepieces, Achro Objectives 4x,10x,40x(S),100x Oil(S) Mechanical stage, double plate stage size 190X140mm X/Y Travel range 75mm x 50mm, Double specimen SS clip, Sub stage Abbe condenser NA 1.25 with aspheric lens, IRIS diaphram with frosted white/blue filter, Illumination Kohler Q-LED 3.5W 3V', '24000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1521', '13', '208', '32', 'RYSICONIC55T', 'RYS-ICONIC-55 Trinocular Research Microscope Single mould aluminium stand with hand rests for enhanced comfort and stability, Sliding type Trinocular head, 30\'inclined, 360\' Rotable, Eypepiece Wide field 10x/18mm, DIN Semi Plan Achromatic Objectives 4x,10x,40x(S),100x Oil(S) Mechanical stage, double plate stage size 190mmx140mm X/Y Travel range 75mmx50mm, Double specimen holder clip, Sub stage Abbe condenser NA 1.25 with aspheric lens,  IRIS diaphram, Illumination Halogen or LED ', '25000', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1522', '13', '208', '32', 'RYSICONIC77T', 'RYS-ICONIC-77 Trinocular Research Microscope, Single mould aluminium stand with hand rests for \r\nenhanced comfort and stability, Butterfly type Trinocular head, 30\'inclined, 360\' Rotable, Eypepiece Wide field 10x/20mm, Achro Objectives 4x,10x,40x(S),100x Oil(S) Mechanical stage, double plate stage size 190mmx140mm X/Y Travel range 75mmx50mm, Double specimen holder clip, Sub stage Abbe condenser NA 1.25 with aspheric lens, IRIS diaphram, Illumination Halogen or LED ', '30000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1523', '13', '208', '32', 'RYSICNONIC99T', 'RYS-ICONIC-99 Trinocular Research Microscope, Single mould aluminium stand with hand rests for enhanced comfort and stability, Butterfly type Trinocular head, 30\' inclined, 360\' Rotatable, Eypepiece WF 10x/20mm with anti-reflection & anti-fungal coatings, DIN Plan Achro Objectives 4x,10x,40x(S),100x Oil(S), Anti-fungal. Mechanical stage Rackless X Axis, double plate stage size 190mmx140mm X/Y Travel range 75mmx50mm, Double specimen holder clip, Sub stage Abbe condenser NA 1.25 with aspheric lens, IRIS diaphram with Blue daylight filter, Illumination Halogen 6v-20w or 3w LED ', '40000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1524', '13', '208', '32', 'RYS7DELTAT', '<p>RYS-7 Delta Trinocular Research LED Microscope,Viewing head-Compensation Free Trinocular Head, Inclined at 30 &deg;48mm-75mm, Eyepiece WF10&times;/22mm with rubber eye-cup, Infinite PLAN objectives 4&times;, 10&times;, 40&times;(s),100&times;ion(s)Oil, Double layers mechanical stage Double specimen holder clip, Stage Size 190mm &times; 160 mm, Moving Range 75mm&times;50mm, N.A.1.25Abbe condenser with iris diaphragm &amp; filter holder, Coaxial coarse &amp; fine focusing adjustment, light Source Koehler Q-LED 3.5W, 3V illumination with variable control.</p>', '50000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1525', '13', '208', '32', 'RYS7ELITET', '<p>RYS-7 Elite Trinocular Research Microscope, Trinocular Head Inclined at 30 &deg;, Eyepiece WF 10&times;/22mm High contrast Infinity corrected PLAN Achro objectives 4&times;,10&times;,40&times;(s),100&times;ion(s)Oil, Double layers mechanical stage, Double specimen holder clip, Stage Size 216mm&times;140mm, X/Y Travel range 90mm X 65mm, Abbe condenser NA 1.25 with Aspheric lense, IRIS diaphragm with frosted white filter, Coaxial coarse &amp; fine focusing, &nbsp;Koehler Q-LED 3.5W, 3V illumination with variable control.</p>', '60000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1526', '13', '209', '32', 'RYSNEXUS3MV', 'Nexus-3 Multi Viewing Microscope, Compensation free Trinocular Head, Inclined 30\'(50mm-70mm), 2 Binocular head, Interpupillary distance adjustable 50mm-75mm, Eyepiece Plan WF 10X/22mm, Infinity Plan Objectives 4X,10X,40X,100X, X axis double layer mechanical stage size 190mm X 160mm, moving range 80mm X 50mm, Coaxial & fine focusing, Light source halogen bulb 12V/100w.', '275000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1527', '13', '209', '32', 'RYSNEXUS5MV', 'Nexus-5 Multi Viewing Microscope, Compensation free Trinocular Head.Inclined 30\'(50mm-70mm), 4 Binocular head, Interpupillary distance adjustable 50mm-75mm, Eyepiece Plan WF 10X/22mm, Infinity Plan Objectives 4X,10X,40X,100X, X axis double layer mechanical stage size 190mm X 160mm, moving range 80mm X 50mm, Coaxial & fine focusing, Light source halogen bulb 12V/100w.', '440000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1528', '13', '209', '32', 'RYSNEXUS10MV', 'Nexus-10 Multi Viewing Microscope, Compensation free Trinocular Head.Inclined 30\'(50mm-70mm), 9 Binocular head, Interpupillary distance adjustable 50mm-75mm, Eyepiece Plan WF 10X/22mm, Infinity Plan Objectives 4X,10X,40X,100X, X axis double layer mechanical stage size 190mm X 160mm, moving range 80mm X 50mm, Coaxial & fine focusing, Light source halogen bulb 12V/100w.', '1095000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1529', '13', '209', '32', 'RYSPH777MV', 'RYS-PH-777 Multi Viewing Microscope, Obervation head one number high transmission, Trinocular head 45\'inclined, 360\' Rotatable, Four number compensation free Binocular head inclined 45\'for multi viewing,  Antifungal coated, 5 pairs of WF Eyepieces 10X/18mm with diopter adjustment, DIN Plan Achro Objectives 4X,10X,40X,100X anti fungal coated, Double plate stage size 140 X 120, X/Y Travel range 100mm X 60mm, Abbe condenser NA 1.25, IRIS diaphram with blue daylight filter, Coaxial & fine focusing, True kohler Illumination, Halogen lamp 24V-100W/LED 3W with brightness controller.', '250000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1530', '13', '209', '32', 'RYSPH999MV', 'RYS-PH-999 Multi Viewing Microscope, Obervation head one number high transmission, Trinocular head 30\' inclined, 360\' Rotatable.Four number compensation free Binocular head inclined 45\'for multi viewing. Antifungal coated, 5 pairs of WF Eyepieces 10X/18mm with diopter adjustment, DIN Plan Achro Objectives 4X,10X,40X,100X anti fungal coated, Double plate stage size 140 X 120, X/Y Travel range 100mm X 60mm, Abbe condenser NA 1.25, IRIS diaphram with blue daylight filter, Coaxial & fine focusing, True kohler Illumination, Halogen lamp 24V-100W/LED 3W with brightness controller.', '750000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1531', '13', '210', '32', 'RYS44S', 'RYS-44 series Stereo Microscope has two Magnification levels(10x/20x,10x/30x or 20x/40x). It is an Ideal Microscope for student learning and classroom teaching, also a perfect device for viewing Jewel, PCB, Insects and so on. WF Eyepiece 10x/20mm, Binocular head 45\' Inclined, 360\'Rotatable, Interpupillary distance adjustment 55-75mm. 12V /10W Incandescent lamp,12V/10W Halogen Lamp', '13500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1532', '13', '210', '32', 'RYS45ES', 'RYS-45e series Stereo Microscope can provide crystal clear sharp images with high resolution and good depth within a board field of view. Magnification 7X-45X,3.5X-270X,WF Eyepiece 10x/20mm, Objective 0.7X-4.5X stereo zoom,Binocular head 45\' Inclined, 360\'Rotatable,Indicator LED cursor brightness adjustable.', '34500', '1', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1533', '13', '210', '32', 'RYS674SS', 'RYS-6745 series Stereo Microscope is fully coated optical system with super high resolution. Ideally suitable for Industrial as well as for biological research where high precision, Maximum working distance and large field coverage is required. Eyepiece WF 15X/FN 15, WF 20X/FN 10, Binocular head 45\' Inclined, 360\' Rotatable, can be locked in any position desired. Interpupillary distance adjustment 54-75mm, working distance 30-165mm, Illumination transmitted & reflected 5v/3w LED, with independent switches and adjustable intensity.', '42000', '1', '0', '1', '25-06-2022', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1534', '13', '210', '32', 'RYS45SS', 'RYS-45s series Stereo Microscope is fully coated optical system with super high resolution.Eyepiece WF 10X/22mm, Binocular head 45\' Inclined, 360\'Rotatable,can be locked in any position desired. Interpupillary distance adjustment 52-75mm, Objective 0.8X5.0x Stereo zoom,  zoom ratio 6.3/Aux lens 0.5X,2.0X Illumination transmitted & reflected 5v/3w LED, with independent switches and adjustable intensity.', '45000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1535', '13', '210', '32', 'RYSDMSZ20S', 'RYS-DMSZ20 series Digital Stereo Zoom Microscope integrated zoom optical module with high definition camera. It can be conveniently used in a narrow and small space. According to ergonomic principles, its internal optical corner design and angle adjustment of the display screen, allow operator to look at the display in a flat view. Through the HDMI HD interface, it can connect to another display simultaneously. Magnification 17x/10x, Objective 0.7x-4.5X, Output HDMI,USB,SD card, Illumination comes with 56LED ring light.', '85000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1536', '13', '210', '32', 'RYS48ABS', 'RYS-48A High Performance parallel Optical Stereo Zoom Microscope - Binocular Head ( Ask for Specifications)', '230000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1537', '13', '210', '32', 'RYS48ATS', 'RYS-48A High Performance parallel Optical Stereo Zoom Microscope - Trinocular Head ( Ask for Specifications)', '275000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1538', '13', '210', '32', 'RYSSZX12S', 'RYS-SZX12 Research Stereo Zoom Microscope ( Ask for Specifications)', '700000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1539', '13', '210', '32', 'RYS2D3DS', 'RYS-2D/3D Inspection Microscope ( Ask for Specifications)', '122000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1540', '13', '211', '32', 'RYS60RISM', 'RYS-60 Research Inverted Sytem Microscope, viewing head 20-45 tilting binocular head, inverted image, interpupillary distance 50-76mm, High eype point plan eyepiece PL10X/22mm, diopter adjustable,reticle attachable', 'POR', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1541', '13', '212', '32', 'RYSARM10B', 'RYS-ARM-10B Rayscope Microtome Regular Quality', '31000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1542', '13', '212', '32', 'RYSARM10A', 'RYS-ARM-10A Rasyscope Microtome High Precision Quality', '47500', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1543', '13', '213', '32', 'RYSICX40BIO', 'RYS-ICX-40 Biological Research Microscope( Ask for Specifications)', 'POR', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1544', '13', '213', '32', 'RYSIRX50BIO', 'RYS-IRX-50 Biological Research Microscope( Ask for Specifications)', 'POR', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1545', '13', '214', '32', '', 'RYS-Delta-7FLB LED Fluorescent Research Microscope (Ask for Specifications)', '', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1546', '13', '214', '32', 'RYS7FLBBLUE', 'Single Filter (Blue)', '100000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1547', '13', '214', '32', 'RYS7FLBG', 'Dual Filters( Blue & Green )', '200000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1548', '13', '214', '32', '', 'RYS-102 Fluorescent Research Microscope with Two Filter (Ask for Specifications)', '', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1549', '13', '214', '32', 'RYS102BG', '2 Filters ( Blue & Green )', '150000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1550', '13', '214', '32', 'RYS102BGUV', '4 Filters ( Blue & Green , Ultra Violet and Violet)', '200000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1551', '13', '214', '32', 'RYSSTAR9FL', 'RYS-Star-9FL Research Biological Fluorescent Microscope (5+1 Filters ) ( Blue & Green , Ultra Violet and Violet  , Blue Violet + One Empty Block) (Ask for Specifications)', '705000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1552', '13', '214', '32', '', 'RYS-106-FL Inverted Fluorescent Research Microscope (Ask for Specifications)', '', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1553', '13', '214', '32', 'RYS106FLBG', '2 Filters ( Blue & Green )', '445000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1554', '13', '214', '32', 'RYS106FLBGUV', '4 Filters ( Blue & Green , Ultra Violet and Violet )', '565000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1555', '13', '214', '32', 'RYS600FL', 'RYS-600-FL Research Biological Fluorescent Microscope (Ask for Specifications)', 'POR', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1556', '13', '214', '32', 'RYS60FL', 'RYS-60-FL Inverted Fluorescent Research Microscope (Ask for Specifications)', '675000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1557', '13', '215', '32', 'RYS105STISSUE', 'RYS-105s Research Tissue Culture Microscope (Ask for specifications)', '160000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1558', '13', '215', '32', 'RYS41TISSUE', 'RYS-41 Cell Culture Research Microscope (Ask for specifications)', 'POR', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1559', '13', '216', '32', 'RYSPR1', 'RYS-PR-1 Monocular Polarizing Microscope (Ask for specifications)', '30000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1560', '13', '216', '32', 'RYSPR2', 'RYS-PR-2 Binocular Polarizing Microscope (Ask for specifications)', '32000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1561', '13', '216', '32', 'RYSPR3', 'RYS-PR-3 Trinocular Polarizing Microscope (Ask for specifications)', '33000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1562', '13', '216', '32', 'RYSPR5', 'RYS-PR-5 Research Polarizing Microscope (Ask for specifications)', '42000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1563', '13', '216', '32', 'RYSSMARTPOL', 'RYS-Smart POL Research Polarizing Microscope (Ask for specifications)', '135000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1564', '13', '217', '32', 'RYSITMM', 'RYS-INFINIX Trinocular Metallurgical Microscope', '55000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1565', '13', '217', '32', 'RYSM40', 'RYS-M40 Inverted Metal Analysis Microscope ', '105000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1566', '13', '217', '32', 'RYSM50', 'RYS-M50 Inverted Metallurgical Microscope ', '150000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1567', '13', '217', '32', 'RYSM200', 'RYS-M200 Inverted Metallurgical Microscope ', '135000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1568', '13', '217', '32', 'RYSM500', 'RYS-M500 Upright Metallurgical Microscope ', '175000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1569', '13', '218', '32', '', 'RYS-20/20BD Inverted Dark and Bright Field Microscope', '', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1570', '13', '218', '32', 'RYS20BF', 'Bright Field', '190000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1571', '13', '218', '32', 'RYS20DF', 'BF/DF', '478000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1572', '13', '218', '32', 'RYS20DIC', 'RYS-20-DIC Inverted Dark and Bright Field Microscope', 'POR', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1573', '13', '219', '32', 'RYSTM200', 'RYS-TM-200 Tool Makers Microscope', '44000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1574', '13', '220', '32', 'RYSTM2', 'RYS-TM2 Two Motion Travelling Microscope', '6500', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1575', '13', '220', '32', 'RYSTM4', 'RYS-TM4 Three Motion Travelling Microscope', '8000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1576', '13', '220', '32', 'RYSTM6', 'RYS-TM6 Digital Travelling Microscope', 'POR', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1577', '13', '221', '32', 'RYSGM50', 'RYS-GM50 Gemological Binocular Microscope', 'POR', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1578', '13', '221', '32', 'RYSGM52', 'RYS-GM52 Gemological Trinocular Microscope', 'POR', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1579', '13', '222', '32', 'RYSOPM400SURGICAL', 'RYS-OPM-400 Surgical Operating Microscope', '285000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1580', '13', '222', '32', 'RYSOPM400ENT', 'RYS-OPM-400 Surgical ENT Microscope', '285000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1581', '13', '222', '32', 'RYSOPM400DENTAL', 'RYS-OPM-400 Dental Operating Microscope', '285000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1582', '13', '223', '32', 'C31MP', 'UA Series 3.1 MP Camera', '21000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1583', '13', '223', '32', 'C51MP', '<p>UA Series 5.1 MP Camera</p>', '24500', '1', '0', '1', '14-07-2022', '', '', '', '', NULL, '2022-07-14 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1584', '13', '223', '32', 'C10MP', 'UA Series 10.0 MP Camera', '35000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1585', '13', '223', '32', 'C63MP', '1080P HDMI Camera 6.3 MP', '60000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1586', '13', '223', '32', 'C63MPWIFI', '1080P HDMI Camera 6.3 MP with WiFi', '67500', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1587', '13', '223', '32', 'C5MPTOUCH', 'RYS Touch Digital touch Screen with built in android tab and 5.0 MP Camera', '55000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1588', '13', '224', '8', '', 'Microscope Spare Camera Lucida Mirror type', '800', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1589', '13', '224', '8', '', 'Microscope Spare Camera Lucida Prism type', '700', '0', '0', '1', '', NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1590', '13', '225', '32', 'MD130', '<p>MD 130 ,1.3 MP, Max. Resolution 1280*1024, Pixel size 2.2&micro;m*2.2&micro;m, Spectral range 400-650nm</p>', '12750', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1591', '13', '225', '32', 'MD300', '<p>MD 300 , 3.0 MP,Max. Resolution 2048*1536, Pixel size 2.2&micro;m*2.2&micro;m,Spectral range 400-650nm</p>', '14250', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1592', '13', '225', '32', 'MD500', '<p>MD 500 , 5.0 MP, Max. Resolution 2592*1944, Pixel size 2.2&micro;m*2.2&micro;m, Spectral range 400-650nm</p>', '16500', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2022-06-27 00:00:00', '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1593', '13', '226', '32', '', 'EY-PIECE', '', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1594', '13', '226', '32', 'EP1018', '10X/18mm WIDE FIELD EYE&#8208;PIECE PAIR \r\n', '1100', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1595', '13', '226', '32', 'EP1020', '10X/20mm WIDE FIELD EYE&#8208;PIECEP PAIR \r\n', '1500', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1596', '13', '226', '32', '', 'MECHANICAL STAGE', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1597', '13', '226', '32', 'MSCSP', 'Coaxial Single Plate Mechanical Stage', '1200', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1598', '13', '226', '32', 'MSCXM', 'Coaxial X-axis rackless Mechanical Stage ', '1500', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1599', '13', '226', '32', '', 'HEAD', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1600', '13', '226', '32', 'HEAD45B', '45 degree Bino Head Sliding Type', '1650', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1601', '13', '226', '32', 'HEAD30SB', '30 degree Sliding Head Bino', '2500', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1602', '13', '226', '32', 'HEAD30T', '30 degree Trino Head ', '3100', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1603', '13', '226', '32', 'HEAD30BB', '30 Degree Siedentopf Binocular Head butterfly type ', '5600', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1604', '13', '226', '32', 'HEAD30TB', '30 Degree Siedentopf Binocular Head butterfly type ', '7400', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1605', '13', '226', '32', '', 'LED Circuit', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1606', '13', '226', '32', 'LEDVC', 'LED Circuit with Volume Control', '1400', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1607', '13', '226', '32', 'LEDBB', 'LED Circuit With Volume Control & Battery Backup', '2400', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1608', '13', '226', '32', '', 'Phase Contrast attachment', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1609', '13', '226', '32', 'PCAST', 'Sliding Type phase contrast attachment with 10x , 40x phase objectives and centering Eyepiece and Green Filter', '30000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1610', '13', '226', '32', 'PCATT', 'Turret Type phase contrast attachment with 10x 20x, 40x,100xphase objectives and\r\ncentering Eyepiece and Green Filter', '35000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1611', '13', '226', '32', 'PCAIC', 'Infinity Corrected Turret Type phase contrast attachment with 10x 20x,40x ,100xphase objectives and\r\ncentering Eyepiece and Green Filter', '106000', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1612', '13', '226', '32', '', 'DIN FIXED (ACHROMAT)', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1613', '13', '226', '32', 'DFA4', '4X ', '410', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1614', '13', '226', '32', 'DFA10', '10X ', '550', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1615', '13', '226', '32', 'DFA20', '20X ', '750', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1616', '13', '226', '32', 'DFA40', '40X', '650', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1617', '13', '226', '32', 'DFA100', '100x (S) Oil ', '1350', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1618', '13', '226', '32', 'DFA40IT', '40x ( with imported Tip) ', '750', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1619', '13', '226', '32', 'DFA100IT', '100x (S)Oil (with imported Tip)', '1400', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1620', '13', '226', '32', '', 'DIN CENTERING (ACHROMAT)', '', '0', '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1621', '13', '226', '32', 'DCA4', '4X ', '500', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_code`, `product_name`, `product_rate`, `rcolor`, `pcolor`, `product_status`, `udate`, `product_desc`, `product_image`, `product_pdf`, `product_video`, `insertedat`, `updatedat`, `sortid`, `delete_date`, `delete_status`) VALUES ('1622', '13', '226', '32', 'DCA10', '10X ', '625', '0', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0', NULL, '0');
INSERT INTO `products` (`product_id`, `category_id`, `subcategory_id`, `brand_id`, `product_c