#
# TABLE STRUCTURE FOR: appln
#

DROP TABLE IF EXISTS `appln`;

CREATE TABLE `appln` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `appln_name` varchar(50) DEFAULT NULL,
  `image` varchar(50) DEFAULT NULL,
  `image1` varchar(50) DEFAULT NULL,
  `delete_status` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8;

INSERT INTO `appln` (`id`, `appln_name`, `image`, `image1`, `delete_status`) VALUES ('1', 'Hotels', '22962723162e8b4d3e55e1.jpg', '49496859262ea035db752d.jpg', '1');
INSERT INTO `appln` (`id`, `appln_name`, `image`, `image1`, `delete_status`) VALUES ('2', 'Medical', '133792483462e8b4e0077ff.jpg', '94249249562e8b4e0078b0.jpg', '1');
INSERT INTO `appln` (`id`, `appln_name`, `image`, `image1`, `delete_status`) VALUES ('3', 'Biotechnology', '31334184562e7dd450564f.jpg', '7070547362e7dd450573a.jpg', '0');
INSERT INTO `appln` (`id`, `appln_name`, `image`, `image1`, `delete_status`) VALUES ('4', 'Civil', '15889534362e8b4894db17.jpg', '140090727462e8b4894dbca.jpg', '1');
INSERT INTO `appln` (`id`, `appln_name`, `image`, `image1`, `delete_status`) VALUES ('5', 'Food and Beverage', '151784050562e8b4ba1458a.jpg', '42619119062e8b4ba1463b.jpg', '0');
INSERT INTO `appln` (`id`, `appln_name`, `image`, `image1`, `delete_status`) VALUES ('6', 'Petroleum', '44634951062e8b4fb87709.jpg', '26294538462e8b4fb87888.jpg', '1');
INSERT INTO `appln` (`id`, `appln_name`, `image`, `image1`, `delete_status`) VALUES ('7', 'Pharmaceuticals', '69121550062e8b5074d7fd.jpg', '161880710162e8b5074d8af.jpg', '0');
INSERT INTO `appln` (`id`, `appln_name`, `image`, `image1`, `delete_status`) VALUES ('8', 'Water Plant', '143983855962e8b52d2e6fa.jpg', '190009887462e8b52d2e7aa.jpg', '1');
INSERT INTO `appln` (`id`, `appln_name`, `image`, `image1`, `delete_status`) VALUES ('9', 'Arts and Science', '146797922962e8b4559928c.jpg', '99944887762e7dd3b23591.jpg', '1');
INSERT INTO `appln` (`id`, `appln_name`, `image`, `image1`, `delete_status`) VALUES ('10', 'Engineering', '6753061562e8b4a94d4b2.jpg', '97456517862e8b4a94d56a.jpg', '1');
INSERT INTO `appln` (`id`, `appln_name`, `image`, `image1`, `delete_status`) VALUES ('11', 'Polytechnic', '99193632962e8b514b693e.jpg', '19040007162e8b514b69f0.jpg', '1');
INSERT INTO `appln` (`id`, `appln_name`, `image`, `image1`, `delete_status`) VALUES ('12', 'Paint Industry', '173634850362e8b4ec66a9d.jpg', '73920707262e8b4ec66b65.jpg', '1');
INSERT INTO `appln` (`id`, `appln_name`, `image`, `image1`, `delete_status`) VALUES ('13', 'Agriculture', '91576889262e7dd2f4668d.jpg', '39428671062e7dd2f46742.jpg', '0');
INSERT INTO `appln` (`id`, `appln_name`, `image`, `image1`, `delete_status`) VALUES ('14', 'Cement', '91912999662e7dd5165475.jpg', '72971926162e7dd51656e3.jpg', '0');
INSERT INTO `appln` (`id`, `appln_name`, `image`, `image1`, `delete_status`) VALUES ('15', 'Dairy', '7176930562e8b497ca786.jpg', '181168318462e8b497ca84e.jpg', '0');
INSERT INTO `appln` (`id`, `appln_name`, `image`, `image1`, `delete_status`) VALUES ('16', 'Chemical Labs', '31304274462e8b473e5905.jpg', '72933862262e8b473e59b3.jpg', '0');
INSERT INTO `appln` (`id`, `appln_name`, `image`, `image1`, `delete_status`) VALUES ('17', 'Hospitals', '134500311862e8b4c7accb2.jpg', '176093125362e8b4c7acd63.jpg', '0');
INSERT INTO `appln` (`id`, `appln_name`, `image`, `image1`, `delete_status`) VALUES ('18', 'Sewage Treatment Plants', '138987623562e8b52336ed1.jpg', '123723925062e8b52336fde.jpg', '0');
INSERT INTO `appln` (`id`, `appln_name`, `image`, `image1`, `delete_status`) VALUES ('19', 'Aqua Culture', '698345722637c97ab710b7.jpg', '296713505637c97ab713ca.jpg', '0');
INSERT INTO `appln` (`id`, `appln_name`, `image`, `image1`, `delete_status`) VALUES ('20', 'Blood Chemistries', '1856740158637c99002ea40.jpg', '837752083637c99002ed10.jpg', '0');
INSERT INTO `appln` (`id`, `appln_name`, `image`, `image1`, `delete_status`) VALUES ('21', 'Chemical Industries', '351348025637c9a6e07660.jpg', '88380891637c9a6e07945.jpg', '0');
INSERT INTO `appln` (`id`, `appln_name`, `image`, `image1`, `delete_status`) VALUES ('22', 'Colleges', '1539614604637c9bc0667c1.jpg', '511211270637c9bc066a76.jpg', '0');
INSERT INTO `appln` (`id`, `appln_name`, `image`, `image1`, `delete_status`) VALUES ('23', 'Effluent Treatment Plants', '1040903980637c9cba2826d.jpg', '193960160637c9cba28567.jpg', '0');
INSERT INTO `appln` (`id`, `appln_name`, `image`, `image1`, `delete_status`) VALUES ('24', 'Fertilizers', '2055769341637c9de4ea24e.jpg', '1089938686637c9de4ea51d.jpg', '0');
INSERT INTO `appln` (`id`, `appln_name`, `image`, `image1`, `delete_status`) VALUES ('25', 'Industrial Water Disposal', '1992281405637c9f0f52f19.jpg', '743617356637c9f0f531f1.jpg', '0');
INSERT INTO `appln` (`id`, `appln_name`, `image`, `image1`, `delete_status`) VALUES ('26', 'Iron and Steel', '1819630065637ca0534c60f.jpg', '307998740637ca0534c963.jpg', '0');
INSERT INTO `appln` (`id`, `appln_name`, `image`, `image1`, `delete_status`) VALUES ('27', 'Metallurgy', '1529491614637ca1375104e.jpg', '197335740637ca13751364.jpg', '0');
INSERT INTO `appln` (`id`, `appln_name`, `image`, `image1`, `delete_status`) VALUES ('28', 'Mineral water Plant', '8662500637ca25271008.jpg', '383620164637ca2527143b.jpg', '0');
INSERT INTO `appln` (`id`, `appln_name`, `image`, `image1`, `delete_status`) VALUES ('29', 'Mines and Geology', '1746636856637ca33c4ece8.jpg', '1490492723637ca33c4f075.jpg', '0');
INSERT INTO `appln` (`id`, `appln_name`, `image`, `image1`, `delete_status`) VALUES ('30', 'Petro Chemicals', '1719020399637ca4692905d.jpg', '1077288960637ca4692936e.jpg', '0');
INSERT INTO `appln` (`id`, `appln_name`, `image`, `image1`, `delete_status`) VALUES ('31', 'Plant and Dyes', '1505479530637ca57f65777.jpg', '748541485637ca57f65c34.jpg', '0');
INSERT INTO `appln` (`id`, `appln_name`, `image`, `image1`, `delete_status`) VALUES ('32', 'Pollution Control', '1739442526637ca66a2877c.jpg', '1798684394637ca66a28a30.jpg', '0');
INSERT INTO `appln` (`id`, `appln_name`, `image`, `image1`, `delete_status`) VALUES ('33', 'Portable Water Plant', '698380972637ca922077f6.jpg', '124490137637ca92207ab8.jpg', '0');
INSERT INTO `appln` (`id`, `appln_name`, `image`, `image1`, `delete_status`) VALUES ('34', 'Power Plants', '1393232599637caa19a1374.jpg', '2085795974637caa19a166a.jpg', '0');
INSERT INTO `appln` (`id`, `appln_name`, `image`, `image1`, `delete_status`) VALUES ('35', 'Textile', '1873151439637caafbeb0aa.jpg', '1951849357637cab6504f17.jpg', '0');


#
# TABLE STRUCTURE FOR: appln1
#

DROP TABLE IF EXISTS `appln1`;

CREATE TABLE `appln1` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `appln_name` varchar(50) DEFAULT NULL,
  `delete_status` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8;

INSERT INTO `appln1` (`id`, `appln_name`, `delete_status`) VALUES ('1', 'Hotels', '0');
INSERT INTO `appln1` (`id`, `appln_name`, `delete_status`) VALUES ('2', 'Medical', '0');
INSERT INTO `appln1` (`id`, `appln_name`, `delete_status`) VALUES ('3', 'Biotechnology', '0');
INSERT INTO `appln1` (`id`, `appln_name`, `delete_status`) VALUES ('4', 'Civil', '0');
INSERT INTO `appln1` (`id`, `appln_name`, `delete_status`) VALUES ('5', 'Food and Beverage', '0');
INSERT INTO `appln1` (`id`, `appln_name`, `delete_status`) VALUES ('6', 'Petroleum', '0');
INSERT INTO `appln1` (`id`, `appln_name`, `delete_status`) VALUES ('7', 'Pharmaceuticals', '0');
INSERT INTO `appln1` (`id`, `appln_name`, `delete_status`) VALUES ('8', 'Water Plant', '0');
INSERT INTO `appln1` (`id`, `appln_name`, `delete_status`) VALUES ('9', 'Arts and Science', '0');
INSERT INTO `appln1` (`id`, `appln_name`, `delete_status`) VALUES ('10', 'Engineering', '0');
INSERT INTO `appln1` (`id`, `appln_name`, `delete_status`) VALUES ('11', 'Polytechnic', '0');
INSERT INTO `appln1` (`id`, `appln_name`, `delete_status`) VALUES ('12', 'Paint Industry', '0');
INSERT INTO `appln1` (`id`, `appln_name`, `delete_status`) VALUES ('13', 'Agriculture', '0');
INSERT INTO `appln1` (`id`, `appln_name`, `delete_status`) VALUES ('14', 'Cement', '0');
INSERT INTO `appln1` (`id`, `appln_name`, `delete_status`) VALUES ('15', 'Dairy', '0');
INSERT INTO `appln1` (`id`, `appln_name`, `delete_status`) VALUES ('16', 'Chemical Lab', '0');
INSERT INTO `appln1` (`id`, `appln_name`, `delete_status`) VALUES ('17', 'Hospitals', '0');
INSERT INTO `appln1` (`id`, `appln_name`, `delete_status`) VALUES ('18', 'Sewerage Plants', '0');


#
# TABLE STRUCTURE FOR: banner_image
#

DROP TABLE IF EXISTS `banner_image`;

CREATE TABLE `banner_image` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT COMMENT 'Primary key',
  `product_id` mediumint(8) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL COMMENT 'Foreign Key',
  `subcategory_id` int(11) DEFAULT NULL COMMENT 'Foreign Key',
  `image` text,
  `banner_status` int(1) DEFAULT '0',
  `insertedat` date DEFAULT NULL,
  `updatedat` datetime DEFAULT NULL,
  `delete_date` date DEFAULT NULL,
  `delete_status` int(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: baskets
#

DROP TABLE IF EXISTS `baskets`;

CREATE TABLE `baskets` (
  `basketID` int(11) NOT NULL AUTO_INCREMENT,
  `basketSession` varchar(50) DEFAULT NULL,
  `productID` int(11) DEFAULT NULL,
  `productPrice` varchar(50) DEFAULT NULL,
  `productQty` int(11) DEFAULT NULL,
  `product_weight` varchar(50) DEFAULT NULL,
  `pcode` varchar(100) DEFAULT NULL,
  `rid` int(11) DEFAULT NULL,
  `status` int(1) DEFAULT NULL,
  `order_id` int(11) DEFAULT NULL,
  `mem_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`basketID`)
) ENGINE=InnoDB AUTO_INCREMENT=3004 DEFAULT CHARSET=latin1;

INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('21', 'rmc9p640qrgi2bhiqfs7rneuj7', '1', '100.00', '1', '22cm', '22cm', '1', '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('22', 'rmc9p640qrgi2bhiqfs7rneuj7', '2', '300.00', '2', '35cm', '35cm', '6', '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('25', 'rmc9p640qrgi2bhiqfs7rneuj7', '4', '100.00', '1', '22cm', '22cm', '10', '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('30', '79u8qjbr140nuotaaspv53je77', '1', '90.00', '1', 'celld-22', 'celld-22', '1', '0', NULL, '1');
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('32', 'b6pl673040717llutrhbqaepr2', '1', '90.00', '1', 'celld-22', 'celld-22', '1', '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('33', '7t20b6c77sdpesehaghv9gsek2', '1', '90.00', '1', 'celld-22', 'celld-22', '1', '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('34', 'abc36tot7giic8fcgph0r3h610', '1', '90.00', '1', 'celld-22', 'celld-22', '1', '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('35', 'd7mgpi8jovs4tor2fnav6t7tj7', '1', '90.00', '1', 'celld-22', 'celld-22', '1', '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('36', 'rdkki31on8rpg90t5ja4ndohk1', '1', '90.00', '2', 'celld-22', 'celld-22', '1', '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('42', 'bgrl54a6a01r1tfac6gsnnqt72', '1', '24500.00', '2', 'King Size', 'King Size', '1', '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('49', 'nmld5m7ghsnr0klokh94b2g8e3', '1', '24500.00', '1', 'King Size', 'King Size', '1', '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('50', 'anibopk1lon9vbbq46ts749he5', '1', NULL, '1', NULL, NULL, NULL, '1', '1', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('51', 'anibopk1lon9vbbq46ts749he5', '27', NULL, '1', NULL, NULL, NULL, '1', '1', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('54', 'anibopk1lon9vbbq46ts749he5', '96', NULL, '1', NULL, NULL, NULL, '1', '2', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('56', 'q2u38qs9nd434oodd4alr99snp', '2583', NULL, '1', NULL, NULL, NULL, '1', '3', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('57', '41fqdkeujmd75d3v7ti6e4n2rg', '2403', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('58', 'sv7e6597etlfglqvrerq0atou9', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('59', 'sv7e6597etlfglqvrerq0atou9', '45', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('60', 'sv7e6597etlfglqvrerq0atou9', '44', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('61', 'sv7e6597etlfglqvrerq0atou9', '2', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('62', 'sv7e6597etlfglqvrerq0atou9', '53', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('63', 'sv7e6597etlfglqvrerq0atou9', '2288', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('64', 'sv7e6597etlfglqvrerq0atou9', '2236', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('65', 'sv7e6597etlfglqvrerq0atou9', '2289', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('68', 'ajfgf7vneeenn1uo43hmsg2pm2', '2403', NULL, '5', NULL, NULL, NULL, '1', '4', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('69', 'ajfgf7vneeenn1uo43hmsg2pm2', '2311', NULL, '5', NULL, NULL, NULL, '1', '4', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('84', '1guf9gcltn7thbm452m9rugemj', '1', NULL, '1', NULL, NULL, NULL, '1', '5', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('85', '1guf9gcltn7thbm452m9rugemj', '4', NULL, '1', NULL, NULL, NULL, '1', '5', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('86', '3v4k8d8de16jtk4q2o3nqq6kmg', '626', NULL, '1', NULL, NULL, NULL, '1', '7', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('87', '3v4k8d8de16jtk4q2o3nqq6kmg', '1', NULL, '1', NULL, NULL, NULL, '1', '7', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('88', '3v4k8d8de16jtk4q2o3nqq6kmg', '17', NULL, '1', NULL, NULL, NULL, '1', '7', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('89', '1guf9gcltn7thbm452m9rugemj', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('93', 'bdua32qg06q0smu225lb52m5b1', '1', NULL, '1', NULL, NULL, NULL, '1', '8', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('101', 'bqdcfap5hf20pg6vbieokbussf', '1', NULL, '1', NULL, NULL, NULL, '1', '9', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('102', 'bqdcfap5hf20pg6vbieokbussf', '7', NULL, '1', NULL, NULL, NULL, '1', '9', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('103', 'bqdcfap5hf20pg6vbieokbussf', '10', NULL, '1', NULL, NULL, NULL, '1', '9', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('104', 'bqdcfap5hf20pg6vbieokbussf', '13', NULL, '1', NULL, NULL, NULL, '1', '9', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('105', 'bqdcfap5hf20pg6vbieokbussf', '558', NULL, '1', NULL, NULL, NULL, '1', '9', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('106', 'bqdcfap5hf20pg6vbieokbussf', '555', NULL, '1', NULL, NULL, NULL, '1', '9', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('107', 'bqdcfap5hf20pg6vbieokbussf', '626', NULL, '1', NULL, NULL, NULL, '1', '9', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('112', 'bdua32qg06q0smu225lb52m5b1', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('115', 't4qvbbte4b70diohgke5ck6qnr', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('116', '8qr55mrjsrgg240q9tgt6s868e', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('117', '8qr55mrjsrgg240q9tgt6s868e', '2', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('118', '8qr55mrjsrgg240q9tgt6s868e', '3', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('119', 't4qvbbte4b70diohgke5ck6qnr', '1925', NULL, '5', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('120', 't4qvbbte4b70diohgke5ck6qnr', '2336', NULL, '5', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('125', 'elnjsc79lg0ofitsa9ecuslho9', '1334', NULL, '10', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('126', 'jdthoi8uctr1906frevafrud74', '322', NULL, '1', NULL, NULL, NULL, '1', '10', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('127', 'jdthoi8uctr1906frevafrud74', '323', NULL, '2', NULL, NULL, NULL, '1', '10', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('132', 'v0c6bvd016vdfa7es00vck5jpl', '1', NULL, '1', NULL, NULL, NULL, '1', '11', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('133', 'v0c6bvd016vdfa7es00vck5jpl', '2', NULL, '1', NULL, NULL, NULL, '1', '11', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('134', '3gs3iupq0hqmsc81r5nld2akst', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('135', '3gs3iupq0hqmsc81r5nld2akst', '2', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('136', 'njef8r1cv8voeiv5k7ve8bb2mj', '1', NULL, '1', NULL, NULL, NULL, '1', '12', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('137', 'v0c6bvd016vdfa7es00vck5jpl', '55', NULL, '1', NULL, NULL, NULL, '1', '13', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('138', 'v0c6bvd016vdfa7es00vck5jpl', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('139', 'v0c6bvd016vdfa7es00vck5jpl', '5', NULL, '3', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('140', 'q5lmnd9q42vhh2v3d9leikud6p', '1907', NULL, '3', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('141', 'njef8r1cv8voeiv5k7ve8bb2mj', '13', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('142', 'njef8r1cv8voeiv5k7ve8bb2mj', '14', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('143', 'l1vhup8h5ar5mba45ev3jmdgfv', '534', NULL, '1', NULL, NULL, NULL, '1', '18', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('145', 'l1vhup8h5ar5mba45ev3jmdgfv', '1358', NULL, '7', NULL, NULL, NULL, '1', '18', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('146', 'l1vhup8h5ar5mba45ev3jmdgfv', '1925', NULL, '1', NULL, NULL, NULL, '1', '19', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('147', 'l1vhup8h5ar5mba45ev3jmdgfv', '2338', NULL, '1', NULL, NULL, NULL, '1', '19', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('148', 'l1vhup8h5ar5mba45ev3jmdgfv', '2336', NULL, '1', NULL, NULL, NULL, '1', '19', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('149', 'l1vhup8h5ar5mba45ev3jmdgfv', '3078', NULL, '1', NULL, NULL, NULL, '1', '19', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('150', 'l1vhup8h5ar5mba45ev3jmdgfv', '2339', NULL, '1', NULL, NULL, NULL, '1', '19', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('151', '7ujo6rfrq80ulb7d43fc9ul9v5', '2403', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('152', '7ujo6rfrq80ulb7d43fc9ul9v5', '2404', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('153', 'o2bpjm11e41933l0f1p91guul4', '933', NULL, '3', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('154', 'r915mbgubpcrdmv0783f4q41qc', '1', NULL, '1', NULL, NULL, NULL, '1', '20', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('155', 'r915mbgubpcrdmv0783f4q41qc', '3', NULL, '1', NULL, NULL, NULL, '1', '20', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('156', 'hg72qcfdlg3n54qd77ul346c7s', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('157', 'hg72qcfdlg3n54qd77ul346c7s', '2', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('158', 'o8m2gh0k7lsi1rdau87q83th7o', '55', NULL, '5', NULL, NULL, NULL, '1', '21', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('159', 'o8m2gh0k7lsi1rdau87q83th7o', '1907', NULL, '3', NULL, NULL, NULL, '1', '22', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('160', 'o8m2gh0k7lsi1rdau87q83th7o', '2', NULL, '7', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('161', 'o8m2gh0k7lsi1rdau87q83th7o', '5', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('162', 'o8m2gh0k7lsi1rdau87q83th7o', '9', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('163', '8mpgmpo6gevb0ubmt6j70ukdsk', '96', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('164', '5bqrlcv1bbsloil9vgcu8mch15', '1892', NULL, '2', NULL, NULL, NULL, '1', '23', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('165', '5bqrlcv1bbsloil9vgcu8mch15', '1893', NULL, '1', NULL, NULL, NULL, '1', '23', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('166', '5bqrlcv1bbsloil9vgcu8mch15', '1921', NULL, '5', NULL, NULL, NULL, '1', '23', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('167', '5bqrlcv1bbsloil9vgcu8mch15', '1892', NULL, '1', NULL, NULL, NULL, '1', '24', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('168', '5bqrlcv1bbsloil9vgcu8mch15', '1893', NULL, '1', NULL, NULL, NULL, '1', '24', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('169', '5bqrlcv1bbsloil9vgcu8mch15', '1894', NULL, '1', NULL, NULL, NULL, '1', '24', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('170', 'rftsv98ejpnedkldpbqmns8ee6', '47', NULL, '3', NULL, NULL, NULL, '1', '25', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('171', 'rftsv98ejpnedkldpbqmns8ee6', '27', NULL, '2', NULL, NULL, NULL, '1', '25', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('172', 'rftsv98ejpnedkldpbqmns8ee6', '1', NULL, '2', NULL, NULL, NULL, '1', '25', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('173', 'rftsv98ejpnedkldpbqmns8ee6', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('174', 'rftsv98ejpnedkldpbqmns8ee6', '2', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('176', 'orqp4685r7njv9fordjkkegd18', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('177', 'orqp4685r7njv9fordjkkegd18', '2', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('178', 'orqp4685r7njv9fordjkkegd18', '3', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('179', 'v5d2rfoh04i65acljtrnffjfuf', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('180', 'lvj0uhgj23vam9mkpp90b1morn', '55', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('181', '7ml9iff2ohhm8io7vb8cr9gos0', '1', NULL, '7', NULL, NULL, NULL, '1', '26', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('182', '2b9rkne7vhevqb39c51arfkjrb', '935', NULL, '7', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('183', '2b9rkne7vhevqb39c51arfkjrb', '316', NULL, '7', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('189', 'o75v1ka1mdrm7q9dd7atiqii0j', '1', NULL, '2', NULL, NULL, NULL, '1', '27', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('190', 'o75v1ka1mdrm7q9dd7atiqii0j', '2', NULL, '1', NULL, NULL, NULL, '1', '27', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('191', 'v11tadcm1v8o0tcbjba2ve3187', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('192', 'o75v1ka1mdrm7q9dd7atiqii0j', '1', NULL, '2', NULL, NULL, NULL, '1', '28', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('193', 'o75v1ka1mdrm7q9dd7atiqii0j', '2', NULL, '1', NULL, NULL, NULL, '1', '28', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('195', 'ctacf9rn4j752kt1ihiufeha7q', '389', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('197', 'sdanumu24smkfsvtjtrf0otsng', '4', NULL, '2', NULL, NULL, NULL, '1', '29', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('198', 'j3hk659i7746olb526nunchb91', '1972', NULL, '15', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('200', '29h7me8o11ekjfl4uu9ijksmpu', '2603', NULL, '1', NULL, NULL, NULL, '1', '30', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('201', 'r515bp2h8ob1rfko6s128h037d', '1892', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('205', 'v7mvbg0kq0m9cjash94iuubqme', '2', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('206', '02unpgrvvvqrf0q3fanu8nk335', '606', NULL, '4', NULL, NULL, NULL, '1', '31', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('209', '1odpcgj527bu9ii5637rduqri1', '1004', NULL, '1', NULL, NULL, NULL, '1', '32', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('214', '7ki2it1228a47ovk57utnp2phs', '1', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('215', '7ki2it1228a47ovk57utnp2phs', '2', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('218', '49jnar6bl3hvna8i9e40mi7jq9', '317', NULL, '5', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('219', '49jnar6bl3hvna8i9e40mi7jq9', '318', NULL, '4', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('222', 'qq0c0790s19pfs6n353l23q25t', '55', NULL, '6', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('224', '930d5f89a798daad767dce4b5683528a', '2417', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('227', '3b9cd40a3841dd6b6517b3e42093048c', '3067', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('229', '3337cc9ddad6d7abef1bb5689c5c6667', '56', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('230', '3337cc9ddad6d7abef1bb5689c5c6667', '58', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('239', '96ac38e20d4e1d8bf9ebcea77efac421', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('241', '96ac38e20d4e1d8bf9ebcea77efac421', '2311', NULL, '5', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('242', '103991431ddafb1b18ec1b153bf23d92', '410', NULL, '1', NULL, NULL, NULL, '1', '33', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('243', '103991431ddafb1b18ec1b153bf23d92', '412', NULL, '1', NULL, NULL, NULL, '1', '33', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('245', 'b13ec099a096d3262ea13ae38067cb47', '2311', NULL, '3', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('247', 'b6208fd3ca03f481bb211d621f541ab2', '2311', NULL, '4', NULL, NULL, NULL, '1', '34', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('249', 'b6208fd3ca03f481bb211d621f541ab2', '2311', NULL, '5', NULL, NULL, NULL, '1', '35', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('250', '459e97ca6d04e8b1fbd621315bc23bc4', '1', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('253', 'b6208fd3ca03f481bb211d621f541ab2', '280', NULL, '3', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('254', 'b6208fd3ca03f481bb211d621f541ab2', '352', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('255', '0f4cac9d6611a10b1d09f0054092ea0d', '3177', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('256', 'ce02e115864ee6245ac9db329844961f', '3123', NULL, '6', NULL, NULL, NULL, '1', '36', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('257', 'ce02e115864ee6245ac9db329844961f', '3144', NULL, '6', NULL, NULL, NULL, '1', '36', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('260', 'e948a5ddcd1a340b6508283e3e21256a', '1422', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('262', '43b74ddc165789479dc735bd766b25e3', '2407', NULL, '5', NULL, NULL, NULL, '1', '37', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('263', 'edbd7d9033af27110e5b2e0e9f7928d4', '1892', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('264', '377b81a0cc42912ff9d85818ecd3cdad', '20', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('265', '377b81a0cc42912ff9d85818ecd3cdad', '3259', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('268', '1c288cd879ffd45557828c98a7d65861', '1275', NULL, '6', NULL, NULL, NULL, '1', '38', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('270', '956d2786871bb4d6dffc24e2ead5236a', '1275', NULL, '6', NULL, NULL, NULL, '1', '39', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('271', 'ffbe7738426669c31ec26b18149f7416', '1275', NULL, '6', NULL, NULL, NULL, '1', '40', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('272', 'ffbe7738426669c31ec26b18149f7416', '1275', NULL, '6', NULL, NULL, NULL, '1', '41', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('273', '50d843c4ecc5ffadc7958f6ea7df831e', '1925', NULL, '2', NULL, NULL, NULL, '1', '42', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('274', '50d843c4ecc5ffadc7958f6ea7df831e', '2338', NULL, '3', NULL, NULL, NULL, '1', '42', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('275', '4f10f30c621e56760a5f395929bf94fd', '1319', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('277', '80ef44af5fa741a28cee64278a20696c', '1934', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('278', '80ef44af5fa741a28cee64278a20696c', '365', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('279', '80ef44af5fa741a28cee64278a20696c', '366', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('280', '80ef44af5fa741a28cee64278a20696c', '607', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('283', '7586804d60214bc466d2c116b43b8067', '365', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('284', '7586804d60214bc466d2c116b43b8067', '1934', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('285', '5606a64c6cb3473c76f691211dd33369', '1359', NULL, '4', NULL, NULL, NULL, '1', '43', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('286', '5606a64c6cb3473c76f691211dd33369', '1362', NULL, '4', NULL, NULL, NULL, '1', '43', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('287', 'f603d3c3292665c8a2ab8e4d25f5f3e5', '1494', NULL, '1', NULL, NULL, NULL, '1', '44', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('288', 'f7381cd412dd4490d28c0248e46c577e', '1934', NULL, '1', NULL, NULL, NULL, '1', '45', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('289', 'f7381cd412dd4490d28c0248e46c577e', '365', NULL, '1', NULL, NULL, NULL, '1', '45', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('290', '0af6b43b359df306cbd18c54baa98776', '200', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('291', 'ee42627f1b86b6512bad467c76935b05', '659', NULL, '4', NULL, NULL, NULL, '1', '46', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('292', 'ee42627f1b86b6512bad467c76935b05', '659', NULL, '4', NULL, NULL, NULL, '1', '47', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('293', 'b51627f4720f33ecc055e2e52077cdca', '2074', NULL, '400', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('296', 'dd9695070cd21c7b1617627d2339accf', '1904', NULL, '2', NULL, NULL, NULL, '1', '48', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('298', '76073b2e078077825aefe1c718a94278', '124', NULL, '1', NULL, NULL, NULL, '1', '49', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('299', '76073b2e078077825aefe1c718a94278', '128', NULL, '1', NULL, NULL, NULL, '1', '50', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('300', '76073b2e078077825aefe1c718a94278', '843', NULL, '5', NULL, NULL, NULL, '1', '51', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('301', '76073b2e078077825aefe1c718a94278', '658', NULL, '2', NULL, NULL, NULL, '1', '51', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('302', 'd350ee3427a455378ba3447f56c1836c', '337', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('303', 'd350ee3427a455378ba3447f56c1836c', '316', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('304', 'a777d5f50dc584679598d7c0103a8b5f', '391', NULL, '1', NULL, NULL, NULL, '1', '52', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('305', 'a777d5f50dc584679598d7c0103a8b5f', '392', NULL, '1', NULL, NULL, NULL, '1', '52', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('317', '1c1c72a8ce8a4db234fc93c188a2f05c', '607', NULL, '5', NULL, NULL, NULL, '1', '53', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('318', '1c1c72a8ce8a4db234fc93c188a2f05c', '2400', NULL, '4', NULL, NULL, NULL, '1', '54', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('319', 'a356ac747497b96a05a764c4230b099f', '1820', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('326', 'cef53efe1d3220c03e0fe901e39e3bdf', '1790', NULL, '100', NULL, NULL, NULL, '1', '55', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('327', '6d73ff9144db58626c9dfd4bd3921ea6', '1794', NULL, '100', NULL, NULL, NULL, '1', '56', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('328', '3c4d582a246280891b35106eefadd654', '3091', NULL, '1', NULL, NULL, NULL, '1', '57', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('332', 'e3ea0c14cd72450020d29a9b9c5ad698', '1268', NULL, '3', NULL, NULL, NULL, '1', '58', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('333', 'e3ea0c14cd72450020d29a9b9c5ad698', '1282', NULL, '10', NULL, NULL, NULL, '1', '58', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('334', '96b8a4f9cdac99c9c385322f2e3bc5c1', '2489', NULL, '5', NULL, NULL, NULL, '1', '59', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('335', '96b8a4f9cdac99c9c385322f2e3bc5c1', '2491', NULL, '5', NULL, NULL, NULL, '1', '59', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('337', 'b26f99d21b2fb6f42d46791b905737c8', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('338', 'b96a2067a8d6ae4454fe845b8adc84b1', '626', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('339', 'b96a2067a8d6ae4454fe845b8adc84b1', '631', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('342', '0851a86c11ebfffed02609e455dcc1d1', '1461', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('343', '0851a86c11ebfffed02609e455dcc1d1', '2902', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('344', '7998ed05baa79b2e8f42ac5a958aee59', '2058', NULL, '12', NULL, NULL, NULL, '1', '61', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('346', 'cc80fd620282da49962c8ba1fbaa735e', '1273', NULL, '20', NULL, NULL, NULL, '1', '62', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('347', '26c03613f5acc2c1fbeb9359a439194e', '917', NULL, '1', NULL, NULL, NULL, '1', '63', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('348', '4bf014f355068fa7f3c75733542ed317', '1270', NULL, '10', NULL, NULL, NULL, '1', '64', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('349', '4bf014f355068fa7f3c75733542ed317', '1286', NULL, '10', NULL, NULL, NULL, '1', '64', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('350', '626c6efe24c1a4699265d60d765a77ac', '1797', NULL, '3', NULL, NULL, NULL, '1', '65', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('351', 'd7d3e9defa828a40f4aa4b06c39c35a4', '2051', NULL, '12', NULL, NULL, NULL, '1', '66', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('352', 'd7d3e9defa828a40f4aa4b06c39c35a4', '2052', NULL, '12', NULL, NULL, NULL, '1', '66', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('353', 'd7d3e9defa828a40f4aa4b06c39c35a4', '2086', NULL, '12', NULL, NULL, NULL, '1', '66', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('354', 'd7d3e9defa828a40f4aa4b06c39c35a4', '366', NULL, '1', NULL, NULL, NULL, '1', '66', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('355', 'd7d3e9defa828a40f4aa4b06c39c35a4', '607', NULL, '1', NULL, NULL, NULL, '1', '66', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('357', '5a45626544a7136fed1d92fdd3763bb3', '1506', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('358', 'a3d6565b419f345d61b3c9aa2bba69f6', '1790', NULL, '100', NULL, NULL, NULL, '1', '67', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('359', 'a3d6565b419f345d61b3c9aa2bba69f6', '1794', NULL, '100', NULL, NULL, NULL, '1', '67', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('364', '131a7eeda8f4d02a2fbda17d35ba241e', '381', NULL, '2', NULL, NULL, NULL, '1', '68', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('365', '131a7eeda8f4d02a2fbda17d35ba241e', '550', NULL, '8', NULL, NULL, NULL, '1', '68', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('366', '131a7eeda8f4d02a2fbda17d35ba241e', '2484', NULL, '4', NULL, NULL, NULL, '1', '68', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('367', '131a7eeda8f4d02a2fbda17d35ba241e', '2485', NULL, '10', NULL, NULL, NULL, '1', '68', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('368', 'd6bad956fecb0424f5c364991a9bd475', '3094', NULL, '1', NULL, NULL, NULL, '1', '69', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('369', 'b8a26e9ddbbb8c558904a3dd99f6b5cf', '2406', NULL, '50', NULL, NULL, NULL, '1', '70', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('370', 'b8a26e9ddbbb8c558904a3dd99f6b5cf', '1379', NULL, '2', NULL, NULL, NULL, '1', '70', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('371', '5b47ffd9fba6eb5861aa30972c7e3ff9', '1870', NULL, '1', NULL, NULL, NULL, '1', '71', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('372', '5b47ffd9fba6eb5861aa30972c7e3ff9', '2400', NULL, '10', NULL, NULL, NULL, '1', '71', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('373', '5b47ffd9fba6eb5861aa30972c7e3ff9', '2401', NULL, '10', NULL, NULL, NULL, '1', '71', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('374', '72eb93e5e441009a8536ee07f573ff60', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('375', '72eb93e5e441009a8536ee07f573ff60', '2', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('378', 'dd12b44f03830e8eda14fc2a61874c8e', '1', NULL, '3', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('381', '14d7fc42f2742d9077f3de140479145b', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('383', '49c6bbb186e4c4021354f6a86f33285e', '2946', NULL, '20', NULL, NULL, NULL, '1', '72', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('384', '49c6bbb186e4c4021354f6a86f33285e', '3031', NULL, '1', NULL, NULL, NULL, '1', '72', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('385', '545b8246c539d27ef503d567e8d15c70', '692', NULL, '2', NULL, NULL, NULL, '1', '73', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('386', '2ba40475d12b8dffe449357fcd413ff7', '400', NULL, '1', NULL, NULL, NULL, '1', '74', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('387', '7471ffa1cdddba57be9c83084c019a9a', '3263', NULL, '20', NULL, NULL, NULL, '1', '75', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('388', '7471ffa1cdddba57be9c83084c019a9a', '1790', NULL, '40', NULL, NULL, NULL, '1', '75', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('389', '7471ffa1cdddba57be9c83084c019a9a', '1786', NULL, '80', NULL, NULL, NULL, '1', '75', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('390', 'dd8e33b6e4a725d09e19253348431800', '1270', NULL, '30', NULL, NULL, NULL, '1', '76', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('391', 'dd8e33b6e4a725d09e19253348431800', '1275', NULL, '10', NULL, NULL, NULL, '1', '76', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('392', 'dd8e33b6e4a725d09e19253348431800', '1797', NULL, '20', NULL, NULL, NULL, '1', '76', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('393', 'db4df56b86455b3318166715accacbfe', '2878', NULL, '2', NULL, NULL, NULL, '1', '77', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('394', 'db4df56b86455b3318166715accacbfe', '2877', NULL, '1', NULL, NULL, NULL, '1', '77', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('398', '7a85619ec19a8d7d37006682821d9e95', '3502', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('399', '7a85619ec19a8d7d37006682821d9e95', '3501', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('400', '7a85619ec19a8d7d37006682821d9e95', '3500', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('401', '7a85619ec19a8d7d37006682821d9e95', '2103', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('402', '7a85619ec19a8d7d37006682821d9e95', '1973', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('403', '7a85619ec19a8d7d37006682821d9e95', '3393', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('404', '7a85619ec19a8d7d37006682821d9e95', '3391', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('405', '7a85619ec19a8d7d37006682821d9e95', '1974', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('406', '1f4cbc49db40ba5a2f693962b5782365', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('407', '1f4cbc49db40ba5a2f693962b5782365', '2', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('408', 'd0aa5cb978e5d1e7b8cd694290b3620e', '3095', NULL, '1', NULL, NULL, NULL, '1', '78', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('410', '0fa2088076e10bcd4caa6a60f9bad723', '1734', NULL, '1', NULL, NULL, NULL, '1', '79', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('411', '0fa2088076e10bcd4caa6a60f9bad723', '1734', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('413', 'e73b32035f31e04d1850f07359e241b2', '2407', NULL, '2', NULL, NULL, NULL, '1', '80', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('414', 'e73b32035f31e04d1850f07359e241b2', '482', NULL, '2', NULL, NULL, NULL, '1', '80', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('415', 'e73b32035f31e04d1850f07359e241b2', '484', NULL, '2', NULL, NULL, NULL, '1', '80', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('416', 'e73b32035f31e04d1850f07359e241b2', '1362', NULL, '2', NULL, NULL, NULL, '1', '80', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('417', 'e73b32035f31e04d1850f07359e241b2', '1363', NULL, '2', NULL, NULL, NULL, '1', '80', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('418', '4b4f544b21f0ae92b8e3f94642c60f8a', '214', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('419', '49e5be3cbaf2636696147a610f3e59ea', '38', NULL, '20', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('420', '2f600c44e749a05122a3616e5650136a', '1974', NULL, '2', NULL, NULL, NULL, '1', '81', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('421', '2f600c44e749a05122a3616e5650136a', '1934', NULL, '2', NULL, NULL, NULL, '1', '81', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('422', '2f600c44e749a05122a3616e5650136a', '344', NULL, '2', NULL, NULL, NULL, '1', '81', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('423', '2f600c44e749a05122a3616e5650136a', '616', NULL, '5', NULL, NULL, NULL, '1', '81', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('424', '2f600c44e749a05122a3616e5650136a', '607', NULL, '3', NULL, NULL, NULL, '1', '81', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('425', '2f600c44e749a05122a3616e5650136a', '614', NULL, '3', NULL, NULL, NULL, '1', '81', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('426', '2f600c44e749a05122a3616e5650136a', '366', NULL, '3', NULL, NULL, NULL, '1', '81', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('427', '2f600c44e749a05122a3616e5650136a', '2364', NULL, '2', NULL, NULL, NULL, '1', '81', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('428', '2f600c44e749a05122a3616e5650136a', '2086', NULL, '30', NULL, NULL, NULL, '1', '81', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('430', '54aea9de17edd4ee25062322a3082597', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('431', '02f2a1c8c1abe0ae0cb8305ba3df473d', '1731', NULL, '1', NULL, NULL, NULL, '1', '82', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('432', '02f2a1c8c1abe0ae0cb8305ba3df473d', '3123', NULL, '2', NULL, NULL, NULL, '1', '82', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('433', 'fe10c0571ecd713e724cdddb1c3df4f8', '3092', NULL, '1', NULL, NULL, NULL, '1', '83', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('434', 'a3e821050329aa29570f319afce1cee4', '3517', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('435', '6d91a3f14c03398bdbe02c45b441165c', '2669', NULL, '1', NULL, NULL, NULL, '1', '84', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('436', '6d91a3f14c03398bdbe02c45b441165c', '2311', NULL, '1', NULL, NULL, NULL, '1', '84', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('437', '6d91a3f14c03398bdbe02c45b441165c', '2406', NULL, '1', NULL, NULL, NULL, '1', '84', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('438', '6d91a3f14c03398bdbe02c45b441165c', '2416', NULL, '1', NULL, NULL, NULL, '1', '84', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('439', '6d91a3f14c03398bdbe02c45b441165c', '1865', NULL, '1', NULL, NULL, NULL, '1', '84', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('440', '6d91a3f14c03398bdbe02c45b441165c', '3097', NULL, '2', NULL, NULL, NULL, '1', '84', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('441', '6d91a3f14c03398bdbe02c45b441165c', '2661', NULL, '20', NULL, NULL, NULL, '1', '85', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('442', '6d91a3f14c03398bdbe02c45b441165c', '2311', NULL, '5', NULL, NULL, NULL, '1', '85', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('443', '6d91a3f14c03398bdbe02c45b441165c', '2406', NULL, '20', NULL, NULL, NULL, '1', '85', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('444', '6d91a3f14c03398bdbe02c45b441165c', '2416', NULL, '20', NULL, NULL, NULL, '1', '85', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('445', '6d91a3f14c03398bdbe02c45b441165c', '1865', NULL, '1', NULL, NULL, NULL, '1', '85', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('446', '6d91a3f14c03398bdbe02c45b441165c', '3097', NULL, '1', NULL, NULL, NULL, '1', '85', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('447', 'eee1e287d0c80424d62e20d24b345ea5', '1455', NULL, '1', NULL, NULL, NULL, '1', '86', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('450', 'e76959ac3f0dc9c67c231fc34eee5640', '38', NULL, '20', NULL, NULL, NULL, '1', '87', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('451', '101fbc0118abf98eccd643214d7ecc9d', '1794', NULL, '100', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('452', '04f7c23b89bc9e690ff00f86dfbe18e9', '1594', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('453', '6c51be437dfaf5870ddb88adc2b09b9e', '661', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('454', '9121b0c110eddc0145e1156ab98c1f1c', '1027', NULL, '4', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('455', '44e795db78d7e17da417f7b9a111b82e', '1794', NULL, '100', NULL, NULL, NULL, '1', '88', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('456', '44e795db78d7e17da417f7b9a111b82e', '366', NULL, '2', NULL, NULL, NULL, '1', '88', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('457', '44e795db78d7e17da417f7b9a111b82e', '2311', NULL, '2', NULL, NULL, NULL, '1', '88', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('458', '22195a33ea495bc3e10b8f7a74afc784', '1961', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('459', '7dfc98cbc388ac46a5992432d0d4d4a6', '2872', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('460', '7dfc98cbc388ac46a5992432d0d4d4a6', '1455', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('461', '7dfc98cbc388ac46a5992432d0d4d4a6', '3316', NULL, '3', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('462', '19e31f0d2bbf84002d7381809e093dce', '2872', NULL, '2', NULL, NULL, NULL, '1', '89', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('463', '19e31f0d2bbf84002d7381809e093dce', '1455', NULL, '1', NULL, NULL, NULL, '1', '89', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('464', '19e31f0d2bbf84002d7381809e093dce', '3316', NULL, '3', NULL, NULL, NULL, '1', '89', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('465', '4a7f0b4cadcc0b5a0d59913d8f0be232', '1898', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('466', '4a7f0b4cadcc0b5a0d59913d8f0be232', '2017', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('467', '4a7f0b4cadcc0b5a0d59913d8f0be232', '2022', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('468', '4a7f0b4cadcc0b5a0d59913d8f0be232', '2025', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('469', '4a7f0b4cadcc0b5a0d59913d8f0be232', '2034', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('470', '4a7f0b4cadcc0b5a0d59913d8f0be232', '2038', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('471', '4a7f0b4cadcc0b5a0d59913d8f0be232', '2045', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('472', 'b226a0c4d663e2abc3c34b3c87e072e1', '2403', NULL, '1', NULL, NULL, NULL, '1', '90', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('473', 'b226a0c4d663e2abc3c34b3c87e072e1', '2413', NULL, '1', NULL, NULL, NULL, '1', '90', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('482', 'b226a0c4d663e2abc3c34b3c87e072e1', '2858', NULL, '1', NULL, NULL, NULL, '1', '90', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('483', 'b226a0c4d663e2abc3c34b3c87e072e1', '2868', NULL, '1', NULL, NULL, NULL, '1', '90', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('484', 'b226a0c4d663e2abc3c34b3c87e072e1', '2869', NULL, '1', NULL, NULL, NULL, '1', '90', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('485', 'b226a0c4d663e2abc3c34b3c87e072e1', '2867', NULL, '1', NULL, NULL, NULL, '1', '90', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('486', 'b226a0c4d663e2abc3c34b3c87e072e1', '2874', NULL, '2', NULL, NULL, NULL, '1', '90', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('487', 'b226a0c4d663e2abc3c34b3c87e072e1', '2878', NULL, '2', NULL, NULL, NULL, '1', '90', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('488', 'b226a0c4d663e2abc3c34b3c87e072e1', '2876', NULL, '1', NULL, NULL, NULL, '1', '90', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('489', 'b226a0c4d663e2abc3c34b3c87e072e1', '2864', NULL, '1', NULL, NULL, NULL, '1', '90', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('490', 'e430e2464a07c24a318500740fe3b80c', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('491', 'e430e2464a07c24a318500740fe3b80c', '10', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('492', '7ec87b097d30d4f08c0fa0555c2573e7', '567', NULL, '1', NULL, NULL, NULL, '1', '91', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('493', '7ec87b097d30d4f08c0fa0555c2573e7', '568', NULL, '1', NULL, NULL, NULL, '1', '91', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('494', '7ec87b097d30d4f08c0fa0555c2573e7', '567', NULL, '1', NULL, NULL, NULL, '1', '92', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('495', '7ec87b097d30d4f08c0fa0555c2573e7', '568', NULL, '1', NULL, NULL, NULL, '1', '92', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('496', 'd6f219b8e30c08f44fc3e20cb4aa80f9', '878', NULL, '1', NULL, NULL, NULL, '1', '93', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('497', 'da5a61d447c93efb9213f344bf18aec0', '1510', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('498', '1ac59048335cc4a68ba42b5024a17667', '1418', NULL, '10', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('499', 'f72b228dd12bb61d68af2e1d5885a401', '2789', NULL, '1', NULL, NULL, NULL, '1', '94', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('500', '47ed813aa6c3559871cde1790c212386', '2050', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('501', '4b0f1422366ac8010010a6f57b2820ee', '345', NULL, '1', NULL, NULL, NULL, '1', '95', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('502', '28fe7dd246682c759e8e55131bc38b68', '1455', NULL, '1', NULL, NULL, NULL, '1', '96', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('503', '28fe7dd246682c759e8e55131bc38b68', '2878', NULL, '1', NULL, NULL, NULL, '1', '96', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('507', '21dddf95fb2f6115c13b42935a3bbb85', '1794', NULL, '100', NULL, NULL, NULL, '1', '97', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('508', 'a1886b1021fa2f862b16cdffde80e442', '1797', NULL, '30', NULL, NULL, NULL, '1', '98', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('509', 'aa2a44a4823d515c9248ded4586a7242', '2364', NULL, '5', NULL, NULL, NULL, '1', '99', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('510', '54d84645e01961d44c67675206adabb5', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('511', '54d84645e01961d44c67675206adabb5', '5', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('512', '43389895e3b49c64b631c40883587489', '928', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('513', '457d1eaab87102c62c2c408546e013f2', '2943', NULL, '10', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('514', '457d1eaab87102c62c2c408546e013f2', '2945', NULL, '10', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('515', '457d1eaab87102c62c2c408546e013f2', '690', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('516', '457d1eaab87102c62c2c408546e013f2', '699', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('517', '47d8fe2da7f5ad5b310633c5ad77c508', '690', NULL, '1', NULL, NULL, NULL, '1', '100', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('518', '47d8fe2da7f5ad5b310633c5ad77c508', '699', NULL, '1', NULL, NULL, NULL, '1', '100', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('519', '47d8fe2da7f5ad5b310633c5ad77c508', '2943', NULL, '10', NULL, NULL, NULL, '1', '100', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('520', '47d8fe2da7f5ad5b310633c5ad77c508', '2945', NULL, '10', NULL, NULL, NULL, '1', '100', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('522', '7d8e1d8b6bb7bb6df1357d412a27a98e', '2607', NULL, '1', NULL, NULL, NULL, '1', '101', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('523', '49caba34fc379c8b7076cc10aeeab185', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('524', 'd5d506a338da626ee11e38aeb58b7b85', '3374', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('525', 'd5d506a338da626ee11e38aeb58b7b85', '3375', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('526', '4dd0e8be4897c26c2b9cb69ae0119e94', '404', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('527', '4dd0e8be4897c26c2b9cb69ae0119e94', '403', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('528', '55db9f95a422fb3f58855b43822bd000', '372', NULL, '1', NULL, NULL, NULL, '1', '102', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('529', '55db9f95a422fb3f58855b43822bd000', '283', NULL, '1', NULL, NULL, NULL, '1', '102', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('530', '55db9f95a422fb3f58855b43822bd000', '2516', NULL, '1', NULL, NULL, NULL, '1', '102', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('531', '55db9f95a422fb3f58855b43822bd000', '3325', NULL, '1', NULL, NULL, NULL, '1', '102', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('532', '2bc508ded58649da39564fa3e414aa1d', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('533', '2bc508ded58649da39564fa3e414aa1d', '2', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('534', '2df0a2cff10689b9ef9287afa0ed82a2', '3409', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('538', '57855c844d25ec41f52df14d47c26fbc', '3374', NULL, '6', NULL, NULL, NULL, '1', '103', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('539', '57855c844d25ec41f52df14d47c26fbc', '3375', NULL, '3', NULL, NULL, NULL, '1', '103', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('540', '57855c844d25ec41f52df14d47c26fbc', '2086', NULL, '18', NULL, NULL, NULL, '1', '103', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('541', '57855c844d25ec41f52df14d47c26fbc', '2087', NULL, '12', NULL, NULL, NULL, '1', '103', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('542', '57855c844d25ec41f52df14d47c26fbc', '1455', NULL, '1', NULL, NULL, NULL, '1', '103', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('543', '57855c844d25ec41f52df14d47c26fbc', '2937', NULL, '5', NULL, NULL, NULL, '1', '103', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('544', '754b1fd56fc3dba2c94dc2ca46047cf7', '1452', NULL, '1', NULL, NULL, NULL, '1', '104', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('545', '754b1fd56fc3dba2c94dc2ca46047cf7', '1453', NULL, '1', NULL, NULL, NULL, '1', '104', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('546', '754b1fd56fc3dba2c94dc2ca46047cf7', '2417', NULL, '2', NULL, NULL, NULL, '1', '104', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('547', '754b1fd56fc3dba2c94dc2ca46047cf7', '2407', NULL, '2', NULL, NULL, NULL, '1', '104', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('548', '6cd0b86102a020621d1ed21e674f3477', '2746', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('549', '7207fc395c65a4a12c9cb404478b4c0b', '824', NULL, '1', NULL, NULL, NULL, '1', '105', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('550', '3b45c50f2add2f8db07c6becfcdd5849', '388', NULL, '1', NULL, NULL, NULL, '1', '106', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('553', '3b45c50f2add2f8db07c6becfcdd5849', '1282', NULL, '2', NULL, NULL, NULL, '1', '106', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('555', '3b45c50f2add2f8db07c6becfcdd5849', '1268', NULL, '3', NULL, NULL, NULL, '1', '106', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('556', '3b45c50f2add2f8db07c6becfcdd5849', '1277', NULL, '5', NULL, NULL, NULL, '1', '106', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('557', '3b45c50f2add2f8db07c6becfcdd5849', '1278', NULL, '5', NULL, NULL, NULL, '1', '106', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('558', '3b45c50f2add2f8db07c6becfcdd5849', '1706', NULL, '1', NULL, NULL, NULL, '1', '106', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('559', '3b45c50f2add2f8db07c6becfcdd5849', '1787', NULL, '20', NULL, NULL, NULL, '1', '106', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('560', '3b45c50f2add2f8db07c6becfcdd5849', '484', NULL, '10', NULL, NULL, NULL, '1', '106', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('561', '6247370397c364963fd3304e223d36e4', '659', NULL, '6', NULL, NULL, NULL, '1', '107', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('563', '44cd77d518369c5a3c08e7683b16f4e3', '3167', NULL, '2', NULL, NULL, NULL, '1', '108', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('564', '530ab604530be6cbe2b74ad13170d7e8', '1', NULL, '1', NULL, NULL, NULL, '1', '109', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('567', '37df3992c3694f5fbfc08f73398169e9', '1893', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('570', 'b5143dc2226cb02f823505f882577afd', '1661', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('571', 'b48e2d679887096a9ff9ef47a8ed7b9c', '12', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('572', 'fcc75d6109c485e0c4712c1ead00f119', '1731', NULL, '1', NULL, NULL, NULL, '1', '110', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('573', 'e218238bba88b0fcf103d8165aec7b65', '1350', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('574', 'c1332d3d26759b7dfce6094a317be56d', '3357', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('575', 'd9126fd9622c419e284f7afcaf9f3228', '1967', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('576', '61ed896b1cbb3a9801d13cf1d1d134c8', '2407', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('577', 'bc679cb4a7bb139fd72a933c5b68618b', '1892', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('578', 'a1658f834b17521c49f89ac260fdabe2', '2407', NULL, '10', NULL, NULL, NULL, '1', '111', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('579', 'a1658f834b17521c49f89ac260fdabe2', '2364', NULL, '2', NULL, NULL, NULL, '1', '111', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('580', '57a5831c25813f31aca585d81be99d59', '3350', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('581', 'f9dfa9ac3702aeb06d31759090cd0dbc', '3535', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('582', '4540327e99e2e5ceb3dd3a3b54371d3e', '660', NULL, '1', NULL, NULL, NULL, '1', '112', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('585', '4e4785f42230a9e7fe264b60cb339f72', '37', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('586', 'c4754a1e5e0f25dda8d33e7eeca2ec1e', '388', NULL, '1', NULL, NULL, NULL, '1', '113', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('587', 'c4754a1e5e0f25dda8d33e7eeca2ec1e', '484', NULL, '2', NULL, NULL, NULL, '1', '113', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('588', 'c4754a1e5e0f25dda8d33e7eeca2ec1e', '1787', NULL, '2', NULL, NULL, NULL, '1', '113', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('591', 'c4754a1e5e0f25dda8d33e7eeca2ec1e', '1287', NULL, '2', NULL, NULL, NULL, '1', '113', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('592', 'c4754a1e5e0f25dda8d33e7eeca2ec1e', '1706', NULL, '1', NULL, NULL, NULL, '1', '113', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('593', 'c4754a1e5e0f25dda8d33e7eeca2ec1e', '1794', NULL, '5', NULL, NULL, NULL, '1', '113', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('595', 'c4754a1e5e0f25dda8d33e7eeca2ec1e', '3467', NULL, '1', NULL, NULL, NULL, '1', '113', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('596', 'c4754a1e5e0f25dda8d33e7eeca2ec1e', '3468', NULL, '1', NULL, NULL, NULL, '1', '113', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('597', 'c4754a1e5e0f25dda8d33e7eeca2ec1e', '484', NULL, '20', NULL, NULL, NULL, '1', '114', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('598', 'd6eaa8cedf464ef7ba67d4c25a2d6900', '2772', NULL, '1', NULL, NULL, NULL, '1', '115', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('599', '7bb5f95d9c367e4ac503bf27c540bfcc', '1258', NULL, '2', NULL, NULL, NULL, '1', '116', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('600', '7bb5f95d9c367e4ac503bf27c540bfcc', '1258', NULL, '2', NULL, NULL, NULL, '1', '117', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('602', '4f7bac5031beda89d5966e100e6710df', '246', NULL, '1', NULL, NULL, NULL, '1', '118', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('603', '77d16f8e5252ecac54e338b0bf03af68', '327', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('605', 'a67af89f936fa0e0ffd20e3b8e79a535', '3443', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('606', '8f561e14d387c71f89743dee4da31bd1', '2928', NULL, '1', NULL, NULL, NULL, '1', '119', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('609', 'ea051eba2d9bf0c7224c121bb7f9ee99', '3316', NULL, '5', NULL, NULL, NULL, '1', '120', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('610', 'ea051eba2d9bf0c7224c121bb7f9ee99', '2074', NULL, '48', NULL, NULL, NULL, '1', '120', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('611', 'ea051eba2d9bf0c7224c121bb7f9ee99', '2085', NULL, '48', NULL, NULL, NULL, '1', '120', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('612', 'ea051eba2d9bf0c7224c121bb7f9ee99', '3463', NULL, '24', NULL, NULL, NULL, '1', '120', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('613', 'ea051eba2d9bf0c7224c121bb7f9ee99', '3315', NULL, '5', NULL, NULL, NULL, '1', '120', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('614', 'ef26b8c9ee95445e316371424a04e17f', '1938', NULL, '5', NULL, NULL, NULL, '1', '121', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('615', '18d5530365143293e8b50aff5b095506', '2364', NULL, '1', NULL, NULL, NULL, '1', '122', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('617', '18d5530365143293e8b50aff5b095506', '1909', NULL, '1', NULL, NULL, NULL, '1', '122', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('618', '18d5530365143293e8b50aff5b095506', '1455', NULL, '1', NULL, NULL, NULL, '1', '122', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('619', '18d5530365143293e8b50aff5b095506', '3283', NULL, '2', NULL, NULL, NULL, '1', '122', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('620', '84caf2b7ef2804dbb14bf6530811de56', '187', NULL, '1', NULL, NULL, NULL, '1', '123', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('621', 'af381bed4817949b12ef55c3ed3cea24', '1463', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('622', '043767f2ab12720f52aeaa040843702a', '3334', NULL, '1', NULL, NULL, NULL, '1', '124', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('623', '043767f2ab12720f52aeaa040843702a', '2799', NULL, '1', NULL, NULL, NULL, '1', '124', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('624', '043767f2ab12720f52aeaa040843702a', '2802', NULL, '1', NULL, NULL, NULL, '1', '124', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('625', '3f0e608d69c38678ca1e77fb289b2596', '614', NULL, '4', NULL, NULL, NULL, '1', '125', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('626', '3f0e608d69c38678ca1e77fb289b2596', '606', NULL, '4', NULL, NULL, NULL, '1', '125', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('627', '407c021286cd738a3984590676a21f9c', '977', NULL, '1', NULL, NULL, NULL, '1', '126', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('628', 'dbe4ea63227726cb40ebeb9fe8302f06', '659', NULL, '1', NULL, NULL, NULL, '1', '127', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('629', '306f442a465fb4ac7bb6cc4c0fcc20df', '1283', NULL, '6', NULL, NULL, NULL, '1', '128', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('630', '306f442a465fb4ac7bb6cc4c0fcc20df', '366', NULL, '5', NULL, NULL, NULL, '1', '128', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('632', '5d349b25d8d1ff1d8ea3fb1dbf839494', '2516', NULL, '5', NULL, NULL, NULL, '1', '129', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('633', '474ab53297752438d861840e73597a22', '2400', NULL, '10', NULL, NULL, NULL, '1', '130', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('634', '474ab53297752438d861840e73597a22', '491', NULL, '5', NULL, NULL, NULL, '1', '130', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('635', 'e67bb5e37699b02d43cc929ecd8a349e', '62', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('636', '6d69b80b9166507eab531f3be28e773f', '2620', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('639', 'ecf28a90f6cf59c8d5c5a709899270a8', '687', NULL, '1', NULL, NULL, NULL, '1', '131', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('640', 'ecf28a90f6cf59c8d5c5a709899270a8', '690', NULL, '1', NULL, NULL, NULL, '1', '131', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('641', 'ecf28a90f6cf59c8d5c5a709899270a8', '857', NULL, '1', NULL, NULL, NULL, '1', '131', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('642', 'ecf28a90f6cf59c8d5c5a709899270a8', '297', NULL, '1', NULL, NULL, NULL, '1', '131', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('643', 'ecf28a90f6cf59c8d5c5a709899270a8', '300', NULL, '1', NULL, NULL, NULL, '1', '131', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('644', 'ecf28a90f6cf59c8d5c5a709899270a8', '303', NULL, '1', NULL, NULL, NULL, '1', '131', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('645', '184c42e9e585d3f832c8b2a656f6d79f', '711', NULL, '1', NULL, NULL, NULL, '1', '132', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('646', '184c42e9e585d3f832c8b2a656f6d79f', '731', NULL, '1', NULL, NULL, NULL, '1', '132', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('647', 'd9c9feb22cbefa6ea81ae81fbdb78c31', '1366', NULL, '4', NULL, NULL, NULL, '1', '133', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('648', 'c0bf5a2a12245d41bb9a19654066aea8', '1275', NULL, '20', NULL, NULL, NULL, '1', '134', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('649', 'bdad16da57ff2e61182acc11d58ad9ee', '2311', NULL, '2', NULL, NULL, NULL, '1', '135', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('650', 'bdad16da57ff2e61182acc11d58ad9ee', '659', NULL, '5', NULL, NULL, NULL, '1', '135', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('651', '3a4f6bdd327294384c6a758d248ac3bd', '1423', NULL, '25', NULL, NULL, NULL, '1', '136', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('652', 'f820ad37822976ed11c9aacaaf5e6cb2', '1983', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('653', 'f820ad37822976ed11c9aacaaf5e6cb2', '1977', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('654', 'f820ad37822976ed11c9aacaaf5e6cb2', '3289', NULL, '3', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('655', 'f820ad37822976ed11c9aacaaf5e6cb2', '2934', NULL, '3', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('656', 'f820ad37822976ed11c9aacaaf5e6cb2', '2364', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('658', 'f820ad37822976ed11c9aacaaf5e6cb2', '29', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('659', 'hhjv76ocso2egi0elj6c6l9bvc', '2600', NULL, '5', NULL, NULL, NULL, '1', '137', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('660', '9784db8d0d3c0de7b46b8e29d75b4cfa', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('661', '03b3e5d566ea032ca8e67b4e926e3b7e', '1619', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('662', 'b89f026a537e8d100afe0fc61d6a73f2', '37', NULL, '1', NULL, NULL, NULL, '1', '138', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('663', 'b89f026a537e8d100afe0fc61d6a73f2', '38', NULL, '4', NULL, NULL, NULL, '1', '138', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('664', 'b89f026a537e8d100afe0fc61d6a73f2', '40', NULL, '1', NULL, NULL, NULL, '1', '138', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('665', 'b89f026a537e8d100afe0fc61d6a73f2', '46', NULL, '1', NULL, NULL, NULL, '1', '138', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('666', 'b89f026a537e8d100afe0fc61d6a73f2', '49', NULL, '1', NULL, NULL, NULL, '1', '138', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('667', 'b89f026a537e8d100afe0fc61d6a73f2', '3031', NULL, '4', NULL, NULL, NULL, '1', '138', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('668', 'b89f026a537e8d100afe0fc61d6a73f2', '366', NULL, '1', NULL, NULL, NULL, '1', '138', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('669', 'b89f026a537e8d100afe0fc61d6a73f2', '623', NULL, '8', NULL, NULL, NULL, '1', '138', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('670', 'b89f026a537e8d100afe0fc61d6a73f2', '809', NULL, '1', NULL, NULL, NULL, '1', '138', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('671', 'b89f026a537e8d100afe0fc61d6a73f2', '3409', NULL, '36', NULL, NULL, NULL, '1', '138', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('672', 'b89f026a537e8d100afe0fc61d6a73f2', '3411', NULL, '36', NULL, NULL, NULL, '1', '138', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('673', 'b89f026a537e8d100afe0fc61d6a73f2', '2086', NULL, '24', NULL, NULL, NULL, '1', '138', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('674', '6593980a4ec46a946c1539c281987eb6', '916', NULL, '2', NULL, NULL, NULL, '1', '139', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('675', '6593980a4ec46a946c1539c281987eb6', '3463', NULL, '8', NULL, NULL, NULL, '1', '139', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('676', '6593980a4ec46a946c1539c281987eb6', '721', NULL, '2', NULL, NULL, NULL, '1', '139', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('677', '6593980a4ec46a946c1539c281987eb6', '722', NULL, '2', NULL, NULL, NULL, '1', '139', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('679', '48bec2e71db2b558e2a7f14e4c8a0a61', '1428', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('680', '0a790bda7cc88b287f68b8cffb6fc35e', '1283', NULL, '5', NULL, NULL, NULL, '1', '140', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('681', '7bb7d6197b32b93abc5fd028b31a8837', '29', NULL, '1', NULL, NULL, NULL, '1', '141', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('682', '7bb7d6197b32b93abc5fd028b31a8837', '2364', NULL, '1', NULL, NULL, NULL, '1', '141', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('683', '7bb7d6197b32b93abc5fd028b31a8837', '3289', NULL, '3', NULL, NULL, NULL, '1', '141', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('684', '7bb7d6197b32b93abc5fd028b31a8837', '2934', NULL, '3', NULL, NULL, NULL, '1', '141', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('685', '7bb7d6197b32b93abc5fd028b31a8837', '622', NULL, '1', NULL, NULL, NULL, '1', '141', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('686', '7bb7d6197b32b93abc5fd028b31a8837', '616', NULL, '1', NULL, NULL, NULL, '1', '141', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('687', '4cde28ef6b8cf8c307800e1f60b210b2', '425', NULL, '1', NULL, NULL, NULL, '1', '142', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('688', '4cde28ef6b8cf8c307800e1f60b210b2', '430', NULL, '1', NULL, NULL, NULL, '1', '142', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('689', '185033780609610609df3423d1af44cc', '666', NULL, '1', NULL, NULL, NULL, '1', '143', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('690', '185033780609610609df3423d1af44cc', '1286', NULL, '10', NULL, NULL, NULL, '1', '143', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('691', '61b715554f286f5c38687831e5841851', '698', NULL, '2', NULL, NULL, NULL, '1', '144', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('692', '61b715554f286f5c38687831e5841851', '3495', NULL, '2', NULL, NULL, NULL, '1', '144', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('693', '61b715554f286f5c38687831e5841851', '3290', NULL, '10', NULL, NULL, NULL, '1', '145', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('694', '8c82bf4dc1c15e64e7d0636b8232f78d', '3575', NULL, '1', NULL, NULL, NULL, '1', '146', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('695', '8c82bf4dc1c15e64e7d0636b8232f78d', '3545', NULL, '1', NULL, NULL, NULL, '1', '146', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('696', '8c82bf4dc1c15e64e7d0636b8232f78d', '2041', NULL, '1', NULL, NULL, NULL, '1', '146', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('697', '373108595dde27fe7a4f864b9ccfe812', '2406', NULL, '10', NULL, NULL, NULL, '1', '147', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('698', 'd6c56a5baea25970ee07fabfb562b6d3', '916', NULL, '2', NULL, NULL, NULL, '1', '148', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('699', '7b1ffda44a34d18e4af9aca9b0f869b7', '2406', NULL, '12', NULL, NULL, NULL, '1', '149', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('700', 'e55e84e33dfb65e2403f4df8bd1f9a6b', '804', NULL, '1', NULL, NULL, NULL, '1', '150', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('701', 'e55e84e33dfb65e2403f4df8bd1f9a6b', '660', NULL, '4', NULL, NULL, NULL, '1', '150', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('702', 'e55e84e33dfb65e2403f4df8bd1f9a6b', '659', NULL, '5', NULL, NULL, NULL, '1', '150', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('703', 'fdb4a59673eee9010336327bac51be35', '809', NULL, '3', NULL, NULL, NULL, '1', '151', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('704', 'a054769fed6e20a9ebe162f253324d70', '2943', NULL, '21', NULL, NULL, NULL, '1', '152', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('705', 'a5396ebfed5caa6bffb8442f139d4d61', '2869', NULL, '1', NULL, NULL, NULL, '1', '153', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('706', 'a5396ebfed5caa6bffb8442f139d4d61', '2876', NULL, '2', NULL, NULL, NULL, '1', '153', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('707', 'a5396ebfed5caa6bffb8442f139d4d61', '2878', NULL, '2', NULL, NULL, NULL, '1', '153', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('708', '547f88f97f8fba7b17551d2d64df84db', '2405', NULL, '20', NULL, NULL, NULL, '1', '154', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('710', '9c85f4be2c7af20065f039f85bf7a699', '1794', NULL, '200', NULL, NULL, NULL, '1', '155', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('711', '9c85f4be2c7af20065f039f85bf7a699', '1795', NULL, '100', NULL, NULL, NULL, '1', '155', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('712', '6204172524c8af1454a10e36f00f80a3', '37', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('713', '248fa28eaec6cd79c9cc81be2448bbe6', '2075', NULL, '40', NULL, NULL, NULL, '1', '156', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('714', '248fa28eaec6cd79c9cc81be2448bbe6', '3342', NULL, '1', NULL, NULL, NULL, '1', '156', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('715', '248fa28eaec6cd79c9cc81be2448bbe6', '3331', NULL, '2', NULL, NULL, NULL, '1', '156', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('716', 'eb5af8345c54692e9a0d3f5c1018b979', '3067', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('717', 'c7e919a2efdd4f796e41588da53c8985', '2482', NULL, '3', NULL, NULL, NULL, '1', '157', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('718', 'c7e919a2efdd4f796e41588da53c8985', '2490', NULL, '3', NULL, NULL, NULL, '1', '157', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('719', 'c7e919a2efdd4f796e41588da53c8985', '2491', NULL, '5', NULL, NULL, NULL, '1', '157', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('720', 'c7e919a2efdd4f796e41588da53c8985', '2495', NULL, '3', NULL, NULL, NULL, '1', '157', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('721', 'c7e919a2efdd4f796e41588da53c8985', '2498', NULL, '3', NULL, NULL, NULL, '1', '157', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('722', '7d8f0eb191fea011ebcb2deeb6150726', '2731', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('723', 'd8aa1d1e7d32785f286a1702b4c4eda7', '2364', NULL, '4', NULL, NULL, NULL, '1', '158', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('724', 'e8c27b35c51c89f0bddc765a6b9ceec5', '1502', NULL, '2', NULL, NULL, NULL, '1', '159', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('726', 'e8c27b35c51c89f0bddc765a6b9ceec5', '1502', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('727', '5fc6352cb5ac1d1fe9c68271f65dde79', '3092', NULL, '1', NULL, NULL, NULL, '1', '160', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('728', 'b618f7be25a72f2d196252f718ff2eab', '2364', NULL, '2', NULL, NULL, NULL, '1', '161', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('729', '8486beb8ee7fd2c1b788bde6a351bfca', '3092', NULL, '1', NULL, NULL, NULL, '1', '162', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('730', '11bff1471815362a545cd1aacbc47e0f', '381', NULL, '5', NULL, NULL, NULL, '1', '163', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('731', '11bff1471815362a545cd1aacbc47e0f', '1792', NULL, '40', NULL, NULL, NULL, '1', '163', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('732', '11bff1471815362a545cd1aacbc47e0f', '606', NULL, '1', NULL, NULL, NULL, '1', '163', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('733', '868639576c8b2dd53aff97a04846178f', '98', NULL, '1', NULL, NULL, NULL, '1', '164', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('734', 'e5ea4a9ed7ca272aac1e1086475bbbeb', '731', NULL, '1', NULL, NULL, NULL, '1', '165', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('735', 'e5ea4a9ed7ca272aac1e1086475bbbeb', '3451', NULL, '12', NULL, NULL, NULL, '1', '165', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('738', 'f263bc5ce1f5ca25d1de1be532152552', '2405', NULL, '10', NULL, NULL, NULL, '1', '166', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('739', 'f263bc5ce1f5ca25d1de1be532152552', '2415', NULL, '10', NULL, NULL, NULL, '1', '166', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('741', '29de5b89237f5c93b9e846b547257203', '297', NULL, '1', NULL, NULL, NULL, '1', '167', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('742', 'ae05faad9c74bc9c4eced5dd3f44d40c', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('745', 'eb36b826afabb6f16f6d9b44aff99ff1', '624', NULL, '1', NULL, NULL, NULL, '1', '168', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('746', 'eb36b826afabb6f16f6d9b44aff99ff1', '625', NULL, '1', NULL, NULL, NULL, '1', '168', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('747', 'ca0e5d80f6a7c59982103726c6a4720c', '3776', NULL, '5', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('749', '3ca5bc8615af7aefb44fe033fb283250', '3558', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('751', '2716eba5fdc8303413a4b36a4e217163', '592', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('752', '2716eba5fdc8303413a4b36a4e217163', '593', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('753', '443f89f6a85959ffab40459b275cdced', '2604', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('755', '443f89f6a85959ffab40459b275cdced', '1729', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('756', '0f1707ef9dce25394f4f6995bfefa560', '2362', NULL, '1', NULL, NULL, NULL, '1', '169', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('757', '0f1707ef9dce25394f4f6995bfefa560', '1722', NULL, '1', NULL, NULL, NULL, '1', '169', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('758', '0f1707ef9dce25394f4f6995bfefa560', '1784', NULL, '2', NULL, NULL, NULL, '1', '169', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('759', '0f1707ef9dce25394f4f6995bfefa560', '2607', NULL, '1', NULL, NULL, NULL, '1', '169', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('760', 'a930ab56a1f07ea1fad8283fdf104349', '3827', NULL, '12', NULL, NULL, NULL, '1', '170', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('761', '1r5e8crfd77290dcml9jjvjsn2', '317', NULL, '5', NULL, NULL, NULL, '1', '171', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('762', 'hirfibmk2qjkq13bgk1soa5de4', '3328', NULL, '2', NULL, NULL, NULL, '1', '173', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('763', 'hirfibmk2qjkq13bgk1soa5de4', '40', NULL, '3', NULL, NULL, NULL, '1', '173', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('764', 'hirfibmk2qjkq13bgk1soa5de4', '49', NULL, '3', NULL, NULL, NULL, '1', '173', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('765', '87rjfdlqn8jn6dilr1f3nlsnr3', '1268', NULL, '4', NULL, NULL, NULL, '1', '174', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('766', '87rjfdlqn8jn6dilr1f3nlsnr3', '1286', NULL, '10', NULL, NULL, NULL, '1', '174', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('767', '87rjfdlqn8jn6dilr1f3nlsnr3', '1270', NULL, '5', NULL, NULL, NULL, '1', '174', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('768', '87rjfdlqn8jn6dilr1f3nlsnr3', '1282', NULL, '10', NULL, NULL, NULL, '1', '174', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('770', 'hg4osdqvtpdasskuvvhdlallv0', '555', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('771', 'v65rq1ki7bqqamafe7rkd9kfa0', '1893', NULL, '1', NULL, NULL, NULL, '1', '175', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('772', 'v65rq1ki7bqqamafe7rkd9kfa0', '2269', NULL, '1', NULL, NULL, NULL, '1', '175', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('773', 'v65rq1ki7bqqamafe7rkd9kfa0', '3331', NULL, '2', NULL, NULL, NULL, '1', '175', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('774', 'v65rq1ki7bqqamafe7rkd9kfa0', '2409', NULL, '22', NULL, NULL, NULL, '1', '175', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('775', 'v65rq1ki7bqqamafe7rkd9kfa0', '2419', NULL, '2', NULL, NULL, NULL, '1', '175', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('776', 'v65rq1ki7bqqamafe7rkd9kfa0', '41', NULL, '20', NULL, NULL, NULL, '1', '175', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('777', 'fhfof5cnil9up2qivecb52qfp4', '3292', NULL, '12', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('778', '3idmobm3t58rk1flltle3hrs84', '1439', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('780', 'fjk9v8o6toes8u74re5j4c4bu6', '721', NULL, '1', NULL, NULL, NULL, '1', '176', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('781', 'fjk9v8o6toes8u74re5j4c4bu6', '3844', NULL, '5', NULL, NULL, NULL, '1', '176', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('782', 'fjk9v8o6toes8u74re5j4c4bu6', '2949', NULL, '6', NULL, NULL, NULL, '1', '176', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('783', 'fjk9v8o6toes8u74re5j4c4bu6', '2482', NULL, '6', NULL, NULL, NULL, '1', '176', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('784', 'ti4mftqk7nl51gioidtivr9at0', '929', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('785', 'sjj6ialvlv53kbu6ejef1k8tv2', '1275', NULL, '6', NULL, NULL, NULL, '1', '177', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('787', 'lr51rbfhj7nrldmfmc5q40r4b7', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('788', 'lr51rbfhj7nrldmfmc5q40r4b7', '3922', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('789', 'k0n70avfh9f8aheukm774t9oa3', '538', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('790', 'rf4lt0tkt0r0muouleo3dnme42', '935', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('793', 'em3gajb7lc6ofsppieddm09vr5', '3689', NULL, '1', NULL, NULL, NULL, '1', '178', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('794', 'em3gajb7lc6ofsppieddm09vr5', '712', NULL, '1', NULL, NULL, NULL, '1', '178', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('795', 'em3gajb7lc6ofsppieddm09vr5', '550', NULL, '7', NULL, NULL, NULL, '1', '178', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('796', 'em3gajb7lc6ofsppieddm09vr5', '2484', NULL, '4', NULL, NULL, NULL, '1', '178', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('797', 'ce34u398oduafmqhek8jnp3k45', '1934', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('798', 'r6kjnsuplsm2gv993034u81f63', '1282', NULL, '30', NULL, NULL, NULL, '1', '179', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('799', 'r6kjnsuplsm2gv993034u81f63', '1268', NULL, '15', NULL, NULL, NULL, '1', '179', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('800', '86j7art7b106aho19qt8lteep2', '740', NULL, '1', NULL, NULL, NULL, '1', '180', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('801', '86j7art7b106aho19qt8lteep2', '332', NULL, '1', NULL, NULL, NULL, '1', '180', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('802', '86j7art7b106aho19qt8lteep2', '491', NULL, '1', NULL, NULL, NULL, '1', '180', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('803', '86j7art7b106aho19qt8lteep2', '1499', NULL, '1', NULL, NULL, NULL, '1', '180', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('804', 'i5q36dr66re6kna6dqpjabqpg2', '1909', NULL, '2', NULL, NULL, NULL, '1', '181', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('805', 'i5q36dr66re6kna6dqpjabqpg2', '2602', NULL, '4', NULL, NULL, NULL, '1', '181', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('807', '4cufgb4qqbigcim9pe1t9fi037', '3092', NULL, '1', NULL, NULL, NULL, '1', '182', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('808', 'h4paog5a44knlb18doi9mpst55', '1046', NULL, '2', NULL, NULL, NULL, '1', '183', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('809', 'h4paog5a44knlb18doi9mpst55', '1047', NULL, '1', NULL, NULL, NULL, '1', '183', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('810', 'h4paog5a44knlb18doi9mpst55', '1791', NULL, '2', NULL, NULL, NULL, '1', '183', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('811', 'h4paog5a44knlb18doi9mpst55', '1994', NULL, '40', NULL, NULL, NULL, '1', '183', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('812', 'h4paog5a44knlb18doi9mpst55', '3333', NULL, '2', NULL, NULL, NULL, '1', '183', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('813', 'h4paog5a44knlb18doi9mpst55', '3343', NULL, '6', NULL, NULL, NULL, '1', '183', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('814', 'mik3a5sjtqbpgf2t8u7ku3vqu0', '2589', NULL, '2', NULL, NULL, NULL, '1', '184', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('815', 'jrt84rj0m5rdh1ed03ij5pngr0', '630', NULL, '1', NULL, NULL, NULL, '1', '185', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('816', '2oen68vfjfh1gilq3a01itpdm7', '3130', NULL, '5', NULL, NULL, NULL, '1', '186', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('817', '2oen68vfjfh1gilq3a01itpdm7', '3136', NULL, '5', NULL, NULL, NULL, '1', '186', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('818', 'ef27ehjadnjmthqr0mm6f407p0', '1818', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('819', 'ef27ehjadnjmthqr0mm6f407p0', '1947', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('820', 'ef27ehjadnjmthqr0mm6f407p0', '554', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('821', 'i7gv2mdbah8nn4bh2gosofp1l2', '3924', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('822', '2k408u9f080q8ivj8ccfcmopq4', '2407', NULL, '1', NULL, NULL, NULL, '1', '187', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('823', '2k408u9f080q8ivj8ccfcmopq4', '2409', NULL, '1', NULL, NULL, NULL, '1', '187', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('824', '4ideadep72l9agd9vtgugbags3', '1818', NULL, '1', NULL, NULL, NULL, '1', '188', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('825', '4ideadep72l9agd9vtgugbags3', '1947', NULL, '1', NULL, NULL, NULL, '1', '188', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('826', '4ideadep72l9agd9vtgugbags3', '553', NULL, '1', NULL, NULL, NULL, '1', '188', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('827', '4ideadep72l9agd9vtgugbags3', '1366', NULL, '5', NULL, NULL, NULL, '1', '188', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('828', '4ideadep72l9agd9vtgugbags3', '1368', NULL, '5', NULL, NULL, NULL, '1', '188', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('829', '4ideadep72l9agd9vtgugbags3', '488', NULL, '15', NULL, NULL, NULL, '1', '188', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('830', '4ideadep72l9agd9vtgugbags3', '484', NULL, '5', NULL, NULL, NULL, '1', '188', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('832', '1vasdbfr9rop6s75a721ms0op6', '2', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('833', '33ovfs9dadkq2bnmfdnn4cb7l3', '2417', NULL, '10', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('834', '33ovfs9dadkq2bnmfdnn4cb7l3', '2407', NULL, '10', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('835', '33ovfs9dadkq2bnmfdnn4cb7l3', '2356', NULL, '4', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('836', 'sjfcqlapka69qqivv9o62vm7n6', '659', NULL, '12', NULL, NULL, NULL, '1', '189', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('837', 'a24gqu4oboia72does4c3agsh0', '661', NULL, '2', NULL, NULL, NULL, '1', '190', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('838', 'a24gqu4oboia72does4c3agsh0', '3264', NULL, '1', NULL, NULL, NULL, '1', '190', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('839', 'hhcr6ta04poh8gqq7jnnlrrir6', '2376', NULL, '1', NULL, NULL, NULL, '1', '191', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('840', 'q8vn83dobuor6kb23lmlbie3b1', '2356', NULL, '4', NULL, NULL, NULL, '1', '192', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('841', 'q8vn83dobuor6kb23lmlbie3b1', '2417', NULL, '10', NULL, NULL, NULL, '1', '192', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('842', 'q8vn83dobuor6kb23lmlbie3b1', '2407', NULL, '10', NULL, NULL, NULL, '1', '192', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('843', '78i4i6m1jmf5bbn7qijr7irip5', '410', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('844', 'cub2gaa3h1cp964uhkbejbf9v4', '3342', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('845', '79747h1cj3rkhrh0rbdm0luj91', '197', NULL, '1', NULL, NULL, NULL, '1', '193', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('846', 'dn8n015re99j59ev2i54et5hv0', '1947', NULL, '2', NULL, NULL, NULL, '1', '194', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('847', 'maq69nnoj4l67bdmv2qgrhnnk0', '917', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('848', 'maq69nnoj4l67bdmv2qgrhnnk0', '2602', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('849', 'pdrsh32pk0q7inv0meg2dq4rn3', '2364', NULL, '10', NULL, NULL, NULL, '1', '195', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('850', 'v627a4etguanukmgida6t9k1j6', '484', NULL, '10', NULL, NULL, NULL, '1', '196', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('851', 'v627a4etguanukmgida6t9k1j6', '482', NULL, '10', NULL, NULL, NULL, '1', '196', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('852', 'i5jurjrsnad3jk56a5hg2of7k2', '1916', NULL, '1', NULL, NULL, NULL, '1', '197', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('853', 'i5jurjrsnad3jk56a5hg2of7k2', '3174', NULL, '1', NULL, NULL, NULL, '1', '197', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('854', 'njqq1ii9kjdvn9fg9f6j3o01c0', '3312', NULL, '1', NULL, NULL, NULL, '1', '198', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('855', '6nkl700mti1gb61qmh8gg7pt10', '916', NULL, '1', NULL, NULL, NULL, '1', '199', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('856', '6nkl700mti1gb61qmh8gg7pt10', '3312', NULL, '1', NULL, NULL, NULL, '1', '199', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('857', '6nkl700mti1gb61qmh8gg7pt10', '1917', NULL, '1', NULL, NULL, NULL, '1', '199', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('858', '6nkl700mti1gb61qmh8gg7pt10', '1938', NULL, '1', NULL, NULL, NULL, '1', '199', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('859', 'assidaismaniqo7vpms90vo8j4', '329', NULL, '1', NULL, NULL, NULL, '1', '200', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('860', 'assidaismaniqo7vpms90vo8j4', '330', NULL, '1', NULL, NULL, NULL, '1', '200', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('861', 't0seg96fte25ccc64ot01l77q6', '3506', NULL, '1', NULL, NULL, NULL, '1', '201', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('862', 't0seg96fte25ccc64ot01l77q6', '3505', NULL, '1', NULL, NULL, NULL, '1', '201', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('863', 'msn4l8bqid9bsl0f5nb9voeou3', '916', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('866', 'assidaismaniqo7vpms90vo8j4', '3505', NULL, '1', NULL, NULL, NULL, '1', '202', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('867', 'assidaismaniqo7vpms90vo8j4', '3506', NULL, '1', NULL, NULL, NULL, '1', '202', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('870', 'u7v55tgaei5afcbv54440h3nr3', '1', NULL, '1', NULL, NULL, NULL, '1', '203', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('871', 'u7v55tgaei5afcbv54440h3nr3', '2', NULL, '1', NULL, NULL, NULL, '1', '203', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('872', 'u7v55tgaei5afcbv54440h3nr3', '3', NULL, '1', NULL, NULL, NULL, '1', '203', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('873', 'u7v55tgaei5afcbv54440h3nr3', '4', NULL, '1', NULL, NULL, NULL, '1', '203', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('874', 'vq6kdgsm2vk0db5d3ik2606dh5', '2311', NULL, '2', NULL, NULL, NULL, '1', '204', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('875', 'vq6kdgsm2vk0db5d3ik2606dh5', '3263', NULL, '50', NULL, NULL, NULL, '1', '204', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('876', 'vq6kdgsm2vk0db5d3ik2606dh5', '1271', NULL, '50', NULL, NULL, NULL, '1', '204', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('877', 'vq6kdgsm2vk0db5d3ik2606dh5', '1272', NULL, '50', NULL, NULL, NULL, '1', '204', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('878', 'nqr025q1nq4r6rrgu1sh0qg545', '4102', NULL, '36', NULL, NULL, NULL, '1', '205', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('879', 'm54t641jd105br4hmppqurpbi2', '2325', NULL, '1', NULL, NULL, NULL, '1', '206', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('880', 'm54t641jd105br4hmppqurpbi2', '2351', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('881', '071k9hd581viiqdv08o1hpumu2', '1461', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('882', '0p6hs5cc03vvbus2a9b4cl2050', '2411', NULL, '5', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('883', '2l2jk4etthkm05nkvrcai72pv5', '401', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('884', '2l2jk4etthkm05nkvrcai72pv5', '1507', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('885', '2l2jk4etthkm05nkvrcai72pv5', '260', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('886', 'kr0er14mfteln6d4ro51c2ea27', '31', NULL, '1', NULL, NULL, NULL, '1', '207', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('887', 'ah0dd3g1c1gll8ulvkskttlqt7', '3114', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('888', 'klnl8gtaut7jjcchjpgbcmdps3', '2400', NULL, '13', NULL, NULL, NULL, '1', '208', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('889', 'dpgq526l87r1chj94e2pchjob0', '490', NULL, '6', NULL, NULL, NULL, '1', '209', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('890', 'fmeue07s5r9f90puc89cabg2t3', '2351', NULL, '1', NULL, NULL, NULL, '1', '210', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('891', '3rp9o0i96ceu2ud1fousddc7h5', '1758', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('892', '3rp9o0i96ceu2ud1fousddc7h5', '1756', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('893', '3rp9o0i96ceu2ud1fousddc7h5', '1752', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('894', '3rp9o0i96ceu2ud1fousddc7h5', '1753', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('898', '00cvtb37gumo509mckkcd5ia23', '2406', NULL, '10', NULL, NULL, NULL, '1', '211', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('899', '00cvtb37gumo509mckkcd5ia23', '2416', NULL, '10', NULL, NULL, NULL, '1', '211', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('900', '00cvtb37gumo509mckkcd5ia23', '2351', NULL, '1', NULL, NULL, NULL, '1', '211', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('901', 'h7bg2af4dhkue6eabs2c6q2n36', '2734', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('903', 'ich1gujc87b6vdbi7tdo7i3u27', '1272', NULL, '1', NULL, NULL, NULL, '1', '212', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('904', 'ich1gujc87b6vdbi7tdo7i3u27', '1271', NULL, '1', NULL, NULL, NULL, '1', '212', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('905', 'ich1gujc87b6vdbi7tdo7i3u27', '614', NULL, '5', NULL, NULL, NULL, '1', '212', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('906', 'tv975nq5la3p92jd51kvltb386', '2411', NULL, '2', NULL, NULL, NULL, '1', '213', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('907', '7n68dn6ttvq1g8bp75t2kfs2i0', '1286', NULL, '30', NULL, NULL, NULL, '1', '214', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('909', 'v0er4r5smof9e82b6bmv31dpe7', '1794', NULL, '200', NULL, NULL, NULL, '1', '215', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('910', '1n8cc7mgesd5d9r3n21nl5vtq7', '2237', NULL, '1', NULL, NULL, NULL, '1', '216', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('912', 'ljo1ss4svqe6jh2gn7m2g614k5', '3567', NULL, '2', NULL, NULL, NULL, '1', '217', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('913', 'ljo1ss4svqe6jh2gn7m2g614k5', '660', NULL, '2', NULL, NULL, NULL, '1', '217', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('914', 'ljo1ss4svqe6jh2gn7m2g614k5', '1452', NULL, '4', NULL, NULL, NULL, '1', '217', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('915', 'ljo1ss4svqe6jh2gn7m2g614k5', '1935', NULL, '5', NULL, NULL, NULL, '1', '217', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('916', 'ljo1ss4svqe6jh2gn7m2g614k5', '381', NULL, '5', NULL, NULL, NULL, '1', '217', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('917', 'ljo1ss4svqe6jh2gn7m2g614k5', '443', NULL, '3', NULL, NULL, NULL, '1', '217', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('918', '72o5uor56unbt5mrvvuaupr1b3', '1282', NULL, '10', NULL, NULL, NULL, '1', '218', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('920', 'c97p34b2uhlqgeu9is339jvgi4', '658', NULL, '5', NULL, NULL, NULL, '1', '219', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('921', '108jgrmkh3r5m7gdsal37l1485', '3332', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('923', 'mm91eccd1gk05li2264klec0t0', '658', NULL, '4', NULL, NULL, NULL, '1', '220', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('924', 'mm91eccd1gk05li2264klec0t0', '710', NULL, '4', NULL, NULL, NULL, '1', '220', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('925', 'mm91eccd1gk05li2264klec0t0', '2859', NULL, '1', NULL, NULL, NULL, '1', '220', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('926', 'mm91eccd1gk05li2264klec0t0', '2872', NULL, '1', NULL, NULL, NULL, '1', '220', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('927', 'ujebb49gtp4m5njs33dt8mvps5', '2417', NULL, '2', NULL, NULL, NULL, '1', '221', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('928', 'ujebb49gtp4m5njs33dt8mvps5', '2407', NULL, '2', NULL, NULL, NULL, '1', '221', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('929', 'kfrgbuqq7u3l23d3i12hk35dq2', '39', NULL, '2', NULL, NULL, NULL, '1', '222', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('931', 'turoh4r236vb1d5lgos44esdc7', '2730', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('932', 'r2369i7s07rrmc1p2kv7nqdcl4', '658', NULL, '7', NULL, NULL, NULL, '1', '223', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('933', 'au79ijsta5h0ador8ngo9vaco6', '660', NULL, '10', NULL, NULL, NULL, '1', '224', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('934', 'au79ijsta5h0ador8ngo9vaco6', '658', NULL, '10', NULL, NULL, NULL, '1', '224', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('935', '2hqkkt6nb8g8m5chulraqjll17', '1975', NULL, '6', NULL, NULL, NULL, '1', '225', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('936', '2hqkkt6nb8g8m5chulraqjll17', '1977', NULL, '6', NULL, NULL, NULL, '1', '225', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('937', 'd8hooegq97418d0osrrl9vihi4', '1905', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('938', '7qclikli49kqabepiojelf74o6', '658', NULL, '10', NULL, NULL, NULL, '1', '226', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('939', 'fvk9ft6pvfi9b89g596i8qjvl3', '2205', NULL, '2', NULL, NULL, NULL, '1', '227', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('940', 'fvk9ft6pvfi9b89g596i8qjvl3', '2210', NULL, '2', NULL, NULL, NULL, '1', '227', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('941', 'fvk9ft6pvfi9b89g596i8qjvl3', '2937', NULL, '3', NULL, NULL, NULL, '1', '227', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('942', 'fvk9ft6pvfi9b89g596i8qjvl3', '3030', NULL, '1', NULL, NULL, NULL, '1', '227', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('943', 'fvk9ft6pvfi9b89g596i8qjvl3', '3048', NULL, '1', NULL, NULL, NULL, '1', '227', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('944', 'fvk9ft6pvfi9b89g596i8qjvl3', '3053', NULL, '1', NULL, NULL, NULL, '1', '227', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('945', 'fvk9ft6pvfi9b89g596i8qjvl3', '4313', NULL, '12', NULL, NULL, NULL, '1', '228', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('946', '69s4dc61c6fs4nhh2p23bflg40', '595', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('947', '69s4dc61c6fs4nhh2p23bflg40', '3263', NULL, '109', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('949', '69s4dc61c6fs4nhh2p23bflg40', '1289', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('950', '69s4dc61c6fs4nhh2p23bflg40', '1382', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('951', '69s4dc61c6fs4nhh2p23bflg40', '1380', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('952', '69s4dc61c6fs4nhh2p23bflg40', '219', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('953', '69s4dc61c6fs4nhh2p23bflg40', '4079', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('954', '69s4dc61c6fs4nhh2p23bflg40', '4078', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('955', '69s4dc61c6fs4nhh2p23bflg40', '4077', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('956', 'hbvlv77sc7h778elqs8h4189r0', '4413', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('957', 'khsolcdn5fvp83p7brb0c41qn1', '2265', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('958', 'khsolcdn5fvp83p7brb0c41qn1', '2266', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('959', 'rav6sd8qcr5do7rfs15kthpse6', '4103', NULL, '10', NULL, NULL, NULL, '1', '229', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('960', 'rav6sd8qcr5do7rfs15kthpse6', '4101', NULL, '10', NULL, NULL, NULL, '1', '229', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('961', 'f431bfeqed11j4ar9n9uveqc23', '1059', NULL, '1', NULL, NULL, NULL, '1', '230', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('962', 'f431bfeqed11j4ar9n9uveqc23', '303', NULL, '2', NULL, NULL, NULL, '1', '230', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('964', 'ia5mm2ste5r5j1e1d58iu68vj7', '1921', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('968', 'qrgq0ksfu92k9i70r3f81t4aj5', '1381', NULL, '10', NULL, NULL, NULL, '1', '231', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('969', 'qrgq0ksfu92k9i70r3f81t4aj5', '1382', NULL, '50', NULL, NULL, NULL, '1', '231', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('970', 'qrgq0ksfu92k9i70r3f81t4aj5', '3263', NULL, '10', NULL, NULL, NULL, '1', '231', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('971', 'hkd83mpdtabmsq5n2lmu0q7lk6', '1346', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('972', 'invi9tdgmmvjogb4bs1lh1ora1', '61', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('974', 'mgs1kk73diujff5eonb4u1je64', '2403', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('975', '4m1s3498ab7bjl45lsei8gpr25', '1508', NULL, '1', NULL, NULL, NULL, '1', '232', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('976', '53rcftpe5li0lg3dkdieam68o6', '1282', NULL, '10', NULL, NULL, NULL, '1', '233', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('977', '53rcftpe5li0lg3dkdieam68o6', '1286', NULL, '8', NULL, NULL, NULL, '1', '233', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('978', 'vhbc3kntugdm01m2acs9fjerr1', '380', NULL, '1', NULL, NULL, NULL, '1', '234', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('979', 'lhm8p7dsb895gc9csqbf0pcis3', '916', NULL, '2', NULL, NULL, NULL, '1', '235', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('980', '9eintvjmcfn6bgvqtkr3rmkst7', '1429', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('981', 'a52q7fe05cprqbjngg0loalcd6', '2364', NULL, '3', NULL, NULL, NULL, '1', '236', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('982', 'died691smq5rfjv488i1rj6n76', '124', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('983', '771m6jn8lj9lno447nifvc1d90', '4413', NULL, '7', NULL, NULL, NULL, '1', '237', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('985', '771m6jn8lj9lno447nifvc1d90', '298', NULL, '2', NULL, NULL, NULL, '1', '237', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('986', '771m6jn8lj9lno447nifvc1d90', '304', NULL, '3', NULL, NULL, NULL, '1', '237', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('988', 'u2nchcq0n24o8ba0qb3sa4gsd0', '2928', NULL, '1', NULL, NULL, NULL, '1', '238', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('989', 'u2nchcq0n24o8ba0qb3sa4gsd0', '924', NULL, '2', NULL, NULL, NULL, '1', '238', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('990', 'u2nchcq0n24o8ba0qb3sa4gsd0', '3094', NULL, '2', NULL, NULL, NULL, '1', '238', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('991', 'u2nchcq0n24o8ba0qb3sa4gsd0', '1994', NULL, '108', NULL, NULL, NULL, '1', '238', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('992', 'u2nchcq0n24o8ba0qb3sa4gsd0', '1777', NULL, '1', NULL, NULL, NULL, '1', '238', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('993', 'u2nchcq0n24o8ba0qb3sa4gsd0', '1778', NULL, '1', NULL, NULL, NULL, '1', '238', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('994', 'u2nchcq0n24o8ba0qb3sa4gsd0', '1775', NULL, '1', NULL, NULL, NULL, '1', '238', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('995', 'u2nchcq0n24o8ba0qb3sa4gsd0', '2863', NULL, '1', NULL, NULL, NULL, '1', '238', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('996', 'u2nchcq0n24o8ba0qb3sa4gsd0', '878', NULL, '2', NULL, NULL, NULL, '1', '238', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('997', 'vqt8hv0oqr0p1tkj1r2d476bj6', '887', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('998', 'j31mone7at8l63165at1vtonf2', '2407', NULL, '30', NULL, NULL, NULL, '1', '239', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('999', 'f2pttmk14lltt7kgnb2mpv6el3', '197', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1000', 'f2pttmk14lltt7kgnb2mpv6el3', '381', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1001', 'djahogkpso50uiupm1i6ejk710', '2602', NULL, '1', NULL, NULL, NULL, '1', '240', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1002', 'djahogkpso50uiupm1i6ejk710', '2932', NULL, '6', NULL, NULL, NULL, '1', '240', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1004', '4tbtd8ssoqc1029b6p0edibvl6', '666', NULL, '1', NULL, NULL, NULL, '1', '241', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1005', 'gkdqoa4brbimv17nqa4dvl5r14', '2736', NULL, '2', NULL, NULL, NULL, '1', '242', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1006', '4tbtd8ssoqc1029b6p0edibvl6', '719', NULL, '2', NULL, NULL, NULL, '1', '243', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1007', '4tbtd8ssoqc1029b6p0edibvl6', '2405', NULL, '10', NULL, NULL, NULL, '1', '244', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1008', 'eu3340rvvcruor9vntot62c547', '1270', NULL, '10', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1009', 'eu3340rvvcruor9vntot62c547', '1269', NULL, '5', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1010', 'a968pgk9qhggc0r08p3op1thr4', '1347', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1012', 'l996o6ekoaepqlfoc6tggvent3', '1317', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1013', '2kj92icaeovj38j6bu150mfu20', '615', NULL, '2', NULL, NULL, NULL, '1', '245', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1014', '2kj92icaeovj38j6bu150mfu20', '614', NULL, '2', NULL, NULL, NULL, '1', '245', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1015', '2kj92icaeovj38j6bu150mfu20', '609', NULL, '2', NULL, NULL, NULL, '1', '245', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1016', '2kj92icaeovj38j6bu150mfu20', '616', NULL, '2', NULL, NULL, NULL, '1', '245', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1017', '2kj92icaeovj38j6bu150mfu20', '344', NULL, '3', NULL, NULL, NULL, '1', '245', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1018', '2kj92icaeovj38j6bu150mfu20', '2349', NULL, '1', NULL, NULL, NULL, '1', '245', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1020', '2kj92icaeovj38j6bu150mfu20', '1935', NULL, '3', NULL, NULL, NULL, '1', '246', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1021', '2kj92icaeovj38j6bu150mfu20', '1974', NULL, '3', NULL, NULL, NULL, '1', '246', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1023', 'd5eptp8rr8g4kid0ok75h1u2q6', '4106', NULL, '2', NULL, NULL, NULL, '1', '247', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1024', 'd5eptp8rr8g4kid0ok75h1u2q6', '4081', NULL, '2', NULL, NULL, NULL, '1', '247', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1026', '9qdovceh7vehobubn53jdrl0k1', '1290', NULL, '10', NULL, NULL, NULL, '1', '248', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1027', '9qdovceh7vehobubn53jdrl0k1', '1270', NULL, '10', NULL, NULL, NULL, '1', '248', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1028', '9qdovceh7vehobubn53jdrl0k1', '1269', NULL, '10', NULL, NULL, NULL, '1', '248', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1029', '9qdovceh7vehobubn53jdrl0k1', '1273', NULL, '10', NULL, NULL, NULL, '1', '248', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1030', '9qdovceh7vehobubn53jdrl0k1', '1787', NULL, '40', NULL, NULL, NULL, '1', '248', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1031', 'd1j09h0updjfgh48lch06srl37', '857', NULL, '1', NULL, NULL, NULL, '1', '249', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1034', '4r6hd22c05mjuumnij670v9b82', '1268', NULL, '15', NULL, NULL, NULL, '1', '250', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1035', '4r6hd22c05mjuumnij670v9b82', '1286', NULL, '15', NULL, NULL, NULL, '1', '250', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1040', 'qk5gb38di382mp1jte7oji78i3', '2602', NULL, '1', NULL, NULL, NULL, '1', '251', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1041', 'f9ujnnegagqg1jdrvqknp4pke7', '1774', NULL, '4', NULL, NULL, NULL, '1', '252', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1042', 'f9ujnnegagqg1jdrvqknp4pke7', '1775', NULL, '3', NULL, NULL, NULL, '1', '252', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1044', 'f9ujnnegagqg1jdrvqknp4pke7', '1777', NULL, '2', NULL, NULL, NULL, '1', '252', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1048', 'f9ujnnegagqg1jdrvqknp4pke7', '1441', NULL, '2', NULL, NULL, NULL, '1', '252', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1049', 'f9ujnnegagqg1jdrvqknp4pke7', '606', NULL, '3', NULL, NULL, NULL, '1', '252', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1050', 'eb4skjatt4409evupbp4smr5p2', '2979', NULL, '2', NULL, NULL, NULL, '1', '253', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1051', 'eb4skjatt4409evupbp4smr5p2', '2998', NULL, '1', NULL, NULL, NULL, '1', '253', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1052', 'eb4skjatt4409evupbp4smr5p2', '2999', NULL, '1', NULL, NULL, NULL, '1', '253', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1053', 'eb4skjatt4409evupbp4smr5p2', '3000', NULL, '1', NULL, NULL, NULL, '1', '253', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1054', 'eb4skjatt4409evupbp4smr5p2', '3001', NULL, '1', NULL, NULL, NULL, '1', '253', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1055', 'eb4skjatt4409evupbp4smr5p2', '3002', NULL, '1', NULL, NULL, NULL, '1', '253', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1056', 'eb4skjatt4409evupbp4smr5p2', '4266', NULL, '2', NULL, NULL, NULL, '1', '253', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1057', 'eb4skjatt4409evupbp4smr5p2', '4276', NULL, '2', NULL, NULL, NULL, '1', '253', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1058', 'eb4skjatt4409evupbp4smr5p2', '4277', NULL, '2', NULL, NULL, NULL, '1', '253', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1059', 'eb4skjatt4409evupbp4smr5p2', '4278', NULL, '2', NULL, NULL, NULL, '1', '253', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1060', 'eb4skjatt4409evupbp4smr5p2', '4280', NULL, '2', NULL, NULL, NULL, '1', '253', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1061', 'eb4skjatt4409evupbp4smr5p2', '4279', NULL, '2', NULL, NULL, NULL, '1', '253', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1062', 'eb4skjatt4409evupbp4smr5p2', '2372', NULL, '1', NULL, NULL, NULL, '1', '253', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1063', 'h83d5tnphnjd7ldt1n58qfn110', '3984', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1064', 'vmnahou6j4utm5m4brft5o13n6', '2361', NULL, '1', NULL, NULL, NULL, '1', '254', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1065', 'v7b83sttfvk0tsio2u4132qn60', '2408', NULL, '5', NULL, NULL, NULL, '1', '255', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1066', 'pof7j1prma2u4nlc7bvf5j0bc6', '1892', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1067', 'h0pp6d812lue8v3vt58tp2mpu5', '2232', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1068', 'h0pp6d812lue8v3vt58tp2mpu5', '2516', NULL, '10', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1070', '0tc2f8a0rbjtt36btdp8gljao6', '2232', NULL, '2', NULL, NULL, NULL, '1', '256', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1071', '0tc2f8a0rbjtt36btdp8gljao6', '2516', NULL, '10', NULL, NULL, NULL, '1', '256', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1072', '0tc2f8a0rbjtt36btdp8gljao6', '3067', NULL, '1', NULL, NULL, NULL, '1', '257', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1073', '5el698lb8j705sjictvq70mib1', '2863', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1076', '5trvrdge6fivrq0nn4s730ua12', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1077', '9rd3cc37dj7qdbdj48621jt740', '39', NULL, '4', NULL, NULL, NULL, '1', '258', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1078', '9rd3cc37dj7qdbdj48621jt740', '48', NULL, '4', NULL, NULL, NULL, '1', '258', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1079', '9rd3cc37dj7qdbdj48621jt740', '608', NULL, '4', NULL, NULL, NULL, '1', '258', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1080', 'cc2rj5v0dti1jv906765p4rq62', '2022', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1081', 'cc2rj5v0dti1jv906765p4rq62', '2021', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1082', 'anc9smfese0iivvguu643hh956', '2406', NULL, '50', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1083', 'iku91l4ung1riukm1u1kk60fk6', '2406', NULL, '50', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1084', 'a72q56tds4nbp3j8tk4m357ma7', '1446', NULL, '2', NULL, NULL, NULL, '1', '259', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1085', '77jgef6pk4clupsi2r6cqd8hv3', '2407', NULL, '40', NULL, NULL, NULL, '1', '260', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1086', '77jgef6pk4clupsi2r6cqd8hv3', '2417', NULL, '40', NULL, NULL, NULL, '1', '260', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1088', 'mhknd2qqh780q3mq5a4krfe3j0', '2602', NULL, '5', NULL, NULL, NULL, '1', '261', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1089', 'kdlk24p8cra05d5dop8tdc8d64', '3984', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1091', '9htnjn4vittcsir0jmgii0ekq6', '1275', NULL, '4', NULL, NULL, NULL, '1', '262', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1092', '9htnjn4vittcsir0jmgii0ekq6', '1282', NULL, '10', NULL, NULL, NULL, '1', '262', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1093', '9htnjn4vittcsir0jmgii0ekq6', '2583', NULL, '2', NULL, NULL, NULL, '1', '262', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1094', 'n27t2o3d6r91rilqv02u09g7v1', '2406', NULL, '50', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1095', '9htnjn4vittcsir0jmgii0ekq6', '4001', NULL, '24', NULL, NULL, NULL, '1', '262', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1096', '7qih7ambtheef6si42gusn4gp4', '658', NULL, '10', NULL, NULL, NULL, '1', '263', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1097', 'kv3se5fmhfi3tejkhj4ul84c64', '2616', NULL, '1', NULL, NULL, NULL, '1', '264', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1100', 'tu5p3va5k4l6ps019u28l25tu2', '2605', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1101', 'fmd1k37h1pnoeh1o46c8b3cbh7', '290', NULL, '1', NULL, NULL, NULL, '1', '265', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1102', 'b946bnvmr1psdiu2j1436mp504', '3558', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1103', '7c9oc64m0q8egjr02s1o6opeq3', '410', NULL, '1', NULL, NULL, NULL, '1', '266', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1104', '7c9oc64m0q8egjr02s1o6opeq3', '412', NULL, '1', NULL, NULL, NULL, '1', '266', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1108', 'fah07t6pua5meqddap5656c5g2', '331', NULL, '1', NULL, NULL, NULL, '1', '267', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1109', 'fah07t6pua5meqddap5656c5g2', '3312', NULL, '1', NULL, NULL, NULL, '1', '267', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1111', '40n9pucqcjdepnlo4efe0glm62', '1282', NULL, '10', NULL, NULL, NULL, '1', '268', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1112', 'mvjpn931qkotm7u3jcm6fgcek1', '1268', NULL, '3', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1113', 'mvjpn931qkotm7u3jcm6fgcek1', '2311', NULL, '10', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1114', 'ukknbogkhdm3cb18l1f12puk71', '2311', NULL, '10', NULL, NULL, NULL, '1', '269', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1115', 'ukknbogkhdm3cb18l1f12puk71', '1268', NULL, '3', NULL, NULL, NULL, '1', '269', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1116', 'cbgch07esrf8r6tv4tntsdhvd1', '4229', NULL, '400', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1117', 'b7lg1o1o5qf4bdb93d27qgkub3', '2251', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1118', 't0tgv4kdstt68ovj0odi3vc5u7', '2583', NULL, '1', NULL, NULL, NULL, '1', '270', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1119', 't0tgv4kdstt68ovj0odi3vc5u7', '2585', NULL, '1', NULL, NULL, NULL, '1', '270', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1120', 't0tgv4kdstt68ovj0odi3vc5u7', '979', NULL, '1', NULL, NULL, NULL, '1', '270', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1121', 'klanb45oet7eah330devcg5c56', '615', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1122', 'klanb45oet7eah330devcg5c56', '4443', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1123', 'hal8utbqhcok1hm34te27i95l3', '1896', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1124', 'p4sdqnf0peq06j68h0rk6betj4', '1047', NULL, '1', NULL, NULL, NULL, '1', '271', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1125', 'p4sdqnf0peq06j68h0rk6betj4', '1048', NULL, '1', NULL, NULL, NULL, '1', '271', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1126', '1ktgre0jlim0oj43pregm03j74', '4463', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1127', '0in689mlmdr1q808nh03s43615', '1907', NULL, '1', NULL, NULL, NULL, '1', '272', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1128', '73h0jftegdoc4637vnoe8b3rk0', '2288', NULL, '3', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1129', 'un0ot51sc31h0o2phmk79cj4b3', '4160', NULL, '36', NULL, NULL, NULL, '1', '273', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1130', 'un0ot51sc31h0o2phmk79cj4b3', '2361', NULL, '4', NULL, NULL, NULL, '1', '273', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1132', 'gm3afte9i420i6b0oir94hb9a6', '410', NULL, '1', NULL, NULL, NULL, '1', '274', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1133', 'gm3afte9i420i6b0oir94hb9a6', '414', NULL, '1', NULL, NULL, NULL, '1', '274', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1134', 'gm3afte9i420i6b0oir94hb9a6', '1866', NULL, '1', NULL, NULL, NULL, '1', '274', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1135', 'gm3afte9i420i6b0oir94hb9a6', '3067', NULL, '1', NULL, NULL, NULL, '1', '274', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1136', 'gm3afte9i420i6b0oir94hb9a6', '1716', NULL, '1', NULL, NULL, NULL, '1', '274', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1137', 'gm3afte9i420i6b0oir94hb9a6', '1720', NULL, '1', NULL, NULL, NULL, '1', '274', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1138', 'gm3afte9i420i6b0oir94hb9a6', '1994', NULL, '72', NULL, NULL, NULL, '1', '274', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1139', 'fm84k5rrs4gbjlk3b372970197', '198', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1140', 'gnislns6s5mvcuf3f4db1e0ae0', '1716', NULL, '1', NULL, NULL, NULL, '1', '275', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1141', 'gnislns6s5mvcuf3f4db1e0ae0', '1720', NULL, '1', NULL, NULL, NULL, '1', '275', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1144', 'jsvf79rh8dk1k4s3q72gducav6', '363', NULL, '1', NULL, NULL, NULL, '1', '276', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1145', 'njgekv1656fiud9ier1l2t7em4', '1945', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1146', 'fcpqkpvkl5jfd461uijfo2vb86', '381', NULL, '2', NULL, NULL, NULL, '1', '277', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1147', 'fcpqkpvkl5jfd461uijfo2vb86', '2364', NULL, '5', NULL, NULL, NULL, '1', '277', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1148', 'fcpqkpvkl5jfd461uijfo2vb86', '2516', NULL, '5', NULL, NULL, NULL, '1', '277', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1149', 'v38gr0d2li5127os5qcm2ha6n2', '1787', NULL, '40', NULL, NULL, NULL, '1', '278', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1150', '92eou98fr55anb70qoko5omp47', '34', NULL, '1', NULL, NULL, NULL, '1', '279', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1151', '92eou98fr55anb70qoko5omp47', '2506', NULL, '2', NULL, NULL, NULL, '1', '279', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1153', 'dt5n4llhheqkotalluhm7pugr3', '187', NULL, '1', NULL, NULL, NULL, '1', '280', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1155', 'qroasmgs2a0ifn4e45j4immkk1', '2944', NULL, '25', NULL, NULL, NULL, '1', '281', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1156', 'snb8kuftn47k35tt29uh0n3pj6', '4332', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1157', 'sgjdcfbp1eo3jnp9ei5ch00pa5', '4141', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1158', '8kcn6mtgttqp08rrf2os36h032', '2605', NULL, '1', NULL, NULL, NULL, '1', '282', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1159', 'fr8ak1tj98sggk78npok6a0fp3', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1160', 'dkmpnfe8t8fbg16hub4h6dpfn3', '1907', NULL, '1', NULL, NULL, NULL, '1', '283', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1161', 'kgdbdf7ee2t2ubdqtnctl1msl0', '1902', NULL, '10', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1162', 'aqava3n5perervpkqrvpmk3en0', '4320', NULL, '1', NULL, NULL, NULL, '1', '284', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1163', 'aqava3n5perervpkqrvpmk3en0', '4338', NULL, '2', NULL, NULL, NULL, '1', '284', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1164', '8aphi81cv7ktuu2e6qukkh3qh5', '1000', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1165', 'k5p2c9vletlo52g7rmd4pfalg4', '1002', NULL, '1', NULL, NULL, NULL, '1', '285', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1166', 'k5p2c9vletlo52g7rmd4pfalg4', '2590', NULL, '10', NULL, NULL, NULL, '1', '285', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1168', 'bue2figbg63fp0vkp4q25kq1j6', '2313', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1169', 'bue2figbg63fp0vkp4q25kq1j6', '1902', NULL, '10', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1170', 'bue2figbg63fp0vkp4q25kq1j6', '1909', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1171', 'kvq56oqd68rbpg3obajdsl5ug3', '389', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1172', 'kvq56oqd68rbpg3obajdsl5ug3', '390', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1174', 'tdek08ftaqope5ukui7bv5hms3', '3091', NULL, '1', NULL, NULL, NULL, '1', '286', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1175', '7apa8tdppmkt12jbqj9fmn91h2', '124', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1176', '9p2ufo4q1vikl4elpbpeo977a4', '1446', NULL, '1', NULL, NULL, NULL, '1', '287', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1177', '9p2ufo4q1vikl4elpbpeo977a4', '317', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1178', '9p2ufo4q1vikl4elpbpeo977a4', '320', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1179', '9p2ufo4q1vikl4elpbpeo977a4', '926', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1180', '9p2ufo4q1vikl4elpbpeo977a4', '1315', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1181', '1k2ajaav92a4mg0l7hg1qq0lb1', '1902', NULL, '10', NULL, NULL, NULL, '1', '288', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1182', 'lqndnmujr2ilr3nv45d7fti033', '378', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1184', 'hqo3kj1t9jfqa98ft97d2309o2', '1892', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1186', '4tpcojhsk16vj9tmvqsutko6d2', '1915', NULL, '1', NULL, NULL, NULL, '1', '289', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1187', '4tpcojhsk16vj9tmvqsutko6d2', '290', NULL, '1', NULL, NULL, NULL, '1', '289', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1191', 'o3fqnqa6lkkov7vogqeotb49q4', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1192', 'v890dv3g44lija1nncfbd0v6c1', '3263', NULL, '40', NULL, NULL, NULL, '1', '290', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1194', 'sn99rt2s90doc8kbdh6uo107k1', '385', NULL, '1', NULL, NULL, NULL, '1', '291', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1196', 'kjqf8bmlm0bjiq9oa9rvms48r4', '1282', NULL, '10', NULL, NULL, NULL, '1', '292', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1197', 'kjqf8bmlm0bjiq9oa9rvms48r4', '1268', NULL, '5', NULL, NULL, NULL, '1', '292', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1198', 'h399i8upbjvu6or4hdsr346vg6', '672', NULL, '2', NULL, NULL, NULL, '1', '293', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1199', 'saihjaihuctpvbd160nmhp9u07', '1785', NULL, '1', NULL, NULL, NULL, '1', '294', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1203', 'b2m1kqolhsu9oq61s8lbbb7g87', '1347', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1226', '28dh819maqiuj0lmin1jikidu2', '1904', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1227', 'ohcjijpctmi5tpobbnd3mu65d5', '1470', NULL, '1', NULL, NULL, NULL, '1', '295', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1228', 'ohcjijpctmi5tpobbnd3mu65d5', '3034', NULL, '4', NULL, NULL, NULL, '1', '295', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1229', 'ohcjijpctmi5tpobbnd3mu65d5', '3067', NULL, '1', NULL, NULL, NULL, '1', '295', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1230', 'ohcjijpctmi5tpobbnd3mu65d5', '712', NULL, '1', NULL, NULL, NULL, '1', '295', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1231', 'bgrm9fa7n1qvml50gua9d79vi3', '2703', NULL, '2', NULL, NULL, NULL, '1', '296', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1232', 'bgrm9fa7n1qvml50gua9d79vi3', '4319', NULL, '1', NULL, NULL, NULL, '1', '296', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1233', 'nvu4lksa57pu36e91dvdh0q313', '4232', NULL, '250', NULL, NULL, NULL, '1', '297', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1234', 'j89d1v6nc5j0o934oug2bkosr6', '658', NULL, '10', NULL, NULL, NULL, '1', '298', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1235', 'j89d1v6nc5j0o934oug2bkosr6', '659', NULL, '2', NULL, NULL, NULL, '1', '298', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1236', '59njp1r9f4ki4a0gpfr8p7jp06', '300', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1237', '754ejvul559k45vf0bgkv84883', '654', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1238', '754ejvul559k45vf0bgkv84883', '655', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1239', '3kljfup43f5jcsbvqm3ovpcif6', '3123', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1240', 'qjua9covp1fvadcbadbeouu5p1', '2635', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1241', 'plrdt4o3vgskcdgio7d4jmbfh6', '3331', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1242', 'p3chn0gkhukga3kb18g6464fe7', '1268', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1243', 'u6g4v5cjn7d4lqe5261ahn1d97', '490', NULL, '5', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1244', 'v2mfre3jfq6av9bhf4j92ec2a0', '654', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1245', 'v2mfre3jfq6av9bhf4j92ec2a0', '655', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1246', 'skcavjqj6o2e492904quiq2sj5', '3505', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1247', 'ffoiahj2eimr0abkmdcucpvq75', '27', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1248', '3q8utes4a3h6v1qc0oat0p2j74', '1134', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1249', '3q8utes4a3h6v1qc0oat0p2j74', '1135', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1250', 'ndbo99qp05vmrn5a0e9160him3', '719', NULL, '1', NULL, NULL, NULL, '1', '299', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1251', 'r0fjdqm6ejm03os3kmeh0bo2p7', '2359', NULL, '1', NULL, NULL, NULL, '1', '300', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1252', 'lc545b7lajg3rtshrvi8fbec51', '4208', NULL, '4', NULL, NULL, NULL, '1', '301', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1253', 'lc545b7lajg3rtshrvi8fbec51', '4070', NULL, '12', NULL, NULL, NULL, '1', '301', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1254', 'lc545b7lajg3rtshrvi8fbec51', '4414', NULL, '5', NULL, NULL, NULL, '1', '301', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1255', '6bu7atd97nkbi71fggk6rsb9t2', '3476', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1256', 'u2eo6atmke0s9nok6sl8t6mvd1', '3309', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1257', 'js62uea8h2idup9l4evord2325', '2384', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1259', '852sc82oqt37sca0po9q3amke3', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1260', '852sc82oqt37sca0po9q3amke3', '2', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1261', '852sc82oqt37sca0po9q3amke3', '3', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1262', 'nhh3amtt4nphbvrj7qd36e9ra0', '280', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1264', 'i2er5dmvg5oqilofhesonpo5n5', '4419', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1265', 'br9thi8jgkvdbghhf934t9u607', '659', NULL, '7', NULL, NULL, NULL, '1', '302', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1271', 'vcjesn67pa802n0cm3v0fhqo06', '389', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1272', 'vcjesn67pa802n0cm3v0fhqo06', '390', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1273', '5m2ve94o8gsbma7tm1dt6ki1r6', '2368', NULL, '1', NULL, NULL, NULL, '1', '303', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1274', 'dm5r8iguh43taiqh5mldi76li5', '1282', NULL, '15', NULL, NULL, NULL, '1', '304', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1275', 'a4sn1s8n2g5v7jr9433a51pae5', '249', NULL, '2', NULL, NULL, NULL, '1', '305', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1276', 'a4sn1s8n2g5v7jr9433a51pae5', '2632', NULL, '3', NULL, NULL, NULL, '1', '305', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1277', 'a4sn1s8n2g5v7jr9433a51pae5', '2313', NULL, '5', NULL, NULL, NULL, '1', '305', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1278', 'a4sn1s8n2g5v7jr9433a51pae5', '2406', NULL, '50', NULL, NULL, NULL, '1', '305', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1279', 'q5nqdus5rk1tr5lam7431je2j0', '654', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1280', 'q5nqdus5rk1tr5lam7431je2j0', '655', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1281', '1dogj9albshq8qumtf33co6lv4', '3579', NULL, '1', NULL, NULL, NULL, '1', '306', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1282', '5i46cp3t8jj8m2e2oo0q86tnu0', '3996', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1283', 'anb2jvllno5n30rdjjkt8umlm4', '1324', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1286', 'jma61ov33bruj5nneq2g707rq1', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1287', '03psgv6f7ustkrc54be3ns4bv4', '1346', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1288', 'vv2qm36v17bgbet5gfinm8io23', '4015', NULL, '36', NULL, NULL, NULL, '1', '307', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1289', 'vv2qm36v17bgbet5gfinm8io23', '4325', NULL, '10', NULL, NULL, NULL, '1', '307', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1290', 'eosnvih7l7hjmjji34qkt430o6', '4439', NULL, '2', NULL, NULL, NULL, '1', '308', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1292', '7g6i8figsqj2riqu4nqb2f4he1', '607', NULL, '2', NULL, NULL, NULL, '1', '309', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1293', 'r50iijbm0gmfjmgf2e2b3q9ra4', '1', NULL, '1', NULL, NULL, NULL, '1', '310', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1294', '699lqiu0k3fei6l7fn7c9efqa5', '3113', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1295', '5ussf90dn01ir2qhjjr0vtcnq7', '1794', NULL, '100', NULL, NULL, NULL, '1', '311', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1296', 'hjl6kjecn703ocfdu1c0t5jq57', '658', NULL, '6', NULL, NULL, NULL, '1', '312', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1297', 'ddb4qmju7m98c1v2f9skmc2j14', '3113', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1298', 'j02h7ms6vig6jnbp1ltj0bt1v3', '916', NULL, '4', NULL, NULL, NULL, '1', '313', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1299', 'd2jqu87ip0lffrem9od89jdtt6', '345', NULL, '1', NULL, NULL, NULL, '1', '314', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1300', 'tgejfu0jj3h872tjr9usjqfp34', '3092', NULL, '1', NULL, NULL, NULL, '1', '315', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1302', '2rkiq31auq2t0mpnos4ln4ip41', '29', NULL, '3', NULL, NULL, NULL, '1', '316', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1303', '2rkiq31auq2t0mpnos4ln4ip41', '30', NULL, '1', NULL, NULL, NULL, '1', '317', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1305', '1eqlbjhchspj79ank9l886gpf3', '3953', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1306', '166695e2e079f075bb3f38df4efbab01', '3239', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1307', 'o7b5ent20bfhh37k4ip0q58da0', '606', NULL, '3', NULL, NULL, NULL, '1', '318', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1308', 'o7b5ent20bfhh37k4ip0q58da0', '4442', NULL, '5', NULL, NULL, NULL, '1', '318', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1309', 'o7b5ent20bfhh37k4ip0q58da0', '4443', NULL, '3', NULL, NULL, NULL, '1', '318', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1310', 'o7b5ent20bfhh37k4ip0q58da0', '4444', NULL, '3', NULL, NULL, NULL, '1', '318', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1311', '1ftmgl6lqrep69kabphgu45o81', '4057', NULL, '6', NULL, NULL, NULL, '1', '319', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1312', '1ftmgl6lqrep69kabphgu45o81', '4046', NULL, '18', NULL, NULL, NULL, '1', '319', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1313', '1ftmgl6lqrep69kabphgu45o81', '656', NULL, '2', NULL, NULL, NULL, '1', '320', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1315', 'mse64m0oa1cciubdp2apmkg3h0', '3078', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1316', 'il7adu7bqg0cej9pbt0acnq7f7', '2874', NULL, '1', NULL, NULL, NULL, '1', '321', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1317', 'il7adu7bqg0cej9pbt0acnq7f7', '2230', NULL, '5', NULL, NULL, NULL, '1', '321', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1318', 'dkmre66h6gppui0befo9jfq7p5', '96', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1319', 'hc729s9o17jfdkvjqp3i9b4k13', '1696', NULL, '1', NULL, NULL, NULL, '1', '322', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1320', 'hc729s9o17jfdkvjqp3i9b4k13', '1698', NULL, '1', NULL, NULL, NULL, '1', '322', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1321', 'hc729s9o17jfdkvjqp3i9b4k13', '3214', NULL, '1', NULL, NULL, NULL, '1', '322', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1322', 'hc729s9o17jfdkvjqp3i9b4k13', '1775', NULL, '1', NULL, NULL, NULL, '1', '322', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1323', 'nj3i4n3upke9pulp3l99k39jn5', '658', NULL, '5', NULL, NULL, NULL, '1', '323', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1324', 'nj3i4n3upke9pulp3l99k39jn5', '710', NULL, '1', NULL, NULL, NULL, '1', '323', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1325', 'q4g1oc6d09qgv03rfn24km2d47', '630', NULL, '1', NULL, NULL, NULL, '1', '324', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1326', '8k3ihijfciodbp92ljrq4q51s6', '1691', NULL, '2', NULL, NULL, NULL, '1', '325', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1327', '8k3ihijfciodbp92ljrq4q51s6', '1692', NULL, '2', NULL, NULL, NULL, '1', '325', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1328', '8k3ihijfciodbp92ljrq4q51s6', '1695', NULL, '2', NULL, NULL, NULL, '1', '325', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1329', '3rlg2vkb9uph8h5rrg69ni73s1', '2600', NULL, '1', NULL, NULL, NULL, '1', '326', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1330', '3rlg2vkb9uph8h5rrg69ni73s1', '2230', NULL, '1', NULL, NULL, NULL, '1', '326', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1331', '3rlg2vkb9uph8h5rrg69ni73s1', '2231', NULL, '1', NULL, NULL, NULL, '1', '326', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1332', '3rlg2vkb9uph8h5rrg69ni73s1', '2232', NULL, '1', NULL, NULL, NULL, '1', '326', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1333', '3rlg2vkb9uph8h5rrg69ni73s1', '1004', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1334', '3rlg2vkb9uph8h5rrg69ni73s1', '2937', NULL, '5', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1335', '6316dlnfq7b414ptcogevmp7e0', '658', NULL, '10', NULL, NULL, NULL, '1', '327', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1336', 'ce7vs78vuefv7j5a9olu608572', '1689', NULL, '2', NULL, NULL, NULL, '1', '328', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1337', 'pbihv7ufgg9p0i1fka6o9q2s31', '365', NULL, '1', NULL, NULL, NULL, '1', '329', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1338', 'd2g2f0945f9vvsqhooapdl3sm7', '2583', NULL, '8', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1339', 'hrlbsh4caq7anjr3ibfmt5ueq4', '2468', NULL, '2', NULL, NULL, NULL, '1', '330', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1340', 'hckusa3vj4p564u5qpgmkfpgk0', '1320', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1341', 'aoq1m2gvugg66agjo8s9q6h9g5', '660', NULL, '10', NULL, NULL, NULL, '1', '331', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1342', 'je2gfegcqtrq16uf9j9eqt1983', '1481', NULL, '1', NULL, NULL, NULL, '1', '332', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1343', 'ijalglv46lbnbvdg1nbvgbhft7', '2311', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1344', 'ijalglv46lbnbvdg1nbvgbhft7', '2314', NULL, '3', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1345', 'c7so1s0gn620qgqdtoa4mpmjr0', '1733', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1346', 'ld4qu76nq4912eqq78cgbufkl0', '1004', NULL, '1', NULL, NULL, NULL, '1', '333', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1347', 'ld4qu76nq4912eqq78cgbufkl0', '1785', NULL, '1', NULL, NULL, NULL, '1', '333', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1348', 'ld4qu76nq4912eqq78cgbufkl0', '3583', NULL, '1', NULL, NULL, NULL, '1', '333', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1349', 'ld4qu76nq4912eqq78cgbufkl0', '2599', NULL, '2', NULL, NULL, NULL, '1', '333', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1351', 'co9aeoqib2600go2obv7jbvst2', '658', NULL, '10', NULL, NULL, NULL, '1', '334', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1352', 'co9aeoqib2600go2obv7jbvst2', '2405', NULL, '5', NULL, NULL, NULL, '1', '334', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1353', '0j276ocnjo5e6podq0lf3cmtk4', '2406', NULL, '2', NULL, NULL, NULL, '1', '335', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1354', '0j276ocnjo5e6podq0lf3cmtk4', '2871', NULL, '1', NULL, NULL, NULL, '1', '335', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1355', '0j276ocnjo5e6podq0lf3cmtk4', '2869', NULL, '2', NULL, NULL, NULL, '1', '335', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1356', '0j276ocnjo5e6podq0lf3cmtk4', '2867', NULL, '1', NULL, NULL, NULL, '1', '335', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1357', '0j276ocnjo5e6podq0lf3cmtk4', '2859', NULL, '1', NULL, NULL, NULL, '1', '335', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1358', '0j276ocnjo5e6podq0lf3cmtk4', '2863', NULL, '1', NULL, NULL, NULL, '1', '335', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1359', '0j276ocnjo5e6podq0lf3cmtk4', '2855', NULL, '1', NULL, NULL, NULL, '1', '335', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1360', '0j276ocnjo5e6podq0lf3cmtk4', '2876', NULL, '1', NULL, NULL, NULL, '1', '335', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1361', '0j276ocnjo5e6podq0lf3cmtk4', '2878', NULL, '2', NULL, NULL, NULL, '1', '335', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1362', '0j276ocnjo5e6podq0lf3cmtk4', '2406', NULL, '5', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1363', 'ct9u0p87fjr2kqlcc32598pm47', '3514', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1365', 'rg537usceemdagjm6ja75br8d4', '3312', NULL, '1', NULL, NULL, NULL, '1', '336', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1366', 'rg537usceemdagjm6ja75br8d4', '1907', NULL, '1', NULL, NULL, NULL, '1', '336', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1367', 'rg537usceemdagjm6ja75br8d4', '3514', NULL, '2', NULL, NULL, NULL, '1', '336', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1368', '85m0e6v8esv9si8l9tnmcve8m4', '50', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1369', 'tr97f5td1p263s5usn9h0t3t27', '1', NULL, '1', NULL, NULL, NULL, '1', '337', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1370', 'tr97f5td1p263s5usn9h0t3t27', '14', NULL, '1', NULL, NULL, NULL, '1', '337', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1371', 'gt2de9t62e6fqrkcuktnbbj1p7', '3094', NULL, '1', NULL, NULL, NULL, '1', '338', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1372', 'gt2de9t62e6fqrkcuktnbbj1p7', '878', NULL, '1', NULL, NULL, NULL, '1', '338', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1373', 'gt2de9t62e6fqrkcuktnbbj1p7', '606', NULL, '4', NULL, NULL, NULL, '1', '338', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1374', 'gt2de9t62e6fqrkcuktnbbj1p7', '2311', NULL, '10', NULL, NULL, NULL, '1', '338', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1375', 'gt2de9t62e6fqrkcuktnbbj1p7', '1272', NULL, '1', NULL, NULL, NULL, '1', '338', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1376', 'gt2de9t62e6fqrkcuktnbbj1p7', '2722', NULL, '5', NULL, NULL, NULL, '1', '338', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1377', 'gt2de9t62e6fqrkcuktnbbj1p7', '2723', NULL, '5', NULL, NULL, NULL, '1', '338', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1379', '1h5d2n5dqoo00sjkgrvkuiqk43', '654', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1380', '1h5d2n5dqoo00sjkgrvkuiqk43', '655', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1381', 'lks6rthjreleak3fquf7er7n70', '4435', NULL, '1', NULL, NULL, NULL, '1', '339', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1382', 'lks6rthjreleak3fquf7er7n70', '2515', NULL, '10', NULL, NULL, NULL, '1', '339', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1383', 'lks6rthjreleak3fquf7er7n70', '1446', NULL, '1', NULL, NULL, NULL, '1', '339', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1385', 'gm8jfapuo54p5ptgn1gblck7d7', '655', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1389', 'jng3pb3hinoh05pek5ofvcnn50', '666', NULL, '1', NULL, NULL, NULL, '1', '340', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1390', 'jng3pb3hinoh05pek5ofvcnn50', '658', NULL, '10', NULL, NULL, NULL, '1', '340', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1391', 'jng3pb3hinoh05pek5ofvcnn50', '1268', NULL, '15', NULL, NULL, NULL, '1', '340', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1392', 'mjgbbf4rf03d4ckl8jrapj5ue1', '4388', NULL, '500', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1393', '3d4c516jdvq4g6jb7hvs2925i1', '388', NULL, '2', NULL, NULL, NULL, '1', '341', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1394', '3d4c516jdvq4g6jb7hvs2925i1', '2289', NULL, '2', NULL, NULL, NULL, '1', '341', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1395', 'tlpc7n2tod046c298g0g2dtsa3', '4388', NULL, '500', NULL, NULL, NULL, '1', '342', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1396', 'tlpc7n2tod046c298g0g2dtsa3', '2631', NULL, '2', NULL, NULL, NULL, '1', '342', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1397', '18lvcppefhkv07pf21kcqrjnk7', '297', NULL, '1', NULL, NULL, NULL, '1', '343', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1398', '18lvcppefhkv07pf21kcqrjnk7', '655', NULL, '1', NULL, NULL, NULL, '1', '343', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1399', 'fa5vpr2nrfhlru2tqsd4urlvi7', '1452', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1400', 'fa5vpr2nrfhlru2tqsd4urlvi7', '2482', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1401', 'rmrtdt4mem6lhsuekse2tmm3j4', '3123', NULL, '3', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1402', 'rmrtdt4mem6lhsuekse2tmm3j4', '3144', NULL, '3', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1403', 'sksjl1r8j49heqksgv6iqv9tg2', '3510', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1404', '8jr9pla7atha8cli8j6vmi16s6', '1362', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1405', 'gch1mg6nrg651rdbc9bpvoi2i4', '872', NULL, '1', NULL, NULL, NULL, '1', '344', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1406', 'qoj8fenlas5grlla1t55aj1q80', '3091', NULL, '2', NULL, NULL, NULL, '1', '345', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1407', '2blhh34a0h3dc05oqd00hs3ul7', '2314', NULL, '5', NULL, NULL, NULL, '1', '346', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1408', '308769di0jsjnhi8v4vcfvtho3', '1934', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1409', 'ku4h9e4emgr2076uq126nam2b1', '719', NULL, '1', NULL, NULL, NULL, '1', '347', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1410', 'ku4h9e4emgr2076uq126nam2b1', '2409', NULL, '20', NULL, NULL, NULL, '1', '347', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1412', 'o0gjn5ntmk0sn89ieiimd2b5v0', '28', NULL, '2', NULL, NULL, NULL, '1', '348', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1413', 'o0gjn5ntmk0sn89ieiimd2b5v0', '659', NULL, '2', NULL, NULL, NULL, '1', '348', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1414', 'o0gjn5ntmk0sn89ieiimd2b5v0', '4229', NULL, '400', NULL, NULL, NULL, '1', '348', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1415', 'o0gjn5ntmk0sn89ieiimd2b5v0', '4285', NULL, '20', NULL, NULL, NULL, '1', '348', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1416', 'o0gjn5ntmk0sn89ieiimd2b5v0', '4388', NULL, '200', NULL, NULL, NULL, '1', '348', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1417', '33i1r0dm9jepld643o6csji0a2', '1498', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1418', 'h8kfl1s56jdrmsriulglj4i0a6', '657', NULL, '4', NULL, NULL, NULL, '1', '349', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1419', 'h8kfl1s56jdrmsriulglj4i0a6', '655', NULL, '1', NULL, NULL, NULL, '1', '349', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1420', 'a114kbgk1o40k6ddlrsbqkkvg4', '4332', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1421', '4aqgjgercbsrntbrhgipab81q5', '1921', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1422', 'srlbcmvk90f8jjt0lpn69dl705', '1636', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1423', 'srlbcmvk90f8jjt0lpn69dl705', '1635', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1424', 'srlbcmvk90f8jjt0lpn69dl705', '1633', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1425', '1vt0tiht5221ekmcmcb2rieq37', '2949', NULL, '30', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1426', 'cl5lkk9i1bnmk2lgdijcrapjs2', '284', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1427', 'r8ioo3jqh6vk74k17s98uj6v24', '4063', NULL, '2', NULL, NULL, NULL, '1', '350', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1428', '114hjgo2to7s578r7oqv9sh8l2', '3312', NULL, '1', NULL, NULL, NULL, '1', '351', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1429', '114hjgo2to7s578r7oqv9sh8l2', '2405', NULL, '20', NULL, NULL, NULL, '1', '351', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1431', 'dnevm1mfi012sk1acu58ssf3t5', '2876', NULL, '1', NULL, NULL, NULL, '1', '352', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1432', 'dnevm1mfi012sk1acu58ssf3t5', '2879', NULL, '2', NULL, NULL, NULL, '1', '352', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1433', 'dnevm1mfi012sk1acu58ssf3t5', '1011', NULL, '6', NULL, NULL, NULL, '1', '352', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1434', 'dnevm1mfi012sk1acu58ssf3t5', '2933', NULL, '2', NULL, NULL, NULL, '1', '352', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1435', 'dnevm1mfi012sk1acu58ssf3t5', '2944', NULL, '4', NULL, NULL, NULL, '1', '352', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1436', 'dnevm1mfi012sk1acu58ssf3t5', '2939', NULL, '4', NULL, NULL, NULL, '1', '352', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1437', 'dnevm1mfi012sk1acu58ssf3t5', '482', NULL, '30', NULL, NULL, NULL, '1', '352', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1438', 'dnevm1mfi012sk1acu58ssf3t5', '2878', NULL, '2', NULL, NULL, NULL, '1', '352', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1439', 'et7e51748u5h9itubaus29fv42', '660', NULL, '15', NULL, NULL, NULL, '1', '353', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1440', 'at5m0hu8ohprhcap3ieq3t1n33', '2868', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1441', 'at5m0hu8ohprhcap3ieq3t1n33', '2884', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1442', 'at5m0hu8ohprhcap3ieq3t1n33', '916', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1443', 'at5m0hu8ohprhcap3ieq3t1n33', '2364', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1444', 'v9vnpsrt68bakjvqe3qat9aq75', '1556', NULL, '1', NULL, NULL, NULL, '1', '354', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1445', '838ourkpkap7b9tgna5fhf3n14', '4475', NULL, '1', NULL, NULL, NULL, '1', '355', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1446', '838ourkpkap7b9tgna5fhf3n14', '4477', NULL, '3', NULL, NULL, NULL, '1', '355', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1447', '838ourkpkap7b9tgna5fhf3n14', '4478', NULL, '1', NULL, NULL, NULL, '1', '355', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1448', '7mlqm7sba6l9cs3gvg3g96nrr0', '2364', NULL, '10', NULL, NULL, NULL, '1', '356', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1449', '7mlqm7sba6l9cs3gvg3g96nrr0', '916', NULL, '2', NULL, NULL, NULL, '1', '356', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1451', 'nga33j302vubgmnrbpa8c4u881', '3566', NULL, '3', NULL, NULL, NULL, '1', '357', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1452', 'nga33j302vubgmnrbpa8c4u881', '3567', NULL, '2', NULL, NULL, NULL, '1', '357', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1453', 'nga33j302vubgmnrbpa8c4u881', '1778', NULL, '1', NULL, NULL, NULL, '1', '357', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1454', 'nga33j302vubgmnrbpa8c4u881', '4415', NULL, '3', NULL, NULL, NULL, '1', '357', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1455', 'nga33j302vubgmnrbpa8c4u881', '380', NULL, '1', NULL, NULL, NULL, '1', '357', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1456', 'iocppg6vm2hgeur4sc0ass2717', '949', NULL, '1', NULL, NULL, NULL, '1', '358', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1457', 'ooc4pmsbqdg9msrludjd8487u1', '1794', NULL, '200', NULL, NULL, NULL, '1', '359', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1458', '6mmoehiiinjeedlganbtc4enj3', '732', NULL, '4', NULL, NULL, NULL, '1', '360', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1459', '6mmoehiiinjeedlganbtc4enj3', '2874', NULL, '1', NULL, NULL, NULL, '1', '360', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1460', 'vseh2cqve14fr3fo73oomo8pe7', '1909', NULL, '1', NULL, NULL, NULL, '1', '361', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1462', 'tugvb125jqtbsppu6oqpfi5tu2', '2400', NULL, '65', NULL, NULL, NULL, '1', '362', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1463', 'tugvb125jqtbsppu6oqpfi5tu2', '2401', NULL, '60', NULL, NULL, NULL, '1', '362', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1464', 'akcsommb4piavurs21ifegfh22', '1974', NULL, '1', NULL, NULL, NULL, '1', '363', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1465', 'akcsommb4piavurs21ifegfh22', '1935', NULL, '1', NULL, NULL, NULL, '1', '363', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1466', 'akcsommb4piavurs21ifegfh22', '2311', NULL, '30', NULL, NULL, NULL, '1', '363', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1467', 'akcsommb4piavurs21ifegfh22', '1274', NULL, '3', NULL, NULL, NULL, '1', '363', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1468', 'ju9uob0c33ns0js4a2a74mqjt7', '385', NULL, '2', NULL, NULL, NULL, '1', '364', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1469', 'ju9uob0c33ns0js4a2a74mqjt7', '1498', NULL, '5', NULL, NULL, NULL, '1', '364', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1470', 'ju9uob0c33ns0js4a2a74mqjt7', '388', NULL, '2', NULL, NULL, NULL, '1', '364', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1471', 'ju9uob0c33ns0js4a2a74mqjt7', '595', NULL, '5', NULL, NULL, NULL, '1', '364', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1472', 'ju9uob0c33ns0js4a2a74mqjt7', '1268', NULL, '5', NULL, NULL, NULL, '1', '364', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1473', 'ju9uob0c33ns0js4a2a74mqjt7', '1725', NULL, '3', NULL, NULL, NULL, '1', '364', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1474', 'ju9uob0c33ns0js4a2a74mqjt7', '1727', NULL, '3', NULL, NULL, NULL, '1', '364', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1475', 'ju9uob0c33ns0js4a2a74mqjt7', '4271', NULL, '5', NULL, NULL, NULL, '1', '364', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1476', 'ju9uob0c33ns0js4a2a74mqjt7', '4277', NULL, '5', NULL, NULL, NULL, '1', '364', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1477', 'ju9uob0c33ns0js4a2a74mqjt7', '4246', NULL, '2', NULL, NULL, NULL, '1', '364', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1478', 'ju9uob0c33ns0js4a2a74mqjt7', '4247', NULL, '2', NULL, NULL, NULL, '1', '364', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1479', 'gnpun7l7fsh824q8u8ov9gh4o7', '4285', NULL, '20', NULL, NULL, NULL, '1', '365', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1481', '2jd2vjlsvbmkitq47jtjdj8d83', '774', NULL, '1', NULL, NULL, NULL, '1', '366', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1482', 'bdi0nda4tn2dksqf30cnrp8vb4', '4036', NULL, '100', NULL, NULL, NULL, '1', '367', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1483', 'bdi0nda4tn2dksqf30cnrp8vb4', '4037', NULL, '96', NULL, NULL, NULL, '1', '367', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1484', 'bdi0nda4tn2dksqf30cnrp8vb4', '4039', NULL, '96', NULL, NULL, NULL, '1', '367', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1485', 'bdi0nda4tn2dksqf30cnrp8vb4', '606', NULL, '3', NULL, NULL, NULL, '1', '367', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1486', 'bdi0nda4tn2dksqf30cnrp8vb4', '4071', NULL, '6', NULL, NULL, NULL, '1', '367', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1489', 'ccnfkv1qeonsistmqvver9mjl0', '455', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1490', 't7l84tp71cpnuq72011mj7u7r6', '124', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1491', 'o73vbk4rkou7k5rj7t4s7u0j75', '2034', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1492', 'l0a4lr7ri505q705ascf8fmg12', '382', NULL, '1', NULL, NULL, NULL, '1', '368', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1496', 'l7bsmurjgovq91qlmb7s02hrf6', '2589', NULL, '4', NULL, NULL, NULL, '1', '369', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1497', 'l7bsmurjgovq91qlmb7s02hrf6', '691', NULL, '4', NULL, NULL, NULL, '1', '369', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1498', 'l7bsmurjgovq91qlmb7s02hrf6', '607', NULL, '2', NULL, NULL, NULL, '1', '369', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1499', 'l7bsmurjgovq91qlmb7s02hrf6', '608', NULL, '2', NULL, NULL, NULL, '1', '369', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1500', 'feuqqufhbpj3em5coq78i3t8g6', '819', NULL, '1', NULL, NULL, NULL, '1', '370', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1501', 'feuqqufhbpj3em5coq78i3t8g6', '1787', NULL, '20', NULL, NULL, NULL, '1', '370', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1502', 'feuqqufhbpj3em5coq78i3t8g6', '1794', NULL, '8', NULL, NULL, NULL, '1', '370', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1503', 'feuqqufhbpj3em5coq78i3t8g6', '1994', NULL, '50', NULL, NULL, NULL, '1', '370', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1504', 'c5h2psjr6ms6r154rrclr4nhu5', '660', NULL, '2', NULL, NULL, NULL, '1', '371', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1505', 'c5h2psjr6ms6r154rrclr4nhu5', '483', NULL, '5', NULL, NULL, NULL, '1', '371', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1506', 'c5h2psjr6ms6r154rrclr4nhu5', '489', NULL, '5', NULL, NULL, NULL, '1', '371', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1507', 'c5h2psjr6ms6r154rrclr4nhu5', '488', NULL, '1', NULL, NULL, NULL, '1', '371', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1508', 'c5h2psjr6ms6r154rrclr4nhu5', '484', NULL, '1', NULL, NULL, NULL, '1', '371', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1509', '09d1t50lpiqke4kfl2fumde9b6', '1300', NULL, '3', NULL, NULL, NULL, '1', '372', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1510', '09d1t50lpiqke4kfl2fumde9b6', '1271', NULL, '15', NULL, NULL, NULL, '1', '372', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1511', '09d1t50lpiqke4kfl2fumde9b6', '1272', NULL, '15', NULL, NULL, NULL, '1', '372', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1512', '09d1t50lpiqke4kfl2fumde9b6', '1787', NULL, '40', NULL, NULL, NULL, '1', '372', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1513', '09d1t50lpiqke4kfl2fumde9b6', '4285', NULL, '10', NULL, NULL, NULL, '1', '373', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1514', 'ci0ev2qi9ib90k774k7abeplo2', '410', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1515', 'j97p4tgk68dlgct0fr34s48ml1', '3998', NULL, '5', NULL, NULL, NULL, '1', '374', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1516', 'j97p4tgk68dlgct0fr34s48ml1', '4355', NULL, '24', NULL, NULL, NULL, '1', '374', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1517', 'j97p4tgk68dlgct0fr34s48ml1', '4389', NULL, '200', NULL, NULL, NULL, '1', '374', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1520', 'aigus6f02v5knea4si6e2ejo51', '2406', NULL, '40', NULL, NULL, NULL, '1', '375', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1521', 'uv972pfc8fhp64hq7f8t9v8lv4', '607', NULL, '4', NULL, NULL, NULL, '1', '376', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1522', 'o1jptr7q7dm6ppbtl8dueiapk0', '260', NULL, '1', NULL, NULL, NULL, '1', '377', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1523', 'o1jptr7q7dm6ppbtl8dueiapk0', '1282', NULL, '2', NULL, NULL, NULL, '1', '377', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1524', 'o1jptr7q7dm6ppbtl8dueiapk0', '388', NULL, '1', NULL, NULL, NULL, '1', '377', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1525', 'o1jptr7q7dm6ppbtl8dueiapk0', '1698', NULL, '1', NULL, NULL, NULL, '1', '378', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1526', 'o1jptr7q7dm6ppbtl8dueiapk0', '1776', NULL, '1', NULL, NULL, NULL, '1', '378', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1527', 'rck0tvh3rq5kbq1oob2eheknv7', '4355', NULL, '24', NULL, NULL, NULL, '1', '379', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1530', 't8ljq4beuhlbcjtpg7194hc2q6', '3934', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1531', 'dsjh059u3cf09fbjv2h91o6ug3', '712', NULL, '2', NULL, NULL, NULL, '1', '380', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1532', 'dsjh059u3cf09fbjv2h91o6ug3', '2588', NULL, '1', NULL, NULL, NULL, '1', '380', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1533', 'dsjh059u3cf09fbjv2h91o6ug3', '3289', NULL, '15', NULL, NULL, NULL, '1', '380', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1535', 'vkseokkem8ltse4euccn99kbp6', '1935', NULL, '3', NULL, NULL, NULL, '1', '381', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1536', 'vkseokkem8ltse4euccn99kbp6', '381', NULL, '1', NULL, NULL, NULL, '1', '381', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1537', 'vkseokkem8ltse4euccn99kbp6', '1457', NULL, '1', NULL, NULL, NULL, '1', '381', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1538', 'vkseokkem8ltse4euccn99kbp6', '1994', NULL, '100', NULL, NULL, NULL, '1', '381', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1539', 'vkseokkem8ltse4euccn99kbp6', '1274', NULL, '2', NULL, NULL, NULL, '1', '381', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1540', 'rck0tvh3rq5kbq1oob2eheknv7', '1453', NULL, '1', NULL, NULL, NULL, '1', '382', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1541', 'qq6v1bp2p98k2ap96iaku5u3b2', '2736', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1542', '2blp18mp6hbm3aug9n7ke3qc67', '1267', NULL, '3', NULL, NULL, NULL, '1', '383', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1543', '2blp18mp6hbm3aug9n7ke3qc67', '1293', NULL, '5', NULL, NULL, NULL, '1', '383', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1545', 'ihgaj25jekojpq9unqp0gc6ck2', '40', NULL, '3', NULL, NULL, NULL, '1', '384', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1547', '5u3l4rotohkepiqlcdvei6k4k4', '1275', NULL, '5', NULL, NULL, NULL, '1', '385', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1548', '2vuuvgctpsh7giljh9hcdnfh36', '4313', NULL, '18', NULL, NULL, NULL, '1', '386', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1549', '2vuuvgctpsh7giljh9hcdnfh36', '4387', NULL, '500', NULL, NULL, NULL, '1', '386', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1550', '2vuuvgctpsh7giljh9hcdnfh36', '4388', NULL, '500', NULL, NULL, NULL, '1', '386', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1551', '2vuuvgctpsh7giljh9hcdnfh36', '3998', NULL, '4', NULL, NULL, NULL, '1', '386', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1552', '1atdheffuof7l5uiihnqckcab3', '2406', NULL, '5', NULL, NULL, NULL, '1', '387', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1553', '1atdheffuof7l5uiihnqckcab3', '2407', NULL, '15', NULL, NULL, NULL, '1', '387', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1554', '1atdheffuof7l5uiihnqckcab3', '1727', NULL, '2', NULL, NULL, NULL, '1', '387', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1556', '1atdheffuof7l5uiihnqckcab3', '1794', NULL, '7', NULL, NULL, NULL, '1', '387', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1557', '1atdheffuof7l5uiihnqckcab3', '1729', NULL, '1', NULL, NULL, NULL, '1', '387', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1558', '1atdheffuof7l5uiihnqckcab3', '1732', NULL, '1', NULL, NULL, NULL, '1', '387', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1559', '1atdheffuof7l5uiihnqckcab3', '1777', NULL, '1', NULL, NULL, NULL, '1', '387', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1560', '1atdheffuof7l5uiihnqckcab3', '1778', NULL, '1', NULL, NULL, NULL, '1', '387', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1562', '4sk69qbh4gicksmfgkuu2t9b07', '1293', NULL, '2', NULL, NULL, NULL, '1', '388', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1563', '64qkm8lstd4mahpk4anp1g7f95', '55', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1565', '3u49gahcu9apalb04eg6chb5p0', '4229', NULL, '2000', NULL, NULL, NULL, '1', '389', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1566', '3u49gahcu9apalb04eg6chb5p0', '2945', NULL, '10', NULL, NULL, NULL, '1', '389', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1567', '3u49gahcu9apalb04eg6chb5p0', '1403', NULL, '1', NULL, NULL, NULL, '1', '389', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1568', '3u49gahcu9apalb04eg6chb5p0', '2589', NULL, '1', NULL, NULL, NULL, '1', '389', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1569', '3u49gahcu9apalb04eg6chb5p0', '28', NULL, '1', NULL, NULL, NULL, '1', '389', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1570', '3u49gahcu9apalb04eg6chb5p0', '2311', NULL, '1', NULL, NULL, NULL, '1', '389', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1571', 'deb7h703hol0gis65adt11ja76', '219', NULL, '1', NULL, NULL, NULL, '1', '390', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1572', 'deb7h703hol0gis65adt11ja76', '2363', NULL, '2', NULL, NULL, NULL, '1', '390', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1573', 'deb7h703hol0gis65adt11ja76', '2364', NULL, '2', NULL, NULL, NULL, '1', '390', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1574', 'deb7h703hol0gis65adt11ja76', '2736', NULL, '4', NULL, NULL, NULL, '1', '390', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1575', 'deb7h703hol0gis65adt11ja76', '1909', NULL, '2', NULL, NULL, NULL, '1', '390', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1576', 'i6omnst3mdeepf1asfomgis6a2', '2781', NULL, '2', NULL, NULL, NULL, '1', '391', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1577', '8poqgvj0nka1oei72vuqkv46a4', '800', NULL, '1', NULL, NULL, NULL, '1', '392', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1578', 'ckkvvnnl88om2ragojklo85ar3', '2878', NULL, '1', NULL, NULL, NULL, '1', '393', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1579', 'ckkvvnnl88om2ragojklo85ar3', '2879', NULL, '1', NULL, NULL, NULL, '1', '393', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1580', '5slpefdrhr1ddanbj6q9cncl90', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1581', '5slpefdrhr1ddanbj6q9cncl90', '3', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1582', '5slpefdrhr1ddanbj6q9cncl90', '4', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1584', 'bhr2o0torbal3s9bu396h053f5', '3349', NULL, '10', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1585', 'hbl22im87avr6h4oia3n1lgvj2', '1298', NULL, '5', NULL, NULL, NULL, '1', '394', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1586', 'hbl22im87avr6h4oia3n1lgvj2', '491', NULL, '2', NULL, NULL, NULL, '1', '394', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1587', 'hbl22im87avr6h4oia3n1lgvj2', '2311', NULL, '4', NULL, NULL, NULL, '1', '395', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1588', 'hbl22im87avr6h4oia3n1lgvj2', '4355', NULL, '36', NULL, NULL, NULL, '1', '396', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1589', 'hbl22im87avr6h4oia3n1lgvj2', '660', NULL, '2', NULL, NULL, NULL, '1', '397', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1590', 'hbl22im87avr6h4oia3n1lgvj2', '1453', NULL, '1', NULL, NULL, NULL, '1', '398', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1591', 'llnf1hj1sr2fht4ga0o3mnrb75', '42', NULL, '1', NULL, NULL, NULL, '1', '399', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1593', 'llnf1hj1sr2fht4ga0o3mnrb75', '1045', NULL, '1', NULL, NULL, NULL, '1', '399', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1594', 'llnf1hj1sr2fht4ga0o3mnrb75', '1064', NULL, '1', NULL, NULL, NULL, '1', '399', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1595', 'llnf1hj1sr2fht4ga0o3mnrb75', '38', NULL, '1', NULL, NULL, NULL, '1', '399', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1596', 'llnf1hj1sr2fht4ga0o3mnrb75', '47', NULL, '1', NULL, NULL, NULL, '1', '399', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1597', '2djr5nacu8dm08urh7bish0gb5', '2406', NULL, '5', NULL, NULL, NULL, '1', '400', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1598', '2djr5nacu8dm08urh7bish0gb5', '2416', NULL, '5', NULL, NULL, NULL, '1', '400', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1599', '2djr5nacu8dm08urh7bish0gb5', '56', NULL, '1', NULL, NULL, NULL, '1', '400', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1600', 'hbl22im87avr6h4oia3n1lgvj2', '1303', NULL, '2', NULL, NULL, NULL, '1', '401', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1601', 'hbl22im87avr6h4oia3n1lgvj2', '1281', NULL, '5', NULL, NULL, NULL, '1', '401', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1602', 'hbl22im87avr6h4oia3n1lgvj2', '1278', NULL, '1', NULL, NULL, NULL, '1', '401', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1603', 'hbl22im87avr6h4oia3n1lgvj2', '1277', NULL, '3', NULL, NULL, NULL, '1', '401', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1604', 'jn51aim8fnqo1tkdiejnhk9dt2', '3167', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1605', 'mog6sb31rfmucqms43m9cjpri2', '2364', NULL, '3', NULL, NULL, NULL, '1', '402', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1606', 'mog6sb31rfmucqms43m9cjpri2', '2482', NULL, '1', NULL, NULL, NULL, '1', '402', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1607', 'mog6sb31rfmucqms43m9cjpri2', '658', NULL, '6', NULL, NULL, NULL, '1', '402', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1608', 'gcla5eckldom997rrbf3mbfth4', '2439', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1609', '0skkii4lj8mmbfjiuo10tm3bu3', '2773', NULL, '1', NULL, NULL, NULL, '1', '403', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1610', '59fael0c6mt45i04gvrebgi8q7', '2406', NULL, '20', NULL, NULL, NULL, '1', '404', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1611', 'j7p2r6n02248529bqij14fdb85', '599', NULL, '1', NULL, NULL, NULL, '1', '405', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1612', 'j7p2r6n02248529bqij14fdb85', '4333', NULL, '1', NULL, NULL, NULL, '1', '405', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1613', 'j7p2r6n02248529bqij14fdb85', '4334', NULL, '2', NULL, NULL, NULL, '1', '405', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1614', 'j7p2r6n02248529bqij14fdb85', '4335', NULL, '2', NULL, NULL, NULL, '1', '405', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1615', '2makhvhb2utvff195d46jusai5', '1276', NULL, '10', NULL, NULL, NULL, '1', '406', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1616', '2makhvhb2utvff195d46jusai5', '1298', NULL, '10', NULL, NULL, NULL, '1', '406', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1618', 'mmu45iqecq2hpatbrki4p094i5', '3171', NULL, '1', NULL, NULL, NULL, '1', '407', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1619', 'mmu45iqecq2hpatbrki4p094i5', '660', NULL, '4', NULL, NULL, NULL, '1', '408', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1620', 'mmu45iqecq2hpatbrki4p094i5', '658', NULL, '5', NULL, NULL, NULL, '1', '408', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1621', 'thm2jm1ejqp0cu81rm3vs1mtb3', '1729', NULL, '1', NULL, NULL, NULL, '1', '409', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1622', 'thm2jm1ejqp0cu81rm3vs1mtb3', '660', NULL, '2', NULL, NULL, NULL, '1', '409', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1626', 'gggoudmnj9mgp142l3np74qm87', '1', NULL, '2', NULL, NULL, NULL, '1', '410', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1627', 'mmu45iqecq2hpatbrki4p094i5', '679', NULL, '1', NULL, NULL, NULL, '1', '411', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1628', '1ijlcf4rdbf67q7d9bf2ob8ib4', '3503', NULL, '1', NULL, NULL, NULL, '1', '412', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1629', '1ijlcf4rdbf67q7d9bf2ob8ib4', '4414', NULL, '1', NULL, NULL, NULL, '1', '412', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1630', '1ijlcf4rdbf67q7d9bf2ob8ib4', '4110', NULL, '1', NULL, NULL, NULL, '1', '412', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1631', '1ijlcf4rdbf67q7d9bf2ob8ib4', '4126', NULL, '1', NULL, NULL, NULL, '1', '412', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1632', 'nes16ku1jt1cu4mc05rptoj373', '20', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1633', 'ce6aocl58b5ucmcdop6eddi235', '2376', NULL, '1', NULL, NULL, NULL, '1', '413', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1634', '6aa6jlful8g8do489u4t7j2fu2', '3031', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1635', 'glq491tf0nr9u3qrd4io0sf964', '654', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1636', 'glq491tf0nr9u3qrd4io0sf964', '656', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1637', 'tjvhc4agfnf62q2epgh3r2j2s6', '1087', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1638', '9a8n3lpc2v74mmojdk4p2vefq1', '248', NULL, '2', NULL, NULL, NULL, '1', '414', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1639', '9a8n3lpc2v74mmojdk4p2vefq1', '2938', NULL, '4', NULL, NULL, NULL, '1', '414', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1640', '9a8n3lpc2v74mmojdk4p2vefq1', '3024', NULL, '5', NULL, NULL, NULL, '1', '414', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1641', '1ptled23sfmrgcsn6u8sjha9u0', '1010', NULL, '1', NULL, NULL, NULL, '1', '416', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1642', '1ptled23sfmrgcsn6u8sjha9u0', '3091', NULL, '1', NULL, NULL, NULL, '1', '416', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1643', '9a8n3lpc2v74mmojdk4p2vefq1', '2938', NULL, '10', NULL, NULL, NULL, '1', '415', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1644', '1ptled23sfmrgcsn6u8sjha9u0', '2484', NULL, '4', NULL, NULL, NULL, '1', '416', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1645', '1ptled23sfmrgcsn6u8sjha9u0', '550', NULL, '3', NULL, NULL, NULL, '1', '416', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1647', '5jgs0np7m05gg66jj9qk1u4l02', '1904', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1648', '5jgs0np7m05gg66jj9qk1u4l02', '2230', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1649', '10b0b7427be8f042b7d78d59bc396cdf', '280', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1650', '191032f9941dbec81a27f271d3ec520e', '1934', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1651', '191032f9941dbec81a27f271d3ec520e', '2746', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1652', '31fe077ac530e17f81ba638250e00368', '1934', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1653', '31fe077ac530e17f81ba638250e00368', '2746', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1654', '2f1d36bc8f7721f43df447f8f5235a46', '242', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1655', '0aed4292990fa3f4f071dff90a9f785b', '570', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1656', '793d94374443d06a4e8852e61f61d0b1', '1271', NULL, '30', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1657', '793d94374443d06a4e8852e61f61d0b1', '1272', NULL, '20', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1658', '793d94374443d06a4e8852e61f61d0b1', '1273', NULL, '10', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1659', 'c1622ab3bdd96f21ccc9b7df32392af6', '1271', NULL, '30', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1660', 'c1622ab3bdd96f21ccc9b7df32392af6', '1272', NULL, '20', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1661', 'c1622ab3bdd96f21ccc9b7df32392af6', '1273', NULL, '10', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1662', '67e40be5b977979a7d9c24ee01955fea', '4038', NULL, '100', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1663', '67e40be5b977979a7d9c24ee01955fea', '4040', NULL, '100', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1664', '4033122885163db91c61ce6f796dbea9', '1281', NULL, '5', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1665', '4033122885163db91c61ce6f796dbea9', '1277', NULL, '5', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1666', '55e3db3423d9c2d9178a4dca41d352c5', '2400', NULL, '4', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1667', '55e3db3423d9c2d9178a4dca41d352c5', '2401', NULL, '4', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1668', '55e3db3423d9c2d9178a4dca41d352c5', '1935', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1669', 'c09040eb4b75245d2459e5f1d90ae99e', '15', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1670', '5c964d44fee4ad72893ab336bd4566c8', '1271', NULL, '40', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1671', '5c964d44fee4ad72893ab336bd4566c8', '1272', NULL, '20', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1672', '5c964d44fee4ad72893ab336bd4566c8', '1273', NULL, '10', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1673', '5941970bde5c54d6de50e618b4b0db53', '2415', NULL, '25', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1674', '5941970bde5c54d6de50e618b4b0db53', '2405', NULL, '25', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1675', '3ee2f736ce176f77bcbcfd15961ec372', '1277', NULL, '5', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1676', 'bde34362ea9861ccfb7e4c3e44a8c6a8', '1275', NULL, '5', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1677', 'ef1e2aeb2ffb017b964c7f9b821cac02', '666', NULL, '3', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1679', '1ce8330e25581d053dbc620caf1ffdef', '1180', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1680', '1ce8330e25581d053dbc620caf1ffdef', '1241', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1681', '1ce8330e25581d053dbc620caf1ffdef', '1242', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1682', 'e9bb775b31d32995be06599f3a48c0a3', '672', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1683', '654d9e79b5b4aabee6c7b31fffe0d52a', '773', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1684', 'ed752a1ae175f04e5d1cf95d0518d231', '281', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1685', 'db102b449bc40f061f31cb15b5144a37', '2407', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1686', 'db102b449bc40f061f31cb15b5144a37', '2417', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1687', 'db102b449bc40f061f31cb15b5144a37', '2482', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1688', 'db102b449bc40f061f31cb15b5144a37', '2205', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1689', 'db102b449bc40f061f31cb15b5144a37', '2210', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1690', '45cacb327139cbdba9ebeae252c56a83', '804', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1692', '45cacb327139cbdba9ebeae252c56a83', '732', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1693', '45cacb327139cbdba9ebeae252c56a83', '712', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1694', '45cacb327139cbdba9ebeae252c56a83', '774', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1695', '45cacb327139cbdba9ebeae252c56a83', '781', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1697', '92999830512b21c0c35f1005c2d133fd', '712', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1699', 'fc46956973726ad1cb8a617c6ef53643', '1974', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1700', '0115bc3f8b21c79441d77e52ea261eb3', '2410', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1701', 'd0088432ed47f8f50084ee5c2145775d', '488', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1702', '8f4f7686f0afba70b38a95dd768b6dc1', '712', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1703', '0a83c3c25560ede151522ebdb442bfaa', '712', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1704', '0a83c3c25560ede151522ebdb442bfaa', '187', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1705', 'c67ea39c9da4ebb384747cdf98cd67d6', '2376', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1706', '18b4af1a2a5836d49e95b54f1720e115', '2376', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1707', '90d2cef2236773181490ab35d30608f9', '1464', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1708', '04b73731455ecd07164bf6c2755de0ed', '3', NULL, '1', NULL, NULL, NULL, '1', '417', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1709', '04b73731455ecd07164bf6c2755de0ed', '1', NULL, '1', NULL, NULL, NULL, '1', '417', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1710', '2c2498db6b0809ac4bc7fd79c5f71f39', '3123', NULL, '1', NULL, NULL, NULL, '1', '418', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1711', '95c9cb411c5d8427ba2d8d9e7fd6cdb7', '3123', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1712', '3bfcd1fde961b4dc90eedf4497e2c1b5', '1945', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1714', 'e0f910931ebad01f26acdc32eb5cfe08', '2945', NULL, '15', NULL, NULL, NULL, '1', '419', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1715', '96f14131ac6aac5142e7812e4130fd6c', '4055', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1716', 'e5f459cc7de9e6beddfa77d3690dcab2', '1353', NULL, '1', NULL, NULL, NULL, '1', '420', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1717', 'e5f459cc7de9e6beddfa77d3690dcab2', '3929', NULL, '1', NULL, NULL, NULL, '1', '420', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1718', 'b4932695cc79878c004c78eab4471f2a', '1271', NULL, '20', NULL, NULL, NULL, '1', '421', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1719', 'b4932695cc79878c004c78eab4471f2a', '1272', NULL, '25', NULL, NULL, NULL, '1', '421', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1720', 'b4932695cc79878c004c78eab4471f2a', '1273', NULL, '20', NULL, NULL, NULL, '1', '421', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1722', '4c2a1aaf39b1f1373e54c416b6caf87b', '3076', NULL, '1', NULL, NULL, NULL, '1', '422', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1723', '4c2a1aaf39b1f1373e54c416b6caf87b', '3091', NULL, '1', NULL, NULL, NULL, '1', '422', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1724', '4c2a1aaf39b1f1373e54c416b6caf87b', '2855', NULL, '1', NULL, NULL, NULL, '1', '422', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1725', '4c2a1aaf39b1f1373e54c416b6caf87b', '2859', NULL, '1', NULL, NULL, NULL, '1', '422', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1726', '4c2a1aaf39b1f1373e54c416b6caf87b', '2863', NULL, '1', NULL, NULL, NULL, '1', '422', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1727', '4c2a1aaf39b1f1373e54c416b6caf87b', '2866', NULL, '1', NULL, NULL, NULL, '1', '422', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1728', '4c2a1aaf39b1f1373e54c416b6caf87b', '2868', NULL, '1', NULL, NULL, NULL, '1', '422', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1729', '4c2a1aaf39b1f1373e54c416b6caf87b', '2874', NULL, '1', NULL, NULL, NULL, '1', '422', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1730', '4c2a1aaf39b1f1373e54c416b6caf87b', '2878', NULL, '1', NULL, NULL, NULL, '1', '422', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1731', '4c2a1aaf39b1f1373e54c416b6caf87b', '2884', NULL, '1', NULL, NULL, NULL, '1', '422', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1732', '1856578ba5e932a2de97d96156fbf873', '1453', NULL, '1', NULL, NULL, NULL, '1', '423', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1733', '1fa2cf4518cd1bc8e07072be80ca76ec', '1935', NULL, '2', NULL, NULL, NULL, '1', '424', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1734', '5749dd36b231386759ba861ee4f74877', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1735', '15065a0e9c2deccdf4f9571eaccfece2', '2736', NULL, '1', NULL, NULL, NULL, '1', '425', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1736', '15065a0e9c2deccdf4f9571eaccfece2', '1904', NULL, '1', NULL, NULL, NULL, '1', '425', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1737', '15065a0e9c2deccdf4f9571eaccfece2', '2882', NULL, '1', NULL, NULL, NULL, '1', '425', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1738', '15065a0e9c2deccdf4f9571eaccfece2', '2883', NULL, '1', NULL, NULL, NULL, '1', '425', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1739', '33409842e98c9f323e1e35240f92c5d1', '29', NULL, '1', NULL, NULL, NULL, '1', '426', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1740', '33409842e98c9f323e1e35240f92c5d1', '2416', NULL, '10', NULL, NULL, NULL, '1', '426', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1741', '60d7f797fe16742b090278cc014a48da', '1282', NULL, '20', NULL, NULL, NULL, '1', '427', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1742', '218a239e109685c1ef7b15dcc9b01ff0', '281', NULL, '2', NULL, NULL, NULL, '1', '428', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1743', '218a239e109685c1ef7b15dcc9b01ff0', '283', NULL, '2', NULL, NULL, NULL, '1', '428', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1744', '218a239e109685c1ef7b15dcc9b01ff0', '286', NULL, '2', NULL, NULL, NULL, '1', '428', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1745', '218a239e109685c1ef7b15dcc9b01ff0', '287', NULL, '2', NULL, NULL, NULL, '1', '428', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1746', '0361f4aec210abbcc40f0ea412a8f911', '2473', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1747', 'ed4c7d344da87ee1d35820c156562889', '3212', NULL, '1', NULL, NULL, NULL, '1', '429', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1749', '3a5fee0e623b7471e82b807e4c7314d0', '1912', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1750', '2ca7e6f3480540d874f462ab2071e7f5', '3948', NULL, '1', NULL, NULL, NULL, '1', '430', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1751', 'db078e3d1f2d6553d7af68271a0eca5a', '4016', NULL, '50', NULL, NULL, NULL, '1', '431', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1752', 'db078e3d1f2d6553d7af68271a0eca5a', '4014', NULL, '100', NULL, NULL, NULL, '1', '431', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1753', 'db078e3d1f2d6553d7af68271a0eca5a', '879', NULL, '1', NULL, NULL, NULL, '1', '431', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1754', '000d96b6d925d08c7355b1c74723703b', '292', NULL, '1', NULL, NULL, NULL, '1', '432', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1756', '60d895ac7eb8e1d407bc79c8d62bcff5', '379', NULL, '1', NULL, NULL, NULL, '1', '433', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1757', 'e142f65afdd661a84c7636d0cf168285', '414', NULL, '1', NULL, NULL, NULL, '1', '434', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1758', 'e142f65afdd661a84c7636d0cf168285', '410', NULL, '1', NULL, NULL, NULL, '1', '434', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1759', '95417d75a00f2c678e5236f217d8b0bb', '4215', NULL, '50', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1760', 'ab86cb72362ac279027d09bcae6b7d50', '300', NULL, '1', NULL, NULL, NULL, '1', '435', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1761', 'dc70f2c864c83ca897166e135dd908d2', '1032', NULL, '5', NULL, NULL, NULL, '1', '436', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1762', 'dc70f2c864c83ca897166e135dd908d2', '486', NULL, '5', NULL, NULL, NULL, '1', '437', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1763', '9f5282632dcb4567e10ce2ec933e6b20', '1354', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1764', '9f5282632dcb4567e10ce2ec933e6b20', '3929', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1765', '7392fc07683674f9f65b7783b26256b3', '214', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1766', '0bcb6b13be48e6302f4c346050bad5af', '3929', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1767', '0bcb6b13be48e6302f4c346050bad5af', '1354', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1768', '235b082d26b09e0bcc5ab4d4b89d3e1e', '3364', NULL, '1', NULL, NULL, NULL, '1', '438', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1769', 'b5cfdcf16847564bac46d62716abb9b7', '4175', NULL, '3', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1770', '826648d93061a338bce8b5cfc15e09bf', '2186', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1772', 'b4bc17edf48ff4394b24432fd07f47b0', '4591', NULL, '1', NULL, NULL, NULL, '1', '439', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1773', 'b6a937c4a073bbbae0f8d07406d30c28', '2617', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1774', 'c77296b1aa0b191ad11fcfc14a82d7b9', '1268', NULL, '1', NULL, NULL, NULL, '1', '440', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1775', 'c77296b1aa0b191ad11fcfc14a82d7b9', '1275', NULL, '1', NULL, NULL, NULL, '1', '440', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1776', 'f0043d37dbad38e70c5295204ad067e6', '3929', NULL, '1', NULL, NULL, NULL, '1', '441', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1777', 'f0043d37dbad38e70c5295204ad067e6', '1354', NULL, '1', NULL, NULL, NULL, '1', '441', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1779', '8c58501f42079e0884ef3e73ffab07a3', '3556', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1780', 'ef32c5d2961f146ced8c3a177a63dd11', '637', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1781', '1f87029a57ff7e561e61f2bf93a6e42c', '389', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1782', '1f87029a57ff7e561e61f2bf93a6e42c', '444', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1784', '1f87029a57ff7e561e61f2bf93a6e42c', '381', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1785', '1f87029a57ff7e561e61f2bf93a6e42c', '1723', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1786', '1f87029a57ff7e561e61f2bf93a6e42c', '1726', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1787', '1f87029a57ff7e561e61f2bf93a6e42c', '1727', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1790', '1f87029a57ff7e561e61f2bf93a6e42c', '1994', NULL, '100', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1791', 'c39b56bc836427642b315ca02008b716', '1268', NULL, '15', NULL, NULL, NULL, '1', '442', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1792', 'c39b56bc836427642b315ca02008b716', '1275', NULL, '10', NULL, NULL, NULL, '1', '442', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1793', 'c39b56bc836427642b315ca02008b716', '1273', NULL, '20', NULL, NULL, NULL, '1', '442', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1794', 'c9b2a3792f1bf7a7c29ddf43550bf37a', '482', NULL, '10', NULL, NULL, NULL, '1', '443', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1795', 'c9b2a3792f1bf7a7c29ddf43550bf37a', '3076', NULL, '1', NULL, NULL, NULL, '1', '443', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1797', 'b6f998df3477a8a7144d5568dac4d3ad', '2736', NULL, '3', NULL, NULL, NULL, '1', '444', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1798', 'b6f998df3477a8a7144d5568dac4d3ad', '41', NULL, '1', NULL, NULL, NULL, '1', '444', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1799', 'b6f998df3477a8a7144d5568dac4d3ad', '337', NULL, '2', NULL, NULL, NULL, '1', '444', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1800', 'ba4bcfa71f74a7c85df051eb8b1375a5', '2021', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1801', 'a92caf71f4f6fa2a185082ff06dfe46c', '2855', NULL, '1', NULL, NULL, NULL, '1', '445', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1802', 'a92caf71f4f6fa2a185082ff06dfe46c', '2857', NULL, '1', NULL, NULL, NULL, '1', '445', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1803', 'a92caf71f4f6fa2a185082ff06dfe46c', '2859', NULL, '1', NULL, NULL, NULL, '1', '445', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1804', 'a92caf71f4f6fa2a185082ff06dfe46c', '2863', NULL, '1', NULL, NULL, NULL, '1', '445', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1805', 'a92caf71f4f6fa2a185082ff06dfe46c', '2867', NULL, '1', NULL, NULL, NULL, '1', '445', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1806', 'a92caf71f4f6fa2a185082ff06dfe46c', '2869', NULL, '1', NULL, NULL, NULL, '1', '445', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1807', 'a92caf71f4f6fa2a185082ff06dfe46c', '2873', NULL, '1', NULL, NULL, NULL, '1', '445', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1808', 'a92caf71f4f6fa2a185082ff06dfe46c', '2874', NULL, '1', NULL, NULL, NULL, '1', '445', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1809', 'a92caf71f4f6fa2a185082ff06dfe46c', '2875', NULL, '1', NULL, NULL, NULL, '1', '445', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1810', 'a92caf71f4f6fa2a185082ff06dfe46c', '2876', NULL, '1', NULL, NULL, NULL, '1', '445', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1811', 'a92caf71f4f6fa2a185082ff06dfe46c', '2878', NULL, '1', NULL, NULL, NULL, '1', '445', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1812', 'a92caf71f4f6fa2a185082ff06dfe46c', '2882', NULL, '1', NULL, NULL, NULL, '1', '445', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1813', 'a92caf71f4f6fa2a185082ff06dfe46c', '2880', NULL, '1', NULL, NULL, NULL, '1', '445', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1814', 'f4797c8f78277c6a17bb25a3ad820c4c', '4328', NULL, '10', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1815', 'f4797c8f78277c6a17bb25a3ad820c4c', '2311', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1816', 'f4797c8f78277c6a17bb25a3ad820c4c', '2937', NULL, '5', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1817', 'f4797c8f78277c6a17bb25a3ad820c4c', '2938', NULL, '5', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1818', 'f4797c8f78277c6a17bb25a3ad820c4c', '2939', NULL, '5', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1819', 'f4797c8f78277c6a17bb25a3ad820c4c', '2944', NULL, '5', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1821', 'ca424b5e511d30425a788f4d4a5088bc', '2322', NULL, '1', NULL, NULL, NULL, '1', '446', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1822', 'ca424b5e511d30425a788f4d4a5088bc', '379', NULL, '1', NULL, NULL, NULL, '1', '446', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1823', '86ba4ab6f6b77807119b552add218cbd', '381', NULL, '1', NULL, NULL, NULL, '1', '447', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1824', '86ba4ab6f6b77807119b552add218cbd', '444', NULL, '1', NULL, NULL, NULL, '1', '447', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1825', '86ba4ab6f6b77807119b552add218cbd', '1994', NULL, '120', NULL, NULL, NULL, '1', '447', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1826', '86ba4ab6f6b77807119b552add218cbd', '389', NULL, '1', NULL, NULL, NULL, '1', '447', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1830', '86ba4ab6f6b77807119b552add218cbd', '2874', NULL, '2', NULL, NULL, NULL, '1', '447', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1831', '86ba4ab6f6b77807119b552add218cbd', '2514', NULL, '1', NULL, NULL, NULL, '1', '447', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1832', '86ba4ab6f6b77807119b552add218cbd', '2502', NULL, '1', NULL, NULL, NULL, '1', '447', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1833', '86ba4ab6f6b77807119b552add218cbd', '1723', NULL, '1', NULL, NULL, NULL, '1', '447', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1834', '86ba4ab6f6b77807119b552add218cbd', '1726', NULL, '1', NULL, NULL, NULL, '1', '447', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1835', '86ba4ab6f6b77807119b552add218cbd', '1727', NULL, '1', NULL, NULL, NULL, '1', '447', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1836', '86ba4ab6f6b77807119b552add218cbd', '1797', NULL, '5', NULL, NULL, NULL, '1', '448', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1837', '86ba4ab6f6b77807119b552add218cbd', '1794', NULL, '5', NULL, NULL, NULL, '1', '448', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1839', 'ce0008c5db807e02b5684c58961181cf', '1933', NULL, '1', NULL, NULL, NULL, '1', '449', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1840', 'ce0008c5db807e02b5684c58961181cf', '187', NULL, '1', NULL, NULL, NULL, '1', '449', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1841', 'ce0008c5db807e02b5684c58961181cf', '3093', NULL, '1', NULL, NULL, NULL, '1', '449', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1842', 'ce0008c5db807e02b5684c58961181cf', '977', NULL, '1', NULL, NULL, NULL, '1', '449', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1843', 'ce0008c5db807e02b5684c58961181cf', '2419', NULL, '6', NULL, NULL, NULL, '1', '449', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1844', 'ce0008c5db807e02b5684c58961181cf', '2409', NULL, '6', NULL, NULL, NULL, '1', '449', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1845', '8a66cc5a05296f98a71d9896703d599f', '2407', NULL, '10', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1846', '8a66cc5a05296f98a71d9896703d599f', '2405', NULL, '10', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1847', '61c466c57b572bf980021a4dfc37d32a', '217', NULL, '1', NULL, NULL, NULL, '1', '450', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1848', '61c466c57b572bf980021a4dfc37d32a', '2855', NULL, '1', NULL, NULL, NULL, '1', '450', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1849', '48bafb6b9c171a709ef34dac85beca81', '2502', NULL, '1', NULL, NULL, NULL, '1', '451', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1850', 'd612a9ec648a19e32b4643537e41d56d', '219', NULL, '2', NULL, NULL, NULL, '1', '452', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1851', 'd612a9ec648a19e32b4643537e41d56d', '2855', NULL, '1', NULL, NULL, NULL, '1', '452', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1852', 'd612a9ec648a19e32b4643537e41d56d', '2933', NULL, '3', NULL, NULL, NULL, '1', '452', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1853', 'd612a9ec648a19e32b4643537e41d56d', '2937', NULL, '2', NULL, NULL, NULL, '1', '452', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1854', '99f7f5029f8d5f881656e07eed0ae771', '1933', NULL, '1', NULL, NULL, NULL, '1', '453', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1855', '99f7f5029f8d5f881656e07eed0ae771', '606', NULL, '3', NULL, NULL, NULL, '1', '453', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1856', '99f7f5029f8d5f881656e07eed0ae771', '4069', NULL, '35', NULL, NULL, NULL, '1', '453', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1857', '99f7f5029f8d5f881656e07eed0ae771', '4070', NULL, '30', NULL, NULL, NULL, '1', '453', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1858', '804b1e330c95eef02c39a56addb5cd82', '1922', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1860', '85f41ccefdba0a978f2a923887be70c2', '2230', NULL, '1', NULL, NULL, NULL, '1', '454', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1861', '85f41ccefdba0a978f2a923887be70c2', '2283', NULL, '1', NULL, NULL, NULL, '1', '454', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1862', 'b7fbb9a0917e9e1c327c9013fbc2d7f0', '2407', NULL, '2', NULL, NULL, NULL, '1', '455', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1863', 'b7fbb9a0917e9e1c327c9013fbc2d7f0', '2417', NULL, '2', NULL, NULL, NULL, '1', '455', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1864', 'ad0bfacb86364222e1ab9dd08abf3e84', '1934', NULL, '1', NULL, NULL, NULL, '1', '456', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1865', 'ad0bfacb86364222e1ab9dd08abf3e84', '607', NULL, '1', NULL, NULL, NULL, '1', '456', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1866', '5d3189d52a22e3c73fc88a65bca61174', '1892', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1869', '8bbad929dbad1c7763911f06934577a5', '2313', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1870', '866155a4e1494945904344194dd98744', '4118', NULL, '3', NULL, NULL, NULL, '1', '457', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1871', 'e369eb4fd85858d4cb2b8ff078e52922', '658', NULL, '8', NULL, NULL, NULL, '1', '458', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1874', '551e32c6ab6da3955d9448eb52a99d63', '1811', NULL, '1', NULL, NULL, NULL, '1', '459', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1875', '551e32c6ab6da3955d9448eb52a99d63', '486', NULL, '20', NULL, NULL, NULL, '1', '459', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1876', '85a981952ea82866f34fa7701a3ff97d', '636', NULL, '1', NULL, NULL, NULL, '1', '460', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1877', '97fca52176a6ea427f693635e72d914c', '4435', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1878', 'c6377ab2fa8cd70b8d3b495696054ddc', '281', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1880', '866fdd691edfbcd541deb6a217636028', '1032', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1881', 'fa460d6bf3c0f58f070be596b75c9708', '2403', NULL, '11', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1882', '8365106c31f9fa3a2b69632a4f93ba3e', '3203', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1883', '299e0510a887c3248722cfb4df213018', '4647', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1884', '299e0510a887c3248722cfb4df213018', '258', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1885', 'ad7e7f1d94295dbb63e7a8d22759c201', '3981', NULL, '12', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1886', '7a2535bb55e8297e77b9ba6d569e5004', '2405', NULL, '30', NULL, NULL, NULL, '1', '461', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1887', 'fab58f3f4cd01be562e252c290df15c4', '465', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1888', 'efbbadebcde62ea6ae6580481e42abd0', '658', NULL, '7', NULL, NULL, NULL, '1', '462', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1889', '919cdbc8ca82b0883b4c38a584591c6f', '1136', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1891', '20a457a94628211694ae240f16d2190a', '610', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1892', '20a457a94628211694ae240f16d2190a', '606', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1893', '20a457a94628211694ae240f16d2190a', '4443', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1894', '20a457a94628211694ae240f16d2190a', '4444', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1895', 'fcbcc9d38c1bb44fb313469420d7b842', '4068', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1896', 'e91a1f65289c124458043405aa0eff54', '62', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1897', '2eeddea645d5ba4def3f5df82f2cf237', '1137', NULL, '1', NULL, NULL, NULL, '1', '463', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1898', '91e218e4234234559f5f06d7cff50678', '959', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1899', '2eeddea645d5ba4def3f5df82f2cf237', '609', NULL, '2', NULL, NULL, NULL, '1', '463', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1901', '03600692b23adc398e25088db2e7cc74', '659', NULL, '10', NULL, NULL, NULL, '1', '464', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1903', '53087e981fb0240e190a6dacb4654947', '4051', NULL, '5', NULL, NULL, NULL, '1', '465', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1904', '53087e981fb0240e190a6dacb4654947', '4039', NULL, '10', NULL, NULL, NULL, '1', '465', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1906', 'b74ee60c90ea1eaa9a7e4b3d0d483cfd', '297', NULL, '1', NULL, NULL, NULL, '1', '466', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1907', 'b74ee60c90ea1eaa9a7e4b3d0d483cfd', '300', NULL, '1', NULL, NULL, NULL, '1', '466', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1908', 'b74ee60c90ea1eaa9a7e4b3d0d483cfd', '303', NULL, '1', NULL, NULL, NULL, '1', '466', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1910', '30144997866856884b2307d487ef4ce8', '2232', NULL, '1', NULL, NULL, NULL, '1', '467', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1911', '30144997866856884b2307d487ef4ce8', '300', NULL, '1', NULL, NULL, NULL, '1', '467', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1912', '223d187b627c5fca5c9a54dd0ab4c3c0', '4039', NULL, '12', NULL, NULL, NULL, '1', '468', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1913', '223d187b627c5fca5c9a54dd0ab4c3c0', '4109', NULL, '1', NULL, NULL, NULL, '1', '468', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1914', '223d187b627c5fca5c9a54dd0ab4c3c0', '4186', NULL, '2', NULL, NULL, NULL, '1', '468', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1915', 'c9454e1d8d8720896d1a417a740318aa', '3998', NULL, '5', NULL, NULL, NULL, '1', '469', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1916', 'c9454e1d8d8720896d1a417a740318aa', '2400', NULL, '10', NULL, NULL, NULL, '1', '469', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1917', 'c9454e1d8d8720896d1a417a740318aa', '1268', NULL, '10', NULL, NULL, NULL, '1', '469', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1918', 'c9454e1d8d8720896d1a417a740318aa', '1275', NULL, '50', NULL, NULL, NULL, '1', '469', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1919', '1751527b8eafc0858cccfd2fea0e7242', '1724', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1920', '1751527b8eafc0858cccfd2fea0e7242', '1695', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1921', '1751527b8eafc0858cccfd2fea0e7242', '1696', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1922', '94394fa7733053c0103969ab052d4512', '2583', NULL, '3', NULL, NULL, NULL, '1', '470', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1923', '94394fa7733053c0103969ab052d4512', '2603', NULL, '5', NULL, NULL, NULL, '1', '470', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1924', '2a026f62e8bd2cf96981f0846fda791f', '41', NULL, '1', NULL, NULL, NULL, '1', '471', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1925', '2a026f62e8bd2cf96981f0846fda791f', '40', NULL, '1', NULL, NULL, NULL, '1', '471', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1926', '2a026f62e8bd2cf96981f0846fda791f', '50', NULL, '1', NULL, NULL, NULL, '1', '471', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1927', '2a026f62e8bd2cf96981f0846fda791f', '49', NULL, '1', NULL, NULL, NULL, '1', '471', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1929', '131002ca952c9a07421b9a9b406040bd', '2781', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1930', '85ca5a898e65916c939c423962409d56', '1476', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1931', '458e1c7de29c22cef750e84d8511a652', '2875', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1932', '5444414277abb1d192718ff8a31cfbc7', '1275', NULL, '5', NULL, NULL, NULL, '1', '472', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1933', '5444414277abb1d192718ff8a31cfbc7', '658', NULL, '10', NULL, NULL, NULL, '1', '472', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1935', 'c38af976d4057e19f9e13340aedcbad9', '2800', NULL, '2', NULL, NULL, NULL, '1', '473', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1936', 'b0fd60b2f893b55a6934f034a26dfcfb', '2505', NULL, '10', NULL, NULL, NULL, '1', '474', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1937', 'b0fd60b2f893b55a6934f034a26dfcfb', '2514', NULL, '10', NULL, NULL, NULL, '1', '474', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1940', '6d78e02ecc9cd2fe5d00a38e007c3161', '2406', NULL, '2', NULL, NULL, NULL, '1', '475', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1941', '6d78e02ecc9cd2fe5d00a38e007c3161', '2416', NULL, '2', NULL, NULL, NULL, '1', '475', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1942', '6d78e02ecc9cd2fe5d00a38e007c3161', '2407', NULL, '2', NULL, NULL, NULL, '1', '475', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1943', '6d78e02ecc9cd2fe5d00a38e007c3161', '2417', NULL, '2', NULL, NULL, NULL, '1', '475', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1944', 'dc09b7a0b00ff4686610b4e22e4ba723', '799', NULL, '1', NULL, NULL, NULL, '1', '476', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1945', 'dc09b7a0b00ff4686610b4e22e4ba723', '3094', NULL, '1', NULL, NULL, NULL, '1', '476', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1946', 'dc09b7a0b00ff4686610b4e22e4ba723', '1423', NULL, '6', NULL, NULL, NULL, '1', '476', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1947', 'dc09b7a0b00ff4686610b4e22e4ba723', '1994', NULL, '36', NULL, NULL, NULL, '1', '476', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1948', 'dc09b7a0b00ff4686610b4e22e4ba723', '1476', NULL, '1', NULL, NULL, NULL, '1', '477', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1949', 'b43fca5f4931aff2048307129f7d2e5c', '1275', NULL, '3', NULL, NULL, NULL, '1', '478', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1950', 'b43fca5f4931aff2048307129f7d2e5c', '1268', NULL, '1', NULL, NULL, NULL, '1', '478', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1951', '7e0532e390ee17ce188f1caacb83f855', '971', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1953', '8dbee680ebe7a9599f821f4b36543a52', '337', NULL, '2', NULL, NULL, NULL, '1', '479', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1954', '8dbee680ebe7a9599f821f4b36543a52', '1934', NULL, '2', NULL, NULL, NULL, '1', '479', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1955', '2d51d7d256d0b0d2533b35ae71090d01', '2736', NULL, '5', NULL, NULL, NULL, '1', '480', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1956', '2d51d7d256d0b0d2533b35ae71090d01', '2602', NULL, '5', NULL, NULL, NULL, '1', '480', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1957', '2d51d7d256d0b0d2533b35ae71090d01', '4593', NULL, '3', NULL, NULL, NULL, '1', '480', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1958', '6d68184c3c92d3c36d7a1c173b29c3e9', '4019', NULL, '20', NULL, NULL, NULL, '1', '481', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1959', '6d68184c3c92d3c36d7a1c173b29c3e9', '4021', NULL, '20', NULL, NULL, NULL, '1', '481', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1960', '6d68184c3c92d3c36d7a1c173b29c3e9', '4023', NULL, '20', NULL, NULL, NULL, '1', '481', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1961', '6d68184c3c92d3c36d7a1c173b29c3e9', '4025', NULL, '20', NULL, NULL, NULL, '1', '481', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1962', '6d68184c3c92d3c36d7a1c173b29c3e9', '4266', NULL, '4', NULL, NULL, NULL, '1', '481', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1963', '6d68184c3c92d3c36d7a1c173b29c3e9', '1785', NULL, '1', NULL, NULL, NULL, '1', '481', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1964', '9a9252699080fbf3d2b3419e52ad9b19', '1787', NULL, '20', NULL, NULL, NULL, '1', '482', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1965', '9a9252699080fbf3d2b3419e52ad9b19', '2931', NULL, '6', NULL, NULL, NULL, '1', '482', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1966', '9a9252699080fbf3d2b3419e52ad9b19', '4211', NULL, '50', NULL, NULL, NULL, '1', '482', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1967', '9a9252699080fbf3d2b3419e52ad9b19', '4215', NULL, '50', NULL, NULL, NULL, '1', '482', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1968', '2f394e08fdd3943eb8b9164fc6bfa654', '916', NULL, '2', NULL, NULL, NULL, '1', '483', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1969', 'd73a872afbf25173bf95b636543e03fd', '1032', NULL, '2', NULL, NULL, NULL, '1', '484', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1970', 'd73a872afbf25173bf95b636543e03fd', '1109', NULL, '2', NULL, NULL, NULL, '1', '484', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1971', 'd73a872afbf25173bf95b636543e03fd', '4513', NULL, '2', NULL, NULL, NULL, '1', '484', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1972', 'abc0fb663b15b8697f2be910f5c900d0', '918', NULL, '1', NULL, NULL, NULL, '1', '485', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1973', '80fe41d37763335f7de6b249dd85afd8', '4414', NULL, '2', NULL, NULL, NULL, '1', '486', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1974', '0a7120cfc50dec6fa57a5e35702533dc', '2311', NULL, '5', NULL, NULL, NULL, '1', '487', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1975', '2f5dbbc85bfab29e6d225a72558f50ce', '2614', NULL, '3', NULL, NULL, NULL, '1', '488', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1976', '8c3b29d9394f4213be6304c54dde663d', '3343', NULL, '2', NULL, NULL, NULL, '1', '489', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1977', '8c3b29d9394f4213be6304c54dde663d', '2516', NULL, '5', NULL, NULL, NULL, '1', '490', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1978', '639abfeabc81f95ba9db218229dc959b', '1111', NULL, '10', NULL, NULL, NULL, '1', '491', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1979', '8c3b29d9394f4213be6304c54dde663d', '401', NULL, '1', NULL, NULL, NULL, '1', '492', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1980', '6aa300a4221c1e49040e23f69931a437', '3565', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1981', '63561e4fcec996da4ecf59f9f5438b8a', '2516', NULL, '5', NULL, NULL, NULL, '1', '493', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1982', '63561e4fcec996da4ecf59f9f5438b8a', '2311', NULL, '5', NULL, NULL, NULL, '1', '493', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1985', '769925ee03e9294b58edc227f3d297d8', '437', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1988', 'be2ee224e860232ed7a316958a043804', '303', NULL, '1', NULL, NULL, NULL, '1', '495', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1989', '5c1f71fde30c93fee2503f412250ff77', '1934', NULL, '1', NULL, NULL, NULL, '1', '494', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1990', '5c1f71fde30c93fee2503f412250ff77', '1457', NULL, '1', NULL, NULL, NULL, '1', '494', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1991', '58dc8c3da92df89f004623ab25950959', '2407', NULL, '10', NULL, NULL, NULL, '1', '496', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1992', '431f24008cfe92532d42173a0d3cf261', '3123', NULL, '3', NULL, NULL, NULL, '1', '497', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1993', '431f24008cfe92532d42173a0d3cf261', '248', NULL, '2', NULL, NULL, NULL, '1', '497', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1994', '431f24008cfe92532d42173a0d3cf261', '1271', NULL, '10', NULL, NULL, NULL, '1', '497', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1995', '431f24008cfe92532d42173a0d3cf261', '1272', NULL, '10', NULL, NULL, NULL, '1', '497', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1996', '431f24008cfe92532d42173a0d3cf261', '3144', NULL, '3', NULL, NULL, NULL, '1', '497', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1997', 'f202eee4b0075dd38b02fd47eb9d7a3d', '2406', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('1999', '9f3f7dcfcea7fb72ab7dc29d15730adf', '658', NULL, '3', NULL, NULL, NULL, '1', '498', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2000', '9f3f7dcfcea7fb72ab7dc29d15730adf', '659', NULL, '5', NULL, NULL, NULL, '1', '498', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2001', 'f34b53816422231826c8ee1e7100c7b5', '2406', NULL, '20', NULL, NULL, NULL, '1', '499', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2002', 'afbabedf4493a4a78b6b318182024a17', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2003', 'afbabedf4493a4a78b6b318182024a17', '4', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2004', 'bfdf9e2e2316edf4a4b645ef206a1d0d', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2005', 'bfdf9e2e2316edf4a4b645ef206a1d0d', '3', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2006', '9f7f21099dd3f20fd3449600c034e8ec', '654', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2007', '9f7f21099dd3f20fd3449600c034e8ec', '661', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2008', '9f7f21099dd3f20fd3449600c034e8ec', '2242', NULL, '3', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2009', '9f7f21099dd3f20fd3449600c034e8ec', '2248', NULL, '3', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2010', 'e04392e55e689cc1999b8147b38c3ab8', '606', NULL, '2', NULL, NULL, NULL, '1', '500', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2011', 'e04392e55e689cc1999b8147b38c3ab8', '4439', NULL, '2', NULL, NULL, NULL, '1', '500', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2012', '16daf822c8c8fd3f202e3defd90da1e3', '3096', NULL, '1', NULL, NULL, NULL, '1', '501', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2013', '16daf822c8c8fd3f202e3defd90da1e3', '809', NULL, '2', NULL, NULL, NULL, '1', '501', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2014', '82a971e0eca9e8ee8ba6f3e15831377c', '4012', NULL, '120', NULL, NULL, NULL, '1', '502', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2015', '82a971e0eca9e8ee8ba6f3e15831377c', '4015', NULL, '120', NULL, NULL, NULL, '1', '502', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2017', 'cb03ae89c432ac861d234e045c5663d9', '4577', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2018', 'cb03ae89c432ac861d234e045c5663d9', '3507', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2019', 'dc4f43bc39eaf7be74a711293f57e4bc', '4069', NULL, '5', NULL, NULL, NULL, '1', '503', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2020', 'dc4f43bc39eaf7be74a711293f57e4bc', '4070', NULL, '5', NULL, NULL, NULL, '1', '503', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2021', 'dc4f43bc39eaf7be74a711293f57e4bc', '660', NULL, '10', NULL, NULL, NULL, '1', '503', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2022', '6f06dceb76cb0c25f247136de1e4a5a7', '2230', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2023', '6f06dceb76cb0c25f247136de1e4a5a7', '2231', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2024', '6f06dceb76cb0c25f247136de1e4a5a7', '2232', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2025', 'f9c994c4225b42934b4a228c171f559b', '1353', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2026', 'f9c994c4225b42934b4a228c171f559b', '1354', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2027', 'f9c994c4225b42934b4a228c171f559b', '1355', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2028', 'f9c994c4225b42934b4a228c171f559b', '1356', NULL, '5', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2029', '5kh7mo0p26rm11tagtgfmongb5', '1452', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2030', 'c05ad461301309150298da3f43c92728', '4320', NULL, '1', NULL, NULL, NULL, '1', '504', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2031', 'c05ad461301309150298da3f43c92728', '3061', NULL, '2', NULL, NULL, NULL, '1', '505', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2033', '023b91ef46a395517cb142b1264b133a', '626', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2034', 'aacd4030e8be04b0678227ae6042f2cf', '2783', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2035', '6ed08816061823636d83a1c3400b792d', '4111', NULL, '2', NULL, NULL, NULL, '1', '506', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2036', 'aebf5e46258535252f73944a9e807c8e', '2498', NULL, '5', NULL, NULL, NULL, '1', '507', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2037', '611dce82c53c29726a6761b0b0b5d176', '3952', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2041', '1c3ce06d1fa2f31752959c93ad5ca955', '4365', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2042', '1fbc7d45d8b72f19c58b4d7c5877cc83', '328', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2043', 'f4cf464711072ffda791aadea2bd7457', '1304', NULL, '30', NULL, NULL, NULL, '1', '508', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2044', 'f4cf464711072ffda791aadea2bd7457', '3263', NULL, '40', NULL, NULL, NULL, '1', '508', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2045', 'f4cf464711072ffda791aadea2bd7457', '491', NULL, '20', NULL, NULL, NULL, '1', '508', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2046', 'f4cf464711072ffda791aadea2bd7457', '667', NULL, '1', NULL, NULL, NULL, '1', '508', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2047', 'ef24c82ce1ce2151aaa76b2068ee2202', '2993', NULL, '1', NULL, NULL, NULL, '1', '509', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2048', 'ef24c82ce1ce2151aaa76b2068ee2202', '2994', NULL, '1', NULL, NULL, NULL, '1', '509', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2049', 'ef24c82ce1ce2151aaa76b2068ee2202', '2995', NULL, '1', NULL, NULL, NULL, '1', '509', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2050', 'ef24c82ce1ce2151aaa76b2068ee2202', '2996', NULL, '1', NULL, NULL, NULL, '1', '509', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2051', 'ef24c82ce1ce2151aaa76b2068ee2202', '4110', NULL, '1', NULL, NULL, NULL, '1', '509', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2052', 'ef24c82ce1ce2151aaa76b2068ee2202', '4111', NULL, '1', NULL, NULL, NULL, '1', '509', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2053', '2c5bdcaf178ca7e9c6908b3c3b518069', '4070', NULL, '6', NULL, NULL, NULL, '1', '510', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2054', '2c5bdcaf178ca7e9c6908b3c3b518069', '2416', NULL, '10', NULL, NULL, NULL, '1', '510', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2055', '2c5bdcaf178ca7e9c6908b3c3b518069', '2406', NULL, '10', NULL, NULL, NULL, '1', '510', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2056', '7cfebbfc7269970569bc73e40e0c5092', '1787', NULL, '60', NULL, NULL, NULL, '1', '511', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2062', '3c2adaf5f573f3b4ddde8191707791d2', '4443', NULL, '6', NULL, NULL, NULL, '1', '512', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2063', '3c2adaf5f573f3b4ddde8191707791d2', '4444', NULL, '2', NULL, NULL, NULL, '1', '512', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2064', '3c2adaf5f573f3b4ddde8191707791d2', '607', NULL, '4', NULL, NULL, NULL, '1', '512', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2065', '3c2adaf5f573f3b4ddde8191707791d2', '615', NULL, '5', NULL, NULL, NULL, '1', '512', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2066', '3c2adaf5f573f3b4ddde8191707791d2', '609', NULL, '5', NULL, NULL, NULL, '1', '512', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2068', '1b07cc7ac6b86c228aa944d5015ac566', '4335', NULL, '1', NULL, NULL, NULL, '1', '513', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2069', '1b07cc7ac6b86c228aa944d5015ac566', '3031', NULL, '1', NULL, NULL, NULL, '1', '513', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2070', '2ca4b9ed5d65c344cce318c6e67c3625', '277', NULL, '1', NULL, NULL, NULL, '1', '514', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2071', '2ca4b9ed5d65c344cce318c6e67c3625', '1304', NULL, '10', NULL, NULL, NULL, '1', '514', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2072', '9521fe00af7fdab06c4b4a77552a5a3d', '692', NULL, '1', NULL, NULL, NULL, '1', '515', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2073', '9521fe00af7fdab06c4b4a77552a5a3d', '727', NULL, '1', NULL, NULL, NULL, '1', '515', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2074', '9521fe00af7fdab06c4b4a77552a5a3d', '2906', NULL, '1', NULL, NULL, NULL, '1', '515', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2075', '9521fe00af7fdab06c4b4a77552a5a3d', '39', NULL, '1', NULL, NULL, NULL, '1', '516', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2076', '9521fe00af7fdab06c4b4a77552a5a3d', '48', NULL, '1', NULL, NULL, NULL, '1', '516', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2077', 'af872a2b4f945170b749c007687fb0cf', '596', NULL, '2', NULL, NULL, NULL, '1', '517', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2078', '213787eb75d90b6b63ed6faade9132a9', '3512', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2079', '5eafb5330d9c586c9f854b0952b3707e', '3092', NULL, '1', NULL, NULL, NULL, '1', '518', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2080', '5d80e77e12942cfc45b10fc7c91a5401', '2375', NULL, '1', NULL, NULL, NULL, '1', '519', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2081', '5d80e77e12942cfc45b10fc7c91a5401', '2349', NULL, '2', NULL, NULL, NULL, '1', '519', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2082', '67778177753409471d2bd8a8874f612f', '1435', NULL, '1', NULL, NULL, NULL, '1', '520', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2083', '67778177753409471d2bd8a8874f612f', '610', NULL, '5', NULL, NULL, NULL, '1', '520', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2084', '67778177753409471d2bd8a8874f612f', '1134', NULL, '1', NULL, NULL, NULL, '1', '520', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2085', '7aa36093a84d4e89f392aad3e775088a', '2400', NULL, '10', NULL, NULL, NULL, '1', '521', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2086', '7aa36093a84d4e89f392aad3e775088a', '2401', NULL, '10', NULL, NULL, NULL, '1', '521', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2087', '7aa36093a84d4e89f392aad3e775088a', '1275', NULL, '15', NULL, NULL, NULL, '1', '521', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2089', '4fbe802b8b6ccc35d72ffe5c09ab5d57', '2230', NULL, '2', NULL, NULL, NULL, '1', '522', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2090', '4fbe802b8b6ccc35d72ffe5c09ab5d57', '2406', NULL, '60', NULL, NULL, NULL, '1', '522', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2091', '80aa9b8a9da74d289d56895428233ee9', '1505', NULL, '1', NULL, NULL, NULL, '1', '523', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2092', '0cfdea517ed7f480ac60f202f60a1ec1', '2550', NULL, '1', NULL, NULL, NULL, '1', '524', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2094', '9a4edcd548dea170188305df4c525ae9', '389', NULL, '1', NULL, NULL, NULL, '1', '525', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2095', '7e79d6e05bc5483a52ec61da7edd6319', '2790', NULL, '1', NULL, NULL, NULL, '1', '526', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2096', '7e79d6e05bc5483a52ec61da7edd6319', '2793', NULL, '1', NULL, NULL, NULL, '1', '526', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2097', '7e79d6e05bc5483a52ec61da7edd6319', '2795', NULL, '1', NULL, NULL, NULL, '1', '526', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2098', '15c322fafc432c022f6cb8b0c61b74bf', '1894', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2099', '6428ee54108e9aa0871d9f4dbe6da6cd', '1508', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2100', '74a624c29b3d5a904488afb179a25bb8', '3197', NULL, '1', NULL, NULL, NULL, '1', '527', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2101', '74a624c29b3d5a904488afb179a25bb8', '4186', NULL, '1', NULL, NULL, NULL, '1', '527', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2102', '5b608b017eaa91e00f6b42be326786f6', '1507', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2103', '5b608b017eaa91e00f6b42be326786f6', '260', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2104', '5b608b017eaa91e00f6b42be326786f6', '399', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2105', 'b50e506190b072d91702edcad84572dd', '1275', NULL, '1', NULL, NULL, NULL, '1', '528', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2106', 'b50e506190b072d91702edcad84572dd', '1268', NULL, '30', NULL, NULL, NULL, '1', '528', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2107', 'b50e506190b072d91702edcad84572dd', '1797', NULL, '5', NULL, NULL, NULL, '1', '529', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2108', 'b50e506190b072d91702edcad84572dd', '1275', NULL, '14', NULL, NULL, NULL, '1', '529', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2109', '3b113bca0bcf9fdababc1993a298afe5', '2515', NULL, '10', NULL, NULL, NULL, '1', '530', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2110', '145fbbf06bdae2c37fcde7019f326ffc', '2364', NULL, '3', NULL, NULL, NULL, '1', '531', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2111', '4c5828c923f8dc05521326e0410fad92', '2963', NULL, '2', NULL, NULL, NULL, '1', '532', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2112', '4c5828c923f8dc05521326e0410fad92', '2965', NULL, '2', NULL, NULL, NULL, '1', '532', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2113', '4c5828c923f8dc05521326e0410fad92', '2966', NULL, '2', NULL, NULL, NULL, '1', '532', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2114', '4c5828c923f8dc05521326e0410fad92', '2967', NULL, '2', NULL, NULL, NULL, '1', '532', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2115', '4c5828c923f8dc05521326e0410fad92', '2968', NULL, '1', NULL, NULL, NULL, '1', '532', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2116', '4c5828c923f8dc05521326e0410fad92', '2969', NULL, '1', NULL, NULL, NULL, '1', '532', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2117', 'd252ec0e9f53d70969211a5a05b92204', '443', NULL, '1', NULL, NULL, NULL, '1', '533', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2118', 'd252ec0e9f53d70969211a5a05b92204', '4362', NULL, '20', NULL, NULL, NULL, '1', '534', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2119', '0b131d768019059e7db291ea329ff9aa', '2771', NULL, '1', NULL, NULL, NULL, '1', '535', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2120', '3c6e736196876f211184772961b2b701', '282', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2121', '9aa3dd56dbe1a621d225898ebc2a17fd', '1302', NULL, '1', NULL, NULL, NULL, '1', '536', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2122', '9aa3dd56dbe1a621d225898ebc2a17fd', '1271', NULL, '3', NULL, NULL, NULL, '1', '536', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2123', '9aa3dd56dbe1a621d225898ebc2a17fd', '1272', NULL, '3', NULL, NULL, NULL, '1', '536', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2124', '9aa3dd56dbe1a621d225898ebc2a17fd', '2610', NULL, '1', NULL, NULL, NULL, '1', '536', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2125', '9aa3dd56dbe1a621d225898ebc2a17fd', '593', NULL, '6', NULL, NULL, NULL, '1', '536', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2126', '9aa3dd56dbe1a621d225898ebc2a17fd', '595', NULL, '2', NULL, NULL, NULL, '1', '536', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2127', '9aa3dd56dbe1a621d225898ebc2a17fd', '337', NULL, '1', NULL, NULL, NULL, '1', '536', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2128', '9aa3dd56dbe1a621d225898ebc2a17fd', '2123', NULL, '1', NULL, NULL, NULL, '1', '536', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2129', '3caf11aac607ee113288d594e053c82b', '3338', NULL, '3', NULL, NULL, NULL, '1', '537', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2130', '404e7c61c8df21ed1694294f568cf38a', '1134', NULL, '5', NULL, NULL, NULL, '1', '538', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2131', '404e7c61c8df21ed1694294f568cf38a', '1136', NULL, '5', NULL, NULL, NULL, '1', '538', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2132', '404e7c61c8df21ed1694294f568cf38a', '660', NULL, '5', NULL, NULL, NULL, '1', '538', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2133', '018e3b9789a3a2523d9420fb97298519', '660', NULL, '15', NULL, NULL, NULL, '1', '539', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2134', 'f7707babe97b2226912997761b16f424', '414', NULL, '2', NULL, NULL, NULL, '1', '540', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2135', 'f7707babe97b2226912997761b16f424', '1286', NULL, '1', NULL, NULL, NULL, '1', '540', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2136', 'fe1e228b30f58c91fe814c763c1ea07e', '4336', NULL, '4', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2137', '4c8fe041087b8847c7c9483c9dc11d6c', '2602', NULL, '2', NULL, NULL, NULL, '1', '541', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2139', '4a0edfe25c642f144f338cae57d6fea9', '610', NULL, '2', NULL, NULL, NULL, '1', '542', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2140', '4a0edfe25c642f144f338cae57d6fea9', '607', NULL, '5', NULL, NULL, NULL, '1', '542', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2143', 'e60d58b9d8cb7f896bb18fb1b98bc838', '3364', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2144', '0389d9a1abfaf878e0a4cee8427f36fb', '2602', NULL, '5', NULL, NULL, NULL, '1', '543', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2145', '0028dd78c57823331a2182790436b068', '710', NULL, '2', NULL, NULL, NULL, '1', '544', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2146', '0028dd78c57823331a2182790436b068', '658', NULL, '4', NULL, NULL, NULL, '1', '544', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2147', '3d8b51a05a19e64107e73a3325b8414d', '4111', NULL, '2', NULL, NULL, NULL, '1', '545', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2149', 'baea0911f02a79e586a4104b2cb2ae50', '2506', NULL, '4', NULL, NULL, NULL, '1', '546', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2150', 'baea0911f02a79e586a4104b2cb2ae50', '2499', NULL, '4', NULL, NULL, NULL, '1', '546', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2151', '77093539129d944d6c2e47c72b2d7169', '4716', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2152', '77093539129d944d6c2e47c72b2d7169', '4718', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2154', '2c6bf1cd1417f4893904070c013955e2', '20', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2155', 'e4abc30c5e2897de1021bf825bb25756', '484', NULL, '10', NULL, NULL, NULL, '1', '547', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2156', 'e4abc30c5e2897de1021bf825bb25756', '2865', NULL, '1', NULL, NULL, NULL, '1', '547', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2157', 'e4abc30c5e2897de1021bf825bb25756', '2878', NULL, '1', NULL, NULL, NULL, '1', '547', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2165', '1b511120d44a4bd26a47a08a85c43650', '1275', NULL, '27', NULL, NULL, NULL, '1', '548', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2167', '1b511120d44a4bd26a47a08a85c43650', '732', NULL, '1', NULL, NULL, NULL, '1', '548', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2168', '55163736337426801e8cb88530ebc023', '290', NULL, '1', NULL, NULL, NULL, '1', '549', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2169', '6a8264ec72b3d788ea0f9cbe1e6de45f', '27', NULL, '1', NULL, NULL, NULL, '1', '551', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2170', '6a8264ec72b3d788ea0f9cbe1e6de45f', '28', NULL, '1', NULL, NULL, NULL, '1', '551', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2171', '32a3c30db2fc8ba64279a2f239891c3f', '37', NULL, '1', NULL, NULL, NULL, '1', '550', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2172', '6a8264ec72b3d788ea0f9cbe1e6de45f', '2939', NULL, '4', NULL, NULL, NULL, '1', '551', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2173', '6a8264ec72b3d788ea0f9cbe1e6de45f', '1455', NULL, '1', NULL, NULL, NULL, '1', '551', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2174', '6a8264ec72b3d788ea0f9cbe1e6de45f', '3998', NULL, '1', NULL, NULL, NULL, '1', '551', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2175', '6a8264ec72b3d788ea0f9cbe1e6de45f', '3999', NULL, '1', NULL, NULL, NULL, '1', '551', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2176', 'f52a27dce968479f2b728733fce87016', '4', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2177', '04b48fc9acd70f36da552e2a46ce917a', '282', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2178', '7612575a58a21fa1b7dbf6c80ee3011d', '2938', NULL, '10', NULL, NULL, NULL, '1', '552', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2179', '7612575a58a21fa1b7dbf6c80ee3011d', '3290', NULL, '10', NULL, NULL, NULL, '1', '552', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2180', '7612575a58a21fa1b7dbf6c80ee3011d', '3293', NULL, '10', NULL, NULL, NULL, '1', '552', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2182', '7612575a58a21fa1b7dbf6c80ee3011d', '2943', NULL, '5', NULL, NULL, NULL, '1', '552', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2183', '17cb38e533f9639a1acd29aa86a857f1', '2736', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2184', '17cb38e533f9639a1acd29aa86a857f1', '2732', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2185', '17cb38e533f9639a1acd29aa86a857f1', '2733', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2186', 'a3f5281026b4182eec5c18bc427a3b60', '658', NULL, '7', NULL, NULL, NULL, '1', '553', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2187', 'a3f5281026b4182eec5c18bc427a3b60', '1275', NULL, '5', NULL, NULL, NULL, '1', '553', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2188', 'a3f5281026b4182eec5c18bc427a3b60', '1271', NULL, '10', NULL, NULL, NULL, '1', '553', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2189', 'a3f5281026b4182eec5c18bc427a3b60', '1272', NULL, '10', NULL, NULL, NULL, '1', '553', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2190', 'a3f5281026b4182eec5c18bc427a3b60', '2400', NULL, '10', NULL, NULL, NULL, '1', '553', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2191', 'a3f5281026b4182eec5c18bc427a3b60', '2401', NULL, '13', NULL, NULL, NULL, '1', '553', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2192', 'a3f5281026b4182eec5c18bc427a3b60', '1909', NULL, '1', NULL, NULL, NULL, '1', '554', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2193', '3071e9e16f5b3af0a47c82faf26ed3dc', '385', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2195', '0f42f19873698cb5010c0b6cf5c8a7b6', '2886', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2196', '79747h1cj3rkhrh0rbdm0luj91', '2860', NULL, '2', NULL, NULL, NULL, '1', '555', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2197', '79747h1cj3rkhrh0rbdm0luj91', '2867', NULL, '2', NULL, NULL, NULL, '1', '555', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2198', '79747h1cj3rkhrh0rbdm0luj91', '2871', NULL, '2', NULL, NULL, NULL, '1', '555', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2199', '79747h1cj3rkhrh0rbdm0luj91', '2874', NULL, '2', NULL, NULL, NULL, '1', '555', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2200', '79747h1cj3rkhrh0rbdm0luj91', '2878', NULL, '2', NULL, NULL, NULL, '1', '555', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2201', '79747h1cj3rkhrh0rbdm0luj91', '2879', NULL, '2', NULL, NULL, NULL, '1', '555', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2202', '79747h1cj3rkhrh0rbdm0luj91', '2880', NULL, '2', NULL, NULL, NULL, '1', '555', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2203', '79747h1cj3rkhrh0rbdm0luj91', '2881', NULL, '2', NULL, NULL, NULL, '1', '555', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2204', '79747h1cj3rkhrh0rbdm0luj91', '2882', NULL, '2', NULL, NULL, NULL, '1', '555', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2205', 'c1a10ec1bd867ed5e734114e0797123a', '4891', NULL, '8', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2206', 'c1a10ec1bd867ed5e734114e0797123a', '2313', NULL, '8', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2208', '42d62a091fe3de993222803224124e46', '1275', NULL, '10', NULL, NULL, NULL, '1', '556', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2209', '42d62a091fe3de993222803224124e46', '1268', NULL, '10', NULL, NULL, NULL, '1', '556', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2210', '42d62a091fe3de993222803224124e46', '1797', NULL, '6', NULL, NULL, NULL, '1', '556', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2211', 'a6b227e1b16c9bc93e9f036d8927dc49', '4000', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2212', 'a6b227e1b16c9bc93e9f036d8927dc49', '3998', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2213', 'a6b227e1b16c9bc93e9f036d8927dc49', '4084', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2214', 'ed4e3d2e9549d34a71dba9adc6608071', '2406', NULL, '20', NULL, NULL, NULL, '1', '557', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2215', 'ed4e3d2e9549d34a71dba9adc6608071', '705', NULL, '4', NULL, NULL, NULL, '1', '557', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2216', 'ed4e3d2e9549d34a71dba9adc6608071', '721', NULL, '2', NULL, NULL, NULL, '1', '557', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2217', 'ed4e3d2e9549d34a71dba9adc6608071', '3295', NULL, '6', NULL, NULL, NULL, '1', '557', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2218', '48994805c85e74b75656c265c7ce0477', '2943', NULL, '10', NULL, NULL, NULL, '1', '558', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2219', 'dc485259597ee68e9d4558fcbb751803', '485', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2220', '0e64f4585aaa9c45a5bcf9332ac72fb1', '4891', NULL, '8', NULL, NULL, NULL, '1', '559', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2221', '0e64f4585aaa9c45a5bcf9332ac72fb1', '220', NULL, '1', NULL, NULL, NULL, '1', '559', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2222', 'cb687b842001db5939174bdbade0a7ef', '1283', NULL, '25', NULL, NULL, NULL, '1', '560', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2223', 'cb687b842001db5939174bdbade0a7ef', '1267', NULL, '20', NULL, NULL, NULL, '1', '560', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2224', 'cb687b842001db5939174bdbade0a7ef', '1797', NULL, '10', NULL, NULL, NULL, '1', '560', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2225', 'd49ee8bb0438c8de2a495c54bac7769a', '2311', NULL, '10', NULL, NULL, NULL, '1', '561', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2226', '077fa20dc6f78a38d1e9b8536af0aee2', '3030', NULL, '1', NULL, NULL, NULL, '1', '562', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2227', '077fa20dc6f78a38d1e9b8536af0aee2', '2937', NULL, '7', NULL, NULL, NULL, '1', '562', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2228', '077fa20dc6f78a38d1e9b8536af0aee2', '2946', NULL, '2', NULL, NULL, NULL, '1', '562', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2229', '077fa20dc6f78a38d1e9b8536af0aee2', '2943', NULL, '2', NULL, NULL, NULL, '1', '562', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2230', 'a2e2c4c2d93308d92be46fc11afc9795', '4579', NULL, '1', NULL, NULL, NULL, '1', '563', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2231', 'a2e2c4c2d93308d92be46fc11afc9795', '593', NULL, '1', NULL, NULL, NULL, '1', '563', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2232', 'ecc54c9494684cd4298af68e0aee7b0e', '918', NULL, '1', NULL, NULL, NULL, '1', '564', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2233', '5cfa46c9f9cb55807714fbf93eb49b35', '658', NULL, '17', NULL, NULL, NULL, '1', '565', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2234', '5cfa46c9f9cb55807714fbf93eb49b35', '2400', NULL, '13', NULL, NULL, NULL, '1', '565', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2235', '5cfa46c9f9cb55807714fbf93eb49b35', '2401', NULL, '10', NULL, NULL, NULL, '1', '565', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2236', '5cfa46c9f9cb55807714fbf93eb49b35', '1282', NULL, '5', NULL, NULL, NULL, '1', '565', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2237', '5cfa46c9f9cb55807714fbf93eb49b35', '1286', NULL, '1', NULL, NULL, NULL, '1', '565', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2238', 'ac8752d6538a65b8875db1191ad0271d', '3094', NULL, '1', NULL, NULL, NULL, '1', '566', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2239', 'ac8752d6538a65b8875db1191ad0271d', '1961', NULL, '1', NULL, NULL, NULL, '1', '567', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2240', '6763a1a454149fbd39ba5c63860ed8d3', '399', NULL, '1', NULL, NULL, NULL, '1', '568', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2241', 'b2088df5d35ff6e95b55522e76eab2e9', '2405', NULL, '16', NULL, NULL, NULL, '1', '569', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2242', 'b2088df5d35ff6e95b55522e76eab2e9', '2401', NULL, '9', NULL, NULL, NULL, '1', '569', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2243', 'ccfaffdd61d6fc5838cdecf81dac1f9c', '2400', NULL, '20', NULL, NULL, NULL, '1', '571', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2244', 'ccfaffdd61d6fc5838cdecf81dac1f9c', '2401', NULL, '20', NULL, NULL, NULL, '1', '571', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2245', 'ccfaffdd61d6fc5838cdecf81dac1f9c', '1282', NULL, '25', NULL, NULL, NULL, '1', '571', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2246', 'fe904dbea477959ff0682de995f9ee8a', '2874', NULL, '2', NULL, NULL, NULL, '1', '570', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2247', 'ccfaffdd61d6fc5838cdecf81dac1f9c', '1273', NULL, '50', NULL, NULL, NULL, '1', '571', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2249', '291712a7a83ae7cbb119144937a9b2b8', '3983', NULL, '120', NULL, NULL, NULL, '1', '572', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2250', '291712a7a83ae7cbb119144937a9b2b8', '4006', NULL, '25', NULL, NULL, NULL, '1', '572', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2251', '291712a7a83ae7cbb119144937a9b2b8', '4007', NULL, '25', NULL, NULL, NULL, '1', '572', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2253', '291712a7a83ae7cbb119144937a9b2b8', '4081', NULL, '2', NULL, NULL, NULL, '1', '572', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2254', '291712a7a83ae7cbb119144937a9b2b8', '4106', NULL, '2', NULL, NULL, NULL, '1', '572', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2256', '291712a7a83ae7cbb119144937a9b2b8', '4070', NULL, '10', NULL, NULL, NULL, '1', '572', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2258', 'ff121cdc0f54f03f2973a06d11002dcb', '2883', NULL, '1', NULL, NULL, NULL, '1', '573', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2259', 'ff121cdc0f54f03f2973a06d11002dcb', '1134', NULL, '2', NULL, NULL, NULL, '1', '573', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2260', '8cac00d86fd3fa429509427a1b23a833', '3553', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2261', '588433edb6600e491113f9460b6c7c9b', '810', NULL, '2', NULL, NULL, NULL, '1', '574', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2262', 'f845f7745bca3c75d9a7909c28778634', '114', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2263', '95d3926ecf016fa3e768488e551d559a', '658', NULL, '6', NULL, NULL, NULL, '1', '575', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2264', '95d3926ecf016fa3e768488e551d559a', '1797', NULL, '10', NULL, NULL, NULL, '1', '575', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2268', 'c77186bde6ba7c5d3e99b3f4a22eedcf', '4122', NULL, '1', NULL, NULL, NULL, '1', '576', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2269', 'c77186bde6ba7c5d3e99b3f4a22eedcf', '4123', NULL, '1', NULL, NULL, NULL, '1', '576', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2270', 'c77186bde6ba7c5d3e99b3f4a22eedcf', '4124', NULL, '1', NULL, NULL, NULL, '1', '576', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2271', 'c77186bde6ba7c5d3e99b3f4a22eedcf', '3093', NULL, '1', NULL, NULL, NULL, '1', '576', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2272', 'c77186bde6ba7c5d3e99b3f4a22eedcf', '990', NULL, '1', NULL, NULL, NULL, '1', '576', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2275', 'deb90e658fd645c5d72f3728bf223716', '1748', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2276', 'deb90e658fd645c5d72f3728bf223716', '1744', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2277', 'deb90e658fd645c5d72f3728bf223716', '1743', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2278', 'deb90e658fd645c5d72f3728bf223716', '1732', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2279', 'deb90e658fd645c5d72f3728bf223716', '1731', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2280', 'deb90e658fd645c5d72f3728bf223716', '924', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2282', 'deb90e658fd645c5d72f3728bf223716', '878', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2283', 'deb90e658fd645c5d72f3728bf223716', '1775', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2284', 'deb90e658fd645c5d72f3728bf223716', '1778', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2285', 'deb90e658fd645c5d72f3728bf223716', '1774', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2286', 'bc54bcb589d2489dda15d96ab9734370', '4774', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2287', '0ebb94b38b919e4d40bce8ef39ef320a', '1935', NULL, '1', NULL, NULL, NULL, '1', '577', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2288', 'a630f2d585efa01f4a236e568ab9bb8c', '405', NULL, '1', NULL, NULL, NULL, '1', '578', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2289', '29194d9275565f8b86918d293ccdab6a', '300', NULL, '1', NULL, NULL, NULL, '1', '580', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2290', '29194d9275565f8b86918d293ccdab6a', '3024', NULL, '2', NULL, NULL, NULL, '1', '580', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2291', '893c3402a9612b3ddd5beaaad307b418', '219', NULL, '1', NULL, NULL, NULL, '1', '581', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2292', '5e63e3760853aed7161eb6cc4a601472', '2650', NULL, '5', NULL, NULL, NULL, '1', '582', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2293', '5e63e3760853aed7161eb6cc4a601472', '2655', NULL, '10', NULL, NULL, NULL, '1', '582', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2294', '64e522c00482f643efc8d5cb9e2ec0ef', '135', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2295', '6d08098ae9efb30f807f6da77ad96db5', '1268', NULL, '5', NULL, NULL, NULL, '1', '583', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2296', '546eb34d1ed1b1569a479879e91c8ecd', '2599', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2297', 'e4206392279b741785a92e8db14048b0', '2785', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2298', '4638b0c1c5c313829362a3f022e3a608', '219', NULL, '1', NULL, NULL, NULL, '1', '584', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2299', 'd3283933cafc4f64b4d50a830a49dd8c', '2265', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2300', 'da118136fde726d71fdf1a26314e89f3', '1109', NULL, '1', NULL, NULL, NULL, '1', '585', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2301', '6f4c65ce3ce91477efa7c01b7acf6cea', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2302', 'da118136fde726d71fdf1a26314e89f3', '1109', NULL, '1', NULL, NULL, NULL, '1', '586', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2303', '47bd88761e852dcbbdf7554282b19712', '1921', NULL, '1', NULL, NULL, NULL, '1', '587', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2304', '47bd88761e852dcbbdf7554282b19712', '1345', NULL, '1', NULL, NULL, NULL, '1', '587', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2305', 'f73322a64f8f250bb3f0124907a749f4', '4210', NULL, '1', NULL, NULL, NULL, '1', '588', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2306', 'f73322a64f8f250bb3f0124907a749f4', '2931', NULL, '2', NULL, NULL, NULL, '1', '588', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2307', 'f73322a64f8f250bb3f0124907a749f4', '2937', NULL, '5', NULL, NULL, NULL, '1', '588', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2308', 'f73322a64f8f250bb3f0124907a749f4', '2938', NULL, '10', NULL, NULL, NULL, '1', '588', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2309', '1cc4437f846c9df7154ae102b53d0359', '280', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2311', 'a2c0bb46cb5b1b0256d2a913fdf08019', '2874', NULL, '1', NULL, NULL, NULL, '1', '589', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2312', 'ed39711833b053dd22b90fd43aa23973', '1282', NULL, '10', NULL, NULL, NULL, '1', '590', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2313', 'ed39711833b053dd22b90fd43aa23973', '1271', NULL, '20', NULL, NULL, NULL, '1', '590', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2314', '550cf2585585afcd133b42acf7591f08', '633', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2317', '525ff8dffb33623269e54c643cdf73a1', '4111', NULL, '2', NULL, NULL, NULL, '1', '591', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2318', '9aaf4d489cf2cec5fc58e4b933ba5925', '3096', NULL, '1', NULL, NULL, NULL, '1', '592', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2319', '2c4ab598e7bf1d257666bd68db30d66f', '2406', NULL, '30', NULL, NULL, NULL, '1', '593', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2320', '2c4ab598e7bf1d257666bd68db30d66f', '2416', NULL, '30', NULL, NULL, NULL, '1', '593', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2321', 'b4a872453d28e995f477db7bb12dc394', '219', NULL, '2', NULL, NULL, NULL, '1', '594', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2322', 'ac2ca5f9b46805ffc9f6826732d9da39', '659', NULL, '5', NULL, NULL, NULL, '1', '595', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2323', 'ac2ca5f9b46805ffc9f6826732d9da39', '719', NULL, '1', NULL, NULL, NULL, '1', '595', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2324', 'ac2ca5f9b46805ffc9f6826732d9da39', '1271', NULL, '30', NULL, NULL, NULL, '1', '595', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2325', 'ac2ca5f9b46805ffc9f6826732d9da39', '1272', NULL, '30', NULL, NULL, NULL, '1', '595', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2326', '8c759813287a8b751afafad1489edafb', '1275', NULL, '10', NULL, NULL, NULL, '1', '596', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2327', '8c759813287a8b751afafad1489edafb', '1267', NULL, '10', NULL, NULL, NULL, '1', '596', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2328', '1c40e1ec9f03b12f8a7080f9660669be', '35', NULL, '1', NULL, NULL, NULL, '1', '597', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2329', '1c40e1ec9f03b12f8a7080f9660669be', '4663', NULL, '1', NULL, NULL, NULL, '1', '597', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2330', '1c40e1ec9f03b12f8a7080f9660669be', '2600', NULL, '1', NULL, NULL, NULL, '1', '597', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2331', '1c40e1ec9f03b12f8a7080f9660669be', '2946', NULL, '5', NULL, NULL, NULL, '1', '597', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2332', '1c40e1ec9f03b12f8a7080f9660669be', '2944', NULL, '5', NULL, NULL, NULL, '1', '597', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2333', '1c40e1ec9f03b12f8a7080f9660669be', '2949', NULL, '5', NULL, NULL, NULL, '1', '597', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2334', '1c40e1ec9f03b12f8a7080f9660669be', '2937', NULL, '5', NULL, NULL, NULL, '1', '597', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2335', '1c40e1ec9f03b12f8a7080f9660669be', '809', NULL, '1', NULL, NULL, NULL, '1', '597', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2336', '79cc3eee1ad192c95001a25ba081c0f9', '1283', NULL, '10', NULL, NULL, NULL, '1', '598', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2337', '79cc3eee1ad192c95001a25ba081c0f9', '659', NULL, '5', NULL, NULL, NULL, '1', '598', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2338', '79cc3eee1ad192c95001a25ba081c0f9', '1273', NULL, '40', NULL, NULL, NULL, '1', '598', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2339', '381137debfd91756f24443d0304aebd5', '4591', NULL, '1', NULL, NULL, NULL, '1', '599', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2340', '3a1ca4540aa9b3f33cee87976be486ed', '3983', NULL, '15', NULL, NULL, NULL, '1', '600', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2341', '3a1ca4540aa9b3f33cee87976be486ed', '3984', NULL, '15', NULL, NULL, NULL, '1', '600', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2342', '3a1ca4540aa9b3f33cee87976be486ed', '4106', NULL, '1', NULL, NULL, NULL, '1', '600', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2343', '3a1ca4540aa9b3f33cee87976be486ed', '4160', NULL, '36', NULL, NULL, NULL, '1', '600', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2346', '91708121e68697b7870ae7f37bceec84', '40', NULL, '1', NULL, NULL, NULL, '1', '601', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2347', '91708121e68697b7870ae7f37bceec84', '49', NULL, '1', NULL, NULL, NULL, '1', '601', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2348', '91708121e68697b7870ae7f37bceec84', '712', NULL, '1', NULL, NULL, NULL, '1', '601', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2349', '91708121e68697b7870ae7f37bceec84', '658', NULL, '1', NULL, NULL, NULL, '1', '601', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2352', '9f8314cde73a98f3df9104f17250d498', '4909', NULL, '3', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2353', '9f8314cde73a98f3df9104f17250d498', '1268', NULL, '3', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2354', '9f8314cde73a98f3df9104f17250d498', '1282', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2355', '9f8314cde73a98f3df9104f17250d498', '1270', NULL, '10', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2356', 'fdc37acd54d83bae8aeb28fde7859957', '2407', NULL, '5', NULL, NULL, NULL, '1', '602', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2357', 'fdc37acd54d83bae8aeb28fde7859957', '2409', NULL, '5', NULL, NULL, NULL, '1', '602', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2358', 'fdc37acd54d83bae8aeb28fde7859957', '2410', NULL, '10', NULL, NULL, NULL, '1', '602', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2359', 'fdc37acd54d83bae8aeb28fde7859957', '2411', NULL, '10', NULL, NULL, NULL, '1', '602', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2360', 'e39e066367c8c55b8888d235db34fc88', '4340', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2361', 'd123bcb350c058d8166104b8f832838d', '2944', NULL, '6', NULL, NULL, NULL, '1', '603', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2362', 'fa2a8a179bcb7b974d2985b048502848', '2311', NULL, '10', NULL, NULL, NULL, '1', '605', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2363', 'fa2a8a179bcb7b974d2985b048502848', '2970', NULL, '10', NULL, NULL, NULL, '1', '605', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2364', 'fa2a8a179bcb7b974d2985b048502848', '2937', NULL, '5', NULL, NULL, NULL, '1', '605', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2365', 'fa2a8a179bcb7b974d2985b048502848', '2944', NULL, '10', NULL, NULL, NULL, '1', '605', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2366', '9eb026598bdfbc418ad72957fdf14f13', '2400', NULL, '20', NULL, NULL, NULL, '1', '604', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2367', '9eb026598bdfbc418ad72957fdf14f13', '2401', NULL, '20', NULL, NULL, NULL, '1', '604', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2368', 'fa2a8a179bcb7b974d2985b048502848', '1457', NULL, '1', NULL, NULL, NULL, '1', '605', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2369', 'fa2a8a179bcb7b974d2985b048502848', '1461', NULL, '2', NULL, NULL, NULL, '1', '605', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2370', '9a6432173e744a776456f3c35f30aeda', '3263', NULL, '20', NULL, NULL, NULL, '1', '606', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2371', '9a6432173e744a776456f3c35f30aeda', '1269', NULL, '10', NULL, NULL, NULL, '1', '606', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2372', '9a6432173e744a776456f3c35f30aeda', '1268', NULL, '3', NULL, NULL, NULL, '1', '606', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2373', '9a6432173e744a776456f3c35f30aeda', '1277', NULL, '10', NULL, NULL, NULL, '1', '606', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2374', '9a6432173e744a776456f3c35f30aeda', '1282', NULL, '2', NULL, NULL, NULL, '1', '606', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2375', '9a6432173e744a776456f3c35f30aeda', '1283', NULL, '1', NULL, NULL, NULL, '1', '606', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2376', '9a6432173e744a776456f3c35f30aeda', '1787', NULL, '20', NULL, NULL, NULL, '1', '606', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2377', '9f223ddd93bde0c25a2bd470f1554c22', '2409', NULL, '4', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2378', '9f223ddd93bde0c25a2bd470f1554c22', '1175', NULL, '5', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2379', '9f223ddd93bde0c25a2bd470f1554c22', '1173', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2380', '9f223ddd93bde0c25a2bd470f1554c22', '746', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2381', 'af39bf97c41e104979c15f2978510e4e', '5', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2382', '29f5f8bfa457f0ac5be8ea02ca44acbd', '2230', NULL, '1', NULL, NULL, NULL, '1', '607', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2383', '6dc0db23ce3e819498a1442dfcedc1da', '1907', NULL, '1', NULL, NULL, NULL, '1', '608', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2384', '6dc0db23ce3e819498a1442dfcedc1da', '2937', NULL, '10', NULL, NULL, NULL, '1', '608', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2385', '6dc0db23ce3e819498a1442dfcedc1da', '2734', NULL, '1', NULL, NULL, NULL, '1', '608', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2386', '6dc0db23ce3e819498a1442dfcedc1da', '2650', NULL, '10', NULL, NULL, NULL, '1', '608', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2387', '77686558953cee163744f9802bd7033c', '712', NULL, '1', NULL, NULL, NULL, '1', '609', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2388', '77686558953cee163744f9802bd7033c', '732', NULL, '1', NULL, NULL, NULL, '1', '609', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2389', '6f3a087c339faa0a12c448940e8b48ac', '2733', NULL, '1', NULL, NULL, NULL, '1', '610', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2390', '6f3a087c339faa0a12c448940e8b48ac', '1907', NULL, '1', NULL, NULL, NULL, '1', '610', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2391', '6f3a087c339faa0a12c448940e8b48ac', '384', NULL, '1', NULL, NULL, NULL, '1', '610', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2392', '6f3a087c339faa0a12c448940e8b48ac', '947', NULL, '1', NULL, NULL, NULL, '1', '610', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2393', '4ecce85297f5acd26e0ab479909e24df', '1517', NULL, '1', NULL, NULL, NULL, '1', '611', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2394', '4ecce85297f5acd26e0ab479909e24df', '1583', NULL, '1', NULL, NULL, NULL, '1', '611', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2395', '411382f7e2bca379370acc0f5443d20b', '4648', NULL, '2', NULL, NULL, NULL, '1', '612', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2396', '411382f7e2bca379370acc0f5443d20b', '2349', NULL, '4', NULL, NULL, NULL, '1', '612', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2397', '2b4f2a92bd9faaefa131ae0a8d391517', '1673', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2398', '952e83b0980d7b8e6a127cb2ad1a1319', '658', NULL, '2', NULL, NULL, NULL, '1', '613', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2399', '952e83b0980d7b8e6a127cb2ad1a1319', '660', NULL, '2', NULL, NULL, NULL, '1', '613', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2400', '952e83b0980d7b8e6a127cb2ad1a1319', '690', NULL, '1', NULL, NULL, NULL, '1', '613', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2401', '952e83b0980d7b8e6a127cb2ad1a1319', '919', NULL, '4', NULL, NULL, NULL, '1', '613', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2402', '952e83b0980d7b8e6a127cb2ad1a1319', '918', NULL, '1', NULL, NULL, NULL, '1', '613', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2403', 'f14b5b8e4d519ecfed969783be1d0b85', '1286', NULL, '30', NULL, NULL, NULL, '1', '614', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2404', 'f14b5b8e4d519ecfed969783be1d0b85', '4909', NULL, '30', NULL, NULL, NULL, '1', '614', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2405', 'f14b5b8e4d519ecfed969783be1d0b85', '1275', NULL, '15', NULL, NULL, NULL, '1', '614', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2406', '1fdc69357a80596b3177f238114ff782', '3060', NULL, '1', NULL, NULL, NULL, '1', '615', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2407', '5a0e8ed65d2e2ea910b09c28d34d1b2d', '38', NULL, '5', NULL, NULL, NULL, '1', '616', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2408', '5a0e8ed65d2e2ea910b09c28d34d1b2d', '47', NULL, '5', NULL, NULL, NULL, '1', '616', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2409', '5a0e8ed65d2e2ea910b09c28d34d1b2d', '4121', NULL, '1', NULL, NULL, NULL, '1', '617', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2410', '5a0e8ed65d2e2ea910b09c28d34d1b2d', '4124', NULL, '1', NULL, NULL, NULL, '1', '617', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2411', '611ac6bc25dd3e9e65fe37674b14bbd6', '740', NULL, '1', NULL, NULL, NULL, '1', '618', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2412', '611ac6bc25dd3e9e65fe37674b14bbd6', '691', NULL, '8', NULL, NULL, NULL, '1', '618', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2413', '611ac6bc25dd3e9e65fe37674b14bbd6', '760', NULL, '1', NULL, NULL, NULL, '1', '618', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2414', '611ac6bc25dd3e9e65fe37674b14bbd6', '711', NULL, '2', NULL, NULL, NULL, '1', '618', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2415', '611ac6bc25dd3e9e65fe37674b14bbd6', '731', NULL, '1', NULL, NULL, NULL, '1', '618', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2416', 'afd5583b897e71e324188ff35470f461', '3532', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2417', '2d57f94131bff2da58192cd2b972e19e', '1904', NULL, '1', NULL, NULL, NULL, '1', '619', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2418', '2d57f94131bff2da58192cd2b972e19e', '2736', NULL, '1', NULL, NULL, NULL, '1', '619', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2419', '2d57f94131bff2da58192cd2b972e19e', '344', NULL, '1', NULL, NULL, NULL, '1', '619', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2420', 'caf0c4b7d0893ebee2c5d9d37a753c03', '710', NULL, '1', NULL, NULL, NULL, '1', '620', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2421', 'caf0c4b7d0893ebee2c5d9d37a753c03', '1271', NULL, '1', NULL, NULL, NULL, '1', '620', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2422', 'bbf2d3f268cbe9e07c6fcd8b799db5ed', '1001', NULL, '1', NULL, NULL, NULL, '1', '621', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2423', 'bbf2d3f268cbe9e07c6fcd8b799db5ed', '2406', NULL, '4', NULL, NULL, NULL, '1', '621', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2424', 'bbf2d3f268cbe9e07c6fcd8b799db5ed', '2416', NULL, '4', NULL, NULL, NULL, '1', '621', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2425', 'bbf2d3f268cbe9e07c6fcd8b799db5ed', '38', NULL, '1', NULL, NULL, NULL, '1', '621', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2426', 'bbf2d3f268cbe9e07c6fcd8b799db5ed', '47', NULL, '1', NULL, NULL, NULL, '1', '621', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2427', '59e576d8eae1a91acd1bf5f751d8cb63', '2874', NULL, '2', NULL, NULL, NULL, '1', '622', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2428', 'e2f8a83718546299ee3d796e877b009a', '1785', NULL, '3', NULL, NULL, NULL, '1', '623', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2429', 'bcef91c6e717d3a43e2e556c0b774531', '4038', NULL, '24', NULL, NULL, NULL, '1', '624', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2430', 'bcef91c6e717d3a43e2e556c0b774531', '4039', NULL, '24', NULL, NULL, NULL, '1', '624', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2431', 'bcef91c6e717d3a43e2e556c0b774531', '4014', NULL, '24', NULL, NULL, NULL, '1', '624', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2432', 'bcef91c6e717d3a43e2e556c0b774531', '4015', NULL, '24', NULL, NULL, NULL, '1', '624', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2434', 'f4b74bc16e6365e7731378cfd295921e', '2514', NULL, '6', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2435', '0e0dbfabc3ea811ec20b68add3e841b6', '1727', NULL, '2', NULL, NULL, NULL, '1', '625', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2436', '0e0dbfabc3ea811ec20b68add3e841b6', '1725', NULL, '2', NULL, NULL, NULL, '1', '625', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2437', '0e0dbfabc3ea811ec20b68add3e841b6', '1723', NULL, '2', NULL, NULL, NULL, '1', '625', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2438', '0e0dbfabc3ea811ec20b68add3e841b6', '1797', NULL, '2', NULL, NULL, NULL, '1', '625', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2439', '0e0dbfabc3ea811ec20b68add3e841b6', '1794', NULL, '3', NULL, NULL, NULL, '1', '625', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2440', '0e0dbfabc3ea811ec20b68add3e841b6', '1994', NULL, '18', NULL, NULL, NULL, '1', '625', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2441', '46abd49fdc9ad32f795bd28b412fc4f1', '1935', NULL, '1', NULL, NULL, NULL, '1', '626', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2442', '46abd49fdc9ad32f795bd28b412fc4f1', '380', NULL, '1', NULL, NULL, NULL, '1', '626', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2443', '271193046030ed930251a7a5bef899df', '1801', NULL, '5', NULL, NULL, NULL, '1', '628', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2444', '271193046030ed930251a7a5bef899df', '1282', NULL, '3', NULL, NULL, NULL, '1', '628', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2446', '271193046030ed930251a7a5bef899df', '711', NULL, '2', NULL, NULL, NULL, '1', '628', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2447', '271193046030ed930251a7a5bef899df', '720', NULL, '2', NULL, NULL, NULL, '1', '628', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2448', '271193046030ed930251a7a5bef899df', '492', NULL, '30', NULL, NULL, NULL, '1', '628', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2449', 'ba81f2c7ea5a7cc48d3f67bfe03df78f', '4443', NULL, '5', NULL, NULL, NULL, '1', '627', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2450', 'ba81f2c7ea5a7cc48d3f67bfe03df78f', '2514', NULL, '6', NULL, NULL, NULL, '1', '627', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2451', 'b75bda3894119996380f478ebf27456b', '4591', NULL, '1', NULL, NULL, NULL, '1', '629', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2452', 'b75bda3894119996380f478ebf27456b', '2288', NULL, '2', NULL, NULL, NULL, '1', '629', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2453', '62fc4d1ea8ec1463440295ca3767c0c3', '328', NULL, '1', NULL, NULL, NULL, '1', '630', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2454', '62fc4d1ea8ec1463440295ca3767c0c3', '3930', NULL, '2', NULL, NULL, NULL, '1', '630', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2455', '62fc4d1ea8ec1463440295ca3767c0c3', '2634', NULL, '2', NULL, NULL, NULL, '1', '630', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2456', '62fc4d1ea8ec1463440295ca3767c0c3', '331', NULL, '1', NULL, NULL, NULL, '1', '630', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2457', '115465622ed0628efdbd3d91340bcee8', '4046', NULL, '50', NULL, NULL, NULL, '1', '631', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2458', '115465622ed0628efdbd3d91340bcee8', '4045', NULL, '50', NULL, NULL, NULL, '1', '631', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2459', 'ebc6519355e9ee3965d8a51240542853', '1275', NULL, '10', NULL, NULL, NULL, '1', '632', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2460', 'ebc6519355e9ee3965d8a51240542853', '1267', NULL, '20', NULL, NULL, NULL, '1', '632', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2462', 'e9beac09306778284ee00e8070b60182', '2944', NULL, '10', NULL, NULL, NULL, '1', '633', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2463', 'e9beac09306778284ee00e8070b60182', '2949', NULL, '3', NULL, NULL, NULL, '1', '633', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2464', 'e9beac09306778284ee00e8070b60182', '2943', NULL, '5', NULL, NULL, NULL, '1', '633', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2465', 'fabcb2e1e9d01478784e13a48fe0a7a9', '798', NULL, '1', NULL, NULL, NULL, '1', '634', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2466', 'fabcb2e1e9d01478784e13a48fe0a7a9', '809', NULL, '2', NULL, NULL, NULL, '1', '634', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2468', '0b62750ec8b2ca87e839fc52b2baeab4', '2372', NULL, '1', NULL, NULL, NULL, '1', '635', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2469', 'e72e6f2452e788e1a5d1fa70120ad6c2', '2416', NULL, '10', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2470', 'e72e6f2452e788e1a5d1fa70120ad6c2', '2406', NULL, '10', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2471', 'e72e6f2452e788e1a5d1fa70120ad6c2', '2417', NULL, '15', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2472', 'e72e6f2452e788e1a5d1fa70120ad6c2', '2407', NULL, '15', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2473', 'e72e6f2452e788e1a5d1fa70120ad6c2', '1136', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2474', 'e72e6f2452e788e1a5d1fa70120ad6c2', '798', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2475', 'e72e6f2452e788e1a5d1fa70120ad6c2', '258', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2476', '10196ad6485efb63f561a83d1caa952e', '884', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2477', '7422402fc53c0e45d9095cab3254538c', '2406', NULL, '10', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2478', '7422402fc53c0e45d9095cab3254538c', '2407', NULL, '15', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2479', '7422402fc53c0e45d9095cab3254538c', '2417', NULL, '15', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2480', '7422402fc53c0e45d9095cab3254538c', '2416', NULL, '10', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2481', '296b3a7e2958251046010781c9c20adb', '1452', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2482', '296b3a7e2958251046010781c9c20adb', '1453', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2483', '351279f851b32acde4324bddbca18a2e', '327', NULL, '3', NULL, NULL, NULL, '1', '636', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2484', '351279f851b32acde4324bddbca18a2e', '303', NULL, '4', NULL, NULL, NULL, '1', '636', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2485', '516b8e64efa06521fe75fd09f1189ef2', '2405', NULL, '5', NULL, NULL, NULL, '1', '637', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2487', '142dd2d84263cb900b23538b86c94ac3', '481', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2488', 'face3e4b5718d06ba3dfb879f6a6e229', '286', NULL, '1', NULL, NULL, NULL, '1', '638', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2489', '8e0bcb65122aa691e894820d41eaf6db', '4591', NULL, '2', NULL, NULL, NULL, '1', '639', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2490', 'b83094b9846f43e011767ed7953a8916', '4185', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2491', '064df7bd45b2075ff17b0cc681316bb4', '298', NULL, '1', NULL, NULL, NULL, '1', '640', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2492', '064df7bd45b2075ff17b0cc681316bb4', '286', NULL, '1', NULL, NULL, NULL, '1', '640', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2493', '064df7bd45b2075ff17b0cc681316bb4', '283', NULL, '1', NULL, NULL, NULL, '1', '640', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2494', '064df7bd45b2075ff17b0cc681316bb4', '281', NULL, '1', NULL, NULL, NULL, '1', '640', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2495', '8e0bcb65122aa691e894820d41eaf6db', '607', NULL, '5', NULL, NULL, NULL, '1', '641', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2497', 'c52904bee0118638aa64d3e8a6d7ec07', '2417', NULL, '1', NULL, NULL, NULL, '1', '642', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2498', 'c52904bee0118638aa64d3e8a6d7ec07', '2407', NULL, '1', NULL, NULL, NULL, '1', '642', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2499', '8f023cc0602996fa092baf6d93d63edf', '2409', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2500', '2e88d6576fdb71d5c6834d3c0ced4230', '2238', NULL, '1', NULL, NULL, NULL, '1', '643', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2501', 'c1f38620165d513ed05cf6d9e88ed93e', '4728', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2502', '72532c32875142bacb818ccb1d7384f1', '277', NULL, '1', NULL, NULL, NULL, '1', '644', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2503', '72532c32875142bacb818ccb1d7384f1', '658', NULL, '6', NULL, NULL, NULL, '1', '644', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2504', '0f96c0978414f8385dc5d004b3d7353c', '2956', NULL, '3', NULL, NULL, NULL, '1', '645', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2505', '0f96c0978414f8385dc5d004b3d7353c', '2949', NULL, '5', NULL, NULL, NULL, '1', '645', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2506', '757821e52d24c04b66a280e7fa5767ae', '34', NULL, '2', NULL, NULL, NULL, '1', '646', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2507', '757821e52d24c04b66a280e7fa5767ae', '32', NULL, '1', NULL, NULL, NULL, '1', '646', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2508', '928eb09fc1a3f0a124edf87868065702', '3096', NULL, '1', NULL, NULL, NULL, '1', '647', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2510', 'c6bc84a3d4426286370c9706439f8bff', '4925', NULL, '1', NULL, NULL, NULL, '1', '648', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2511', 'c6bc84a3d4426286370c9706439f8bff', '4593', NULL, '1', NULL, NULL, NULL, '1', '648', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2512', 'c6bc84a3d4426286370c9706439f8bff', '1907', NULL, '1', NULL, NULL, NULL, '1', '648', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2513', 'c6bc84a3d4426286370c9706439f8bff', '1904', NULL, '1', NULL, NULL, NULL, '1', '648', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2514', '41b9facd33416c0c0be8a11a2fe14178', '3001', NULL, '2', NULL, NULL, NULL, '1', '649', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2515', '41b9facd33416c0c0be8a11a2fe14178', '2406', NULL, '3', NULL, NULL, NULL, '1', '649', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2516', '41b9facd33416c0c0be8a11a2fe14178', '2416', NULL, '3', NULL, NULL, NULL, '1', '649', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2517', '41b9facd33416c0c0be8a11a2fe14178', '4037', NULL, '100', NULL, NULL, NULL, '1', '649', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2518', '41b9facd33416c0c0be8a11a2fe14178', '996', NULL, '1', NULL, NULL, NULL, '1', '649', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2519', '0deda03276111dc9d28e9af5c4e28a6d', '1915', NULL, '3', NULL, NULL, NULL, '1', '650', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2520', '0deda03276111dc9d28e9af5c4e28a6d', '337', NULL, '3', NULL, NULL, NULL, '1', '650', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2521', '0deda03276111dc9d28e9af5c4e28a6d', '1282', NULL, '1', NULL, NULL, NULL, '1', '650', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2522', '9626383936de72d6aeb5b8285aca0e08', '2312', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2523', '9626383936de72d6aeb5b8285aca0e08', '2314', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2524', 'd2923b02a6ad1d0ba05789541f4ea4fc', '4211', NULL, '50', NULL, NULL, NULL, '1', '651', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2525', 'd2923b02a6ad1d0ba05789541f4ea4fc', '4215', NULL, '50', NULL, NULL, NULL, '1', '651', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2526', 'd2923b02a6ad1d0ba05789541f4ea4fc', '2272', NULL, '1', NULL, NULL, NULL, '1', '651', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2527', '8e0bcb65122aa691e894820d41eaf6db', '1909', NULL, '1', NULL, NULL, NULL, '1', '652', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2528', '8e0bcb65122aa691e894820d41eaf6db', '2736', NULL, '2', NULL, NULL, NULL, '1', '652', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2529', 'bcd67e88cd39764dccf5b9c94fbaa230', '3097', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2530', '402b8d6d52105dbb70fafd80790a60a5', '5006', NULL, '5', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2531', '5565e1dfb3f1a71b9468ae80033b2625', '1271', NULL, '30', NULL, NULL, NULL, '1', '653', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2532', '5565e1dfb3f1a71b9468ae80033b2625', '1272', NULL, '30', NULL, NULL, NULL, '1', '653', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2533', '5565e1dfb3f1a71b9468ae80033b2625', '1270', NULL, '50', NULL, NULL, NULL, '1', '653', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2534', '0a7e35c8d6bfe9233a73ad7bd13db16e', '4732', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2535', 'bfff5d41d8385a763600bc817dc27bac', '4472', NULL, '1', NULL, NULL, NULL, '1', '654', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2536', 'bfff5d41d8385a763600bc817dc27bac', '4476', NULL, '1', NULL, NULL, NULL, '1', '654', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2537', 'bfff5d41d8385a763600bc817dc27bac', '4477', NULL, '1', NULL, NULL, NULL, '1', '654', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2538', 'c60f8fbc07e56e457ca44f456d6dec1f', '4584', NULL, '1', NULL, NULL, NULL, '1', '655', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2539', 'c60f8fbc07e56e457ca44f456d6dec1f', '3583', NULL, '1', NULL, NULL, NULL, '1', '655', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2540', '335ba3aacc6021c7e8bc815103bceb8a', '654', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2541', '9febdd6047317809de31aafd85dc6d4d', '4593', NULL, '1', NULL, NULL, NULL, '1', '657', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2542', '9febdd6047317809de31aafd85dc6d4d', '4592', NULL, '1', NULL, NULL, NULL, '1', '657', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2544', '0dcc503ad04bee91ebe1b2f7471682d6', '809', NULL, '1', NULL, NULL, NULL, '1', '656', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2545', '0dcc503ad04bee91ebe1b2f7471682d6', '810', NULL, '1', NULL, NULL, NULL, '1', '656', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2546', '917f5c41a3ad11dc223d50c1f5ff0e35', '5193', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2547', '917f5c41a3ad11dc223d50c1f5ff0e35', '2311', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2548', '917f5c41a3ad11dc223d50c1f5ff0e35', '3360', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2549', '6a5b1499c3f4e12b2188222629fbf5b8', '599', NULL, '1', NULL, NULL, NULL, '1', '658', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2550', '6a5b1499c3f4e12b2188222629fbf5b8', '2311', NULL, '1', NULL, NULL, NULL, '1', '658', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2551', '6a5b1499c3f4e12b2188222629fbf5b8', '5193', NULL, '1', NULL, NULL, NULL, '1', '658', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2552', '6a5b1499c3f4e12b2188222629fbf5b8', '3360', NULL, '1', NULL, NULL, NULL, '1', '658', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2553', 'f4c340ee08045c3961491fb0c1066192', '658', NULL, '5', NULL, NULL, NULL, '1', '659', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2554', 'f4c340ee08045c3961491fb0c1066192', '1275', NULL, '10', NULL, NULL, NULL, '1', '659', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2555', 'af9abd375c556c44c834ab81ca858c3e', '2516', NULL, '5', NULL, NULL, NULL, '1', '660', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2557', 'daa38f0d6a77b1eaa59e7c65e2c44c7f', '1450', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2558', '71ab00b767aff99a46c24c9205e3e363', '1275', NULL, '1', NULL, NULL, NULL, '1', '661', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2559', '71ab00b767aff99a46c24c9205e3e363', '1271', NULL, '1', NULL, NULL, NULL, '1', '661', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2560', '2a3a2ecceef020af98ddaebf1744e0c8', '2313', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2562', '591c2030fc7f9ea872d811960ad5eca2', '599', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2563', 'c91b405d334178ab8c6683b1aca3f3fc', '977', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2564', '74c54d1000a37fb2bb45e2ebf881568b', '710', NULL, '1', NULL, NULL, NULL, '1', '662', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2565', '74c54d1000a37fb2bb45e2ebf881568b', '1282', NULL, '30', NULL, NULL, NULL, '1', '662', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2566', '74c54d1000a37fb2bb45e2ebf881568b', '3263', NULL, '30', NULL, NULL, NULL, '1', '662', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2567', '74c54d1000a37fb2bb45e2ebf881568b', '1273', NULL, '30', NULL, NULL, NULL, '1', '662', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2568', '0a69d23a0de125c734f290bd954a6591', '2364', NULL, '5', NULL, NULL, NULL, '1', '663', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2569', '89e055feff1605416638355bb6b5ce96', '2836', NULL, '1', NULL, NULL, NULL, '1', '664', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2570', '89e055feff1605416638355bb6b5ce96', '4343', NULL, '1', NULL, NULL, NULL, '1', '664', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2571', '89e055feff1605416638355bb6b5ce96', '4342', NULL, '1', NULL, NULL, NULL, '1', '664', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2572', '89e055feff1605416638355bb6b5ce96', '4339', NULL, '1', NULL, NULL, NULL, '1', '664', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2573', '89e055feff1605416638355bb6b5ce96', '4338', NULL, '1', NULL, NULL, NULL, '1', '664', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2574', 'cff96c83a267a35863c5bef51ea59c7a', '5193', NULL, '22', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2575', '1474fe09c71bb7360c79723fcd9d1d0f', '982', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2576', '1036b9e6a743ba7c6330178934a93bec', '5193', NULL, '22', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2577', '76e3ed3b7f447e89ece8cac482a74453', '2699', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2578', '76e3ed3b7f447e89ece8cac482a74453', '2698', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2579', 'eb3b4fedc0c25aee66d90ef2b0f94eaf', '2400', NULL, '20', NULL, NULL, NULL, '1', '665', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2580', '484616c49fe6f84abbe7ee77887b814e', '719', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2581', '5a446330794e55581d7468253bbcfd9c', '5193', NULL, '22', NULL, NULL, NULL, '1', '666', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2585', 'e614c526b98cef44cff9e425afb0cb48', '2799', NULL, '2', NULL, NULL, NULL, '1', '667', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2586', 'e614c526b98cef44cff9e425afb0cb48', '2796', NULL, '1', NULL, NULL, NULL, '1', '667', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2587', 'e614c526b98cef44cff9e425afb0cb48', '2736', NULL, '1', NULL, NULL, NULL, '1', '667', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2588', '5b429ef4fbb2afa08d08db9cc18d405f', '4593', NULL, '1', NULL, NULL, NULL, '1', '668', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2589', '5b429ef4fbb2afa08d08db9cc18d405f', '3312', NULL, '1', NULL, NULL, NULL, '1', '668', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2590', '5b429ef4fbb2afa08d08db9cc18d405f', '4591', NULL, '1', NULL, NULL, NULL, '1', '668', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2592', '5b429ef4fbb2afa08d08db9cc18d405f', '1907', NULL, '1', NULL, NULL, NULL, '1', '668', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2593', '40b589adf601b8169fd34f0ad5b6ebed', '607', NULL, '5', NULL, NULL, NULL, '1', '669', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2594', '91a37ad51007523bd44a7f5c4b60a023', '1787', NULL, '60', NULL, NULL, NULL, '1', '670', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2595', 'd04867bd9bab9d393f79b1a974891cd1', '2206', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2596', '467a9647146da292bac63672219339f1', '484', NULL, '40', NULL, NULL, NULL, '1', '671', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2597', '467a9647146da292bac63672219339f1', '2630', NULL, '1', NULL, NULL, NULL, '1', '671', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2598', 'ab4c4def0444bab12f8cfde59170ff2e', '4912', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2599', '9322496d605c181640545ff64f5f68a6', '1801', NULL, '24', NULL, NULL, NULL, '1', '672', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2600', '9322496d605c181640545ff64f5f68a6', '1275', NULL, '5', NULL, NULL, NULL, '1', '672', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2601', '9322496d605c181640545ff64f5f68a6', '1268', NULL, '5', NULL, NULL, NULL, '1', '672', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2602', '1311efe73da03db5f31c25e8bfe78c1e', '1790', NULL, '40', NULL, NULL, NULL, '1', '673', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2603', '8e7c993cabbad4673af07ae227a22fff', '3335', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2605', '691940b5c6ffb1c89cda619182c70d3e', '3996', NULL, '300', NULL, NULL, NULL, '1', '674', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2606', '691940b5c6ffb1c89cda619182c70d3e', '3996', NULL, '30', NULL, NULL, NULL, '1', '675', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2607', '691940b5c6ffb1c89cda619182c70d3e', '3996', NULL, '30', NULL, NULL, NULL, '1', '676', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2608', '316de345e9fe33e3d7d03abded2ebcfb', '41', NULL, '15', NULL, NULL, NULL, '1', '677', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2609', '316de345e9fe33e3d7d03abded2ebcfb', '50', NULL, '5', NULL, NULL, NULL, '1', '677', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2610', '1e66ab81617cccb76887c53824cecbf2', '2979', NULL, '5', NULL, NULL, NULL, '1', '678', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2611', 'be202dc9dd0bf2278117c7aa1636911b', '1507', NULL, '1', NULL, NULL, NULL, '1', '679', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2612', 'be202dc9dd0bf2278117c7aa1636911b', '388', NULL, '2', NULL, NULL, NULL, '1', '679', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2613', 'be202dc9dd0bf2278117c7aa1636911b', '1279', NULL, '2', NULL, NULL, NULL, '1', '679', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2614', 'be202dc9dd0bf2278117c7aa1636911b', '1280', NULL, '2', NULL, NULL, NULL, '1', '679', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2615', '5f3b3f2f64c041fc81313ade4169a434', '4414', NULL, '3', NULL, NULL, NULL, '1', '680', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2619', '70d82047b025ec8a76fad0d0e68d709d', '710', NULL, '1', NULL, NULL, NULL, '1', '681', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2620', '70d82047b025ec8a76fad0d0e68d709d', '719', NULL, '1', NULL, NULL, NULL, '1', '681', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2621', '70d82047b025ec8a76fad0d0e68d709d', '658', NULL, '4', NULL, NULL, NULL, '1', '681', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2622', '70d82047b025ec8a76fad0d0e68d709d', '1267', NULL, '5', NULL, NULL, NULL, '1', '681', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2623', '70d82047b025ec8a76fad0d0e68d709d', '1275', NULL, '5', NULL, NULL, NULL, '1', '681', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2624', '60a2565860ad6b0de713e8e67ed2e58e', '3999', NULL, '5', NULL, NULL, NULL, '1', '682', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2625', '492524bfcb111a98371aec0fd44197f0', '3343', NULL, '50', NULL, NULL, NULL, '1', '683', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2626', '183699892ccd41bbc78ae90e1a17614e', '4524', NULL, '1', NULL, NULL, NULL, '1', '684', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2627', 'ae8e149ac96d73b3efab5708c3b6530b', '3067', NULL, '1', NULL, NULL, NULL, '1', '685', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2628', 'ae8e149ac96d73b3efab5708c3b6530b', '606', NULL, '8', NULL, NULL, NULL, '1', '685', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2629', 'ae8e149ac96d73b3efab5708c3b6530b', '4443', NULL, '6', NULL, NULL, NULL, '1', '685', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2630', 'ae8e149ac96d73b3efab5708c3b6530b', '4444', NULL, '6', NULL, NULL, NULL, '1', '685', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2632', 'da6d443b8d2dbb61291a63765b028f5e', '277', NULL, '1', NULL, NULL, NULL, '1', '686', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2634', 'a6f7bb6c36e04604cbcc6c5392cd993e', '4034', NULL, '4', NULL, NULL, NULL, '1', '687', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2635', 'eab882f9d6d214938ab4583c29c6289c', '660', NULL, '8', NULL, NULL, NULL, '1', '688', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2636', 'eab882f9d6d214938ab4583c29c6289c', '692', NULL, '3', NULL, NULL, NULL, '1', '688', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2637', 'eab882f9d6d214938ab4583c29c6289c', '1459', NULL, '1', NULL, NULL, NULL, '1', '689', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2638', '345f493d7a1b8fbe72926d02000c3260', '4001', NULL, '20', NULL, NULL, NULL, '1', '690', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2640', 'aeb829734c60d9b62806a8dba87ec020', '286', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2642', '6f9857d4b0d503e4fa69ec1c9b37b7cc', '388', NULL, '1', NULL, NULL, NULL, '1', '691', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2643', '6f9857d4b0d503e4fa69ec1c9b37b7cc', '399', NULL, '1', NULL, NULL, NULL, '1', '691', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2644', '47e3270740c274d43c57e7d24ee9a7cb', '720', NULL, '1', NULL, NULL, NULL, '1', '692', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2645', '94614b4d1903ca7e1526e1d945c8f92a', '1669', NULL, '1', NULL, NULL, NULL, '1', '693', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2646', '94614b4d1903ca7e1526e1d945c8f92a', '1934', NULL, '1', NULL, NULL, NULL, '1', '693', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2647', '94614b4d1903ca7e1526e1d945c8f92a', '2230', NULL, '1', NULL, NULL, NULL, '1', '693', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2648', '94614b4d1903ca7e1526e1d945c8f92a', '2364', NULL, '2', NULL, NULL, NULL, '1', '693', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2649', '94614b4d1903ca7e1526e1d945c8f92a', '281', NULL, '1', NULL, NULL, NULL, '1', '693', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2650', '94614b4d1903ca7e1526e1d945c8f92a', '285', NULL, '1', NULL, NULL, NULL, '1', '693', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2654', '8616998d729f8e2c483b19f4ba881652', '2489', NULL, '20', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2655', '8616998d729f8e2c483b19f4ba881652', '2490', NULL, '20', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2657', 'bdd5f829ee7acd22ddaeac8ad0e438c4', '2489', NULL, '20', NULL, NULL, NULL, '1', '694', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2658', 'bdd5f829ee7acd22ddaeac8ad0e438c4', '2490', NULL, '20', NULL, NULL, NULL, '1', '694', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2659', 'a023f890c18ec1806cd23adb4781f1e0', '692', NULL, '1', NULL, NULL, NULL, '1', '695', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2660', 'a023f890c18ec1806cd23adb4781f1e0', '2634', NULL, '4', NULL, NULL, NULL, '1', '695', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2661', 'd92bbc73dbd39547b973039df9621752', '4162', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2663', 'b711416b918927ea3d1ce008f97e14b4', '1046', NULL, '5', NULL, NULL, NULL, '1', '697', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2664', 'b711416b918927ea3d1ce008f97e14b4', '1063', NULL, '5', NULL, NULL, NULL, '1', '697', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2665', 'b711416b918927ea3d1ce008f97e14b4', '1064', NULL, '5', NULL, NULL, NULL, '1', '697', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2666', 'b711416b918927ea3d1ce008f97e14b4', '2484', NULL, '5', NULL, NULL, NULL, '1', '697', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2667', 'b711416b918927ea3d1ce008f97e14b4', '2485', NULL, '6', NULL, NULL, NULL, '1', '697', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2668', 'b711416b918927ea3d1ce008f97e14b4', '550', NULL, '3', NULL, NULL, NULL, '1', '697', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2669', 'b711416b918927ea3d1ce008f97e14b4', '1907', NULL, '1', NULL, NULL, NULL, '1', '698', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2670', '2ebcf766cf7d3925a9100d1e2fd92b9c', '2311', NULL, '6', NULL, NULL, NULL, '1', '699', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2671', '2ebcf766cf7d3925a9100d1e2fd92b9c', '1727', NULL, '1', NULL, NULL, NULL, '1', '699', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2672', '2ebcf766cf7d3925a9100d1e2fd92b9c', '1725', NULL, '1', NULL, NULL, NULL, '1', '699', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2673', '2ebcf766cf7d3925a9100d1e2fd92b9c', '1775', NULL, '1', NULL, NULL, NULL, '1', '699', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2674', '2ebcf766cf7d3925a9100d1e2fd92b9c', '1774', NULL, '1', NULL, NULL, NULL, '1', '699', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2675', '2ebcf766cf7d3925a9100d1e2fd92b9c', '2601', NULL, '6', NULL, NULL, NULL, '1', '699', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2678', '74f967a1d99524b8281c8ddcbc1328c7', '872', NULL, '2', NULL, NULL, NULL, '1', '700', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2679', '74f967a1d99524b8281c8ddcbc1328c7', '904', NULL, '3', NULL, NULL, NULL, '1', '700', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2680', '99ab3b1d9801a0530970d7ee5e19d156', '2406', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2681', '7f59aa4309eaf70359efe5e7aedb5fa1', '4036', NULL, '72', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2682', '2f9560d1e82f941b049ebf3c3961358a', '4036', NULL, '72', NULL, NULL, NULL, '1', '701', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2683', '3d66ea80d52e560d95e7f7d738d39c69', '3477', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2684', '3d66ea80d52e560d95e7f7d738d39c69', '62', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2685', '3d66ea80d52e560d95e7f7d738d39c69', '4915', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2686', '3d66ea80d52e560d95e7f7d738d39c69', '4914', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2687', '3cc989c80ab56873da93557dc8858d92', '660', NULL, '20', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2688', 'b0cd3b51aadf39b5ac24f25e456f5559', '721', NULL, '4', NULL, NULL, NULL, '1', '702', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2689', 'b0cd3b51aadf39b5ac24f25e456f5559', '662', NULL, '3', NULL, NULL, NULL, '1', '702', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2690', 'b0cd3b51aadf39b5ac24f25e456f5559', '660', NULL, '4', NULL, NULL, NULL, '1', '702', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2691', 'b0cd3b51aadf39b5ac24f25e456f5559', '671', NULL, '2', NULL, NULL, NULL, '1', '702', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2692', 'b0cd3b51aadf39b5ac24f25e456f5559', '2516', NULL, '15', NULL, NULL, NULL, '1', '702', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2694', 'cb01ec2baea0d68bea8c3dc95b350082', '297', NULL, '1', NULL, NULL, NULL, '1', '703', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2695', 'cb01ec2baea0d68bea8c3dc95b350082', '299', NULL, '1', NULL, NULL, NULL, '1', '703', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2696', 'c67502d61e17eb4f0170d2ae887d79f9', '1504', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2697', '6f095805c691f9ee5f8a9afcb3caaba5', '658', NULL, '3', NULL, NULL, NULL, '1', '704', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2698', '6f095805c691f9ee5f8a9afcb3caaba5', '732', NULL, '1', NULL, NULL, NULL, '1', '704', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2699', '6f095805c691f9ee5f8a9afcb3caaba5', '2415', NULL, '10', NULL, NULL, NULL, '1', '704', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2700', '6f095805c691f9ee5f8a9afcb3caaba5', '2405', NULL, '5', NULL, NULL, NULL, '1', '704', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2701', 'd987de222297ce143a23ad3a486a6ffa', '2880', NULL, '1', NULL, NULL, NULL, '1', '705', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2702', 'd987de222297ce143a23ad3a486a6ffa', '2602', NULL, '1', NULL, NULL, NULL, '1', '705', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2703', 'd987de222297ce143a23ad3a486a6ffa', '197', NULL, '1', NULL, NULL, NULL, '1', '707', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2704', '8105023e750cf5686c6cfcd84ba02f9e', '34', NULL, '1', NULL, NULL, NULL, '1', '708', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2705', '8105023e750cf5686c6cfcd84ba02f9e', '40', NULL, '4', NULL, NULL, NULL, '1', '708', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2706', '8105023e750cf5686c6cfcd84ba02f9e', '41', NULL, '3', NULL, NULL, NULL, '1', '708', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2707', '8105023e750cf5686c6cfcd84ba02f9e', '49', NULL, '4', NULL, NULL, NULL, '1', '708', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2708', '8105023e750cf5686c6cfcd84ba02f9e', '50', NULL, '3', NULL, NULL, NULL, '1', '708', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2709', '8c1b171078af6ae603b7f10738561571', '4811', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2710', 'c13d055d35cb8970ba52e960b0bade9a', '660', NULL, '30', NULL, NULL, NULL, '1', '709', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2711', '11d606cc785f255c96bcdfbe60ce8162', '4266', NULL, '2', NULL, NULL, NULL, '1', '710', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2712', '44c5f2ece733c8ee9a29d83d8b3bbf4f', '1459', NULL, '1', NULL, NULL, NULL, '1', '711', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2713', '44c5f2ece733c8ee9a29d83d8b3bbf4f', '41', NULL, '1', NULL, NULL, NULL, '1', '711', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2714', '44c5f2ece733c8ee9a29d83d8b3bbf4f', '50', NULL, '1', NULL, NULL, NULL, '1', '711', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2716', '44c5f2ece733c8ee9a29d83d8b3bbf4f', '4907', NULL, '1', NULL, NULL, NULL, '1', '711', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2717', '06c340b432cc9e8af1e48b7185748864', '660', NULL, '3', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2718', 'e1d1cecb73fb9cd4e32fc1a5c390e81b', '4247', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2719', 'e1d1cecb73fb9cd4e32fc1a5c390e81b', '4248', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2721', 'd987de222297ce143a23ad3a486a6ffa', '2415', NULL, '1', NULL, NULL, NULL, '1', '714', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2722', 'd987de222297ce143a23ad3a486a6ffa', '197', NULL, '1', NULL, NULL, NULL, '1', '714', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2723', 'd987de222297ce143a23ad3a486a6ffa', '2602', NULL, '1', NULL, NULL, NULL, '1', '714', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2724', 'a09c6ebad44c7dc818a154c08860d57a', '3983', NULL, '6', NULL, NULL, NULL, '1', '712', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2725', 'a09c6ebad44c7dc818a154c08860d57a', '4187', NULL, '4', NULL, NULL, NULL, '1', '712', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2726', 'dc49df22a19519a4f6b9d661c7436790', '2878', NULL, '2', NULL, NULL, NULL, '1', '713', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2727', 'dc49df22a19519a4f6b9d661c7436790', '2879', NULL, '2', NULL, NULL, NULL, '1', '713', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2728', 'dc49df22a19519a4f6b9d661c7436790', '2877', NULL, '2', NULL, NULL, NULL, '1', '713', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2729', '2305b1c591e46bb1441f7275c54cf810', '3922', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2730', 'd6cc5d0a81b2bf8f362feb40bdf2025c', '741', NULL, '5', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2731', 'aa96961c509b98b1bf3d9cac5352c756', '1866', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2732', 'aa96961c509b98b1bf3d9cac5352c756', '1865', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2733', 'd3fda62aef3401dd814e8d73bfef9ef8', '741', NULL, '1', NULL, NULL, NULL, '1', '716', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2734', 'd3fda62aef3401dd814e8d73bfef9ef8', '732', NULL, '1', NULL, NULL, NULL, '1', '716', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2735', 'd3fda62aef3401dd814e8d73bfef9ef8', '732', NULL, '27', NULL, NULL, NULL, '1', '717', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2736', 'd3fda62aef3401dd814e8d73bfef9ef8', '741', NULL, '4', NULL, NULL, NULL, '1', '717', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2739', 'a737a3bfbaf6a8fe05dc9af1dcc52f92', '1487', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2742', 'b515188b24d6ac50069c7820602ae5b6', '658', NULL, '4', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2743', 'd987de222297ce143a23ad3a486a6ffa', '2874', NULL, '1', NULL, NULL, NULL, '1', '718', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2748', 'f96753aed21559f293ae1faf95d4aa6c', '1027', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2749', '9f77d7bcc47a684de48c983c791b5663', '40', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2750', '9f77d7bcc47a684de48c983c791b5663', '49', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2751', '743fe6be1219889bde49021c3a282b3e', '2602', NULL, '3', NULL, NULL, NULL, '1', '719', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2752', 'ac16d9906485788ca358df82c33aa9e9', '2588', NULL, '10', NULL, NULL, NULL, '1', '720', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2753', '743fe6be1219889bde49021c3a282b3e', '2313', NULL, '2', NULL, NULL, NULL, '1', '721', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2754', '743fe6be1219889bde49021c3a282b3e', '3984', NULL, '60', NULL, NULL, NULL, '1', '721', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2755', '743fe6be1219889bde49021c3a282b3e', '4338', NULL, '30', NULL, NULL, NULL, '1', '721', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2756', '743fe6be1219889bde49021c3a282b3e', '4339', NULL, '30', NULL, NULL, NULL, '1', '721', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2759', '9891c97ba50e0accae03ddb5dab8dce9', '571', NULL, '1', NULL, NULL, NULL, '1', '722', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2760', '3917fdb8d42860882003901e718c82b4', '1140', NULL, '2', NULL, NULL, NULL, '1', '723', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2761', '3917fdb8d42860882003901e718c82b4', '292', NULL, '1', NULL, NULL, NULL, '1', '723', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2762', '0c4964b4c1a6510006476bb84378de4e', '3994', NULL, '10', NULL, NULL, NULL, '1', '724', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2763', 'd987de222297ce143a23ad3a486a6ffa', '732', NULL, '1', NULL, NULL, NULL, '1', '725', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2764', 'd987de222297ce143a23ad3a486a6ffa', '2736', NULL, '1', NULL, NULL, NULL, '1', '725', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2765', 'abe770ba57fba18697837bc898d2532c', '977', NULL, '1', NULL, NULL, NULL, '1', '727', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2766', '6a52c023a7583e7c4fcb69e2abd5f574', '1444', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2767', 'd93bd0c1d9fde9ebacb01a7e19054878', '4320', NULL, '5', NULL, NULL, NULL, '1', '728', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2768', 'd93bd0c1d9fde9ebacb01a7e19054878', '2588', NULL, '10', NULL, NULL, NULL, '1', '729', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2769', '9b1f1b98a094ef3ee01163aee251d54f', '3015', NULL, '2', NULL, NULL, NULL, '1', '730', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2770', '9b1f1b98a094ef3ee01163aee251d54f', '2999', NULL, '2', NULL, NULL, NULL, '1', '730', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2771', '9b1f1b98a094ef3ee01163aee251d54f', '2945', NULL, '3', NULL, NULL, NULL, '1', '730', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2772', '9b1f1b98a094ef3ee01163aee251d54f', '2944', NULL, '3', NULL, NULL, NULL, '1', '730', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2773', '9b1f1b98a094ef3ee01163aee251d54f', '2932', NULL, '5', NULL, NULL, NULL, '1', '730', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2774', '9b1f1b98a094ef3ee01163aee251d54f', '2933', NULL, '5', NULL, NULL, NULL, '1', '730', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2775', '6a7264936ee4f2ad83589944eb07f745', '658', NULL, '5', NULL, NULL, NULL, '1', '731', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2776', '3220f91740f8233b47caa8fed27fd892', '320', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2777', '281f9ec4e237c7472b4f37c5a554ce87', '571', NULL, '1', NULL, NULL, NULL, '1', '732', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2778', '063617315bffa1ba7814e41c6a2fe9b6', '410', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2779', '6f6d4c8384321c34c92879f13bfb70e4', '4477', NULL, '2', NULL, NULL, NULL, '1', '733', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2780', '6f6d4c8384321c34c92879f13bfb70e4', '4475', NULL, '2', NULL, NULL, NULL, '1', '733', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2781', '36a66669e8bec71f5154f517ea84a379', '660', NULL, '10', NULL, NULL, NULL, '1', '734', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2782', '36a66669e8bec71f5154f517ea84a379', '850', NULL, '2', NULL, NULL, NULL, '1', '734', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2784', '946de5cc721ad3864b47ec45159eae28', '2956', NULL, '10', NULL, NULL, NULL, '1', '735', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2785', '974995f24154f32d146bdc9bc63f932f', '810', NULL, '3', NULL, NULL, NULL, '1', '736', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2786', 'd987de222297ce143a23ad3a486a6ffa', '4592', NULL, '1', NULL, NULL, NULL, '1', '737', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2788', '107e05b8a27ccc65b12555efdb013839', '1902', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2789', '1dd82e76bac248e650b59f71edc6abce', '4591', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2790', '1dd82e76bac248e650b59f71edc6abce', '4416', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2791', 'bfb04d0427a3bbe6ea9eed95cc3e1cc1', '1893', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2793', '97956aa7e6cd65794801ffd87310fa01', '721', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2794', '211ecb7bdfe30cc4eccc45e47e3b8b34', '5229', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2795', '1b06da0b0910b96ad8d4932d9d94dfd6', '1459', NULL, '1', NULL, NULL, NULL, '1', '738', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2796', 'ceeb7fd7c71899be3be5a4c6df124bc3', '1923', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2797', '2146e2e26784f29405d834b261d1966f', '4591', NULL, '1', NULL, NULL, NULL, '1', '739', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2798', '2146e2e26784f29405d834b261d1966f', '571', NULL, '1', NULL, NULL, NULL, '1', '739', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2799', '2146e2e26784f29405d834b261d1966f', '4416', NULL, '1', NULL, NULL, NULL, '1', '739', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2800', '2146e2e26784f29405d834b261d1966f', '2291', NULL, '1', NULL, NULL, NULL, '1', '739', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2801', '2146e2e26784f29405d834b261d1966f', '1785', NULL, '2', NULL, NULL, NULL, '1', '739', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2802', '7086f95c64faeb8dc7adc725afb74dd8', '1267', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2804', 'cdf1521d9db416ee4c39013ebbe1d2b0', '4015', NULL, '60', NULL, NULL, NULL, '1', '740', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2805', 'cdf1521d9db416ee4c39013ebbe1d2b0', '4331', NULL, '48', NULL, NULL, NULL, '1', '740', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2806', 'cdf1521d9db416ee4c39013ebbe1d2b0', '4332', NULL, '12', NULL, NULL, NULL, '1', '740', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2807', 'cdf1521d9db416ee4c39013ebbe1d2b0', '4345', NULL, '10', NULL, NULL, NULL, '1', '740', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2808', '25462bc0b904e06b11e2b228d9578273', '4252', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2809', '331767ebbd340422e0db686c849a67c4', '1141', NULL, '2', NULL, NULL, NULL, '1', '741', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2812', '331767ebbd340422e0db686c849a67c4', '1000', NULL, '1', NULL, NULL, NULL, '1', '742', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2813', '12ed1f089c99af3a39de4c5579ccbd3d', '1935', NULL, '1', NULL, NULL, NULL, '1', '743', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2814', '12ed1f089c99af3a39de4c5579ccbd3d', '2999', NULL, '2', NULL, NULL, NULL, '1', '743', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2815', '12ed1f089c99af3a39de4c5579ccbd3d', '2980', NULL, '2', NULL, NULL, NULL, '1', '743', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2816', '12ed1f089c99af3a39de4c5579ccbd3d', '3294', NULL, '5', NULL, NULL, NULL, '1', '743', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2817', '12ed1f089c99af3a39de4c5579ccbd3d', '2946', NULL, '5', NULL, NULL, NULL, '1', '743', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2818', '12ed1f089c99af3a39de4c5579ccbd3d', '2949', NULL, '2', NULL, NULL, NULL, '1', '743', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2819', '12ed1f089c99af3a39de4c5579ccbd3d', '2938', NULL, '2', NULL, NULL, NULL, '1', '743', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2820', '12ed1f089c99af3a39de4c5579ccbd3d', '2937', NULL, '10', NULL, NULL, NULL, '1', '743', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2821', 'c3fbdbddf7800171c78a3261800fdcef', '607', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2822', '01676886e48df04ac72b018465fea1a5', '4742', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2823', '4d3681dfedca47b7eb13725fda1d2559', '2314', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2824', 'd2479751c8991fadc9a1cbc4fdfb9d73', '2640', NULL, '6', NULL, NULL, NULL, '1', '744', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2825', '61c314fb68ee9b032c25fb4aa6e8aba7', '1909', NULL, '2', NULL, NULL, NULL, '1', '745', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2826', '61c314fb68ee9b032c25fb4aa6e8aba7', '2736', NULL, '2', NULL, NULL, NULL, '1', '745', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2827', '0bc44e3d0fd249ebcedebc950f145918', '2400', NULL, '10', NULL, NULL, NULL, '1', '746', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2828', '0bc44e3d0fd249ebcedebc950f145918', '2401', NULL, '10', NULL, NULL, NULL, '1', '746', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2829', '0bc44e3d0fd249ebcedebc950f145918', '2401', NULL, '10', NULL, NULL, NULL, '1', '747', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2830', '2f5ba061e18657303af893e66e592d24', '809', NULL, '3', NULL, NULL, NULL, '1', '748', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2831', 'd84935c1f5ee8892e228aaf19894f6c9', '5205', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2832', 'a8ee9d46f2eda30916c3faff77f32cb5', '4100', NULL, '1', NULL, NULL, NULL, '1', '749', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2833', '74b80caf1c49b9f06670df14e439dda1', '674', NULL, '20', NULL, NULL, NULL, '1', '750', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2834', 'dacc93ffae7a647c9135f7835140f46d', '1811', NULL, '1', NULL, NULL, NULL, '1', '751', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2835', '932d1fb0d7d2ccb8b776d6bac0dc673f', '797', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2836', 'dacc93ffae7a647c9135f7835140f46d', '2289', NULL, '3', NULL, NULL, NULL, '1', '751', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2837', '169ffc372c2591ea1ccc1aeaa178e2f3', '300', NULL, '10', NULL, NULL, NULL, '1', '752', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2838', '169ffc372c2591ea1ccc1aeaa178e2f3', '2733', NULL, '3', NULL, NULL, NULL, '1', '752', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2839', '169ffc372c2591ea1ccc1aeaa178e2f3', '4477', NULL, '3', NULL, NULL, NULL, '1', '752', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2840', '169ffc372c2591ea1ccc1aeaa178e2f3', '4475', NULL, '4', NULL, NULL, NULL, '1', '752', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2841', '169ffc372c2591ea1ccc1aeaa178e2f3', '4509', NULL, '1', NULL, NULL, NULL, '1', '752', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2842', '23205167be6f1a7b388fa2124eac46c6', '399', NULL, '1', NULL, NULL, NULL, '1', '753', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2843', '014d4643cd6b69476aa86ac5f9564ae8', '9', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2844', '014d4643cd6b69476aa86ac5f9564ae8', '1353', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2845', '014d4643cd6b69476aa86ac5f9564ae8', '3919', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2846', '014d4643cd6b69476aa86ac5f9564ae8', '478', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2847', '1ef5fd7f4bc079db7e918a71ef93396a', '606', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2848', '1ef5fd7f4bc079db7e918a71ef93396a', '607', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2849', '1ef5fd7f4bc079db7e918a71ef93396a', '614', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2850', '1ef5fd7f4bc079db7e918a71ef93396a', '4443', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2851', '39c7931f1818be39ae49494522edf579', '40', NULL, '2', NULL, NULL, NULL, '1', '754', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2852', '39c7931f1818be39ae49494522edf579', '49', NULL, '2', NULL, NULL, NULL, '1', '754', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2853', '61c314fb68ee9b032c25fb4aa6e8aba7', '2468', NULL, '3', NULL, NULL, NULL, '1', '755', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2854', 'b35f87c936db43dbf0d3c22a91ef2aa4', '4509', NULL, '1', NULL, NULL, NULL, '1', '756', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2855', 'b35f87c936db43dbf0d3c22a91ef2aa4', '300', NULL, '10', NULL, NULL, NULL, '1', '756', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2856', 'd489d5210b4d0c656285a82fb66cc46a', '5008', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2857', 'bd50861e55421f088384083c9c2da616', '38', NULL, '1', NULL, NULL, NULL, '1', '757', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2858', 'bd50861e55421f088384083c9c2da616', '40', NULL, '1', NULL, NULL, NULL, '1', '757', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2859', 'bd50861e55421f088384083c9c2da616', '41', NULL, '1', NULL, NULL, NULL, '1', '757', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2860', 'bd50861e55421f088384083c9c2da616', '47', NULL, '1', NULL, NULL, NULL, '1', '757', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2861', 'bd50861e55421f088384083c9c2da616', '49', NULL, '1', NULL, NULL, NULL, '1', '757', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2862', 'bd50861e55421f088384083c9c2da616', '50', NULL, '1', NULL, NULL, NULL, '1', '757', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2863', 'bd50861e55421f088384083c9c2da616', '2937', NULL, '5', NULL, NULL, NULL, '1', '757', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2864', 'bd50861e55421f088384083c9c2da616', '2944', NULL, '5', NULL, NULL, NULL, '1', '757', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2865', 'bd50861e55421f088384083c9c2da616', '4593', NULL, '1', NULL, NULL, NULL, '1', '757', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2866', '4e954bc96e5a9738f81247d3b17d696e', '982', NULL, '1', NULL, NULL, NULL, '1', '759', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2867', '61c314fb68ee9b032c25fb4aa6e8aba7', '1059', NULL, '1', NULL, NULL, NULL, '1', '758', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2868', '61c314fb68ee9b032c25fb4aa6e8aba7', '1060', NULL, '1', NULL, NULL, NULL, '1', '758', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2869', '61c314fb68ee9b032c25fb4aa6e8aba7', '1159', NULL, '1', NULL, NULL, NULL, '1', '758', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2870', '61c314fb68ee9b032c25fb4aa6e8aba7', '1160', NULL, '1', NULL, NULL, NULL, '1', '758', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2871', 'dc00478f8779d91ec3869cb50f26ec20', '3920', NULL, '1', NULL, NULL, NULL, '1', '760', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2872', 'dc00478f8779d91ec3869cb50f26ec20', '1356', NULL, '1', NULL, NULL, NULL, '1', '760', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2873', '66167bd23e9fd6f721b23aa346a6a32d', '3312', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2874', '66167bd23e9fd6f721b23aa346a6a32d', '4593', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2875', '66167bd23e9fd6f721b23aa346a6a32d', '4592', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2876', '662fef64b70e28fea44f168ed394dbf8', '1283', NULL, '10', NULL, NULL, NULL, '1', '761', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2877', '13b54047a6d1ba1abe34013374ce6326', '3999', NULL, '2', NULL, NULL, NULL, '1', '762', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2878', 'd00e2db29b5e01dff2c1393f3084609f', '2646', NULL, '4', NULL, NULL, NULL, '1', '763', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2879', 'c945aa4e33ca29e58694cfa327a2c2fc', '4279', NULL, '1', NULL, NULL, NULL, '1', '764', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2880', 'c945aa4e33ca29e58694cfa327a2c2fc', '4277', NULL, '1', NULL, NULL, NULL, '1', '764', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2881', 'c945aa4e33ca29e58694cfa327a2c2fc', '4051', NULL, '2', NULL, NULL, NULL, '1', '764', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2882', 'de1e7f4b903ff3c13008cee83d2ae4b0', '6', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2883', 'de1e7f4b903ff3c13008cee83d2ae4b0', '4902', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2884', 'de1e7f4b903ff3c13008cee83d2ae4b0', '37', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2885', '9caa179dfe26a4175924006f3d080d16', '260', NULL, '1', NULL, NULL, NULL, '1', '765', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2886', '9caa179dfe26a4175924006f3d080d16', '571', NULL, '1', NULL, NULL, NULL, '1', '765', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2887', 'aa7b94d5e66521a48120d46815677727', '2931', NULL, '10', NULL, NULL, NULL, '1', '766', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2888', '1e9dcbaa2d366791843c4509c3bf8d57', '1904', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2889', '1e9dcbaa2d366791843c4509c3bf8d57', '3312', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2890', '1e9dcbaa2d366791843c4509c3bf8d57', '4593', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2891', '1e9dcbaa2d366791843c4509c3bf8d57', '4592', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2892', '7a17f1f5b73ee1b4af700ccc7e3b0939', '4038', NULL, '15', NULL, NULL, NULL, '1', '767', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2893', '7a17f1f5b73ee1b4af700ccc7e3b0939', '4040', NULL, '10', NULL, NULL, NULL, '1', '767', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2894', '7ac4141ef1a4cb854e3967345f21d9c9', '4038', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2895', '7ac4141ef1a4cb854e3967345f21d9c9', '4039', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2896', '7ac4141ef1a4cb854e3967345f21d9c9', '4040', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2897', '8b75500765501dc1bbef1897eec7de7d', '730', NULL, '1', NULL, NULL, NULL, '1', '768', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2898', '3b3d94c822f3a61f7b8b85a71a1aed64', '2407', NULL, '10', NULL, NULL, NULL, '1', '769', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2899', '7cceea85872045df749bba2b3188963e', '4888', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2900', '7995ca473e56e2d0b06e507c4e4dd13e', '954', NULL, '2', NULL, NULL, NULL, '1', '770', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2901', '3b3d94c822f3a61f7b8b85a71a1aed64', '380', NULL, '1', NULL, NULL, NULL, '1', '771', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2902', '463e87495ac77bd6cae6cf19eaebeed7', '2901', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2903', 'd92d169037ced3d109ad3adcede4e5d6', '658', NULL, '5', NULL, NULL, NULL, '1', '772', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2904', '24bdaf6edbdc50b4237718e616407030', '1327', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2907', '5e7c88547b286e7f38254bf16c10ce3e', '294', NULL, '1', NULL, NULL, NULL, '1', '773', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2908', 'e3816db400902d8a4c349eefd3a66d46', '4727', NULL, '5', NULL, NULL, NULL, '1', '774', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2909', 'e3816db400902d8a4c349eefd3a66d46', '2637', NULL, '3', NULL, NULL, NULL, '1', '774', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2910', '734f63874da8c317033b8f2b75993977', '2726', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2911', '39639f4fbcdd1ec88495a17dccee6875', '2836', NULL, '1', NULL, NULL, NULL, '1', '775', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2912', 'd00e2db29b5e01dff2c1393f3084609f', '4401', NULL, '1', NULL, NULL, NULL, '1', '776', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2913', '251fc38bbfae044f791c556483cad45f', '2534', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2914', 'fd622bc277719db8c065cc899392ad65', '4218', NULL, '60', NULL, NULL, NULL, '1', '777', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2915', '081c3970b659253f13e7034cd3b3da5f', '3967', NULL, '1', NULL, NULL, NULL, '1', '778', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2916', '3b3d94c822f3a61f7b8b85a71a1aed64', '2736', NULL, '1', NULL, NULL, NULL, '1', '779', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2917', 'c37b4c79a92b8151b40f9338938b97d3', '658', NULL, '5', NULL, NULL, NULL, '1', '780', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2918', 'c5b637080935bed4cf92cfa4492a7208', '4013', NULL, '100', NULL, NULL, NULL, '1', '781', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2919', 'c5b637080935bed4cf92cfa4492a7208', '4012', NULL, '200', NULL, NULL, NULL, '1', '781', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2920', 'c5b637080935bed4cf92cfa4492a7208', '4011', NULL, '200', NULL, NULL, NULL, '1', '781', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2921', 'f80a60bf03b0fa9749baec4e0cd1bd68', '2406', NULL, '5', NULL, NULL, NULL, '1', '782', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2922', 'f80a60bf03b0fa9749baec4e0cd1bd68', '2407', NULL, '5', NULL, NULL, NULL, '1', '782', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2923', 'f80a60bf03b0fa9749baec4e0cd1bd68', '2416', NULL, '5', NULL, NULL, NULL, '1', '782', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2924', 'f80a60bf03b0fa9749baec4e0cd1bd68', '2417', NULL, '5', NULL, NULL, NULL, '1', '782', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2925', '196dddf5a529d237c1296beb46bbec2b', '1271', NULL, '30', NULL, NULL, NULL, '1', '783', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2926', '196dddf5a529d237c1296beb46bbec2b', '1272', NULL, '30', NULL, NULL, NULL, '1', '783', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2927', '196dddf5a529d237c1296beb46bbec2b', '1273', NULL, '30', NULL, NULL, NULL, '1', '783', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2928', '4c0834038f909542b4e55bcac4a97d6d', '2938', NULL, '10', NULL, NULL, NULL, '1', '784', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2929', '8434d1d197872bce87d70eee54e3e514', '5095', NULL, '1', NULL, NULL, NULL, '1', '785', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2930', '4c0834038f909542b4e55bcac4a97d6d', '4029', NULL, '2', NULL, NULL, NULL, '1', '786', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2931', '4c0834038f909542b4e55bcac4a97d6d', '4030', NULL, '2', NULL, NULL, NULL, '1', '786', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2932', 'e751392924e6f6182d866d9e965ba469', '2874', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2933', '1859a3cef1a769df28be16cc90861a2b', '1268', NULL, '3', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2934', '1859a3cef1a769df28be16cc90861a2b', '4593', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2935', '1859a3cef1a769df28be16cc90861a2b', '2736', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2936', '1859a3cef1a769df28be16cc90861a2b', '2735', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2937', '1859a3cef1a769df28be16cc90861a2b', '1909', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2938', '1859a3cef1a769df28be16cc90861a2b', '3312', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2939', 'badd97e486ed6455c3c0db086caafbe8', '2406', NULL, '10', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2941', 'd5e1697b6ddcdd1d7edef8e5d73c1355', '4516', NULL, '2', NULL, NULL, NULL, '1', '787', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2942', '3b3d94c822f3a61f7b8b85a71a1aed64', '4433', NULL, '1', NULL, NULL, NULL, '1', '788', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2943', 'b77a288a4b9fd84a980e5b8d14dbd040', '5010', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2944', '3b9fd4643f785ccd3d4e54e0fdda46fe', '661', NULL, '5', NULL, NULL, NULL, '1', '789', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2945', 'd3231d521b2fe53bd46eb3198f39186e', '3583', NULL, '1', NULL, NULL, NULL, '1', '790', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2946', '3b3d94c822f3a61f7b8b85a71a1aed64', '1347', NULL, '1', NULL, NULL, NULL, '1', '791', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2947', '7f61ba7f92dabedf3f205292ca61f5a4', '2409', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2949', '3b3d94c822f3a61f7b8b85a71a1aed64', '1935', NULL, '1', NULL, NULL, NULL, '1', '792', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2950', 'e8bebb18100eb0dadc924ec45ed63a56', '40', NULL, '2', NULL, NULL, NULL, '1', '793', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2951', 'e8bebb18100eb0dadc924ec45ed63a56', '49', NULL, '2', NULL, NULL, NULL, '1', '793', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2952', 'e8bebb18100eb0dadc924ec45ed63a56', '2944', NULL, '20', NULL, NULL, NULL, '1', '793', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2953', 'e8bebb18100eb0dadc924ec45ed63a56', '2607', NULL, '1', NULL, NULL, NULL, '1', '793', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2954', 'e8bebb18100eb0dadc924ec45ed63a56', '4039', NULL, '3', NULL, NULL, NULL, '1', '793', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2956', '7c7e32ec3774757542ab426cc6de2a7f', '810', NULL, '1', NULL, NULL, NULL, '1', '794', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2957', '7c7e32ec3774757542ab426cc6de2a7f', '658', NULL, '5', NULL, NULL, NULL, '1', '795', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2958', 'cd7bb12b75c00eb052a585c0da150d5d', '540', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2959', '3b3d94c822f3a61f7b8b85a71a1aed64', '1452', NULL, '1', NULL, NULL, NULL, '1', '796', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2960', '82adcc59e00dbe7231cacddb7802f3e3', '33', NULL, '1', NULL, NULL, NULL, '1', '797', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2961', '82adcc59e00dbe7231cacddb7802f3e3', '34', NULL, '1', NULL, NULL, NULL, '1', '797', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2962', '82adcc59e00dbe7231cacddb7802f3e3', '1000', NULL, '1', NULL, NULL, NULL, '1', '797', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2964', '3b3d94c822f3a61f7b8b85a71a1aed64', '2798', NULL, '1', NULL, NULL, NULL, '1', '798', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2965', '3b3d94c822f3a61f7b8b85a71a1aed64', '2781', NULL, '1', NULL, NULL, NULL, '1', '798', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2966', '3b3d94c822f3a61f7b8b85a71a1aed64', '2516', NULL, '1', NULL, NULL, NULL, '1', '798', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2967', '05459b8b9524a7c341c747e7f511d366', '2600', NULL, '1', NULL, NULL, NULL, '1', '799', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2968', '05459b8b9524a7c341c747e7f511d366', '2949', NULL, '4', NULL, NULL, NULL, '1', '799', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2969', '05459b8b9524a7c341c747e7f511d366', '3001', NULL, '2', NULL, NULL, NULL, '1', '799', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2970', '05459b8b9524a7c341c747e7f511d366', '4038', NULL, '10', NULL, NULL, NULL, '1', '799', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2971', '05459b8b9524a7c341c747e7f511d366', '4039', NULL, '2', NULL, NULL, NULL, '1', '799', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2972', '05459b8b9524a7c341c747e7f511d366', '4040', NULL, '1', NULL, NULL, NULL, '1', '799', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2973', '05459b8b9524a7c341c747e7f511d366', '4332', NULL, '1', NULL, NULL, NULL, '1', '799', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2974', '05459b8b9524a7c341c747e7f511d366', '3986', NULL, '3', NULL, NULL, NULL, '1', '799', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2975', 'e06e04b99c8bd436a7129b82a0ed8216', '2372', NULL, '1', NULL, NULL, NULL, '1', '800', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2976', '487e428cd268dc579c68efd872bbc2fa', '4036', NULL, '25', NULL, NULL, NULL, '1', '801', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2977', '487e428cd268dc579c68efd872bbc2fa', '4037', NULL, '15', NULL, NULL, NULL, '1', '801', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2978', '487e428cd268dc579c68efd872bbc2fa', '1935', NULL, '1', NULL, NULL, NULL, '1', '801', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2979', '487e428cd268dc579c68efd872bbc2fa', '2406', NULL, '6', NULL, NULL, NULL, '1', '801', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2980', '487e428cd268dc579c68efd872bbc2fa', '2416', NULL, '6', NULL, NULL, NULL, '1', '801', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2981', 'd3231d521b2fe53bd46eb3198f39186e', '3984', NULL, '60', NULL, NULL, NULL, '1', '802', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2982', 'd3231d521b2fe53bd46eb3198f39186e', '4403', NULL, '5', NULL, NULL, NULL, '1', '802', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2983', 'd3231d521b2fe53bd46eb3198f39186e', '4209', NULL, '10', NULL, NULL, NULL, '1', '802', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2984', 'd3231d521b2fe53bd46eb3198f39186e', '4210', NULL, '10', NULL, NULL, NULL, '1', '802', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2985', '9341c2812f5d3aea1f6a06cbb0e69c9e', '730', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2986', '9341c2812f5d3aea1f6a06cbb0e69c9e', '277', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2987', '9341c2812f5d3aea1f6a06cbb0e69c9e', '1267', NULL, '30', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2988', '9341c2812f5d3aea1f6a06cbb0e69c9e', '1275', NULL, '30', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2989', 'cd4270a4056a61ac3f3ec42f67d7a5f2', '1033', NULL, '3', NULL, NULL, NULL, '1', '803', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2990', 'cd4270a4056a61ac3f3ec42f67d7a5f2', '1045', NULL, '1', NULL, NULL, NULL, '1', '803', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2991', 'cd4270a4056a61ac3f3ec42f67d7a5f2', '1135', NULL, '2', NULL, NULL, NULL, '1', '803', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2993', 'cd4270a4056a61ac3f3ec42f67d7a5f2', '1162', NULL, '1', NULL, NULL, NULL, '1', '803', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2994', 'cd4270a4056a61ac3f3ec42f67d7a5f2', '1271', NULL, '3', NULL, NULL, NULL, '1', '803', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2995', 'cd4270a4056a61ac3f3ec42f67d7a5f2', '1272', NULL, '3', NULL, NULL, NULL, '1', '803', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2996', 'cd4270a4056a61ac3f3ec42f67d7a5f2', '1273', NULL, '3', NULL, NULL, NULL, '1', '803', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2997', 'cd4270a4056a61ac3f3ec42f67d7a5f2', '1274', NULL, '3', NULL, NULL, NULL, '1', '803', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2998', 'cd4270a4056a61ac3f3ec42f67d7a5f2', '1270', NULL, '1', NULL, NULL, NULL, '1', '803', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('2999', 'cd4270a4056a61ac3f3ec42f67d7a5f2', '1269', NULL, '1', NULL, NULL, NULL, '1', '803', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('3000', 'cd4270a4056a61ac3f3ec42f67d7a5f2', '1288', NULL, '1', NULL, NULL, NULL, '1', '803', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('3001', 'cd4270a4056a61ac3f3ec42f67d7a5f2', '1289', NULL, '1', NULL, NULL, NULL, '1', '803', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('3002', 'cd4270a4056a61ac3f3ec42f67d7a5f2', '4911', NULL, '1', NULL, NULL, NULL, '1', '803', NULL);
INSERT INTO `baskets` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('3003', 'd3231d521b2fe53bd46eb3198f39186e', '2515', NULL, '1', NULL, NULL, NULL, '1', '804', NULL);


#
# TABLE STRUCTURE FOR: baskets1
#

DROP TABLE IF EXISTS `baskets1`;

CREATE TABLE `baskets1` (
  `basketID` int(11) NOT NULL AUTO_INCREMENT,
  `basketSession` varchar(50) DEFAULT NULL,
  `productID` int(11) DEFAULT NULL,
  `productPrice` varchar(50) DEFAULT NULL,
  `productQty` int(11) DEFAULT NULL,
  `product_weight` varchar(50) DEFAULT NULL,
  `pcode` varchar(100) DEFAULT NULL,
  `rid` int(11) DEFAULT NULL,
  `status` int(1) DEFAULT NULL,
  `order_id` int(11) DEFAULT NULL,
  `mem_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`basketID`)
) ENGINE=InnoDB AUTO_INCREMENT=750 DEFAULT CHARSET=latin1;

INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('21', 'rmc9p640qrgi2bhiqfs7rneuj7', '1', '100.00', '1', '22cm', '22cm', '1', '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('22', 'rmc9p640qrgi2bhiqfs7rneuj7', '2', '300.00', '2', '35cm', '35cm', '6', '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('25', 'rmc9p640qrgi2bhiqfs7rneuj7', '4', '100.00', '1', '22cm', '22cm', '10', '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('30', '79u8qjbr140nuotaaspv53je77', '1', '90.00', '1', 'celld-22', 'celld-22', '1', '0', NULL, '1');
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('32', 'b6pl673040717llutrhbqaepr2', '1', '90.00', '1', 'celld-22', 'celld-22', '1', '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('33', '7t20b6c77sdpesehaghv9gsek2', '1', '90.00', '1', 'celld-22', 'celld-22', '1', '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('34', 'abc36tot7giic8fcgph0r3h610', '1', '90.00', '1', 'celld-22', 'celld-22', '1', '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('35', 'd7mgpi8jovs4tor2fnav6t7tj7', '1', '90.00', '1', 'celld-22', 'celld-22', '1', '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('36', 'rdkki31on8rpg90t5ja4ndohk1', '1', '90.00', '2', 'celld-22', 'celld-22', '1', '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('42', 'bgrl54a6a01r1tfac6gsnnqt72', '1', '24500.00', '2', 'King Size', 'King Size', '1', '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('49', 'nmld5m7ghsnr0klokh94b2g8e3', '1', '24500.00', '1', 'King Size', 'King Size', '1', '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('50', 'anibopk1lon9vbbq46ts749he5', '1', NULL, '1', NULL, NULL, NULL, '1', '1', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('51', 'anibopk1lon9vbbq46ts749he5', '27', NULL, '1', NULL, NULL, NULL, '1', '1', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('54', 'anibopk1lon9vbbq46ts749he5', '96', NULL, '1', NULL, NULL, NULL, '1', '2', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('56', 'q2u38qs9nd434oodd4alr99snp', '2583', NULL, '1', NULL, NULL, NULL, '1', '3', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('57', '41fqdkeujmd75d3v7ti6e4n2rg', '2403', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('58', 'sv7e6597etlfglqvrerq0atou9', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('59', 'sv7e6597etlfglqvrerq0atou9', '45', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('60', 'sv7e6597etlfglqvrerq0atou9', '44', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('61', 'sv7e6597etlfglqvrerq0atou9', '2', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('62', 'sv7e6597etlfglqvrerq0atou9', '53', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('63', 'sv7e6597etlfglqvrerq0atou9', '2288', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('64', 'sv7e6597etlfglqvrerq0atou9', '2236', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('65', 'sv7e6597etlfglqvrerq0atou9', '2289', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('68', 'ajfgf7vneeenn1uo43hmsg2pm2', '2403', NULL, '5', NULL, NULL, NULL, '1', '4', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('69', 'ajfgf7vneeenn1uo43hmsg2pm2', '2311', NULL, '5', NULL, NULL, NULL, '1', '4', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('84', '1guf9gcltn7thbm452m9rugemj', '1', NULL, '1', NULL, NULL, NULL, '1', '5', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('85', '1guf9gcltn7thbm452m9rugemj', '4', NULL, '1', NULL, NULL, NULL, '1', '5', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('86', '3v4k8d8de16jtk4q2o3nqq6kmg', '626', NULL, '1', NULL, NULL, NULL, '1', '7', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('87', '3v4k8d8de16jtk4q2o3nqq6kmg', '1', NULL, '1', NULL, NULL, NULL, '1', '7', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('88', '3v4k8d8de16jtk4q2o3nqq6kmg', '17', NULL, '1', NULL, NULL, NULL, '1', '7', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('89', '1guf9gcltn7thbm452m9rugemj', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('93', 'bdua32qg06q0smu225lb52m5b1', '1', NULL, '1', NULL, NULL, NULL, '1', '8', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('101', 'bqdcfap5hf20pg6vbieokbussf', '1', NULL, '1', NULL, NULL, NULL, '1', '9', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('102', 'bqdcfap5hf20pg6vbieokbussf', '7', NULL, '1', NULL, NULL, NULL, '1', '9', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('103', 'bqdcfap5hf20pg6vbieokbussf', '10', NULL, '1', NULL, NULL, NULL, '1', '9', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('104', 'bqdcfap5hf20pg6vbieokbussf', '13', NULL, '1', NULL, NULL, NULL, '1', '9', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('105', 'bqdcfap5hf20pg6vbieokbussf', '558', NULL, '1', NULL, NULL, NULL, '1', '9', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('106', 'bqdcfap5hf20pg6vbieokbussf', '555', NULL, '1', NULL, NULL, NULL, '1', '9', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('107', 'bqdcfap5hf20pg6vbieokbussf', '626', NULL, '1', NULL, NULL, NULL, '1', '9', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('112', 'bdua32qg06q0smu225lb52m5b1', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('115', 't4qvbbte4b70diohgke5ck6qnr', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('116', '8qr55mrjsrgg240q9tgt6s868e', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('117', '8qr55mrjsrgg240q9tgt6s868e', '2', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('118', '8qr55mrjsrgg240q9tgt6s868e', '3', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('119', 't4qvbbte4b70diohgke5ck6qnr', '1925', NULL, '5', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('120', 't4qvbbte4b70diohgke5ck6qnr', '2336', NULL, '5', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('125', 'elnjsc79lg0ofitsa9ecuslho9', '1334', NULL, '10', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('126', 'jdthoi8uctr1906frevafrud74', '322', NULL, '1', NULL, NULL, NULL, '1', '10', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('127', 'jdthoi8uctr1906frevafrud74', '323', NULL, '2', NULL, NULL, NULL, '1', '10', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('132', 'v0c6bvd016vdfa7es00vck5jpl', '1', NULL, '1', NULL, NULL, NULL, '1', '11', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('133', 'v0c6bvd016vdfa7es00vck5jpl', '2', NULL, '1', NULL, NULL, NULL, '1', '11', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('134', '3gs3iupq0hqmsc81r5nld2akst', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('135', '3gs3iupq0hqmsc81r5nld2akst', '2', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('136', 'njef8r1cv8voeiv5k7ve8bb2mj', '1', NULL, '1', NULL, NULL, NULL, '1', '12', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('137', 'v0c6bvd016vdfa7es00vck5jpl', '55', NULL, '1', NULL, NULL, NULL, '1', '13', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('138', 'v0c6bvd016vdfa7es00vck5jpl', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('139', 'v0c6bvd016vdfa7es00vck5jpl', '5', NULL, '3', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('140', 'q5lmnd9q42vhh2v3d9leikud6p', '1907', NULL, '3', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('141', 'njef8r1cv8voeiv5k7ve8bb2mj', '13', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('142', 'njef8r1cv8voeiv5k7ve8bb2mj', '14', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('143', 'l1vhup8h5ar5mba45ev3jmdgfv', '534', NULL, '1', NULL, NULL, NULL, '1', '18', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('145', 'l1vhup8h5ar5mba45ev3jmdgfv', '1358', NULL, '7', NULL, NULL, NULL, '1', '18', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('146', 'l1vhup8h5ar5mba45ev3jmdgfv', '1925', NULL, '1', NULL, NULL, NULL, '1', '19', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('147', 'l1vhup8h5ar5mba45ev3jmdgfv', '2338', NULL, '1', NULL, NULL, NULL, '1', '19', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('148', 'l1vhup8h5ar5mba45ev3jmdgfv', '2336', NULL, '1', NULL, NULL, NULL, '1', '19', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('149', 'l1vhup8h5ar5mba45ev3jmdgfv', '3078', NULL, '1', NULL, NULL, NULL, '1', '19', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('150', 'l1vhup8h5ar5mba45ev3jmdgfv', '2339', NULL, '1', NULL, NULL, NULL, '1', '19', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('151', '7ujo6rfrq80ulb7d43fc9ul9v5', '2403', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('152', '7ujo6rfrq80ulb7d43fc9ul9v5', '2404', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('153', 'o2bpjm11e41933l0f1p91guul4', '933', NULL, '3', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('154', 'r915mbgubpcrdmv0783f4q41qc', '1', NULL, '1', NULL, NULL, NULL, '1', '20', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('155', 'r915mbgubpcrdmv0783f4q41qc', '3', NULL, '1', NULL, NULL, NULL, '1', '20', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('156', 'hg72qcfdlg3n54qd77ul346c7s', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('157', 'hg72qcfdlg3n54qd77ul346c7s', '2', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('158', 'o8m2gh0k7lsi1rdau87q83th7o', '55', NULL, '5', NULL, NULL, NULL, '1', '21', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('159', 'o8m2gh0k7lsi1rdau87q83th7o', '1907', NULL, '3', NULL, NULL, NULL, '1', '22', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('160', 'o8m2gh0k7lsi1rdau87q83th7o', '2', NULL, '7', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('161', 'o8m2gh0k7lsi1rdau87q83th7o', '5', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('162', 'o8m2gh0k7lsi1rdau87q83th7o', '9', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('163', '8mpgmpo6gevb0ubmt6j70ukdsk', '96', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('164', '5bqrlcv1bbsloil9vgcu8mch15', '1892', NULL, '2', NULL, NULL, NULL, '1', '23', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('165', '5bqrlcv1bbsloil9vgcu8mch15', '1893', NULL, '1', NULL, NULL, NULL, '1', '23', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('166', '5bqrlcv1bbsloil9vgcu8mch15', '1921', NULL, '5', NULL, NULL, NULL, '1', '23', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('167', '5bqrlcv1bbsloil9vgcu8mch15', '1892', NULL, '1', NULL, NULL, NULL, '1', '24', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('168', '5bqrlcv1bbsloil9vgcu8mch15', '1893', NULL, '1', NULL, NULL, NULL, '1', '24', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('169', '5bqrlcv1bbsloil9vgcu8mch15', '1894', NULL, '1', NULL, NULL, NULL, '1', '24', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('170', 'rftsv98ejpnedkldpbqmns8ee6', '47', NULL, '3', NULL, NULL, NULL, '1', '25', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('171', 'rftsv98ejpnedkldpbqmns8ee6', '27', NULL, '2', NULL, NULL, NULL, '1', '25', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('172', 'rftsv98ejpnedkldpbqmns8ee6', '1', NULL, '2', NULL, NULL, NULL, '1', '25', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('173', 'rftsv98ejpnedkldpbqmns8ee6', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('174', 'rftsv98ejpnedkldpbqmns8ee6', '2', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('176', 'orqp4685r7njv9fordjkkegd18', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('177', 'orqp4685r7njv9fordjkkegd18', '2', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('178', 'orqp4685r7njv9fordjkkegd18', '3', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('179', 'v5d2rfoh04i65acljtrnffjfuf', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('180', 'lvj0uhgj23vam9mkpp90b1morn', '55', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('181', '7ml9iff2ohhm8io7vb8cr9gos0', '1', NULL, '7', NULL, NULL, NULL, '1', '26', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('182', '2b9rkne7vhevqb39c51arfkjrb', '935', NULL, '7', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('183', '2b9rkne7vhevqb39c51arfkjrb', '316', NULL, '7', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('189', 'o75v1ka1mdrm7q9dd7atiqii0j', '1', NULL, '2', NULL, NULL, NULL, '1', '27', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('190', 'o75v1ka1mdrm7q9dd7atiqii0j', '2', NULL, '1', NULL, NULL, NULL, '1', '27', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('191', 'v11tadcm1v8o0tcbjba2ve3187', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('192', 'o75v1ka1mdrm7q9dd7atiqii0j', '1', NULL, '2', NULL, NULL, NULL, '1', '28', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('193', 'o75v1ka1mdrm7q9dd7atiqii0j', '2', NULL, '1', NULL, NULL, NULL, '1', '28', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('195', 'ctacf9rn4j752kt1ihiufeha7q', '389', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('197', 'sdanumu24smkfsvtjtrf0otsng', '4', NULL, '2', NULL, NULL, NULL, '1', '29', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('198', 'j3hk659i7746olb526nunchb91', '1972', NULL, '15', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('200', '29h7me8o11ekjfl4uu9ijksmpu', '2603', NULL, '1', NULL, NULL, NULL, '1', '30', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('201', 'r515bp2h8ob1rfko6s128h037d', '1892', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('205', 'v7mvbg0kq0m9cjash94iuubqme', '2', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('206', '02unpgrvvvqrf0q3fanu8nk335', '606', NULL, '4', NULL, NULL, NULL, '1', '31', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('209', '1odpcgj527bu9ii5637rduqri1', '1004', NULL, '1', NULL, NULL, NULL, '1', '32', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('214', '7ki2it1228a47ovk57utnp2phs', '1', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('215', '7ki2it1228a47ovk57utnp2phs', '2', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('218', '49jnar6bl3hvna8i9e40mi7jq9', '317', NULL, '5', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('219', '49jnar6bl3hvna8i9e40mi7jq9', '318', NULL, '4', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('222', 'qq0c0790s19pfs6n353l23q25t', '55', NULL, '6', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('224', '930d5f89a798daad767dce4b5683528a', '2417', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('227', '3b9cd40a3841dd6b6517b3e42093048c', '3067', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('229', '3337cc9ddad6d7abef1bb5689c5c6667', '56', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('230', '3337cc9ddad6d7abef1bb5689c5c6667', '58', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('239', '96ac38e20d4e1d8bf9ebcea77efac421', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('241', '96ac38e20d4e1d8bf9ebcea77efac421', '2311', NULL, '5', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('242', '103991431ddafb1b18ec1b153bf23d92', '410', NULL, '1', NULL, NULL, NULL, '1', '33', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('243', '103991431ddafb1b18ec1b153bf23d92', '412', NULL, '1', NULL, NULL, NULL, '1', '33', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('245', 'b13ec099a096d3262ea13ae38067cb47', '2311', NULL, '3', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('247', 'b6208fd3ca03f481bb211d621f541ab2', '2311', NULL, '4', NULL, NULL, NULL, '1', '34', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('249', 'b6208fd3ca03f481bb211d621f541ab2', '2311', NULL, '5', NULL, NULL, NULL, '1', '35', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('250', '459e97ca6d04e8b1fbd621315bc23bc4', '1', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('253', 'b6208fd3ca03f481bb211d621f541ab2', '280', NULL, '3', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('254', 'b6208fd3ca03f481bb211d621f541ab2', '352', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('255', '0f4cac9d6611a10b1d09f0054092ea0d', '3177', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('256', 'ce02e115864ee6245ac9db329844961f', '3123', NULL, '6', NULL, NULL, NULL, '1', '36', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('257', 'ce02e115864ee6245ac9db329844961f', '3144', NULL, '6', NULL, NULL, NULL, '1', '36', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('260', 'e948a5ddcd1a340b6508283e3e21256a', '1422', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('262', '43b74ddc165789479dc735bd766b25e3', '2407', NULL, '5', NULL, NULL, NULL, '1', '37', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('263', 'edbd7d9033af27110e5b2e0e9f7928d4', '1892', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('264', '377b81a0cc42912ff9d85818ecd3cdad', '20', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('265', '377b81a0cc42912ff9d85818ecd3cdad', '3259', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('268', '1c288cd879ffd45557828c98a7d65861', '1275', NULL, '6', NULL, NULL, NULL, '1', '38', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('270', '956d2786871bb4d6dffc24e2ead5236a', '1275', NULL, '6', NULL, NULL, NULL, '1', '39', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('271', 'ffbe7738426669c31ec26b18149f7416', '1275', NULL, '6', NULL, NULL, NULL, '1', '40', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('272', 'ffbe7738426669c31ec26b18149f7416', '1275', NULL, '6', NULL, NULL, NULL, '1', '41', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('273', '50d843c4ecc5ffadc7958f6ea7df831e', '1925', NULL, '2', NULL, NULL, NULL, '1', '42', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('274', '50d843c4ecc5ffadc7958f6ea7df831e', '2338', NULL, '3', NULL, NULL, NULL, '1', '42', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('275', '4f10f30c621e56760a5f395929bf94fd', '1319', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('277', '80ef44af5fa741a28cee64278a20696c', '1934', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('278', '80ef44af5fa741a28cee64278a20696c', '365', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('279', '80ef44af5fa741a28cee64278a20696c', '366', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('280', '80ef44af5fa741a28cee64278a20696c', '607', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('283', '7586804d60214bc466d2c116b43b8067', '365', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('284', '7586804d60214bc466d2c116b43b8067', '1934', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('285', '5606a64c6cb3473c76f691211dd33369', '1359', NULL, '4', NULL, NULL, NULL, '1', '43', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('286', '5606a64c6cb3473c76f691211dd33369', '1362', NULL, '4', NULL, NULL, NULL, '1', '43', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('287', 'f603d3c3292665c8a2ab8e4d25f5f3e5', '1494', NULL, '1', NULL, NULL, NULL, '1', '44', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('288', 'f7381cd412dd4490d28c0248e46c577e', '1934', NULL, '1', NULL, NULL, NULL, '1', '45', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('289', 'f7381cd412dd4490d28c0248e46c577e', '365', NULL, '1', NULL, NULL, NULL, '1', '45', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('290', '0af6b43b359df306cbd18c54baa98776', '200', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('291', 'ee42627f1b86b6512bad467c76935b05', '659', NULL, '4', NULL, NULL, NULL, '1', '46', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('292', 'ee42627f1b86b6512bad467c76935b05', '659', NULL, '4', NULL, NULL, NULL, '1', '47', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('293', 'b51627f4720f33ecc055e2e52077cdca', '2074', NULL, '400', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('296', 'dd9695070cd21c7b1617627d2339accf', '1904', NULL, '2', NULL, NULL, NULL, '1', '48', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('298', '76073b2e078077825aefe1c718a94278', '124', NULL, '1', NULL, NULL, NULL, '1', '49', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('299', '76073b2e078077825aefe1c718a94278', '128', NULL, '1', NULL, NULL, NULL, '1', '50', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('300', '76073b2e078077825aefe1c718a94278', '843', NULL, '5', NULL, NULL, NULL, '1', '51', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('301', '76073b2e078077825aefe1c718a94278', '658', NULL, '2', NULL, NULL, NULL, '1', '51', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('302', 'd350ee3427a455378ba3447f56c1836c', '337', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('303', 'd350ee3427a455378ba3447f56c1836c', '316', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('304', 'a777d5f50dc584679598d7c0103a8b5f', '391', NULL, '1', NULL, NULL, NULL, '1', '52', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('305', 'a777d5f50dc584679598d7c0103a8b5f', '392', NULL, '1', NULL, NULL, NULL, '1', '52', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('317', '1c1c72a8ce8a4db234fc93c188a2f05c', '607', NULL, '5', NULL, NULL, NULL, '1', '53', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('318', '1c1c72a8ce8a4db234fc93c188a2f05c', '2400', NULL, '4', NULL, NULL, NULL, '1', '54', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('319', 'a356ac747497b96a05a764c4230b099f', '1820', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('326', 'cef53efe1d3220c03e0fe901e39e3bdf', '1790', NULL, '100', NULL, NULL, NULL, '1', '55', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('327', '6d73ff9144db58626c9dfd4bd3921ea6', '1794', NULL, '100', NULL, NULL, NULL, '1', '56', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('328', '3c4d582a246280891b35106eefadd654', '3091', NULL, '1', NULL, NULL, NULL, '1', '57', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('332', 'e3ea0c14cd72450020d29a9b9c5ad698', '1268', NULL, '3', NULL, NULL, NULL, '1', '58', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('333', 'e3ea0c14cd72450020d29a9b9c5ad698', '1282', NULL, '10', NULL, NULL, NULL, '1', '58', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('334', '96b8a4f9cdac99c9c385322f2e3bc5c1', '2489', NULL, '5', NULL, NULL, NULL, '1', '59', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('335', '96b8a4f9cdac99c9c385322f2e3bc5c1', '2491', NULL, '5', NULL, NULL, NULL, '1', '59', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('337', 'b26f99d21b2fb6f42d46791b905737c8', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('338', 'b96a2067a8d6ae4454fe845b8adc84b1', '626', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('339', 'b96a2067a8d6ae4454fe845b8adc84b1', '631', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('342', '0851a86c11ebfffed02609e455dcc1d1', '1461', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('343', '0851a86c11ebfffed02609e455dcc1d1', '2902', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('344', '7998ed05baa79b2e8f42ac5a958aee59', '2058', NULL, '12', NULL, NULL, NULL, '1', '61', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('346', 'cc80fd620282da49962c8ba1fbaa735e', '1273', NULL, '20', NULL, NULL, NULL, '1', '62', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('347', '26c03613f5acc2c1fbeb9359a439194e', '917', NULL, '1', NULL, NULL, NULL, '1', '63', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('348', '4bf014f355068fa7f3c75733542ed317', '1270', NULL, '10', NULL, NULL, NULL, '1', '64', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('349', '4bf014f355068fa7f3c75733542ed317', '1286', NULL, '10', NULL, NULL, NULL, '1', '64', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('350', '626c6efe24c1a4699265d60d765a77ac', '1797', NULL, '3', NULL, NULL, NULL, '1', '65', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('351', 'd7d3e9defa828a40f4aa4b06c39c35a4', '2051', NULL, '12', NULL, NULL, NULL, '1', '66', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('352', 'd7d3e9defa828a40f4aa4b06c39c35a4', '2052', NULL, '12', NULL, NULL, NULL, '1', '66', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('353', 'd7d3e9defa828a40f4aa4b06c39c35a4', '2086', NULL, '12', NULL, NULL, NULL, '1', '66', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('354', 'd7d3e9defa828a40f4aa4b06c39c35a4', '366', NULL, '1', NULL, NULL, NULL, '1', '66', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('355', 'd7d3e9defa828a40f4aa4b06c39c35a4', '607', NULL, '1', NULL, NULL, NULL, '1', '66', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('357', '5a45626544a7136fed1d92fdd3763bb3', '1506', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('358', 'a3d6565b419f345d61b3c9aa2bba69f6', '1790', NULL, '100', NULL, NULL, NULL, '1', '67', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('359', 'a3d6565b419f345d61b3c9aa2bba69f6', '1794', NULL, '100', NULL, NULL, NULL, '1', '67', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('364', '131a7eeda8f4d02a2fbda17d35ba241e', '381', NULL, '2', NULL, NULL, NULL, '1', '68', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('365', '131a7eeda8f4d02a2fbda17d35ba241e', '550', NULL, '8', NULL, NULL, NULL, '1', '68', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('366', '131a7eeda8f4d02a2fbda17d35ba241e', '2484', NULL, '4', NULL, NULL, NULL, '1', '68', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('367', '131a7eeda8f4d02a2fbda17d35ba241e', '2485', NULL, '10', NULL, NULL, NULL, '1', '68', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('368', 'd6bad956fecb0424f5c364991a9bd475', '3094', NULL, '1', NULL, NULL, NULL, '1', '69', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('369', 'b8a26e9ddbbb8c558904a3dd99f6b5cf', '2406', NULL, '50', NULL, NULL, NULL, '1', '70', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('370', 'b8a26e9ddbbb8c558904a3dd99f6b5cf', '1379', NULL, '2', NULL, NULL, NULL, '1', '70', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('371', '5b47ffd9fba6eb5861aa30972c7e3ff9', '1870', NULL, '1', NULL, NULL, NULL, '1', '71', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('372', '5b47ffd9fba6eb5861aa30972c7e3ff9', '2400', NULL, '10', NULL, NULL, NULL, '1', '71', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('373', '5b47ffd9fba6eb5861aa30972c7e3ff9', '2401', NULL, '10', NULL, NULL, NULL, '1', '71', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('374', '72eb93e5e441009a8536ee07f573ff60', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('375', '72eb93e5e441009a8536ee07f573ff60', '2', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('378', 'dd12b44f03830e8eda14fc2a61874c8e', '1', NULL, '3', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('381', '14d7fc42f2742d9077f3de140479145b', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('383', '49c6bbb186e4c4021354f6a86f33285e', '2946', NULL, '20', NULL, NULL, NULL, '1', '72', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('384', '49c6bbb186e4c4021354f6a86f33285e', '3031', NULL, '1', NULL, NULL, NULL, '1', '72', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('385', '545b8246c539d27ef503d567e8d15c70', '692', NULL, '2', NULL, NULL, NULL, '1', '73', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('386', '2ba40475d12b8dffe449357fcd413ff7', '400', NULL, '1', NULL, NULL, NULL, '1', '74', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('387', '7471ffa1cdddba57be9c83084c019a9a', '3263', NULL, '20', NULL, NULL, NULL, '1', '75', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('388', '7471ffa1cdddba57be9c83084c019a9a', '1790', NULL, '40', NULL, NULL, NULL, '1', '75', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('389', '7471ffa1cdddba57be9c83084c019a9a', '1786', NULL, '80', NULL, NULL, NULL, '1', '75', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('390', 'dd8e33b6e4a725d09e19253348431800', '1270', NULL, '30', NULL, NULL, NULL, '1', '76', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('391', 'dd8e33b6e4a725d09e19253348431800', '1275', NULL, '10', NULL, NULL, NULL, '1', '76', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('392', 'dd8e33b6e4a725d09e19253348431800', '1797', NULL, '20', NULL, NULL, NULL, '1', '76', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('393', 'db4df56b86455b3318166715accacbfe', '2878', NULL, '2', NULL, NULL, NULL, '1', '77', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('394', 'db4df56b86455b3318166715accacbfe', '2877', NULL, '1', NULL, NULL, NULL, '1', '77', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('398', '7a85619ec19a8d7d37006682821d9e95', '3502', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('399', '7a85619ec19a8d7d37006682821d9e95', '3501', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('400', '7a85619ec19a8d7d37006682821d9e95', '3500', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('401', '7a85619ec19a8d7d37006682821d9e95', '2103', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('402', '7a85619ec19a8d7d37006682821d9e95', '1973', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('403', '7a85619ec19a8d7d37006682821d9e95', '3393', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('404', '7a85619ec19a8d7d37006682821d9e95', '3391', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('405', '7a85619ec19a8d7d37006682821d9e95', '1974', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('406', '1f4cbc49db40ba5a2f693962b5782365', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('407', '1f4cbc49db40ba5a2f693962b5782365', '2', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('408', 'd0aa5cb978e5d1e7b8cd694290b3620e', '3095', NULL, '1', NULL, NULL, NULL, '1', '78', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('410', '0fa2088076e10bcd4caa6a60f9bad723', '1734', NULL, '1', NULL, NULL, NULL, '1', '79', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('411', '0fa2088076e10bcd4caa6a60f9bad723', '1734', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('413', 'e73b32035f31e04d1850f07359e241b2', '2407', NULL, '2', NULL, NULL, NULL, '1', '80', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('414', 'e73b32035f31e04d1850f07359e241b2', '482', NULL, '2', NULL, NULL, NULL, '1', '80', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('415', 'e73b32035f31e04d1850f07359e241b2', '484', NULL, '2', NULL, NULL, NULL, '1', '80', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('416', 'e73b32035f31e04d1850f07359e241b2', '1362', NULL, '2', NULL, NULL, NULL, '1', '80', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('417', 'e73b32035f31e04d1850f07359e241b2', '1363', NULL, '2', NULL, NULL, NULL, '1', '80', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('418', '4b4f544b21f0ae92b8e3f94642c60f8a', '214', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('419', '49e5be3cbaf2636696147a610f3e59ea', '38', NULL, '20', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('420', '2f600c44e749a05122a3616e5650136a', '1974', NULL, '2', NULL, NULL, NULL, '1', '81', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('421', '2f600c44e749a05122a3616e5650136a', '1934', NULL, '2', NULL, NULL, NULL, '1', '81', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('422', '2f600c44e749a05122a3616e5650136a', '344', NULL, '2', NULL, NULL, NULL, '1', '81', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('423', '2f600c44e749a05122a3616e5650136a', '616', NULL, '5', NULL, NULL, NULL, '1', '81', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('424', '2f600c44e749a05122a3616e5650136a', '607', NULL, '3', NULL, NULL, NULL, '1', '81', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('425', '2f600c44e749a05122a3616e5650136a', '614', NULL, '3', NULL, NULL, NULL, '1', '81', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('426', '2f600c44e749a05122a3616e5650136a', '366', NULL, '3', NULL, NULL, NULL, '1', '81', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('427', '2f600c44e749a05122a3616e5650136a', '2364', NULL, '2', NULL, NULL, NULL, '1', '81', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('428', '2f600c44e749a05122a3616e5650136a', '2086', NULL, '30', NULL, NULL, NULL, '1', '81', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('430', '54aea9de17edd4ee25062322a3082597', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('431', '02f2a1c8c1abe0ae0cb8305ba3df473d', '1731', NULL, '1', NULL, NULL, NULL, '1', '82', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('432', '02f2a1c8c1abe0ae0cb8305ba3df473d', '3123', NULL, '2', NULL, NULL, NULL, '1', '82', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('433', 'fe10c0571ecd713e724cdddb1c3df4f8', '3092', NULL, '1', NULL, NULL, NULL, '1', '83', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('434', 'a3e821050329aa29570f319afce1cee4', '3517', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('435', '6d91a3f14c03398bdbe02c45b441165c', '2669', NULL, '1', NULL, NULL, NULL, '1', '84', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('436', '6d91a3f14c03398bdbe02c45b441165c', '2311', NULL, '1', NULL, NULL, NULL, '1', '84', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('437', '6d91a3f14c03398bdbe02c45b441165c', '2406', NULL, '1', NULL, NULL, NULL, '1', '84', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('438', '6d91a3f14c03398bdbe02c45b441165c', '2416', NULL, '1', NULL, NULL, NULL, '1', '84', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('439', '6d91a3f14c03398bdbe02c45b441165c', '1865', NULL, '1', NULL, NULL, NULL, '1', '84', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('440', '6d91a3f14c03398bdbe02c45b441165c', '3097', NULL, '2', NULL, NULL, NULL, '1', '84', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('441', '6d91a3f14c03398bdbe02c45b441165c', '2661', NULL, '20', NULL, NULL, NULL, '1', '85', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('442', '6d91a3f14c03398bdbe02c45b441165c', '2311', NULL, '5', NULL, NULL, NULL, '1', '85', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('443', '6d91a3f14c03398bdbe02c45b441165c', '2406', NULL, '20', NULL, NULL, NULL, '1', '85', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('444', '6d91a3f14c03398bdbe02c45b441165c', '2416', NULL, '20', NULL, NULL, NULL, '1', '85', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('445', '6d91a3f14c03398bdbe02c45b441165c', '1865', NULL, '1', NULL, NULL, NULL, '1', '85', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('446', '6d91a3f14c03398bdbe02c45b441165c', '3097', NULL, '1', NULL, NULL, NULL, '1', '85', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('447', 'eee1e287d0c80424d62e20d24b345ea5', '1455', NULL, '1', NULL, NULL, NULL, '1', '86', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('450', 'e76959ac3f0dc9c67c231fc34eee5640', '38', NULL, '20', NULL, NULL, NULL, '1', '87', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('451', '101fbc0118abf98eccd643214d7ecc9d', '1794', NULL, '100', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('452', '04f7c23b89bc9e690ff00f86dfbe18e9', '1594', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('453', '6c51be437dfaf5870ddb88adc2b09b9e', '661', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('454', '9121b0c110eddc0145e1156ab98c1f1c', '1027', NULL, '4', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('455', '44e795db78d7e17da417f7b9a111b82e', '1794', NULL, '100', NULL, NULL, NULL, '1', '88', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('456', '44e795db78d7e17da417f7b9a111b82e', '366', NULL, '2', NULL, NULL, NULL, '1', '88', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('457', '44e795db78d7e17da417f7b9a111b82e', '2311', NULL, '2', NULL, NULL, NULL, '1', '88', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('458', '22195a33ea495bc3e10b8f7a74afc784', '1961', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('459', '7dfc98cbc388ac46a5992432d0d4d4a6', '2872', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('460', '7dfc98cbc388ac46a5992432d0d4d4a6', '1455', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('461', '7dfc98cbc388ac46a5992432d0d4d4a6', '3316', NULL, '3', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('462', '19e31f0d2bbf84002d7381809e093dce', '2872', NULL, '2', NULL, NULL, NULL, '1', '89', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('463', '19e31f0d2bbf84002d7381809e093dce', '1455', NULL, '1', NULL, NULL, NULL, '1', '89', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('464', '19e31f0d2bbf84002d7381809e093dce', '3316', NULL, '3', NULL, NULL, NULL, '1', '89', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('465', '4a7f0b4cadcc0b5a0d59913d8f0be232', '1898', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('466', '4a7f0b4cadcc0b5a0d59913d8f0be232', '2017', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('467', '4a7f0b4cadcc0b5a0d59913d8f0be232', '2022', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('468', '4a7f0b4cadcc0b5a0d59913d8f0be232', '2025', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('469', '4a7f0b4cadcc0b5a0d59913d8f0be232', '2034', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('470', '4a7f0b4cadcc0b5a0d59913d8f0be232', '2038', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('471', '4a7f0b4cadcc0b5a0d59913d8f0be232', '2045', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('472', 'b226a0c4d663e2abc3c34b3c87e072e1', '2403', NULL, '1', NULL, NULL, NULL, '1', '90', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('473', 'b226a0c4d663e2abc3c34b3c87e072e1', '2413', NULL, '1', NULL, NULL, NULL, '1', '90', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('482', 'b226a0c4d663e2abc3c34b3c87e072e1', '2858', NULL, '1', NULL, NULL, NULL, '1', '90', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('483', 'b226a0c4d663e2abc3c34b3c87e072e1', '2868', NULL, '1', NULL, NULL, NULL, '1', '90', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('484', 'b226a0c4d663e2abc3c34b3c87e072e1', '2869', NULL, '1', NULL, NULL, NULL, '1', '90', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('485', 'b226a0c4d663e2abc3c34b3c87e072e1', '2867', NULL, '1', NULL, NULL, NULL, '1', '90', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('486', 'b226a0c4d663e2abc3c34b3c87e072e1', '2874', NULL, '2', NULL, NULL, NULL, '1', '90', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('487', 'b226a0c4d663e2abc3c34b3c87e072e1', '2878', NULL, '2', NULL, NULL, NULL, '1', '90', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('488', 'b226a0c4d663e2abc3c34b3c87e072e1', '2876', NULL, '1', NULL, NULL, NULL, '1', '90', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('489', 'b226a0c4d663e2abc3c34b3c87e072e1', '2864', NULL, '1', NULL, NULL, NULL, '1', '90', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('490', 'e430e2464a07c24a318500740fe3b80c', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('491', 'e430e2464a07c24a318500740fe3b80c', '10', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('492', '7ec87b097d30d4f08c0fa0555c2573e7', '567', NULL, '1', NULL, NULL, NULL, '1', '91', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('493', '7ec87b097d30d4f08c0fa0555c2573e7', '568', NULL, '1', NULL, NULL, NULL, '1', '91', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('494', '7ec87b097d30d4f08c0fa0555c2573e7', '567', NULL, '1', NULL, NULL, NULL, '1', '92', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('495', '7ec87b097d30d4f08c0fa0555c2573e7', '568', NULL, '1', NULL, NULL, NULL, '1', '92', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('496', 'd6f219b8e30c08f44fc3e20cb4aa80f9', '878', NULL, '1', NULL, NULL, NULL, '1', '93', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('497', 'da5a61d447c93efb9213f344bf18aec0', '1510', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('498', '1ac59048335cc4a68ba42b5024a17667', '1418', NULL, '10', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('499', 'f72b228dd12bb61d68af2e1d5885a401', '2789', NULL, '1', NULL, NULL, NULL, '1', '94', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('500', '47ed813aa6c3559871cde1790c212386', '2050', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('501', '4b0f1422366ac8010010a6f57b2820ee', '345', NULL, '1', NULL, NULL, NULL, '1', '95', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('502', '28fe7dd246682c759e8e55131bc38b68', '1455', NULL, '1', NULL, NULL, NULL, '1', '96', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('503', '28fe7dd246682c759e8e55131bc38b68', '2878', NULL, '1', NULL, NULL, NULL, '1', '96', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('507', '21dddf95fb2f6115c13b42935a3bbb85', '1794', NULL, '100', NULL, NULL, NULL, '1', '97', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('508', 'a1886b1021fa2f862b16cdffde80e442', '1797', NULL, '30', NULL, NULL, NULL, '1', '98', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('509', 'aa2a44a4823d515c9248ded4586a7242', '2364', NULL, '5', NULL, NULL, NULL, '1', '99', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('510', '54d84645e01961d44c67675206adabb5', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('511', '54d84645e01961d44c67675206adabb5', '5', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('512', '43389895e3b49c64b631c40883587489', '928', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('513', '457d1eaab87102c62c2c408546e013f2', '2943', NULL, '10', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('514', '457d1eaab87102c62c2c408546e013f2', '2945', NULL, '10', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('515', '457d1eaab87102c62c2c408546e013f2', '690', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('516', '457d1eaab87102c62c2c408546e013f2', '699', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('517', '47d8fe2da7f5ad5b310633c5ad77c508', '690', NULL, '1', NULL, NULL, NULL, '1', '100', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('518', '47d8fe2da7f5ad5b310633c5ad77c508', '699', NULL, '1', NULL, NULL, NULL, '1', '100', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('519', '47d8fe2da7f5ad5b310633c5ad77c508', '2943', NULL, '10', NULL, NULL, NULL, '1', '100', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('520', '47d8fe2da7f5ad5b310633c5ad77c508', '2945', NULL, '10', NULL, NULL, NULL, '1', '100', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('522', '7d8e1d8b6bb7bb6df1357d412a27a98e', '2607', NULL, '1', NULL, NULL, NULL, '1', '101', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('523', '49caba34fc379c8b7076cc10aeeab185', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('524', 'd5d506a338da626ee11e38aeb58b7b85', '3374', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('525', 'd5d506a338da626ee11e38aeb58b7b85', '3375', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('526', '4dd0e8be4897c26c2b9cb69ae0119e94', '404', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('527', '4dd0e8be4897c26c2b9cb69ae0119e94', '403', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('528', '55db9f95a422fb3f58855b43822bd000', '372', NULL, '1', NULL, NULL, NULL, '1', '102', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('529', '55db9f95a422fb3f58855b43822bd000', '283', NULL, '1', NULL, NULL, NULL, '1', '102', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('530', '55db9f95a422fb3f58855b43822bd000', '2516', NULL, '1', NULL, NULL, NULL, '1', '102', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('531', '55db9f95a422fb3f58855b43822bd000', '3325', NULL, '1', NULL, NULL, NULL, '1', '102', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('532', '2bc508ded58649da39564fa3e414aa1d', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('533', '2bc508ded58649da39564fa3e414aa1d', '2', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('534', '2df0a2cff10689b9ef9287afa0ed82a2', '3409', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('538', '57855c844d25ec41f52df14d47c26fbc', '3374', NULL, '6', NULL, NULL, NULL, '1', '103', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('539', '57855c844d25ec41f52df14d47c26fbc', '3375', NULL, '3', NULL, NULL, NULL, '1', '103', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('540', '57855c844d25ec41f52df14d47c26fbc', '2086', NULL, '18', NULL, NULL, NULL, '1', '103', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('541', '57855c844d25ec41f52df14d47c26fbc', '2087', NULL, '12', NULL, NULL, NULL, '1', '103', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('542', '57855c844d25ec41f52df14d47c26fbc', '1455', NULL, '1', NULL, NULL, NULL, '1', '103', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('543', '57855c844d25ec41f52df14d47c26fbc', '2937', NULL, '5', NULL, NULL, NULL, '1', '103', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('544', '754b1fd56fc3dba2c94dc2ca46047cf7', '1452', NULL, '1', NULL, NULL, NULL, '1', '104', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('545', '754b1fd56fc3dba2c94dc2ca46047cf7', '1453', NULL, '1', NULL, NULL, NULL, '1', '104', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('546', '754b1fd56fc3dba2c94dc2ca46047cf7', '2417', NULL, '2', NULL, NULL, NULL, '1', '104', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('547', '754b1fd56fc3dba2c94dc2ca46047cf7', '2407', NULL, '2', NULL, NULL, NULL, '1', '104', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('548', '6cd0b86102a020621d1ed21e674f3477', '2746', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('549', '7207fc395c65a4a12c9cb404478b4c0b', '824', NULL, '1', NULL, NULL, NULL, '1', '105', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('550', '3b45c50f2add2f8db07c6becfcdd5849', '388', NULL, '1', NULL, NULL, NULL, '1', '106', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('553', '3b45c50f2add2f8db07c6becfcdd5849', '1282', NULL, '2', NULL, NULL, NULL, '1', '106', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('555', '3b45c50f2add2f8db07c6becfcdd5849', '1268', NULL, '3', NULL, NULL, NULL, '1', '106', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('556', '3b45c50f2add2f8db07c6becfcdd5849', '1277', NULL, '5', NULL, NULL, NULL, '1', '106', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('557', '3b45c50f2add2f8db07c6becfcdd5849', '1278', NULL, '5', NULL, NULL, NULL, '1', '106', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('558', '3b45c50f2add2f8db07c6becfcdd5849', '1706', NULL, '1', NULL, NULL, NULL, '1', '106', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('559', '3b45c50f2add2f8db07c6becfcdd5849', '1787', NULL, '20', NULL, NULL, NULL, '1', '106', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('560', '3b45c50f2add2f8db07c6becfcdd5849', '484', NULL, '10', NULL, NULL, NULL, '1', '106', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('561', '6247370397c364963fd3304e223d36e4', '659', NULL, '6', NULL, NULL, NULL, '1', '107', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('563', '44cd77d518369c5a3c08e7683b16f4e3', '3167', NULL, '2', NULL, NULL, NULL, '1', '108', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('564', '530ab604530be6cbe2b74ad13170d7e8', '1', NULL, '1', NULL, NULL, NULL, '1', '109', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('567', '37df3992c3694f5fbfc08f73398169e9', '1893', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('570', 'b5143dc2226cb02f823505f882577afd', '1661', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('571', 'b48e2d679887096a9ff9ef47a8ed7b9c', '12', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('572', 'fcc75d6109c485e0c4712c1ead00f119', '1731', NULL, '1', NULL, NULL, NULL, '1', '110', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('573', 'e218238bba88b0fcf103d8165aec7b65', '1350', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('574', 'c1332d3d26759b7dfce6094a317be56d', '3357', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('575', 'd9126fd9622c419e284f7afcaf9f3228', '1967', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('576', '61ed896b1cbb3a9801d13cf1d1d134c8', '2407', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('577', 'bc679cb4a7bb139fd72a933c5b68618b', '1892', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('578', 'a1658f834b17521c49f89ac260fdabe2', '2407', NULL, '10', NULL, NULL, NULL, '1', '111', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('579', 'a1658f834b17521c49f89ac260fdabe2', '2364', NULL, '2', NULL, NULL, NULL, '1', '111', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('580', '57a5831c25813f31aca585d81be99d59', '3350', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('581', 'f9dfa9ac3702aeb06d31759090cd0dbc', '3535', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('582', '4540327e99e2e5ceb3dd3a3b54371d3e', '660', NULL, '1', NULL, NULL, NULL, '1', '112', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('585', '4e4785f42230a9e7fe264b60cb339f72', '37', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('586', 'c4754a1e5e0f25dda8d33e7eeca2ec1e', '388', NULL, '1', NULL, NULL, NULL, '1', '113', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('587', 'c4754a1e5e0f25dda8d33e7eeca2ec1e', '484', NULL, '2', NULL, NULL, NULL, '1', '113', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('588', 'c4754a1e5e0f25dda8d33e7eeca2ec1e', '1787', NULL, '2', NULL, NULL, NULL, '1', '113', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('591', 'c4754a1e5e0f25dda8d33e7eeca2ec1e', '1287', NULL, '2', NULL, NULL, NULL, '1', '113', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('592', 'c4754a1e5e0f25dda8d33e7eeca2ec1e', '1706', NULL, '1', NULL, NULL, NULL, '1', '113', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('593', 'c4754a1e5e0f25dda8d33e7eeca2ec1e', '1794', NULL, '5', NULL, NULL, NULL, '1', '113', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('595', 'c4754a1e5e0f25dda8d33e7eeca2ec1e', '3467', NULL, '1', NULL, NULL, NULL, '1', '113', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('596', 'c4754a1e5e0f25dda8d33e7eeca2ec1e', '3468', NULL, '1', NULL, NULL, NULL, '1', '113', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('597', 'c4754a1e5e0f25dda8d33e7eeca2ec1e', '484', NULL, '20', NULL, NULL, NULL, '1', '114', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('598', 'd6eaa8cedf464ef7ba67d4c25a2d6900', '2772', NULL, '1', NULL, NULL, NULL, '1', '115', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('599', '7bb5f95d9c367e4ac503bf27c540bfcc', '1258', NULL, '2', NULL, NULL, NULL, '1', '116', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('600', '7bb5f95d9c367e4ac503bf27c540bfcc', '1258', NULL, '2', NULL, NULL, NULL, '1', '117', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('602', '4f7bac5031beda89d5966e100e6710df', '246', NULL, '1', NULL, NULL, NULL, '1', '118', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('603', '77d16f8e5252ecac54e338b0bf03af68', '327', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('605', 'a67af89f936fa0e0ffd20e3b8e79a535', '3443', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('606', '8f561e14d387c71f89743dee4da31bd1', '2928', NULL, '1', NULL, NULL, NULL, '1', '119', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('609', 'ea051eba2d9bf0c7224c121bb7f9ee99', '3316', NULL, '5', NULL, NULL, NULL, '1', '120', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('610', 'ea051eba2d9bf0c7224c121bb7f9ee99', '2074', NULL, '48', NULL, NULL, NULL, '1', '120', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('611', 'ea051eba2d9bf0c7224c121bb7f9ee99', '2085', NULL, '48', NULL, NULL, NULL, '1', '120', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('612', 'ea051eba2d9bf0c7224c121bb7f9ee99', '3463', NULL, '24', NULL, NULL, NULL, '1', '120', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('613', 'ea051eba2d9bf0c7224c121bb7f9ee99', '3315', NULL, '5', NULL, NULL, NULL, '1', '120', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('614', 'ef26b8c9ee95445e316371424a04e17f', '1938', NULL, '5', NULL, NULL, NULL, '1', '121', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('615', '18d5530365143293e8b50aff5b095506', '2364', NULL, '1', NULL, NULL, NULL, '1', '122', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('617', '18d5530365143293e8b50aff5b095506', '1909', NULL, '1', NULL, NULL, NULL, '1', '122', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('618', '18d5530365143293e8b50aff5b095506', '1455', NULL, '1', NULL, NULL, NULL, '1', '122', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('619', '18d5530365143293e8b50aff5b095506', '3283', NULL, '2', NULL, NULL, NULL, '1', '122', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('620', '84caf2b7ef2804dbb14bf6530811de56', '187', NULL, '1', NULL, NULL, NULL, '1', '123', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('621', 'af381bed4817949b12ef55c3ed3cea24', '1463', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('622', '043767f2ab12720f52aeaa040843702a', '3334', NULL, '1', NULL, NULL, NULL, '1', '124', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('623', '043767f2ab12720f52aeaa040843702a', '2799', NULL, '1', NULL, NULL, NULL, '1', '124', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('624', '043767f2ab12720f52aeaa040843702a', '2802', NULL, '1', NULL, NULL, NULL, '1', '124', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('625', '3f0e608d69c38678ca1e77fb289b2596', '614', NULL, '4', NULL, NULL, NULL, '1', '125', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('626', '3f0e608d69c38678ca1e77fb289b2596', '606', NULL, '4', NULL, NULL, NULL, '1', '125', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('627', '407c021286cd738a3984590676a21f9c', '977', NULL, '1', NULL, NULL, NULL, '1', '126', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('628', 'dbe4ea63227726cb40ebeb9fe8302f06', '659', NULL, '1', NULL, NULL, NULL, '1', '127', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('629', '306f442a465fb4ac7bb6cc4c0fcc20df', '1283', NULL, '6', NULL, NULL, NULL, '1', '128', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('630', '306f442a465fb4ac7bb6cc4c0fcc20df', '366', NULL, '5', NULL, NULL, NULL, '1', '128', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('632', '5d349b25d8d1ff1d8ea3fb1dbf839494', '2516', NULL, '5', NULL, NULL, NULL, '1', '129', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('633', '474ab53297752438d861840e73597a22', '2400', NULL, '10', NULL, NULL, NULL, '1', '130', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('634', '474ab53297752438d861840e73597a22', '491', NULL, '5', NULL, NULL, NULL, '1', '130', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('635', 'e67bb5e37699b02d43cc929ecd8a349e', '62', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('636', '6d69b80b9166507eab531f3be28e773f', '2620', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('639', 'ecf28a90f6cf59c8d5c5a709899270a8', '687', NULL, '1', NULL, NULL, NULL, '1', '131', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('640', 'ecf28a90f6cf59c8d5c5a709899270a8', '690', NULL, '1', NULL, NULL, NULL, '1', '131', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('641', 'ecf28a90f6cf59c8d5c5a709899270a8', '857', NULL, '1', NULL, NULL, NULL, '1', '131', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('642', 'ecf28a90f6cf59c8d5c5a709899270a8', '297', NULL, '1', NULL, NULL, NULL, '1', '131', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('643', 'ecf28a90f6cf59c8d5c5a709899270a8', '300', NULL, '1', NULL, NULL, NULL, '1', '131', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('644', 'ecf28a90f6cf59c8d5c5a709899270a8', '303', NULL, '1', NULL, NULL, NULL, '1', '131', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('645', '184c42e9e585d3f832c8b2a656f6d79f', '711', NULL, '1', NULL, NULL, NULL, '1', '132', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('646', '184c42e9e585d3f832c8b2a656f6d79f', '731', NULL, '1', NULL, NULL, NULL, '1', '132', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('647', 'd9c9feb22cbefa6ea81ae81fbdb78c31', '1366', NULL, '4', NULL, NULL, NULL, '1', '133', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('648', 'c0bf5a2a12245d41bb9a19654066aea8', '1275', NULL, '20', NULL, NULL, NULL, '1', '134', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('649', 'bdad16da57ff2e61182acc11d58ad9ee', '2311', NULL, '2', NULL, NULL, NULL, '1', '135', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('650', 'bdad16da57ff2e61182acc11d58ad9ee', '659', NULL, '5', NULL, NULL, NULL, '1', '135', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('651', '3a4f6bdd327294384c6a758d248ac3bd', '1423', NULL, '25', NULL, NULL, NULL, '1', '136', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('652', 'f820ad37822976ed11c9aacaaf5e6cb2', '1983', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('653', 'f820ad37822976ed11c9aacaaf5e6cb2', '1977', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('654', 'f820ad37822976ed11c9aacaaf5e6cb2', '3289', NULL, '3', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('655', 'f820ad37822976ed11c9aacaaf5e6cb2', '2934', NULL, '3', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('656', 'f820ad37822976ed11c9aacaaf5e6cb2', '2364', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('658', 'f820ad37822976ed11c9aacaaf5e6cb2', '29', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('659', 'hhjv76ocso2egi0elj6c6l9bvc', '2600', NULL, '5', NULL, NULL, NULL, '1', '137', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('660', '9784db8d0d3c0de7b46b8e29d75b4cfa', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('661', '03b3e5d566ea032ca8e67b4e926e3b7e', '1619', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('662', 'b89f026a537e8d100afe0fc61d6a73f2', '37', NULL, '1', NULL, NULL, NULL, '1', '138', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('663', 'b89f026a537e8d100afe0fc61d6a73f2', '38', NULL, '4', NULL, NULL, NULL, '1', '138', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('664', 'b89f026a537e8d100afe0fc61d6a73f2', '40', NULL, '1', NULL, NULL, NULL, '1', '138', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('665', 'b89f026a537e8d100afe0fc61d6a73f2', '46', NULL, '1', NULL, NULL, NULL, '1', '138', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('666', 'b89f026a537e8d100afe0fc61d6a73f2', '49', NULL, '1', NULL, NULL, NULL, '1', '138', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('667', 'b89f026a537e8d100afe0fc61d6a73f2', '3031', NULL, '4', NULL, NULL, NULL, '1', '138', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('668', 'b89f026a537e8d100afe0fc61d6a73f2', '366', NULL, '1', NULL, NULL, NULL, '1', '138', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('669', 'b89f026a537e8d100afe0fc61d6a73f2', '623', NULL, '8', NULL, NULL, NULL, '1', '138', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('670', 'b89f026a537e8d100afe0fc61d6a73f2', '809', NULL, '1', NULL, NULL, NULL, '1', '138', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('671', 'b89f026a537e8d100afe0fc61d6a73f2', '3409', NULL, '36', NULL, NULL, NULL, '1', '138', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('672', 'b89f026a537e8d100afe0fc61d6a73f2', '3411', NULL, '36', NULL, NULL, NULL, '1', '138', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('673', 'b89f026a537e8d100afe0fc61d6a73f2', '2086', NULL, '24', NULL, NULL, NULL, '1', '138', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('674', '6593980a4ec46a946c1539c281987eb6', '916', NULL, '2', NULL, NULL, NULL, '1', '139', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('675', '6593980a4ec46a946c1539c281987eb6', '3463', NULL, '8', NULL, NULL, NULL, '1', '139', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('676', '6593980a4ec46a946c1539c281987eb6', '721', NULL, '2', NULL, NULL, NULL, '1', '139', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('677', '6593980a4ec46a946c1539c281987eb6', '722', NULL, '2', NULL, NULL, NULL, '1', '139', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('678', 'c0b5027e19498dcdb73f02355c98a8e0', '3078', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('679', '48bec2e71db2b558e2a7f14e4c8a0a61', '1428', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('680', '0a790bda7cc88b287f68b8cffb6fc35e', '1283', NULL, '5', NULL, NULL, NULL, '1', '140', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('681', '7bb7d6197b32b93abc5fd028b31a8837', '29', NULL, '1', NULL, NULL, NULL, '1', '141', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('682', '7bb7d6197b32b93abc5fd028b31a8837', '2364', NULL, '1', NULL, NULL, NULL, '1', '141', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('683', '7bb7d6197b32b93abc5fd028b31a8837', '3289', NULL, '3', NULL, NULL, NULL, '1', '141', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('684', '7bb7d6197b32b93abc5fd028b31a8837', '2934', NULL, '3', NULL, NULL, NULL, '1', '141', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('685', '7bb7d6197b32b93abc5fd028b31a8837', '622', NULL, '1', NULL, NULL, NULL, '1', '141', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('686', '7bb7d6197b32b93abc5fd028b31a8837', '616', NULL, '1', NULL, NULL, NULL, '1', '141', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('687', '4cde28ef6b8cf8c307800e1f60b210b2', '425', NULL, '1', NULL, NULL, NULL, '1', '142', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('688', '4cde28ef6b8cf8c307800e1f60b210b2', '430', NULL, '1', NULL, NULL, NULL, '1', '142', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('689', '185033780609610609df3423d1af44cc', '666', NULL, '1', NULL, NULL, NULL, '1', '143', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('690', '185033780609610609df3423d1af44cc', '1286', NULL, '10', NULL, NULL, NULL, '1', '143', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('691', '61b715554f286f5c38687831e5841851', '698', NULL, '2', NULL, NULL, NULL, '1', '144', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('692', '61b715554f286f5c38687831e5841851', '3495', NULL, '2', NULL, NULL, NULL, '1', '144', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('693', '61b715554f286f5c38687831e5841851', '3290', NULL, '10', NULL, NULL, NULL, '1', '145', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('694', '8c82bf4dc1c15e64e7d0636b8232f78d', '3575', NULL, '1', NULL, NULL, NULL, '1', '146', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('695', '8c82bf4dc1c15e64e7d0636b8232f78d', '3545', NULL, '1', NULL, NULL, NULL, '1', '146', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('696', '8c82bf4dc1c15e64e7d0636b8232f78d', '2041', NULL, '1', NULL, NULL, NULL, '1', '146', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('697', '373108595dde27fe7a4f864b9ccfe812', '2406', NULL, '10', NULL, NULL, NULL, '1', '147', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('698', 'd6c56a5baea25970ee07fabfb562b6d3', '916', NULL, '2', NULL, NULL, NULL, '1', '148', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('699', '7b1ffda44a34d18e4af9aca9b0f869b7', '2406', NULL, '12', NULL, NULL, NULL, '1', '149', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('700', 'e55e84e33dfb65e2403f4df8bd1f9a6b', '804', NULL, '1', NULL, NULL, NULL, '1', '150', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('701', 'e55e84e33dfb65e2403f4df8bd1f9a6b', '660', NULL, '4', NULL, NULL, NULL, '1', '150', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('702', 'e55e84e33dfb65e2403f4df8bd1f9a6b', '659', NULL, '5', NULL, NULL, NULL, '1', '150', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('703', 'fdb4a59673eee9010336327bac51be35', '809', NULL, '3', NULL, NULL, NULL, '1', '151', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('704', 'a054769fed6e20a9ebe162f253324d70', '2943', NULL, '21', NULL, NULL, NULL, '1', '152', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('705', 'a5396ebfed5caa6bffb8442f139d4d61', '2869', NULL, '1', NULL, NULL, NULL, '1', '153', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('706', 'a5396ebfed5caa6bffb8442f139d4d61', '2876', NULL, '2', NULL, NULL, NULL, '1', '153', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('707', 'a5396ebfed5caa6bffb8442f139d4d61', '2878', NULL, '2', NULL, NULL, NULL, '1', '153', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('708', '547f88f97f8fba7b17551d2d64df84db', '2405', NULL, '20', NULL, NULL, NULL, '1', '154', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('710', '9c85f4be2c7af20065f039f85bf7a699', '1794', NULL, '200', NULL, NULL, NULL, '1', '155', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('711', '9c85f4be2c7af20065f039f85bf7a699', '1795', NULL, '100', NULL, NULL, NULL, '1', '155', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('712', '6204172524c8af1454a10e36f00f80a3', '37', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('713', '248fa28eaec6cd79c9cc81be2448bbe6', '2075', NULL, '40', NULL, NULL, NULL, '1', '156', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('714', '248fa28eaec6cd79c9cc81be2448bbe6', '3342', NULL, '1', NULL, NULL, NULL, '1', '156', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('715', '248fa28eaec6cd79c9cc81be2448bbe6', '3331', NULL, '2', NULL, NULL, NULL, '1', '156', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('716', 'eb5af8345c54692e9a0d3f5c1018b979', '3067', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('717', 'c7e919a2efdd4f796e41588da53c8985', '2482', NULL, '3', NULL, NULL, NULL, '1', '157', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('718', 'c7e919a2efdd4f796e41588da53c8985', '2490', NULL, '3', NULL, NULL, NULL, '1', '157', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('719', 'c7e919a2efdd4f796e41588da53c8985', '2491', NULL, '5', NULL, NULL, NULL, '1', '157', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('720', 'c7e919a2efdd4f796e41588da53c8985', '2495', NULL, '3', NULL, NULL, NULL, '1', '157', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('721', 'c7e919a2efdd4f796e41588da53c8985', '2498', NULL, '3', NULL, NULL, NULL, '1', '157', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('722', '7d8f0eb191fea011ebcb2deeb6150726', '2731', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('723', 'd8aa1d1e7d32785f286a1702b4c4eda7', '2364', NULL, '4', NULL, NULL, NULL, '1', '158', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('724', 'e8c27b35c51c89f0bddc765a6b9ceec5', '1502', NULL, '2', NULL, NULL, NULL, '1', '159', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('726', 'e8c27b35c51c89f0bddc765a6b9ceec5', '1502', NULL, '2', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('727', '5fc6352cb5ac1d1fe9c68271f65dde79', '3092', NULL, '1', NULL, NULL, NULL, '1', '160', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('728', 'b618f7be25a72f2d196252f718ff2eab', '2364', NULL, '2', NULL, NULL, NULL, '1', '161', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('729', '8486beb8ee7fd2c1b788bde6a351bfca', '3092', NULL, '1', NULL, NULL, NULL, '1', '162', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('730', '11bff1471815362a545cd1aacbc47e0f', '381', NULL, '5', NULL, NULL, NULL, '1', '163', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('731', '11bff1471815362a545cd1aacbc47e0f', '1792', NULL, '40', NULL, NULL, NULL, '1', '163', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('732', '11bff1471815362a545cd1aacbc47e0f', '606', NULL, '1', NULL, NULL, NULL, '1', '163', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('733', '868639576c8b2dd53aff97a04846178f', '98', NULL, '1', NULL, NULL, NULL, '1', '164', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('734', 'e5ea4a9ed7ca272aac1e1086475bbbeb', '731', NULL, '1', NULL, NULL, NULL, '1', '165', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('735', 'e5ea4a9ed7ca272aac1e1086475bbbeb', '3451', NULL, '12', NULL, NULL, NULL, '1', '165', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('738', 'f263bc5ce1f5ca25d1de1be532152552', '2405', NULL, '10', NULL, NULL, NULL, '1', '166', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('739', 'f263bc5ce1f5ca25d1de1be532152552', '2415', NULL, '10', NULL, NULL, NULL, '1', '166', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('741', '29de5b89237f5c93b9e846b547257203', '297', NULL, '1', NULL, NULL, NULL, '1', '167', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('742', 'ae05faad9c74bc9c4eced5dd3f44d40c', '1', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('745', 'eb36b826afabb6f16f6d9b44aff99ff1', '624', NULL, '1', NULL, NULL, NULL, '1', '168', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('746', 'eb36b826afabb6f16f6d9b44aff99ff1', '625', NULL, '1', NULL, NULL, NULL, '1', '168', NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('747', 'ca0e5d80f6a7c59982103726c6a4720c', '3776', NULL, '5', NULL, NULL, NULL, '0', NULL, NULL);
INSERT INTO `baskets1` (`basketID`, `basketSession`, `productID`, `productPrice`, `productQty`, `product_weight`, `pcode`, `rid`, `status`, `order_id`, `mem_id`) VALUES ('749', '3ca5bc8615af7aefb44fe033fb283250', '3558', NULL, '1', NULL, NULL, NULL, '0', NULL, NULL);


#
# TABLE STRUCTURE FOR: brand
#

DROP TABLE IF EXISTS `brand`;

CREATE TABLE `brand` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `brand_name` varchar(30) NOT NULL,
  `brand_desc` varchar(255) DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `company` tinyint(1) NOT NULL DEFAULT '1',
  `delete_status` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=71 DEFAULT CHARSET=latin1;

INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('1', 'ACETEQ', 'WP pH Meter, WP TDS Meter, WP Conductivity Meter, Multiparameter, IR Thermometer', '1647161246643516c3500cc.jpg', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('2', 'AGATE', NULL, '15010714162ad98620e170.png', '1', '1');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('3', 'ANTECH', 'Ultrasonic Cleaner, Magnetic Stirrer with Hot Plate, 10-Channel Magnetic Stirrer', '198607129962b6e9bfb8e85.jpg', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('4', 'ATAGO', 'Portable Refractometer,Brix/Salinity Meter,Abbe Refractometer, Frying oil Monitor', '4.png', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('5', 'BARIGO', 'Barometer Analog Metal frame', '43561512262ad95bd9ffad.png', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('6', 'BLUESTAR', 'Cover Glasses, Plain Micro Slides, Frosted Slides, Cavity Slides, Printed Slides', '6.png', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('7', 'EUTECH', 'Water Testing Instruments pH, TDS, Conductivity,Ion,Turbidity Meter, Multiparameter and Buffer Solutions', '7.png', '2', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('8', 'GENERAL', 'Agate Mortar & Pestel,Diffraction Grating, Flow Cup Viscometer, Desiccators,Petri Dish, Stop watch, Timers, Silicone Grease, Thermo Hygrometer, Thermometer', '214384218362ad615632bda.png', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('9', 'GL150', NULL, '158973250062ad98a9150d3.png', '1', '1');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('10', 'GLOLAB', 'Pharma lab equipment\'s, Tablet Hardness Tester,Friability,Disintegration,Tab Density ,Leak Test Apparatus, Electomagnetic Sieve Shaker', '10.png', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('11', 'GLOLINE', 'Micropipettes Economic series and Prime series Fixed/ Variable, Multi Channel Micropipettes', '11.png', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('12', 'GLOSIL SILICAWARE', 'Silica Crucible with Lid Low & Tall form, Silica Basin, Silica Capsules, Casing Index, Volumetric Crucible, Silica Boats, Triangles, Muffle Tray', '16865659562b6cb3a1e854.png', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('13', 'GLOSIL TEFLONWARE', 'Magnetic Paddles, Petri Dish, Funnel, Conical Flask, Watch Glass, Crucible, Evaporating Dishes, Beaker', '13.png', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('14', 'GLOSON', 'Test Sieves Brass & SS, Perforated Test Sieves, Test Sieve Shaker', '14.png', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('15', 'GLOVISION', 'Autoclave, Incubator, Hot Air Oven, Hot Plate,Heating Mantle, Jar Test Apparatus, IR Moisture Balance, Orbital Shaker, Rotary Evaporator,UV Cabinet, Vacuum Pump, Water Bath, Petroleum Instruments', '15.png', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('16', 'HANNA', 'Water Testing Instruments pH Meter, TDS Meter, Conductivity Meter, Multiparameter', '16.png', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('17', 'HBG', 'Heamometer, Heamocytometer, Counting Chamber, RBC,WBC Pipette, Wintrobe Tube, ESR Tube', '17.png', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('18', 'HM', NULL, '18.png', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('19', 'INSIZE', NULL, '19.png', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('20', 'JAYANT', 'Test Sieves, Sieve Shaker', '20.png', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('21', 'KUMAR', NULL, '158843177562ad96b7de0a2.png', '1', '1');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('22', 'LABOHOLIC', NULL, '22.png', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('23', 'LARK', 'Cuvettes', '23.png', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('24', 'LEIMCO', 'Hydrometer', '24.png', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('25', 'LOVIBOND', NULL, '25.png', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('26', 'LUTRON', NULL, '26.png', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('27', 'METRAVI', NULL, '27.png', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('28', 'MICROLIT', NULL, '28.png', '2', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('29', 'MITUTOYO', NULL, '52506452962ad95caad808.png', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('30', 'OLYMPUS', NULL, '30.png', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('31', 'POLYLAB', NULL, '62646686062ad95d17a514.png', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('32', 'RAYSCOPE', 'Microscope', '32.png', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('33', 'REMI', NULL, '33.png', '2', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('34', 'RICO', NULL, '210654891662ad95dfea09f.png', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('35', 'SAFFRON', NULL, '35.png', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('36', 'SGE', NULL, '36.png', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('37', 'SHIMADZU', NULL, '37.png', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('38', 'SILICON RUBBER TUBING', NULL, '38.png', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('39', 'STANDARD', NULL, '39.png', '1', '1');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('40', 'SUPERIOR', NULL, '8872102262b6e9b11cd0e.jpg', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('41', 'SWASTIK', NULL, '41.png', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('42', 'TESTO', NULL, '42.png', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('43', 'TOP TECH', NULL, '43.png', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('44', 'CYTIVA WHATMAN', '', '44.png', '2', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('45', 'WORKZONE', NULL, '69164724462ad985d2a4e5.png', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('46', 'GLOSIL HYDROMETER', 'Specific Gravity Hydrometer, Baume, Brix, Soil Hydrometer, Alcohol Meter, Lactometer, Urinometer, Sikes,Twaddle', '124672791162b6da30ad586.jpg', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('47', 'GLOSIL THERMOMETER', 'Alcohol and Mercury Thermometer, Long Stem Thermometer', '63084221162b6da50d27dd.jpg', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('48', 'HAMILTON', 'Liquid Handling Products, Fixed & Removable Needle Syringes', '103530939862c2b5f50c3b8.jpg', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('49', 'DIMPLE', 'Thermometer', '1616600531631198f2d8957.jpg', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('50', 'ROCKER', 'Laboratory Vacuum Pumps, Laboratory Filtration, Life Sciences, Water Analysis, Ultrasonic Cleaner ', '737099212632d4c18a8868.jpeg', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('51', 'ARICO', 'Bomb Calorimeter', '189925163863216f155ca14.jpeg', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('52', 'AQUASOL', 'Test Kits', '1601588114632af1be90712.jpg', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('53', 'DLAB', 'Vortex Mixer, Centrifuges, Rotary Evaporator, Dry Bath and Magnetic Stirrer with Hot plate  ', '137667491963511ea3dc13b.jpg', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('54', 'R-TEK', 'Soil pH, Moisture , Lux, Sound Level, CO2 , Temp, Humidity ', '70561748363b9373841029.jpg', '1', '1');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('55', 'HTC', 'Lux meter, Sound Level Meter, Anemometer, Vibration Meter, Th/Hyg Meter, Digital Thermometer, IR Thermometer', '199774878763c8ea23b5667.jpg', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('56', 'LABOMED', 'Microscopes', '27322716763f9a3cb11d6b.jpg', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('57', 'EI-Deep Vision', '', '196467363464f036c713de7.png', '2', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('58', 'LAMY', 'B-One Plus Viscometer', '212388643466080494e3b09.jpg', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('59', 'ROHEM', '', '30560305666d8617180c3d.jpg', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('60', 'ZEAL', '', '211416823966d86169be2dc.jpg', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('61', 'TRUEDENSE', 'Cuvettes', '112551648663892ce93f7a.jpg', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('62', 'BENNY IMPEX', 'Benny Impex is a renowned manufacturer and supplier of high-quality milk testing equipment, dedicated to ensuring the purity and quality of milk products. Their extensive product line includes advanced milk analyzers, lactometers, milkotesters, and portab', NULL, '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('63', 'CYTIVA - PALL', 'PALL ', '147949484966ffcf9ea0d6f.png', '2', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('64', 'WEIGHPRO', 'Weigh Pro specializes in high-precision analytical balances, delivering exceptional accuracy and reliability for laboratories, research, and industrial applications. Our advanced weighing solutions are designed to meet the stringent demands of professiona', '202869741666d6ad53ec20c.jpg', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('65', 'MILWAUKEE', 'Refractometer', '63684089467988b30bd2c2.png', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('66', 'ADVANCE', 'ADVANCE', NULL, '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('67', 'ERMA', 'Refractometer', '367181419685e34bad3abc.jpg', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('68', 'GOLEY', '', NULL, '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('69', 'FOUR E', 'Four E Scientific is a trusted manufacturer of high-quality laboratory instruments and equipment, known for innovation, precision, and reliability. Their products are designed to meet the needs of research, education, and industrial laboratories worldwide', '196044021689b1675ef2f3.jpeg', '1', '0');
INSERT INTO `brand` (`id`, `brand_name`, `brand_desc`, `image`, `company`, `delete_status`) VALUES ('70', 'PROMIVAC', '', NULL, '1', '0');


#
# TABLE STRUCTURE FOR: category
#

DROP TABLE IF EXISTS `category`;

CREATE TABLE `category` (
  `category_id` mediumint(8) NOT NULL AUTO_INCREMENT COMMENT 'Primary key',
  `category_code` varchar(55) NOT NULL,
  `category_name` varchar(255) NOT NULL,
  `image` varchar(50) DEFAULT NULL,
  `delete_status` int(2) DEFAULT '0',
  `status` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`category_id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=latin1;

INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `image`, `delete_status`, `status`) VALUES ('1', '', 'A', 'A.jpg', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `image`, `delete_status`, `status`) VALUES ('2', '', 'B', 'B.jpg', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `image`, `delete_status`, `status`) VALUES ('3', '', 'C', 'C.jpg', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `image`, `delete_status`, `status`) VALUES ('4', '', 'D', 'D.jpg', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `image`, `delete_status`, `status`) VALUES ('5', '', 'E', 'E.jpg', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `image`, `delete_status`, `status`) VALUES ('6', '', 'F', 'F.jpg', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `image`, `delete_status`, `status`) VALUES ('7', '', 'G', 'G.jpg', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `image`, `delete_status`, `status`) VALUES ('8', '', 'H', 'H.jpg', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `image`, `delete_status`, `status`) VALUES ('9', '', 'I', 'I.jpg', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `image`, `delete_status`, `status`) VALUES ('10', '', 'J', 'J.jpg', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `image`, `delete_status`, `status`) VALUES ('11', '', 'K', 'K.jpg', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `image`, `delete_status`, `status`) VALUES ('12', '', 'L', 'L.jpg', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `image`, `delete_status`, `status`) VALUES ('13', '', 'M', 'M.jpg', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `image`, `delete_status`, `status`) VALUES ('14', '', 'N', 'N.jpg', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `image`, `delete_status`, `status`) VALUES ('15', '', 'O', 'O.jpg', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `image`, `delete_status`, `status`) VALUES ('16', '', 'P', 'P.jpg', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `image`, `delete_status`, `status`) VALUES ('17', '', 'Q', 'Q.jpg', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `image`, `delete_status`, `status`) VALUES ('18', '', 'R', 'R.jpg', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `image`, `delete_status`, `status`) VALUES ('19', '', 'S', 'S.jpg', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `image`, `delete_status`, `status`) VALUES ('20', '', 'T', 'T.jpg', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `image`, `delete_status`, `status`) VALUES ('21', '', 'U', '133829881562ebafe882352.jpg', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `image`, `delete_status`, `status`) VALUES ('22', '', 'V', 'V.jpg', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `image`, `delete_status`, `status`) VALUES ('23', '', 'W', 'W.jpg', '0', '1');
INSERT INTO `category` (`category_id`, `category_code`, `category_name`, `image`, `delete_status`, `status`) VALUES ('24', 'CAT-000024', 'X1', NULL, '1', '1');


#
# TABLE STRUCTURE FOR: colour
#

DROP TABLE IF EXISTS `colour`;

CREATE TABLE `colour` (
  `colour_id` mediumint(8) NOT NULL AUTO_INCREMENT COMMENT 'Primary key',
  `colour_code` varchar(55) NOT NULL,
  `colour_name` varchar(255) NOT NULL,
  `delete_status` int(2) DEFAULT '0',
  `status` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`colour_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=latin1;

INSERT INTO `colour` (`colour_id`, `colour_code`, `colour_name`, `delete_status`, `status`) VALUES ('1', 'C-000001', 'Beige', '0', '1');
INSERT INTO `colour` (`colour_id`, `colour_code`, `colour_name`, `delete_status`, `status`) VALUES ('2', 'C-000002', 'Black', '0', '1');
INSERT INTO `colour` (`colour_id`, `colour_code`, `colour_name`, `delete_status`, `status`) VALUES ('3', 'C-000003', 'Blue', '0', '1');
INSERT INTO `colour` (`colour_id`, `colour_code`, `colour_name`, `delete_status`, `status`) VALUES ('4', 'C-000004', 'Brown', '0', '1');
INSERT INTO `colour` (`colour_id`, `colour_code`, `colour_name`, `delete_status`, `status`) VALUES ('5', 'C-000005', 'Green', '0', '1');
INSERT INTO `colour` (`colour_id`, `colour_code`, `colour_name`, `delete_status`, `status`) VALUES ('6', 'C-000006', 'Gray', '0', '1');
INSERT INTO `colour` (`colour_id`, `colour_code`, `colour_name`, `delete_status`, `status`) VALUES ('7', 'C-000007', 'Magenta', '0', '1');
INSERT INTO `colour` (`colour_id`, `colour_code`, `colour_name`, `delete_status`, `status`) VALUES ('8', 'C-000008', 'Multicolor', '0', '1');
INSERT INTO `colour` (`colour_id`, `colour_code`, `colour_name`, `delete_status`, `status`) VALUES ('9', 'C-000009', 'Orange', '0', '1');
INSERT INTO `colour` (`colour_id`, `colour_code`, `colour_name`, `delete_status`, `status`) VALUES ('10', 'C-000010', 'Pink', '0', '1');
INSERT INTO `colour` (`colour_id`, `colour_code`, `colour_name`, `delete_status`, `status`) VALUES ('11', 'C-000011', 'Red', '0', '1');
INSERT INTO `colour` (`colour_id`, `colour_code`, `colour_name`, `delete_status`, `status`) VALUES ('12', 'C-000012', 'Violet', '0', '1');
INSERT INTO `colour` (`colour_id`, `colour_code`, `colour_name`, `delete_status`, `status`) VALUES ('13', 'C-000013', 'White', '0', '1');
INSERT INTO `colour` (`colour_id`, `colour_code`, `colour_name`, `delete_status`, `status`) VALUES ('14', 'C-000014', 'Yellow', '0', '1');
INSERT INTO `colour` (`colour_id`, `colour_code`, `colour_name`, `delete_status`, `status`) VALUES ('15', 'C-000015', 'Ivory', '0', '1');


#
# TABLE STRUCTURE FOR: company_settings
#

DROP TABLE IF EXISTS `company_settings`;

CREATE TABLE `company_settings` (
  `id` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `site_short_name` varchar(20) NOT NULL,
  `gstin` varchar(16) DEFAULT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(20) NOT NULL,
  `tan_no` varchar(20) DEFAULT NULL,
  `cst_reg_no` varchar(20) DEFAULT NULL,
  `excise_reg_no` varchar(20) DEFAULT NULL,
  `lbt_reg_no` varchar(20) DEFAULT NULL,
  `servicetax_reg_no` varchar(20) DEFAULT NULL,
  `cin` varchar(20) DEFAULT NULL,
  `gst_registration_type` varchar(30) DEFAULT NULL,
  `street` varchar(150) NOT NULL,
  `city_id` int(11) NOT NULL COMMENT 'Foreign Key',
  `state_id` int(11) NOT NULL COMMENT 'Foreign Key',
  `state_code` varchar(2) DEFAULT NULL,
  `zip_code` varchar(10) DEFAULT NULL,
  `country_id` int(11) NOT NULL COMMENT 'Foreign Key',
  `default_language` varchar(20) DEFAULT NULL,
  `default_currency` varchar(10) DEFAULT NULL,
  `logo` varchar(100) DEFAULT NULL,
  `terms_condition` text,
  `bank_name` varchar(50) DEFAULT NULL,
  `account_no` varchar(50) DEFAULT NULL,
  `branch_ifsccode` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `company_settings` (`id`, `name`, `site_short_name`, `gstin`, `email`, `phone`, `tan_no`, `cst_reg_no`, `excise_reg_no`, `lbt_reg_no`, `servicetax_reg_no`, `cin`, `gst_registration_type`, `street`, `city_id`, `state_id`, `state_code`, `zip_code`, `country_id`, `default_language`, `default_currency`, `logo`, `terms_condition`, `bank_name`, `account_no`, `branch_ifsccode`) VALUES ('1', '', '', '24XXXXXXXXXXZ5', '', '', '0', '0', '', '', '', '', 'Unregistered', '', '0', '0', NULL, NULL, '0', '', '1', NULL, '<p><span style=\"font-size:16px\"><span style=\"color:#f39c12\"><strong>&nbsp; &nbsp;</strong></span><strong>NEW UPDATES 2025</strong></span></p>\r\n\r\n<ul>\r\n	<li><span style=\"font-size:16px\"><span style=\"color:#f39c12\"><strong>HANNA PRICE REVISED FROM APRIL 2025</strong></span></span></li>\r\n	<li><span style=\"font-size:16px\"><span style=\"color:#f39c12\"><strong>GLOSIL SILICAWARE PRICE REVISED FROM APRIL 2025</strong></span></span></li>\r\n	<li><span style=\"font-size:16px\"><span style=\"color:#f39c12\"><strong>EUTECH PRICE REVISED FROM APRIL 2025</strong></span></span></li>\r\n	<li><span style=\"font-size:16px\"><span style=\"color:#f39c12\"><strong>SAFFRON / SHIMADZU PRICE REVISED FROM APRIL 2025</strong></span></span></li>\r\n	<li><span style=\"font-size:16px\"><span style=\"color:#f39c12\"><strong>INSIZE PRICE REVISED FROM APRIL 2025</strong></span></span></li>\r\n	<li><span style=\"font-size:16px\"><span style=\"color:#f39c12\"><strong>LABOHOLIC PRICE REVISED FROM APRIL 2025</strong></span></span></li>\r\n	<li><span style=\"font-size:16px\"><span style=\"color:#f39c12\"><strong>CYTIVA WHATMAN PRICE REVISED FROM APRIL 2025</strong></span></span></li>\r\n	<li><span style=\"font-size:16px\"><span style=\"color:#f39c12\"><strong>ROCKER PRICE REVISED FROM APRIL 2025</strong></span></span></li>\r\n	<li><span style=\"font-size:16px\"><span style=\"color:#f39c12\"><strong>MICROLIT PRICE REVISED FROM APRIL 2025</strong></span></span><br />\r\n	<br />\r\n	<span style=\"font-size:16px\"><strong>EMAIL UPADTES</strong></span></li>\r\n	<li><span style=\"font-size:16px\"><strong><span style=\"color:#f39c12\">sales@glosilscientific.com - Orders &amp; Sales</span></strong></span></li>\r\n	<li><span style=\"font-size:16px\"><strong><span style=\"color:#f39c12\">enquiries@glosilscientific.com - Enquiries &amp; Quotations</span></strong></span></li>\r\n	<li><span style=\"font-size:16px\"><strong><span style=\"color:#f39c12\">accounts@glosilscientific.com - Accounts</span></strong></span></li>\r\n	<li><span style=\"font-size:16px\"><strong><span style=\"color:#f39c12\">service@glosilscientific.com - Service</span></strong></span></li>\r\n</ul>\r\n', '', '22-07-2022 15:50:49', '');


#
# TABLE STRUCTURE FOR: currency
#

DROP TABLE IF EXISTS `currency`;

CREATE TABLE `currency` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `symbol` char(5) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `currency` (`id`, `name`, `symbol`) VALUES ('1', 'INR', 'INR');
INSERT INTO `currency` (`id`, `name`, `symbol`) VALUES ('2', 'INR', 'INR');


#
# TABLE STRUCTURE FOR: customer
#

DROP TABLE IF EXISTS `customer`;

CREATE TABLE `customer` (
  `customer_id` mediumint(8) NOT NULL AUTO_INCREMENT COMMENT 'Primary key',
  `first_name` varchar(255) DEFAULT NULL,
  `cust_code` varchar(25) DEFAULT NULL,
  `last_name` varchar(255) DEFAULT NULL,
  `city` varchar(20) DEFAULT NULL,
  `contact_no` varchar(50) DEFAULT NULL,
  `email_address` varchar(100) DEFAULT NULL,
  `cpassword` varchar(15) DEFAULT NULL,
  `gst_no` varchar(25) DEFAULT NULL,
  `address` varchar(355) DEFAULT NULL,
  `lorry_no` varchar(25) DEFAULT NULL,
  `transport_name` varchar(255) DEFAULT NULL,
  `trans_contact` varchar(50) DEFAULT NULL,
  `wallet` double DEFAULT '0',
  `activation_code` varchar(100) DEFAULT NULL,
  `mobile_reg_id` text,
  `c_type` tinyint(1) NOT NULL DEFAULT '0',
  `customer_status` int(1) DEFAULT '0',
  `oauth_provider` varchar(255) DEFAULT NULL,
  `oauth_uid` varchar(255) DEFAULT NULL,
  `picture` varchar(255) DEFAULT NULL,
  `link` varchar(255) DEFAULT NULL,
  `insertedat` datetime DEFAULT NULL,
  `updatedat` datetime DEFAULT NULL,
  `delete_date` date DEFAULT NULL,
  `delete_status` int(1) DEFAULT '0',
  PRIMARY KEY (`customer_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5608 DEFAULT CHARSET=latin1;

INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('1', 'GlosilScientific', 'G001', NULL, NULL, '9940079368', 'glosilscientific@gmail.com', 'b5223b2', NULL, NULL, NULL, NULL, NULL, '0', '539390', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-06-21 15:01:15', '2022-06-22 00:00:00', '2022-06-29', '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('2', 'Glosil Scientific LLP', 'G002', NULL, NULL, '8148556619', 'viki.6103@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, '0', '284200', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-06-21 15:05:21', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('3', 'Glosil Scientific LLP', 'G003', NULL, NULL, '8148556619', 'viki.6103@gmail.com', 'cf8427e', NULL, NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-06-21 15:34:55', NULL, '2022-06-29', '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('4', 'Test', 'G004', NULL, NULL, '9876543219', 'Test@test.com', NULL, NULL, NULL, NULL, NULL, NULL, '0', '383611', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-06-21 15:35:33', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('5', 'Glosil Scientific LLP', 'G005', NULL, NULL, '9597212113', 'gomathi.jayavel@gmail.com', 'cf8427e', '', '', NULL, NULL, NULL, '0', '', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-06-21 15:41:03', '2024-10-23 00:00:00', '2024-11-13', '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('6', 'Glosil scientific ', 'G006', NULL, NULL, '7904168144', 'rashmeejain98@gmail.com', '5b3c3ec', NULL, NULL, NULL, NULL, NULL, '0', '494451', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-06-23 10:58:37', NULL, '2022-06-29', '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('7', 'glosil scientific llp', 'G007', NULL, NULL, '9551367250', 'lokeshjayavel1993@gmail.com', 'acfa73d', NULL, NULL, NULL, NULL, NULL, '0', '490634', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-06-23 15:43:03', NULL, '2022-06-29', '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('8', 'Goldmine Infotech', 'G008', NULL, NULL, '9940044291', 'goldmineinfotech@gmail.com', 'cf8427e', '', '', NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-06-23 17:28:15', '2022-06-30 00:00:00', NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('9', 'Gomathi sci', 'G009', NULL, NULL, '9597212114', 'gomathisci@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, '0', '116183', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-06-24 12:17:41', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('10', 'Test', 'G010', NULL, NULL, '9898989898', 'test@gmail.com', NULL, '33BUUPS6048F1Z4', NULL, NULL, NULL, NULL, '0', '813918', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-06-29 12:42:00', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('11', 'GLOSIL SCIENTIFIC LLP', 'G011', NULL, NULL, '7305830501', 'info@glosilscientific.com', '13c07ad', '33AAVFG4998G1ZP', '', NULL, NULL, NULL, '0', '828326', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-06-29 14:42:30', '2022-07-01 00:00:00', NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('12', 'GLOSIL', 'G012', NULL, NULL, '7904168143', 'rashmeejain98@gmail.com', NULL, 'â€‹33AAVFG4998G1ZP', NULL, NULL, NULL, NULL, '0', '993312', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-06-30 11:51:09', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('13', 'PRAXOR INSTRUMENTS AND SCIENTIFIC CO', 'G013', NULL, NULL, '9788000777', 'PRAVEENPROXOR@GMAIL.COM', 'cf8427e', '33BPRPP0829K1ZG', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 11:22:37', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('14', 'Sri Ram scientific Traders', 'G014', NULL, NULL, '8838260562', 'sriramscientifictraders@gmail.com', NULL, '33AMQPD1286K1ZV', NULL, NULL, NULL, NULL, '0', '659753', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-07-01 11:35:31', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('15', 'Sri Ram scientific Traders', 'G015', NULL, NULL, '8838260562', 'sriramscientifictraders@gmail.com', 'cf8427e', '33AMQPD1286K1ZV', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 11:37:45', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('16', 'Sri ram Scientific Traders', 'G016', NULL, NULL, '8838260562', 'sriramscientifictraders@gmail.com', NULL, '33AMQPD1286K1ZV', NULL, NULL, NULL, NULL, '0', '147345', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-07-01 11:39:18', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('17', 'GENESYS INC', 'G017', NULL, NULL, '9865126006', 'genesysinccbe@gmail.com', '7fac7f6', '33AAJFG1565H1ZI', NULL, NULL, NULL, NULL, '0', '583414', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 11:45:52', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('18', 'DOLPHIN SCIENTIFIC SOLUTIONS', 'G018', NULL, NULL, '9444411215', 'dolphinmdu@gmail.com', 'cf8427e', '33ADXPR7719M1ZJ', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 11:46:37', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('19', 'Santhosh scientifics private limited', 'G019', NULL, NULL, '8754552365', 'accounts@santhoshscientifics.com', 'bb71e29', '33ABGCS4821B1ZS', NULL, NULL, NULL, NULL, '0', '735951', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 11:50:36', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('20', 'santhosh scientifics private limited', 'G020', NULL, NULL, '9940240809', 'sales@santhoshscientifics.com', 'cf8427e', '33AABCG8774H1ZF', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 12:13:15', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('21', 'MARUTHI TRADER ', 'G021', NULL, NULL, '9840018488', 'maruthitrader@gmail.com', 'cf8427e', '33AAKPE9295R1ZU', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 12:52:15', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('22', 'Janandavel', 'G022', NULL, NULL, '9884319640', 'janandavel88@gmail.com', 'cf8427e', '33strvsp', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 13:06:06', NULL, '2025-08-06', '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('23', 'Hindustan Scientific Companies', 'G023', NULL, NULL, '9842249216', 'hss.scie@gmail.com', '5272546', '33AKKPP7208H2Z', NULL, NULL, NULL, NULL, '0', '848163', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 13:15:48', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('24', 'Analytic Services', 'G024', NULL, NULL, '9840282177', 'analytic.chn@gmail.com', '2493e94', '33AIAPR7684M2ZM', NULL, NULL, NULL, NULL, '0', '469944', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 13:49:57', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('25', 'MEHTA DOSHI & CO', 'G025', NULL, NULL, '9840081813', 'mehtadoshi@gmail.com', 'cf8427e', '33AAAFM1320P1ZJ', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 14:23:19', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('26', 'Kesari scientific chemicals', 'G026', NULL, NULL, '9566180298', 'kesariscientificchemicals@gmail.com', 'cf8427e', '33AYFPJ0434L1ZM', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 14:25:30', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('27', 'Gemco Scientific Company', 'G027', NULL, NULL, '9842822310', 'info@gemcolabs.com', 'cf8427e', '33AAAHE1740B1Z8', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 14:28:21', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('28', 'DFT TECH', 'G028', NULL, NULL, '9789382483', 'dfttechindia@gmail.com', '11db45c', '33ACUPV4864D1Z3', NULL, NULL, NULL, NULL, '0', '545705', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 14:35:23', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('29', 'HERENBA INSTRUMENTS & ENGINEERS', 'G029', NULL, NULL, '9791737778', 'herenbainstruments@gmail.com', 'cf8427e', '33AAHFH8721L1Z6', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 14:36:13', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('30', 'CHENKEM', 'G030', NULL, NULL, '9843010093', 'chenkemenquiry@gmail.com', 'cf8427e', '33BJDPS4809J1Z1', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 14:49:59', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('31', 'THE SCIENTIFIC ENGINEERING WORKS', 'G031', NULL, NULL, '9443388285', 'apthangadurai@gmail.com', 'fe8a5c5', '33AELPT1763J1Z5', NULL, NULL, NULL, NULL, '0', '629174', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 15:05:21', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('32', 'FUTURE LAB', 'G032', NULL, NULL, '9686799080', 'futurelabblr@gmail.com', 'cf8427e', '29BIXPS8766F1Z1', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 15:21:20', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('33', 'Sri Jothi Chemicals', 'G033', NULL, NULL, '9443143003', 'srijothichem@yahoo.com', 'cf8427e', '33AHIPB6093P1ZZ', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 15:35:02', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('34', 'Glosil Scientific LLP', 'G034', NULL, NULL, '7200734670', 'glosilscientific@gmail.com', 'cf8427e', '33AAVFG4998G1ZP', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 16:07:52', NULL, '2024-11-23', '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('35', 'R.R.Scientific Suppliers', 'G035', NULL, NULL, '9840120449', 'rrscientific@yahoo.co.in', 'cf8427e', '33AGKPR1990A1ZI', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 16:12:00', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('36', 'srihari Scientific', 'G036', NULL, NULL, '9952958129', 'srihariscientific2013@gmail.com', 'cf8427e', '33AXRPC9965E1Z4', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 16:14:20', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('37', 'AIC INTERNATIONAL', 'G037', NULL, NULL, '9841020254', 'aicpondy@gmail.com', 'cf8427e', '34AAQFA0099P1ZV', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 16:19:39', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('38', 'Sri Vinayaga scientific', 'G038', NULL, NULL, '9942937099', 'svstrichy2015@gmail.com', 'cf8427e', '33BYQPB9005F1ZM', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 16:20:04', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('39', 'Chemico Glass And Scientific Company', 'G039', NULL, NULL, '9790014545', 'chemicoscientific@yahoo.co.in', 'cf8427e', '33AIMPM9517C1Z9', NULL, NULL, NULL, NULL, '0', '549746', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 17:18:29', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('40', 'NARESH SCIENTIFIC COMPANY', 'G040', NULL, NULL, '9345458671', 'nareshscientific@gmail.com', 'cf8427e', '34ADJPV6994J1ZM', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 17:26:12', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('41', 'VIJAYA SCIENTIFIC COMPANY TNY', 'G041', NULL, NULL, '9884013356', 'salestny@vijayascientific.com', 'fc6e8a2', '33ACPPL8181L1ZZ', NULL, NULL, NULL, NULL, '0', '314103', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 17:46:59', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('42', 'PONMANI & CO.,', 'G042', NULL, NULL, '9486751611', 'ponmanitry@yahoo.co.in', 'cf8427e', '33AAAFP5233C1ZV', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-01 17:49:52', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('43', 'SRI VETRI SCIENTIFIC COMPANY', 'G043', NULL, NULL, '7598595993', 'srivetriscientific@gmail.com', '0368f62', '34AXSPR0788H1ZT', NULL, NULL, NULL, NULL, '0', '685672', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-02 09:17:26', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('44', 'VERTTEX ENTERPRISES', 'G044', NULL, NULL, '9884163463', 'salesverttex@gmail.com', 'bbf617c', '33ACGPL9480R1ZS', NULL, NULL, NULL, NULL, '0', '589936', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-02 09:41:31', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('45', 'zoom scientific instruments', 'G045', NULL, NULL, '9080664331', 'zoomscientificinstruments@gmail.com', 'cf8427e', '33DOVPS6904F1ZG', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-02 10:36:07', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('46', 'zoom scientific instruments', 'G046', NULL, NULL, '9080664331', 'zoomscientificinstruments@gmail.com', NULL, '33DOVPS6904F1ZG', NULL, NULL, NULL, NULL, '0', '787611', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-07-02 10:36:09', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('47', 'CSSC Ltd', 'G047', NULL, NULL, '9986466604', 'csscomds@gmail.com', 'cf8427e', '33AAACC3108Q1ZR', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-02 11:04:52', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('48', 'rakas science house', 'G048', NULL, NULL, '9842421597', 'rakas_kkl@yahoo.com', 'cf8427e', '34gqsps5457k1zt', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-02 11:28:34', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('49', 'LabChems', 'G049', NULL, NULL, '8008688484', 'info@labchems.in', 'cf8427e', '37BCYPP4304F1Z9', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-02 12:18:10', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('50', 'glosil', 'G050', NULL, NULL, '9597212113', 'gomathi.jayavel@gmail.com', 'cf8427e', '33AAVFG4998G1ZP', '', NULL, NULL, NULL, '0', '', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-07-02 12:19:05', '2024-10-23 00:00:00', '2024-11-13', '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('51', 'Unicorn biomedicals', 'G051', NULL, NULL, '9884093060', 'unicornbiomed@gmail.com', NULL, '33AAGFU9694Q1Z2', NULL, NULL, NULL, NULL, '0', '342622', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-07-02 12:43:01', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('52', 'Unicorn biomedicals', 'G052', NULL, NULL, '9884093060', 'unicornbiomed@gmail.com', NULL, '33AAGFU9694Q1Z2', NULL, NULL, NULL, NULL, '0', '744565', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-07-02 12:43:04', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('53', 'MADRAS SCIENTIFIC SUPPLIES', 'G053', NULL, NULL, '9443825217', 'mss.slm1@gmail.com', 'cf8427e', '33AAHFM8015C1ZP', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-02 13:14:37', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('54', 'UNIVERSAL SCIENTIFIC APPLIANCES', 'G054', NULL, NULL, '9842083123', 'usas_2007@yahoo.com', 'cf8427e', '33AQLPJ2492E1X', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-02 14:14:15', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('55', 'Hitech Clean Room Pvt.Ltd.', 'G055', NULL, NULL, '8925433747', 'hitechlaminar@gmail.com', 'cf8427e', '33AADCH2961F1ZV', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-02 15:17:58', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('56', 'Jayam Scientific Company', 'G056', NULL, NULL, '9443899136', 'jayam_14@yahoo.co.in', 'cf8427e', '', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-02 17:52:13', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('57', 'Associated instrument and chemicals', 'G057', NULL, NULL, '9841030204', 'chennai@aicgroup.in', 'cf8427e', '33AAAFA4546M1ZJ', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-02 17:59:10', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('58', 'Bhuvaneswar Scientific Glass Works', 'G058', NULL, NULL, '9566687733', 'bhuvaneswarscientific@gmail.com', '796d789', '33AMZPB6070G1ZX', NULL, NULL, NULL, NULL, '0', '965258', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-03 11:00:27', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('59', 'Nellai scientific company', 'G059', NULL, NULL, '9842426778', 'nellaiscientificcompany@gmail.com', 'cf8427e', '33BCGPM5964C1ZO', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-03 19:47:06', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('60', 'SHANKAR SCIENTIFIC SUPPLIES', 'G060', NULL, NULL, '9962560135', 'sankars.chn@gmail.com', 'cf8427e', '33ALXPS3074J2ZF', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-04 11:02:37', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('61', 'SK ENTERPRISES', 'G061', NULL, NULL, '9941158465', 'skenterprisesjoy@gmial.com', NULL, '33MJTPS6544M1Z0', NULL, NULL, NULL, NULL, '0', '842587', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-07-04 15:55:13', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('62', 'SK ENTERPRISES', 'G062', NULL, NULL, '9941158465', 'skenterprisesjoy@gmial.com', NULL, '33MJTPS6544M1Z0', NULL, NULL, NULL, NULL, '0', '122361', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-07-04 15:58:19', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('63', 'SK ENTERPRISES', 'G063', NULL, NULL, '9941158465', 'skenterprisesjoy@gmail.com', 'cf8427e', '33MJTPS6544M1Z0', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-04 16:00:34', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('64', 'shree scientific company', 'G064', NULL, NULL, '9003060805', 'shreescientificcorp@gmail.com', 'cf8427e', '33BRGPR9488F1Z7', NULL, NULL, NULL, NULL, '0', '923564', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-05 10:52:44', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('65', 'A.G.S.SCIENTIFIC COMPANY', 'G065', NULL, NULL, '9840382223', 'agschrompet@gmail.com', 'cf8427e', '33AAMFA5122F1ZW', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-05 12:20:25', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('66', 'Peculiar', 'G066', NULL, NULL, '6382731948', 'peculiarscientific@gmail.com', 'dbb2086', '33buwps0416b1zq', NULL, NULL, NULL, NULL, '0', '917245', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-05 13:14:28', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('67', 'REYNA MULTIPLE SALES LOHGINS', 'G067', NULL, NULL, '9500483936', 'reynasales2277@gmail.com', 'cf8427e', '33ACLPH6183J1ZD', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-05 16:30:11', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('68', 'Varma Scientific Company', 'G068', NULL, NULL, '9940200313', 'varmascientific@gmail.com', 'cf8427e', '33BVBPM1320E1ZC', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-06 12:20:02', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('69', 'VS Agency', 'G069', NULL, NULL, '9442838160', 'vsagency15@gmail.com', NULL, '33FVZPS5548Q1Z3', NULL, NULL, NULL, NULL, '0', '702649', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-07-06 15:36:51', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('70', 'vsagecy', 'G070', NULL, NULL, '9442838160', 'vsagency15@gmail.com', '9da47cb', '33FVZPS5548Q1Z3', NULL, NULL, NULL, NULL, '0', '712950', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-06 17:31:28', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('71', 'EVERFLOW SCIENTIFIC INSTRUMENTS', 'G071', NULL, NULL, '9444259624', 'everflowscientific@yahoo.com', 'cf8427e', '33AFBPG5986P1ZX', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-07 10:48:05', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('72', 'MSP Laboratory Products & Services', 'G072', NULL, NULL, '9840471455', 'msplabproduct@gmail.com', 'cf8427e', '33CBLPM4502P1ZD', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-07 10:49:05', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('73', 'Aadi Enterprises', 'G073', NULL, NULL, '9974690102', 'toaadienterprises@yahoo.co.in', 'cf8427e', '', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-07 19:11:52', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('74', 'KRINSTRUMENTS', 'G074', NULL, NULL, '9886143298', 'krinstruments@gmail.com', 'cf8427e', '29AFQPM3297J1ZL', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-08 15:32:16', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('75', 'BS TECHNOLOGIES', 'G075', NULL, NULL, '9945068468', 'infobstechnologiesblr@gmail.com', 'd234b70', '29BTMPM1978F1Z4', '360 Dhanushree Apartments, Flat No A-401\r\nJakkasandra 1st Cross,Koramangala 1st Block\r\nBangalore - 560 034', NULL, NULL, NULL, '0', NULL, NULL, '1', '1', NULL, NULL, NULL, NULL, '2022-07-08 00:00:00', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('76', 'Sree Priya Scientific & Co', 'G076', NULL, NULL, '9840333668', 'sreepriyascientific@gmail.com', 'cafff59', '33BOXPP5928N2ZV', NULL, NULL, NULL, NULL, '0', '572240', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-11 17:20:16', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('77', 'SCIENTIFIC SYSTEMS', 'G077', NULL, NULL, '9840721704', 'ss.scientificsystems@gmail.com', 'cf8427e', '33AAFPJ9077K1ZC', NULL, NULL, NULL, NULL, '0', '164124', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-12 10:27:04', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('78', 'KAVIN SCIENTIFIC PRODUCTS', 'G078', NULL, NULL, '9840054224', 'kavinscientific@gmail.com', NULL, '33AQKPP4277G1ZL', NULL, NULL, NULL, NULL, '0', '101829', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-07-12 13:53:04', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('79', 'KAVIN SCIENTIFIC PRODUCTS', 'G079', NULL, NULL, '9840054224', 'kavinscientific@yahoo.co.uk', 'cf8427e', '33AQKPP4277G1ZL', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-12 13:54:31', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('80', 'vijayascientific company', 'G080', NULL, NULL, '9884013709', 'salesmadurai@vijayascientific.com', 'bb14dbb', '33ACPPL8181L1ZZ', NULL, NULL, NULL, NULL, '0', '963995', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-13 10:43:34', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('81', 'SAIRAM SCIENTIFIC', 'G081', NULL, NULL, '9842159043', 'sairamscientific@gmail.com', '7b80585', '33ADAFS0245G1ZK', NULL, NULL, NULL, NULL, '0', '417176', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-13 12:55:30', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('82', 'Sai Associate', 'G082', NULL, NULL, '9841680906', 'saiassociate2009@gmail.com', 'cf8427e', '33BGZPM7917E!ZW', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-13 15:15:24', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('83', 'Biolabs and Life Sciences LLP', 'G083', NULL, NULL, '6380553030', 'customercare@biolabsllp.com', 'cf8427e', '33AASFB6747P1ZN', NULL, NULL, NULL, NULL, '0', '716408', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-13 15:30:55', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('84', 'Synergy Scientific Services', 'G084', NULL, NULL, '7299081480', 'instruments@synergyscientific.in', 'cf8427e', '33AEMPV6474K1ZQ', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-13 16:51:54', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('85', 'Argon Scientific ', 'G085', NULL, NULL, '8943119995', 'info@argonscientific.co.in', 'cf8427e', '32ABXFA5279K1ZS', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-14 17:08:59', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('86', 'GLOBAL SCIENTIFIC COMPANY', 'G086', NULL, NULL, '7708299632', 'globalscientificerd@gmail.com', NULL, '33AYDPT4126D1ZQ ', NULL, NULL, NULL, NULL, '0', '144907', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-07-15 12:21:07', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('87', 'GLOBAL SCIENTIFIC COMPANY', 'G087', NULL, NULL, '7708299632', 'globalscientificerd@gmail.com', NULL, '33AYDPT4126D1ZQ ', NULL, NULL, NULL, NULL, '0', '212688', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-07-15 12:21:09', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('88', 'GLOBAL SCIENTIFIC COMPANY', 'G088', NULL, NULL, '7708299632', 'globalscientificerd@gmail.com', 'cf8427e', '33AYDPT4126D1ZQ ', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-15 12:21:09', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('89', 'M.VKRISHNAARAM LABORATORIES CHEMICALS CO', 'G089', NULL, NULL, '9840702945', 'mvkrishnaaram@yahoo.co.in', '87a3168', '33AADFM4922G1ZL', NULL, NULL, NULL, NULL, '0', '659354', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-15 15:08:46', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('90', 'Glosil Scientific LLP', 'G090', NULL, NULL, '7200734670', 'glosilscientific@gmail.com', 'cf8427e', '33AAVFG4998G1ZP', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-16 11:14:48', NULL, '2024-11-23', '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('91', 'Glosil Scientific LLP', 'G091', NULL, NULL, '7200734670', 'glosilscientific@gmail.com', 'cf8427e', '33AAVFG4998G1ZP', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-16 11:22:03', NULL, '2024-11-23', '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('92', 'Temple way', 'G092', NULL, NULL, '9994293024', 'templeway2020@gmail.com', 'cf8427e', '33BVDPS0491Q2Z0', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-16 23:00:26', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('93', 'Kalro trades ', 'G093', NULL, NULL, '9840500006', 'kalrotrades@gmail.com', 'cf8427e', '33AAAFK0705C1Z9', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-17 10:15:08', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('94', 'universal scientific co', 'G094', NULL, NULL, '9842207200', 'universalscientificcbe@gmail.com', 'cf8427e', '33ADJPT8641G1Z9', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-17 10:46:52', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('95', 'BIOSCIENCE', 'G095', NULL, NULL, '9847695181', 'bioscience641@gmail.com', 'cf8427e', '32AAZFB5266G1Z5', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-18 08:26:29', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('96', 'The Precision Scientific co', 'G096', NULL, NULL, '9843922732', 'psctvl@gmail.com', NULL, '33ACOPC4845P1Z6', NULL, NULL, NULL, NULL, '0', '633399', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-07-18 10:01:23', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('97', 'The Precision Scientific co', 'G097', NULL, NULL, '9843922732', 'psctveli@gmail.com', 'cf8427e', '33ACOPC4845P1Z6', NULL, NULL, NULL, NULL, '0', '321170', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-18 10:02:00', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('98', 'THE SCIENTIFIC UNLIMITED', 'G098', NULL, NULL, '9843059043', 'thescientificunlimited@gmail.com', 'cf8427e', '33MZYPS2699E1Z8', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-18 10:24:52', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('99', 'Royal Scientific Suppliers', 'G099', NULL, NULL, '9443648388', 'royalscientifictry@gmail.com', 'cf8427e', '33ajzpr3621g1zw', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-18 11:55:01', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('100', 'CHITRA SCIENTIFIC INDUSTRIES', 'G100', NULL, NULL, '9962853734', 'chitrascientific@yahoo.com', NULL, '33GTHPM7571N1ZX', NULL, NULL, NULL, NULL, '0', '677681', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-07-18 12:31:38', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('101', 'CHITRA SCIENTIFIC INDUSTRIES', 'G101', NULL, NULL, '9751513734', 'chitrascientific@gmail.com', '69ff72e', '33GTHPM7571N1ZX', NULL, NULL, NULL, NULL, '0', '669233', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-18 12:36:59', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('102', 'Shri Madhii Traders', 'G102', NULL, NULL, '9843053580', 'shrimadhii@yahoo.co.in', 'b1a1d6a', '33AAUPL4305R1Z4', NULL, NULL, NULL, NULL, '0', '961502', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-18 13:34:05', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('103', 'SS INSTRUMENTS', 'G103', NULL, NULL, '9380307375', 'ssinstrumentschennai@gmail.com', 'cf8427e', '33AIWPG2289B1Z8', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-19 09:47:37', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('104', 'ABONDING ', 'G104', NULL, NULL, '9442576397', 'abonding22@gmail.com', 'cf8427e', '33BOOPK1916G1Z1', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-19 16:33:29', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('105', 'INNOVATIONS DIAGNOSTICS', 'G105', NULL, NULL, '9080143346', 'innovationdiagnostics@gmail.com', 'cf8427e', '33AAFFI1699J1Z4', '28-A, P.R.V. Complex, 10/1-2, Kalingarayan Street, \r\nRam Nagar, Coimbatore-641009', NULL, NULL, NULL, '0', '', NULL, '1', '1', NULL, NULL, NULL, NULL, '2022-07-20 00:00:00', '2022-07-20 00:00:00', NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('106', 'Chitra Scientific Industries', 'G106', NULL, NULL, '9962853734', 'chitrascientific@yahoo.com', NULL, '33GTHPM7571N1ZX', NULL, NULL, NULL, NULL, '0', '682146', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-07-21 15:02:38', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('107', 'VIDYA LAB EQUIPMENT AND CHEMICALS', 'G107', NULL, NULL, '9847245885', 'vidyalabclt@gmail.com', 'cf8427e', '32AOUPN1138G1ZX', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-22 18:24:13', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('108', 'Rasayan Trading Co.', 'G108', NULL, NULL, '9884047579', 'rasayantradingco@gmail.com', 'da01f27', '33AAMHA0887M1ZZ', NULL, NULL, NULL, NULL, '0', '913774', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-25 18:08:34', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('109', 'Shree Eshwar scientific company', 'G109', NULL, NULL, '9360243018', 'sesco1sowmi@gmail.com', 'cf8427e', '33AKXPP9496Q1ZK', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-26 17:38:21', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('110', 'Newlab equipment', 'G110', NULL, NULL, '8680040005', 'newlab2005@gmail.com', NULL, '33AHAPT2412J1ZM', NULL, NULL, NULL, NULL, '0', '670747', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-07-27 14:51:19', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('111', 'Chennai Technologies ', 'G111', NULL, NULL, '9940522509', 'chennaitechnologies2019@gmail.com', 'cf8427e', '33GVJPK8020E1ZQ', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-29 11:13:02', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('112', 'Gem scientific co ', 'G112', NULL, NULL, '9600556123', 'Gemscientificcbe@gmail.com', 'cf8427e', '33AAWFG1636L1Z0', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-29 14:49:10', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('113', 'Jsp scientific Indian ', 'G113', NULL, NULL, '9944245251', 'Jspscientific@gmail.com', 'cf8427e', '3AAOFJ5483E1Z5', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-29 15:27:35', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('114', 'Akshara Chemicals ', 'G114', NULL, NULL, '9443260199', 'aksharatirunelveli@gmail.com', NULL, '33ALVPB0166E1ZE', NULL, NULL, NULL, NULL, '0', '548007', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-07-29 15:32:55', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('115', 'Shiv scientific', 'G115', NULL, NULL, '7339673309', 'Shivscientifics@gmail.com', 'cf8427e', '33AUAPR6207L1ZK', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-29 16:14:24', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('116', 'Vikas Scientific Instruments Pvt Ltd ', 'G116', NULL, NULL, '9840785354', 'kamal@vikasgroups.com', 'cf8427e', '33AADCV2027J1ZJ', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-29 16:25:27', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('117', 'Mxrady', 'G117', NULL, NULL, '9350697239', 'mxrady@gmail.com', 'cf8427e', '9278333555', '', NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-30 11:46:47', '2022-08-10 00:00:00', '2022-10-20', '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('118', 'A to z lab needs ', 'G118', NULL, NULL, '9176373650', 'a2zlabneeds@gmail.com', 'cf8427e', '33AAMFA8600L1ZE', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-31 12:57:31', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('119', 'Natural scientific company ', 'G119', NULL, NULL, '9003692152', 'naturalscientificpdy@gmail.com', 'cf8427e', '34FEJPK2006A1Z6', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-31 12:57:33', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('120', 'DEEPA PB', 'G120', NULL, NULL, '8943341568', 'deepamanoj1986@gmail.com', 'cf8427e', '', '', NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-31 13:31:46', '2024-07-27 00:00:00', NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('121', 'EBI LAB INC ', 'G121', NULL, NULL, '9894380990', 'ebilabinc@gmail.com', 'cf8427e', '33AAGPE7378F1ZR', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-31 14:29:08', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('122', 'CROWN CHAKRA LAB INSTRUMENTS AND DIAGNOSTICS ', 'G122', NULL, NULL, '9841721239', 'crownchakralab@gmail.com', 'cf8427e', '33AJSPK7116N1ZP ', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-31 17:49:37', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('123', 'Airavata', 'G123', NULL, NULL, '9415007731', 'airavatagem@gmail.com', 'cf8427e', '09ABOPA5905B2ZY', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-07-31 18:32:11', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('124', 'Ryan scientific', 'G124', NULL, NULL, '9444646372', 'ryanscientific2017@gmail.com', 'cf8427e', '33CURPP1119A1ZX', '', NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-08-01 05:30:24', '2024-07-27 00:00:00', NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('125', 'Suddhama Scientific traders ', 'G125', NULL, NULL, '8667384300', 'suddhamascientifictraders@gmail.com', 'cf8427e', '33abvpe9166f1zc', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-08-01 10:42:08', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('126', 'STAR CHEM', 'G126', NULL, NULL, '9620553589', 'starchemblr@gmail.com', 'cf8427e', '29ARWPT8061F1ZW', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-08-01 12:06:29', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('127', 'STAR CHEM', 'G127', NULL, NULL, '9620553589', 'starchemblr@gmail.com', NULL, '29ARWPT8061F1ZW', NULL, NULL, NULL, NULL, '0', '535104', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-08-01 12:06:30', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('128', 'Aston Fine Chem', 'G128', NULL, NULL, '8056066763', 'afcchennai2003@gmail.com', 'cf8427e', '33AARFA7682B1ZE', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-08-02 10:07:38', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('129', 'vels scientific & Instruments', 'G129', NULL, NULL, '9884444258', 'velsscientific@gmail.com', '7e87d47', '33AJOPV9710D1ZZ', NULL, NULL, NULL, NULL, '0', '109001', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-08-03 18:47:34', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('130', 'Sri Mahaalakshmi Scientific Company', 'G130', NULL, NULL, '9842821339', 'smsccbe@gmail.com', 'cf8427e', '33AESFS9774H1Z6', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-08-04 16:38:19', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('131', 'Proline Instruments and Equipment Co ', 'G131', NULL, NULL, '9244206222', 'kumartr@ymail.com', 'cf8427e', '33AXRPK9632L1ZT ', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-08-04 19:18:26', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('132', 'Bharat Instruments', 'G132', NULL, NULL, '9841821719', 'bharatinstruments.electonics@gmail.com', 'd234b70', '', 'A.M Towers, No.36/239, Alagappa Naicken Street, Mannady\r\nChennai - 600 001 ', NULL, NULL, NULL, '0', NULL, NULL, '1', '1', NULL, NULL, NULL, NULL, '2022-08-05 00:00:00', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('133', 'VASA SCIENTIFIC CO', 'G133', NULL, NULL, '9844011371', 'counter@vasascientific.in', 'cf8427e', '29AAMPP7088B1Z8', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-08-05 14:12:36', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('134', 'JEYAM SCIENTIFIC CO PVT LTD', 'G134', NULL, NULL, '9790935698', 'jscco.sas@gmail.com', '70a6ed8', '33AAACJ0855F1ZZ', 'Old No.13 New No.25, 2nd Cross Street,\r\nRamaKrishna Nagar, Raja Annamalaipuram,\r\nChennai-600028.', NULL, NULL, NULL, '0', '554106', NULL, '1', '1', NULL, NULL, NULL, NULL, '2022-08-05 00:00:00', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('135', 'EPS Biosolutions ', 'G135', NULL, NULL, '9941395080', 'ashok@epsbiosolutions.com', '4c84a5f', '33AACFE6561G1ZN ', NULL, NULL, NULL, NULL, '0', '404792', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-08-06 11:26:45', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('136', 'YSP SCIENTIFIC SOLUTIONS', 'G136', NULL, NULL, '7338721875', 'yspscientific@gmail.com', 'cf8427e', '33AACFY1791J1ZY', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-08-06 14:35:57', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('137', 'Jayanth brothers', 'G137', NULL, NULL, '9952974450', 'jpjthbrs@gmail.com', 'cf8427e', '33AADFJ1380K1ZH', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-08-08 13:29:54', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('138', 'SALEM SCIENTIFIC SUPPLIERS ', 'G138', NULL, NULL, '9843035891', 'vasanth@salemscientific.com', 'f65353d', '33ACEPV6866H1Z5', NULL, NULL, NULL, NULL, '0', '946914', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-08-08 15:35:04', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('139', 'TMC Associates', 'G139', NULL, NULL, '9176614859', 'tmcassociates@yahoo.com', 'cf8427e', '33AYQPS6028L2ZR', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-08-08 18:16:14', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('140', 'Galaxy Scientific Company', 'G140', NULL, NULL, '9487259741', 'galaxyvlr@yahoo.com', NULL, '33AVOPS5666H1ZZ', NULL, NULL, NULL, NULL, '0', '557121', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-08-09 11:33:57', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('141', 'Galaxy Scientific Company', 'G141', NULL, NULL, '9487259741', 'galaxyvlr@yahoo.com', '6e10f90', '33AVOPS5666H1ZZ', NULL, NULL, NULL, NULL, '0', '646998', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-08-09 11:39:26', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('142', 'apex service and instruments', 'G142', NULL, NULL, '9940533076', 'velan.natesan@gmail.com', 'cf8427e', '33AVBPV1367M1Z8', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-08-09 12:00:36', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('143', 'ALPHA TECHNOLOGIES', 'G143', NULL, NULL, '9444087961', 'info@alphatechnologiesindia.com', 'cf8427e', '33ALIPR4240E1ZC', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-08-09 16:01:26', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('144', 'sri ganesh life sciences', 'G144', NULL, NULL, '6381610894', 'sglssales@gmail.com', 'cf8427e', '33BKCPS1370Q1ZS', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-08-10 15:41:16', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('145', 'National Scientific Products', 'G145', NULL, NULL, '9949515872', 'nspvja@gmail.com', 'cf8427e', '37AGRPJ3860E1Z6', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-08-10 16:17:18', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('146', 'Modern Scientific Company ', 'G146', NULL, NULL, '9344444670', 'msco2004@gmail.com', NULL, '33AAAaFM1070E1ZZ', NULL, NULL, NULL, NULL, '0', '902497', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-08-12 19:24:30', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('147', 'PSV EQUIPMENTS', 'G147', NULL, NULL, '7418394102', 'psvequipments@gmail.com', 'cf8427e', '33EOIPS898C1ZP', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-08-13 12:46:55', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('148', 'MS SCIENTIFIC CHEMICALS AND INSTRUMENTS', 'G148', NULL, NULL, '7092301040', 'msscientificinstruments@gmail.com', 'cf8427e', '33BGNPS7634C1Z8', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-08-15 17:51:51', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('149', 'Quesst International ', 'G149', NULL, NULL, '9845847070', 'info@quesstinternational.com', NULL, '29AAAFQ2722R1ZS', NULL, NULL, NULL, NULL, '0', '280614', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-08-15 20:33:57', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('150', 'Uma Scientific Suppliers', 'G150', NULL, NULL, '9790083814', 'umascientificsupplier@gmail.com', 'cf8427e', '9790083814', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-08-16 13:35:56', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('151', 'ADVANCE SCIENTIFIC CENTRE', 'G151', NULL, NULL, '9977998215', 'advancescientificc@yahoo.com', 'cf8427e', '23AADPH2719J1Z0', '', NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-08-16 14:34:20', '2022-08-16 00:00:00', NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('152', 'THE GEMINI SCIENTIFIC COMPANY', 'G152', NULL, NULL, '9840283839', 'gemcogks@yahoo.in', 'cf8427e', '33AAJFT8451H1ZY', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-08-16 16:02:46', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('153', 'QUESST INTERNATIONAL ', 'G153', NULL, NULL, '7022031133', 'quesst.international@yahoo.com', NULL, '29AAAFQ2722R1ZS', NULL, NULL, NULL, NULL, '0', '334733', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-08-17 15:41:05', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('154', 'QUESST INTERNATIONAL ', 'G154', NULL, NULL, '7022031133', 'quesst.international@yahoo.com', NULL, '29AAAFQ2722R1ZS', NULL, NULL, NULL, NULL, '0', '669904', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-08-17 15:41:08', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('155', 'QUESST INTERNATIONAL ', 'G155', NULL, NULL, '7022031133', 'quesst.international@yahoo.com', 'cf8427e', '29AAAFQ2722R1ZS', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-08-17 15:41:08', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('156', 'santhosh scientifics pvt.lmtd', 'G156', NULL, NULL, '7871927849', 'thenmozhimurugesan97@gmail.com', 'cf8427e', '33ABGCS4821B1ZS', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-08-18 12:26:10', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('157', 'santhosh scientifics pvt.lmtd', 'G157', NULL, NULL, '7871927849', 'thenmozhimurugesan97@gmail.com', NULL, '33ABGCS4821B1ZS', NULL, NULL, NULL, NULL, '0', '294632', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-08-18 12:26:12', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('158', 'BIOTRONICS INSTRUMENTS', 'G158', NULL, NULL, '9486781441', 'biotronicsinstruments@yahoo.com', 'cf8427e', '33BFSPM6031H1ZC', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-08-22 10:37:55', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('159', 'Science Farmers', 'G159', NULL, NULL, '6360514139', 'sciencefarmers@gmail.com', NULL, '29ADLFS7656N1ZY', NULL, NULL, NULL, NULL, '0', '795191', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-08-24 12:12:59', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('160', 'Micro Scientific Company', 'G160', NULL, NULL, '9443895440', 'microscientificerd@gmail.com', '0ad9353', '33AHHPF5278P1ZV', NULL, NULL, NULL, NULL, '0', '995776', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-08-24 12:13:24', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('161', 'Science Farmers', 'G161', NULL, NULL, '6360514139', 'sciencefarmers@gmail.com', 'cf8427e', '29ADLFS7656N1ZY', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-08-24 12:14:37', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('162', 'Jayanth brothers ', 'G162', NULL, NULL, '9841377496', 'jayanthbros@airtelmail.in', NULL, '33AADFJ1380K1ZH', NULL, NULL, NULL, NULL, '0', '912377', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-08-24 12:20:16', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('163', 'The Precision Scientific Company ', 'G163', NULL, NULL, '9944213551', 'sales.pdy@precision-scientific.com', 'cf8427e', '34AAMFT5165F1Z0', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-08-24 15:28:19', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('164', 'SRK traders', 'G164', NULL, NULL, '9952097315', 'srktraders06@gmail.com', 'cf8427e', '33DHVPK9373M1ZB', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-08-24 15:30:58', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('165', 'RB SCIENTIFIC ', 'G165', NULL, NULL, '9940708138', 'rbscientific1904@gmail.com', 'cf8427e', '33BYUPB1426J1ZG ', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-08-25 12:16:18', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('166', 'SRISCIENTIFIC', 'G166', NULL, NULL, '9840096679', 'sysmkmuralidharan@yahoo.co.in', 'cf8427e', '', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-08-25 14:07:57', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('167', 'Wisei Scientific', 'G167', NULL, NULL, '9840270883', 'wiseiscientific@gmail.com', 'cf8427e', '33AABFW6909K1ZX', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-08-27 13:42:19', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('168', 'MVM Scientific Solutions', 'G168', NULL, NULL, '8825410942', 'mvmscientifics@gmail.com', 'cf8427e', '33AZAPV5894L1ZN', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-08-27 14:00:48', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('169', 'Thamil Kumaran Enterprises', 'G169', NULL, NULL, '9566152911', 'tkeinstruments@gmail.com', 'f1658b4', '33AAXPK4612P1Z4', NULL, NULL, NULL, NULL, '0', '104308', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-08-30 19:35:25', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('170', 'NM ANALYTICAL SOLUTION', 'G170', NULL, NULL, '9941862606', 'nmanalyticalsolution1@gmail.com', 'd9f85b4', '33BBSPA9389L1ZW', NULL, NULL, NULL, NULL, '0', '303339', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-08-31 18:55:41', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('171', 'Kumartraders', 'G171', NULL, NULL, '9080567339', 'kumartraders06@gmail.com', 'cf8427e', '33bwaspzk1gz1', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-09-02 15:49:28', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('172', 'SHIRDI SAI RAM ', 'G172', NULL, NULL, '9952090793', 'shirdisaisn@gmail.com', 'cf8427e', '33AYEPA8409P1Z9', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-09-02 15:58:03', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('173', 'Ponmani and Co ', 'G173', NULL, NULL, '9442616140', 'ponmaniandcocbe@gmail.com', 'a75165e', '33AACFP6624M1Z3', NULL, NULL, NULL, NULL, '0', '868344', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-09-04 18:31:05', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('174', 'Dutta scientific works ', 'G174', NULL, NULL, '9845099730', 'duttascientific@yahoo.com', 'cf8427e', '29AABFD4910H1ZN', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-09-05 15:44:26', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('175', 'Madras Scientific Supplies ', 'G175', NULL, NULL, '9442140099', 'msstirunelveli@gmail.com', 'cf8427e', '33AARFM1030F1ZO', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-09-06 17:58:33', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('176', 'SCIENTIFIC TRADING CORPORATION', 'G176', NULL, NULL, '9825048160', 'nirav@scientifictrading.in', NULL, '24AAAFS6671H1Z5', NULL, NULL, NULL, NULL, '0', '588340', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-09-07 09:52:01', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('177', 'SCIENTIFIC TRADING CORPORATION', 'G177', NULL, NULL, '9825048160', 'nirav@scientifictrading.in', NULL, '24AAAFS6671H1Z5', NULL, NULL, NULL, NULL, '0', '970146', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-09-07 10:27:46', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('178', 'SCIENTIFIC TRADING CORPORATION', 'G178', NULL, NULL, '9825048160', 'stckhushbu@gmail.com', 'cf8427e', '24AAAFS6671H1Z5', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-09-07 10:42:12', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('179', 'SUN SCIENTIFIC SUPPLIERS', 'G179', NULL, NULL, '9345265686', 'sunscientificsuppliers@yahoo.com', 'cf8427e', '34AGAPN5755D1ZL', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-09-08 10:57:32', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('180', 'SUN SCIENTIFIC SUPPLIERS', 'G180', NULL, NULL, '9345265686', 'sunscientificsuppliers@yahoo.com', NULL, '34AGAPN5755D1ZL', NULL, NULL, NULL, NULL, '0', '488802', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-09-08 10:57:35', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('181', 'Atasia Scientific Co ', 'G181', NULL, NULL, '7823998955', 'atasiascientific@gmail.com', 'cf8427e', '33APFPS4783 L1ZB', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-09-08 12:38:25', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('182', 'AIC', 'G182', NULL, NULL, '9790858225', 'imrankhan@aicgroup.in', NULL, '33AAAFA4546M1ZJ', NULL, NULL, NULL, NULL, '0', '698635', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-09-12 14:09:37', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('183', 'ASSOCIATED INSTRUMENT AND CHEMICALS', 'G183', NULL, NULL, '9790858225', 'imrankhan@aicgroup.in', NULL, '33AAAFA4546M1ZJ', NULL, NULL, NULL, NULL, '0', '830931', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-09-12 14:42:57', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('184', 'SM TRADERS', 'G184', NULL, NULL, '9500051707', 'traderss2018@gmail.com', NULL, '33HSCPS2822H1ZQ', NULL, NULL, NULL, NULL, '0', '903495', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-09-16 13:02:53', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('185', 'SM TRADERS', 'G185', NULL, NULL, '9500051707', 'traderss2018@gmail.com', NULL, '33HSCPS2822H1ZQ', NULL, NULL, NULL, NULL, '0', '139199', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-09-16 13:04:00', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('186', 'Scientific Chemicals', 'G186', NULL, NULL, '9790981847', 'scientificchemicals@ymail.com', 'cf8427e', '33AEUPJ7743K1ZW', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-09-16 16:46:42', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('187', 'sakthi diagnostic', 'G187', NULL, NULL, '9884775079', 'sakthi_diag@yahoo.in', NULL, '33BRHPS0731BZ9', NULL, NULL, NULL, NULL, '0', '154646', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-09-17 11:40:15', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('188', 'sakthi diagnostic', 'G188', NULL, NULL, '9884775079', 'sakthi_diag@yahoo.in', 'cf8427e', '33BRHPS0731BZ9', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-09-17 11:40:17', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('189', 'Jayam Chemicals', 'G189', NULL, NULL, '9585540034', 'jayammadurai14@gmail.com', 'cf8427e', '33ALTPM9132Z1', NULL, NULL, NULL, NULL, '0', '838106', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-09-19 17:58:23', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('190', 'Acurel Weighing Systems Private Limited', 'G190', NULL, NULL, '9841027863', 'acurelweighing@gmail.com', 'cf8427e', '33AAHCA2248J1ZT', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-09-19 20:06:58', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('191', 'Theres scientific works', 'G191', NULL, NULL, '9841441914', 'theresscientific@gmail.com', 'cf8427e', '33AJTPC6962B2Z8', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-09-20 12:20:52', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('192', 'Kasthuri Scientific and Surgicals', 'G192', NULL, NULL, '9944481176', 'ksa.kms@gmail.com', 'cf8427e', '33AAMFK6531G1ZD', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-09-21 10:56:09', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('193', 'SANTHOSH SCIENTIFICS PVT LTD', 'G193', NULL, NULL, '9392457497', 'reshmaprasad697@gmail.com', 'cf8427e', '33ABGCS4821B1ZS', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-09-21 12:02:54', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('194', 'Jaykin scientific International ', 'G194', NULL, NULL, '9444104964', 'jayaraj6871@yahoo.in', NULL, '33AOPPJ0210E1Z', NULL, NULL, NULL, NULL, '0', '556671', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-09-24 12:30:16', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('195', 'Jaykin scientific International ', 'G195', NULL, NULL, '9444104964', 'jayaraj6871@yahoo.in', 'cf8427e', '33AOPPJ0210E1Z', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-09-24 12:30:17', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('196', 'Logu Scientific Suppliers ', 'G196', NULL, NULL, '9600174657', 'loguscientificsuppliers@gmail.com', 'cf8427e', '', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-09-24 12:33:36', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('197', 'Krithika sai scientific ', 'G197', NULL, NULL, '8939369355', 'krithikasaiscientific@gmail.com', 'cf8427e', '33DRLPM8360J1ZB', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-09-24 16:07:18', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('198', 'jeyam scientific company', 'G198', NULL, NULL, '8939304457', 'jeyamsoundar22@gmail.com', 'cf8427e', '33AAACJ0855F1ZZ', NULL, NULL, NULL, NULL, '0', '160184', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-09-26 11:56:58', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('199', 'JJ SCIENTIFIC SUPPLIERS', 'G199', NULL, NULL, '9976089874', 'jjscientific@yahoo.in', '765592d', '33AXCPR0059F1ZR', NULL, NULL, NULL, NULL, '0', '411339', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-09-27 11:27:34', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('200', 'THE  PRECISION SCIENTIFIC CO', 'G200', NULL, NULL, '9786675632', 'haripsc45@gmail.com', 'cf8427e', '33ACOPC4845P1Z6', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-10-01 11:41:30', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('201', 'gokul', 'G201', NULL, NULL, '9840903906', 'amarnath.gokul@gmail.com', NULL, '', NULL, NULL, NULL, NULL, '0', '654917', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-10-06 13:33:27', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('202', 'gokul', 'G202', NULL, NULL, '9840903906', 'amarnath.gokul@gmail.com', NULL, '', NULL, NULL, NULL, NULL, '0', '474897', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-10-06 13:40:18', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('203', 'gokul', 'G203', NULL, NULL, '9840903906', 'amarnath.gokul@gmail.com', NULL, '', NULL, NULL, NULL, NULL, '0', '176731', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-10-06 13:44:06', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('204', 'gokul', 'G204', NULL, NULL, '9840903906', 'amarnath.gokul@gmail.com', NULL, '', NULL, NULL, NULL, NULL, '0', '505591', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-10-06 13:48:00', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('205', 'Testing', 'G205', NULL, NULL, '9879879870', 'mydbcard.in@gmail.com', 'cf8427e', '12345678976', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-10-06 15:27:20', NULL, '2022-10-06', '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('206', 'gokul', 'G206', NULL, NULL, '9840903906', 'amarnath.gokul@gmail.com', 'cf8427e', '', '', NULL, NULL, NULL, '0', '', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-10-06 18:03:48', '2024-10-23 00:00:00', '2024-11-13', '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('207', 'Thulir Agency', 'G207', NULL, NULL, '8681818142', 'thulirscientific@gmail.com', 'cf8427e', '33ERCPS4450R2Z5', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-10-08 22:48:15', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('208', 'Shreekrishnaenterprises042019@gmail.com ', 'G208', NULL, NULL, '7358383163', 'Shreekrishnaenterprises042019@gmail.com', NULL, '33AZZPH5342L1ZT ', NULL, NULL, NULL, NULL, '0', '925498', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-10-09 03:52:28', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('209', 'C N S Aqua Chemicals', 'G209', NULL, NULL, '9171435953', 'cnsaqua@gmail.com', NULL, '', NULL, NULL, NULL, NULL, '0', '759520', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-10-09 05:27:51', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('210', 'Ile', 'G210', NULL, NULL, '9087877042', 'sathishileco@gmail.com', 'cf8427e', '', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-10-09 13:06:07', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('211', 'BASIC ESSENTIAL EQUIPMENTS', 'G211', NULL, NULL, '9500079945', 'basicequipmentstn@gmail.com', NULL, '33BYDPR2817L1Z8', NULL, NULL, NULL, NULL, '0', '249016', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-10-09 13:24:24', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('212', 'BASIC ESSENTIAL EQUIPMENTS', 'G212', NULL, NULL, '9500079945', 'basicequipmentstn@gmail.com', 'cf8427e', '33BYDPR2817L1Z8', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-10-09 13:24:26', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('213', 'Sylus Surgicals', 'G213', NULL, NULL, '8939697939', 'info@sylussurgicals.com', 'cf8427e', '33AEGFS3439H1Z0', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-10-10 12:33:50', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('214', 'Vsm systems controll', 'G214', NULL, NULL, '9884580302', 'vsmsystemscontroll@gmail.com', 'cf8427e', '33AFUPV4412N2ZR', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-10-10 13:06:03', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('215', 'A. N. Scientifically ', 'G215', NULL, NULL, '9865243998', 'anscientific@gmail.com', 'cf8427e', '33AAipE1801B1Zp', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-10-11 10:33:27', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('216', 'Scientific ', 'G216', NULL, NULL, '8608858009', 'karthicksubu1998@gmail.com', 'cf8427e', '', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-10-11 11:12:55', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('217', 'Scientific ', 'G217', NULL, NULL, '8608858009', 'karthicksubu1998@gmail.com', NULL, '', NULL, NULL, NULL, NULL, '0', '654241', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-10-11 11:12:57', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('218', 'Magesh scientific suppliers ', 'G218', NULL, NULL, '9884168799', 'mageshscientific@rediffmail.com', 'cf8427e', '33AITPA1207E1ZV', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-10-11 13:33:34', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('219', 'vishnu Scientific suppliers', 'G219', NULL, NULL, '9842722534', 'vishnuscientificslm@gmail.com', NULL, '33CASPK5747E1ZG', NULL, NULL, NULL, NULL, '0', '101318', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-10-12 11:44:54', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('220', 'THE PRECISION SCIENTIFIC CO. (CBE)', 'G220', NULL, NULL, '9843320510', 'psctvr@gmail.com', 'cf8427e', '33AADCB3524E1ZA', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-10-12 15:09:39', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('221', 'HITECH INDIA EQUIPMENTS PVT LTD ', 'G221', NULL, NULL, '9677016899', 'sales@hitechindiaequipments.com', 'cf8427e', '33AAACH2491R1Z8', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-10-13 12:40:24', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('222', 'Jps Technologies', 'G222', NULL, NULL, '9600495295', 'jpstech12@gmail.com', 'cf8427e', '33AMSPJ2943D1Z4', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-10-15 07:27:29', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('223', 'Agikex holdings pvt ktd ', 'G223', NULL, NULL, '0773114429', 'agilex.lk@gmail.com', NULL, '', NULL, NULL, NULL, NULL, '0', '411019', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-10-15 07:52:55', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('224', 'Agikex holdings pvt ktd ', 'G224', NULL, NULL, '0773114429', 'agilex.lk@gmail.com', NULL, '', NULL, NULL, NULL, NULL, '0', '116593', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-10-15 07:52:58', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('225', 'Agikex holdings pvt ktd ', 'G225', NULL, NULL, '0773114429', 'agilex.lk@gmail.com', NULL, '', NULL, NULL, NULL, NULL, '0', '285981', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-10-15 07:54:05', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('226', 'Agikex holdings pvt ktd ', 'G226', NULL, NULL, '0773114429', 'info.aerolabs@gmail.com', NULL, '', NULL, NULL, NULL, NULL, '0', '366427', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-10-15 07:54:54', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('227', 'Agikex holdings pvt ktd ', 'G227', NULL, NULL, '0773114429', 'rasugani@gmail.com', NULL, '', NULL, NULL, NULL, NULL, '0', '755956', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-10-15 07:57:34', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('228', 'SUDHAGAR BIOLOGICAL & CHEMICALS', 'G228', NULL, NULL, '9789973038', 'sales@sbcbio.in', 'cdba347', '33AACPV1123D1ZB', NULL, NULL, NULL, NULL, '0', '981622', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-10-15 11:28:22', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('229', 'Tamil', 'G229', NULL, NULL, '9941551602', 'tamilm095@gmail.com', '13c07ad', '', NULL, NULL, NULL, NULL, '0', '208757', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-10-15 13:21:54', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('230', 'Thanthai Roever college of pharmacy', 'G230', NULL, NULL, '9842137875', 'chandramohanrajan@yahoo.co.in', 'cf8427e', '', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-10-15 17:05:33', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('231', 'THE ILECO ', 'G231', NULL, NULL, '9884303772', 'ilecochennai@gmail.com', NULL, '33AGQPS1310R1ZY', NULL, NULL, NULL, NULL, '0', '301792', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-10-17 17:54:31', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('232', 'The ILECO ', 'G232', NULL, NULL, '9043003774', 'ravikumarileco@gmail.com', 'cf8427e', '33AGQPS1310R1ZY', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-10-17 17:56:59', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('233', 'TEC CRAAFT SCIENTIFIC INSTRUMENTS', 'G233', NULL, NULL, '9942087831', 'teccraaft.in@gmail.com', 'cf8427e', '33BLEPS2156K2ZX', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-10-18 12:04:29', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('234', 'INFRA SCIENTIFIC', 'G234', NULL, NULL, '9447027422', 'infrascientifictcr@gmail.com', 'cf8427e', '32AZHPS5929A1ZG', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-10-19 11:16:38', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('235', 'the ileco', 'G235', NULL, NULL, '9884303761', 'balu.ilecochennai@gmail.com', 'cf8427e', '', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-10-19 12:01:37', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('236', 'DK Enterprises', 'G236', NULL, NULL, '9940276320', 'dkenterprises.lab@gmail.com', 'cf8427e', '33DXJPK4219Q1ZZ', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-10-20 08:48:48', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('237', 'Science World ', 'G237', NULL, NULL, '9942467772', 'scienceworldcbe@gmail.com', 'cf8427e', '33DMJPS9794B1ZI', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-10-20 11:27:58', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('238', 'premja', 'G238', NULL, NULL, '8825772255', 'premjamad1@gmail.com', 'cf8427e', '', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-10-21 13:27:57', NULL, '2024-07-27', '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('239', 'AIC', 'G239', NULL, NULL, '9790858225', 'imrankhan@aicgroup.in', 'cf8427e', '33AAAFA4546M1ZJ', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-10-22 17:57:09', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('240', 'Spark Scientific ', 'G240', NULL, NULL, '9989054800', 'ramanan.natesh@sparksci.in', 'cf8427e', '', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-10-27 12:34:19', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('241', 'vkscientifictraders', 'G241', NULL, NULL, '9952042402', 'vkscientifictraders@gmail.com', 'cf8427e', '33ATNPV2364A1ZQ', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-10-28 13:04:46', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('242', 'Star scientific traders ', 'G242', NULL, NULL, '9894040701', 'starscientiffic@gmail.com', 'cf8427e', 'GSTIN : 33BJKPS6856A1Z2', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-10-29 14:29:50', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('243', 'Micromechinstruments', 'G243', NULL, NULL, '8220045908', 'salesmmi@micromechinstruments.com', 'cf8427e', '33BDDPR7627F1ZI', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-10-31 16:08:28', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('244', 'Micromechinstruments', 'G244', NULL, NULL, '8220045908', 'salesmmi@micromechinstruments.com', NULL, '33BDDPR7627F1ZI', NULL, NULL, NULL, NULL, '0', '893554', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-10-31 16:08:31', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('245', 'SURESH SCIENTIFIC CO', 'G245', NULL, NULL, '9443163618', 'sureshscientific@yahoo.co.in', 'cf8427e', '33AABFS3822K1ZB    ', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-10-31 17:19:31', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('246', 'SURESH SCIENTIFIC CO', 'G246', NULL, NULL, '9443163618', 'sureshscientific@yahoo.co.in', NULL, '33AABFS3822K1ZB    ', NULL, NULL, NULL, NULL, '0', '205913', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-11-01 09:34:33', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('247', 'KPK SCIENTIFIC SUPPLIES', 'G247', NULL, NULL, '9840852943', 'kpkscientific19@gmail.com', 'cf8427e', '33HDIPK6915A1ZR', NULL, NULL, NULL, NULL, '0', '', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-11-02 15:37:19', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('248', 'Kumaran scientific ', 'G248', NULL, NULL, '9443262331', 'sakthivelharshu@gmail.com', NULL, '33AQOPS4698A1ZH', NULL, NULL, NULL, NULL, '0', '588167', NULL, '0', '0', NULL, NULL, NULL, NULL, '2022-11-07 13:56:11', NULL, NULL, '1');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('249', 'Kumaran scientific ', 'G249', NULL, NULL, '9994028140', 'mbhuvaneshwaran1988@gmail.com', '13c07ad', '33AQOPS4698A1ZH', NULL, NULL, NULL, NULL, '0', '262059', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-11-07 13:58:57', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `picture`, `link`, `insertedat`, `updatedat`, `delete_date`, `delete_status`) VALUES ('250', 'tirupurscientific', 'G250', NULL, NULL, '9842284585', 'tirupurscientific@gmail.com', '13c07ad', '33acapn3233a2zf', NULL, NULL, NULL, NULL, '0', '969493', NULL, '0', '1', NULL, NULL, NULL, NULL, '2022-11-07 14:39:10', NULL, NULL, '0');
INSERT INTO `customer` (`customer_id`, `first_name`, `cust_code`, `last_name`, `city`, `contact_no`, `email_address`, `cpassword`, `gst_no`, `address`, `lorry_no`, `transport_name`, `trans_contact`, `wallet`, `activation_code`, `mobile_reg_id`, `c_type`, `customer_status`, `oauth_provider`, `oauth_uid`, `pi